/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Optional;

final class SchemaRegistryClientFactory {
    private SchemaRegistryClientFactory() {
    }

    static Optional<SchemaRegistryClient> getSrClient(Format keyFormat, Format valueFormat, KsqlConfig ksqlConfig) {
        if (keyFormat != FormatFactory.AVRO && valueFormat != FormatFactory.AVRO) {
            return Optional.empty();
        }
        if (ksqlConfig.getString("ksql.schema.registry.url") == null) {
            throw new KsqlException("Schema registry url is not set.");
        }
        return Optional.of(new CachedSchemaRegistryClient((List)ImmutableList.of((Object)ksqlConfig.getString("ksql.schema.registry.url")), 100, (List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()), ksqlConfig.originalsWithPrefix("ksql.schema.registry.")));
    }
}

