/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredVersionedKeyValueStore<K, V>
extends WrappedStateStore<VersionedBytesStore, K, V>
implements VersionedKeyValueStore<K, V> {
    private final MeteredVersionedKeyValueStoreInternal internal;

    MeteredVersionedKeyValueStore(VersionedBytesStore inner, String metricScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.internal = new MeteredVersionedKeyValueStoreInternal(inner, metricScope, time, keySerde, valueSerde);
    }

    @Override
    public long put(K key, V value, long timestamp) {
        return this.internal.put(key, value, timestamp);
    }

    @Override
    public VersionedRecord<V> delete(K key, long timestamp) {
        ValueAndTimestamp valueAndTimestamp = this.internal.delete(key, timestamp);
        return valueAndTimestamp == null ? null : new VersionedRecord(valueAndTimestamp.value(), valueAndTimestamp.timestamp());
    }

    @Override
    public VersionedRecord<V> get(K key) {
        ValueAndTimestamp valueAndTimestamp = (ValueAndTimestamp)this.internal.get(key);
        return valueAndTimestamp == null ? null : new VersionedRecord(valueAndTimestamp.value(), valueAndTimestamp.timestamp());
    }

    @Override
    public VersionedRecord<V> get(K key, long asOfTimestamp) {
        ValueAndTimestamp valueAndTimestamp = this.internal.get(key, asOfTimestamp);
        return valueAndTimestamp == null ? null : new VersionedRecord(valueAndTimestamp.value(), valueAndTimestamp.timestamp());
    }

    @Override
    public String name() {
        return this.internal.name();
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.internal.init(context, root);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.internal.init(context, root);
    }

    @Override
    public void flush() {
        this.internal.flush();
    }

    @Override
    public void close() {
        this.internal.close();
    }

    @Override
    public boolean persistent() {
        return this.internal.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.internal.isOpen();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return this.internal.query(query, positionBound, config);
    }

    @Override
    public Position getPosition() {
        return this.internal.getPosition();
    }

    private class MeteredVersionedKeyValueStoreInternal
    extends MeteredKeyValueStore<K, ValueAndTimestamp<V>> {
        private final VersionedBytesStore inner;
        private final Serde<V> plainValueSerde;
        private StateSerdes<K, V> plainValueSerdes;

        MeteredVersionedKeyValueStoreInternal(VersionedBytesStore inner, String metricScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
            super(inner, metricScope, time, keySerde, valueSerde == null ? null : new ValueAndTimestampSerde(valueSerde));
            this.inner = inner;
            this.plainValueSerde = valueSerde;
        }

        public long put(K key, V value, long timestamp) {
            Objects.requireNonNull(key, "key cannot be null");
            try {
                long validTo = StreamsMetricsImpl.maybeMeasureLatency(() -> this.inner.put(this.keyBytes(key), this.plainValueSerdes.rawValue(value), timestamp), this.time, this.putSensor);
                this.maybeRecordE2ELatency();
                return validTo;
            }
            catch (ProcessorStateException e) {
                String message = String.format(e.getMessage(), key, value);
                throw new ProcessorStateException(message, (Throwable)((Object)e));
            }
        }

        public ValueAndTimestamp<V> get(K key, long asOfTimestamp) {
            Objects.requireNonNull(key, "key cannot be null");
            try {
                return StreamsMetricsImpl.maybeMeasureLatency(() -> (ValueAndTimestamp)this.outerValue(this.inner.get(this.keyBytes(key), asOfTimestamp)), this.time, this.getSensor);
            }
            catch (ProcessorStateException e) {
                String message = String.format(e.getMessage(), key);
                throw new ProcessorStateException(message, (Throwable)((Object)e));
            }
        }

        public ValueAndTimestamp<V> delete(K key, long timestamp) {
            Objects.requireNonNull(key, "key cannot be null");
            try {
                return StreamsMetricsImpl.maybeMeasureLatency(() -> (ValueAndTimestamp)this.outerValue(this.inner.delete(this.keyBytes(key), timestamp)), this.time, this.deleteSensor);
            }
            catch (ProcessorStateException e) {
                String message = String.format(e.getMessage(), key);
                throw new ProcessorStateException(message, (Throwable)((Object)e));
            }
        }

        @Override
        protected <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
            throw new UnsupportedOperationException("Versioned stores do not support RangeQuery queries at this time.");
        }

        @Override
        protected <R> QueryResult<R> runKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
            throw new UnsupportedOperationException("Versioned stores do not support KeyQuery queries at this time.");
        }

        @Override
        protected Serde<ValueAndTimestamp<V>> prepareValueSerdeForStore(Serde<ValueAndTimestamp<V>> valueSerde, SerdeGetter getter) {
            if (valueSerde == null) {
                return new ValueAndTimestampSerde(getter.valueSerde());
            }
            return super.prepareValueSerdeForStore(valueSerde, getter);
        }

        @Override
        @Deprecated
        protected void initStoreSerde(ProcessorContext context) {
            super.initStoreSerde(context);
            String storeName = super.name();
            String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
            this.plainValueSerdes = new StateSerdes(changelogTopic, WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), WrappingNullableUtils.prepareValueSerde(this.plainValueSerde, new SerdeGetter(context)));
        }

        @Override
        protected void initStoreSerde(StateStoreContext context) {
            super.initStoreSerde(context);
            String storeName = super.name();
            String changelogTopic = ProcessorContextUtils.changelogFor(context, storeName, Boolean.FALSE);
            this.plainValueSerdes = new StateSerdes(changelogTopic, WrappingNullableUtils.prepareKeySerde(this.keySerde, new SerdeGetter(context)), WrappingNullableUtils.prepareValueSerde(this.plainValueSerde, new SerdeGetter(context)));
        }
    }
}

