/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.protobuf.events.catalog.v1.ClusterLinkMetadata;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import io.confluent.protobuf.events.catalog.v1.MirrorTopicMetadata;
import io.confluent.protobuf.events.catalog.v1.OpType;
import io.confluent.protobuf.events.catalog.v1.TopicMetadata;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import kafka.catalog.CatalogMetrics;
import kafka.catalog.CatalogTopicConfigUtils;
import kafka.catalog.MetadataEventProvider;
import kafka.common.TenantHelpers;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;

public class MetadataEventUtils {
    public static final String METADATA_SNAPSHOT = "SNAPSHOT";
    public static final String TOPIC_DELTA = "DELTA";
    public static final String CLUSTER_LINK_DELTA = "DELTA";

    public static MetadataEvent topicMetadataEventFromLogConfig(LogConfig logConfig, String topicName, Uuid topicId, int partitionCount, int replicationFactor, @Nullable MirrorTopicMetadata mirrorTopicMetadata, boolean includeFullConfigs, @Nullable Timestamp updateTime, @Nullable Timestamp createTime) {
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder();
        topicMetadataBuilder.setTopicId(topicId.toString()).setTopicName(topicName).setReplicationFactor(replicationFactor).setPartitionsCount(partitionCount);
        for (String configKey : CatalogTopicConfigUtils.CATALOG_TOPIC_CONFIGS) {
            MetadataEventUtils.setField(topicMetadataBuilder, logConfig, configKey);
        }
        if (includeFullConfigs) {
            for (String configKey : CatalogTopicConfigUtils.ADDITIONAL_CATALOG_TOPIC_CONFIGS) {
                MetadataEventUtils.setField(topicMetadataBuilder, logConfig, configKey);
            }
        }
        if (createTime != null) {
            topicMetadataBuilder.setCreateTime(createTime);
        }
        if (updateTime != null) {
            topicMetadataBuilder.setUpdateTime(updateTime);
        }
        if (mirrorTopicMetadata != null) {
            topicMetadataBuilder.setMirrorTopicMetadata(mirrorTopicMetadata);
        }
        return MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
    }

    public static void setField(TopicMetadata.Builder builder, LogConfig logConfig, String configKey) {
        Descriptors.FieldDescriptor fieldDescriptor = TopicMetadata.getDescriptor().findFieldByName(CatalogTopicConfigUtils.configNameToField(configKey));
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException(String.format("Cannot find matching field for config '%s'", configKey));
        }
        Object fieldValue = null;
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                fieldValue = logConfig.getBoolean(configKey);
                break;
            }
            case DOUBLE: {
                fieldValue = logConfig.getDouble(configKey);
                break;
            }
            case INT64: 
            case SINT64: {
                fieldValue = logConfig.getLong(configKey);
                break;
            }
            case INT32: 
            case SINT32: {
                fieldValue = logConfig.getInt(configKey);
                break;
            }
            case ENUM: {
                if ("compression.type".equals(configKey)) {
                    String compressionType = logConfig.getString(configKey).toUpperCase(Locale.ROOT);
                    fieldValue = TopicMetadata.CompressionType.valueOf((String)compressionType).getValueDescriptor();
                    break;
                }
                if (!"cleanup.policy".equals(configKey)) break;
                fieldValue = MetadataEventUtils.cleanupPolicyFromLogConfig(logConfig).getValueDescriptor();
                break;
            }
            case STRING: {
                if (fieldDescriptor.isRepeated()) {
                    fieldValue = logConfig.getList(configKey);
                    break;
                }
                fieldValue = logConfig.getString(configKey);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Found unknown descriptor type '%s' for config '%s'", fieldDescriptor.getType(), configKey));
            }
        }
        if (fieldDescriptor.isRepeated()) {
            for (String value : (List)fieldValue) {
                builder.addRepeatedField(fieldDescriptor, (Object)value);
            }
        } else {
            builder.setField(fieldDescriptor, fieldValue);
        }
    }

    public static MirrorTopicMetadata mirrorTopicMetadata(Uuid linkId, String linkName, Uuid sourceTopicId, String sourceTopicName, String mirrorTopicState, String remoteClusterId, @Nullable Timestamp stateUpdateTime) {
        MirrorTopicMetadata.Builder mirrorTopicMetadataBuilder = MirrorTopicMetadata.newBuilder();
        String link = Optional.ofNullable(TenantHelpers.extractLogicalName(linkName)).orElse(linkName);
        String sourceTopic = Optional.ofNullable(TenantHelpers.extractLogicalName(sourceTopicName)).orElse(sourceTopicName);
        mirrorTopicMetadataBuilder.setLinkId(linkId.toString()).setLinkName(link).setSourceTopicId(sourceTopicId.toString()).setSourceTopicName(sourceTopic).setMirrorTopicState(mirrorTopicState).setRemoteClusterId(remoteClusterId);
        if (stateUpdateTime != null) {
            mirrorTopicMetadataBuilder.setUpdateTime(stateUpdateTime);
        }
        return mirrorTopicMetadataBuilder.build();
    }

    public static TopicMetadata.CleanupPolicy cleanupPolicyFromLogConfig(LogConfig logConfig) {
        if (logConfig.compact() && logConfig.delete()) {
            return TopicMetadata.CleanupPolicy.COMPACT_DELETE;
        }
        if (logConfig.compact()) {
            return TopicMetadata.CleanupPolicy.COMPACT;
        }
        if (logConfig.delete()) {
            return TopicMetadata.CleanupPolicy.DELETE;
        }
        return TopicMetadata.CleanupPolicy.UNSPECIFIED;
    }

    public static MetadataEvent topicMetadataEventForDeletion(String topicName, Optional<String> topicId, Timestamp updateTime) {
        TopicMetadata.Builder topicMetadataBuilder = TopicMetadata.newBuilder().setTopicName(topicName).setUpdateTime(updateTime);
        topicId.ifPresent(arg_0 -> ((TopicMetadata.Builder)topicMetadataBuilder).setTopicId(arg_0));
        return MetadataEvent.newBuilder().setTopicMetadata(topicMetadataBuilder.build()).build();
    }

    public static MetadataEvent clusterLinkMetadataEvent(String clusterLinkName, Uuid clusterLinkId, ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, String remoteClusterId, String localClusterId, @Nullable Timestamp createTime, @Nullable Timestamp updateTime) {
        ClusterLinkMetadata.Builder clusterLinkMetadataBuilder = ClusterLinkMetadata.newBuilder();
        clusterLinkMetadataBuilder.setClusterLinkName(clusterLinkName).setClusterLinkId(clusterLinkId.toString()).setLinkMode(linkMode.toString()).setConnectionMode(connectionMode.toString()).setRemoteClusterId(remoteClusterId).setLocalClusterId(localClusterId);
        if (createTime != null) {
            clusterLinkMetadataBuilder.setCreateTime(createTime);
        }
        if (updateTime != null) {
            clusterLinkMetadataBuilder.setUpdateTime(updateTime);
        }
        return MetadataEvent.newBuilder().setClusterLinkMetadata(clusterLinkMetadataBuilder.build()).build();
    }

    public static MetadataEvent clusterLinkMetadataEventForDeletion(String clusterLinkName, Optional<String> clusterLinkId, Timestamp updateTime) {
        ClusterLinkMetadata.Builder clusterLinkMetadataBuilder = ClusterLinkMetadata.newBuilder().setClusterLinkName(clusterLinkName).setUpdateTime(updateTime);
        clusterLinkId.ifPresent(arg_0 -> ((ClusterLinkMetadata.Builder)clusterLinkMetadataBuilder).setClusterLinkId(arg_0));
        return MetadataEvent.newBuilder().setClusterLinkMetadata(clusterLinkMetadataBuilder.build()).build();
    }

    public static MetadataChange snapshotEvent(String logicalClusterId, List<MetadataEvent> metadataEvents) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.SNAPSHOT).addAllEvents(metadataEvents).build();
    }

    public static MetadataChange entityCreateEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.CREATE).addEvents(metadataEvent).build();
    }

    public static MetadataChange entityUpdateEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.UPDATE).addEvents(metadataEvent).build();
    }

    public static MetadataChange entityDeleteEvent(String logicalClusterId, MetadataEvent metadataEvent) {
        return MetadataChange.newBuilder().setSource(logicalClusterId).setOp(OpType.DELETE).addEvents(metadataEvent).build();
    }

    public static Event metadataCloudEvent(MetadataChange metadataChange, String sourceUrl, String type, int epoch, @Nullable String route, int page, boolean isLastPage, Uuid changeId, EntityType entityType) {
        Event event = new Event().setId(UUID.randomUUID().toString()).setSource(sourceUrl).setSubject(entityType.entityType).setType(type).setTime(OffsetDateTime.now(Clock.systemUTC())).setData("application/protobuf", metadataChange.toByteArray()).setExtension(Extensions.epoch.name(), String.valueOf(epoch)).setExtension(Extensions.partitionkey.name(), metadataChange.getSource());
        if (route != null) {
            event.setExtension(Extensions.route.name(), route);
        }
        if (page >= 0) {
            event.setExtension(Extensions.page.name(), String.valueOf(page)).setExtension(Extensions.lastpage.name(), String.valueOf(isLastPage)).setExtension(Extensions.snapshotid.name(), changeId.toString());
        }
        return event;
    }

    public static Event topicMetadataDeltaCloudEvent(MetadataChange metadataChange, int epoch, String route) {
        String topicName = metadataChange.getEvents(0).getTopicMetadata().getTopicName();
        return MetadataEventUtils.metadataCloudEvent(metadataChange, MetadataEventUtils.topicDeltaSourceUrl(metadataChange.getSource(), topicName), "DELTA", epoch, route, -1, false, null, EntityType.TOPIC);
    }

    public static Event clusterLinkMetadataDeltaCloudEvent(MetadataChange metadataChange, int epoch, String route) {
        String clusterLinkName = metadataChange.getEvents(0).getClusterLinkMetadata().getClusterLinkName();
        return MetadataEventUtils.metadataCloudEvent(metadataChange, MetadataEventUtils.clusterLinkDeltaSourceUrl(metadataChange.getSource(), clusterLinkName), "DELTA", epoch, route, -1, false, null, EntityType.CLUSTER_LINK);
    }

    public static Event metadataSnapshotCloudEvent(MetadataChange metadataChange, int epoch, String route, int page, boolean isLastPage, Uuid snapshotId) {
        return MetadataEventUtils.metadataCloudEvent(metadataChange, MetadataEventUtils.snapshotSourceUrl(metadataChange.getSource()), METADATA_SNAPSHOT, epoch, route, page, isLastPage, snapshotId, EntityType.TOPIC_AND_CLUSTER_LINK);
    }

    public static String snapshotSourceUrl(String logicalClusterId) {
        return String.format("crn://confluent.cloud/kafka=%s/topics-and-cluster-links", logicalClusterId);
    }

    public static String topicDeltaSourceUrl(String logicalClusterId, String topicName) {
        return String.format("crn://confluent.cloud/kafka=%s/topic=%s", logicalClusterId, topicName);
    }

    public static String clusterLinkDeltaSourceUrl(String logicalClusterId, String clusterLinkName) {
        return String.format("crn://confluent.cloud/kafka=%s/cluster-link=%s", logicalClusterId, clusterLinkName);
    }

    public static void emitAndLogError(EventEmitter eventEmitter, Event toEmit, CatalogMetrics metrics, Logger logger) {
        if (eventEmitter instanceof NoOpEventEmitter) {
            throw new IllegalStateException("No EventEmitter configured.");
        }
        ((CompletableFuture)eventEmitter.emit(toEmit).thenApplyAsync(emitted -> {
            if (!emitted.booleanValue()) {
                logger.error("Failed to emit event {}", (Object)toEmit);
                if (metrics != null) {
                    metrics.collectorEventHandleErrorSensor.record();
                }
            } else if (toEmit.type().equals(METADATA_SNAPSHOT)) {
                if (metrics != null) {
                    metrics.snapshotEventEmitSensor.record();
                }
            } else if (metrics != null) {
                metrics.deltaEventEmitSensor.record();
            }
            return null;
        })).exceptionally(e -> {
            logger.error("Failed to emit event {}. This should never happen because the emitter would not throw an exception", (Object)toEmit, e);
            if (metrics != null) {
                metrics.collectorEventHandleErrorSensor.record();
            }
            return null;
        });
    }

    public static void buildAndEmitSnapshot(String logicalCluster, MetadataEventProvider provider, int maxBytes, int epoch, String destTopic, EventEmitter eventEmitter, CatalogMetrics metrics, Logger logger) {
        Event toEmit;
        MetadataChange currSnapshot;
        int currBytes;
        MetadataEvent event;
        int totalBytes = 0;
        Uuid snapshotId = Uuid.randomUuid();
        int page = 0;
        ArrayList<Object> metadataEvents = new ArrayList<MetadataEvent>();
        for (Object topic : provider.topicIterable()) {
            event = provider.getTopicMetadata(topic);
            currBytes = event.getSerializedSize();
            if (totalBytes + currBytes >= maxBytes && !metadataEvents.isEmpty()) {
                currSnapshot = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
                toEmit = MetadataEventUtils.metadataSnapshotCloudEvent(currSnapshot, epoch, destTopic, page, false, snapshotId);
                MetadataEventUtils.emitAndLogError(eventEmitter, toEmit, metrics, logger);
                ++page;
                metadataEvents = new ArrayList();
                totalBytes = 0;
            }
            metadataEvents.add(event);
            totalBytes += currBytes;
        }
        for (Object clusterLink : provider.clusterLinkIterable()) {
            event = provider.getClusterLinkMetadata(clusterLink);
            currBytes = event.getSerializedSize();
            if (totalBytes + currBytes >= maxBytes && !metadataEvents.isEmpty()) {
                currSnapshot = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
                toEmit = MetadataEventUtils.metadataSnapshotCloudEvent(currSnapshot, epoch, destTopic, page, false, snapshotId);
                MetadataEventUtils.emitAndLogError(eventEmitter, toEmit, metrics, logger);
                ++page;
                metadataEvents = new ArrayList();
                totalBytes = 0;
            }
            metadataEvents.add(event);
            totalBytes += currBytes;
        }
        if (!metadataEvents.isEmpty()) {
            MetadataChange currSnapshot2 = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
            Event toEmit2 = MetadataEventUtils.metadataSnapshotCloudEvent(currSnapshot2, epoch, destTopic, page, true, snapshotId);
            MetadataEventUtils.emitAndLogError(eventEmitter, toEmit2, metrics, logger);
        }
    }

    public static Set<String> topicLogConfigDiff(TopicMetadata oldTopicMetadata, TopicMetadata newTopicMetadata) {
        HashSet<String> result = new HashSet<String>();
        Descriptors.Descriptor topicMetadataDescriptor = TopicMetadata.getDescriptor();
        for (String configKey : CatalogTopicConfigUtils.FULL_CATALOG_TOPIC_CONFIGS) {
            Descriptors.FieldDescriptor fieldDescriptor = topicMetadataDescriptor.findFieldByName(CatalogTopicConfigUtils.configNameToField(configKey));
            if (Objects.equals(oldTopicMetadata.getField(fieldDescriptor), newTopicMetadata.getField(fieldDescriptor))) continue;
            result.add(configKey);
        }
        return result;
    }

    public static ConnectionMode getOrDefaultClusterLinkConnectionMode(ConfigurationsImage configurationsImage, ClusterLinkConfig.LinkMode linkMode, String clusterLinkId, Logger logger) {
        ConnectionMode connectionMode;
        Properties props = configurationsImage.configProperties(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLinkId));
        String connectionModeProp = props.getOrDefault((Object)ClusterLinkConfig.ConnectionModeProp(), "").toString();
        try {
            connectionMode = ConnectionMode.fromString(connectionModeProp);
        }
        catch (InvalidConfigurationException e) {
            connectionMode = ClusterLinkConfig.defaultConnectionMode(linkMode);
            logger.warn("No valid connection mode found in cluster link's configs. Connection mode is defaulted as " + connectionMode.name());
        }
        return connectionMode;
    }

    public static boolean eventHasChanged(MetadataEvent oldEvent, MetadataEvent newEvent) {
        if (oldEvent == null && newEvent == null) {
            return false;
        }
        if (oldEvent == null || newEvent == null) {
            return true;
        }
        boolean isSame = Objects.equals(oldEvent.getTopicMetadata().getTopicName(), newEvent.getTopicMetadata().getTopicName()) && Objects.equals(oldEvent.getTopicMetadata().getTopicId(), newEvent.getTopicMetadata().getTopicId()) && Objects.equals(oldEvent.getTopicMetadata().getPartitionsCount(), newEvent.getTopicMetadata().getPartitionsCount()) && Objects.equals(oldEvent.getTopicMetadata().getReplicationFactor(), newEvent.getTopicMetadata().getReplicationFactor()) && MetadataEventUtils.topicLogConfigDiff(oldEvent.getTopicMetadata(), newEvent.getTopicMetadata()).isEmpty() && oldEvent.getClusterLinkMetadata().equals((Object)newEvent.getClusterLinkMetadata()) && oldEvent.getTopicMetadata().getMirrorTopicMetadata().equals((Object)newEvent.getTopicMetadata().getMirrorTopicMetadata());
        return !isSame;
    }

    static enum Extensions {
        route,
        partitionkey,
        epoch,
        page,
        lastpage,
        snapshotid;

    }

    private static enum EntityType {
        TOPIC("topic"),
        CLUSTER_LINK("clusterLink"),
        TOPIC_AND_CLUSTER_LINK("topicAndClusterLink");

        private final String entityType;

        private EntityType(String entityType) {
            this.entityType = entityType;
        }
    }
}

