/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.metrics.AuthenticationLocalTime$;
import kafka.metrics.BrokerLoad$;
import kafka.metrics.BrokerLoadConfig;
import kafka.metrics.BrokerLoadConfig$;
import kafka.metrics.HandshakeLocalTime$;
import kafka.metrics.RequestLocalTime$;
import kafka.metrics.SelectorRegisterTime$;
import kafka.metrics.SelectorServiceMetric;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.ExponentialWeightedAvg;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u001df\u0001B3g\u0001-D\u0011b\u001a\u0001\u0003\u0002\u0003\u0006I!a\u0005\t\u0015\u0005u\u0001A!A!\u0002\u0013\ty\u0002\u0003\u0006\u0002,\u0001\u0011\t\u0011)A\u0005\u0003[A!\"a\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA#\u0011\u001d\tI\u0006\u0001C\u0001\u00037B!\"!\u001b\u0001\u0001\u0004%\t\u0001[A6\u0011)\t\u0019\b\u0001a\u0001\n\u0003A\u0017Q\u000f\u0005\t\u0003\u0003\u0003\u0001\u0015)\u0003\u0002n!Q\u00111\u0011\u0001C\u0002\u0013\u0005\u0001.!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005e\u0005\u0001)A\u0005\u0003'C\u0011\"a'\u0001\u0005\u0004%I!!(\t\u0011\u0005m\u0006\u0001)A\u0005\u0003?C!\"!0\u0001\u0005\u0004%\t\u0001[A`\u0011!\t\t\u0010\u0001Q\u0001\n\u0005\u0005\u0007\"CAz\u0001\t\u0007I\u0011BA{\u0011!\u0011\u0019\u0001\u0001Q\u0001\n\u0005]\b\"\u0003B\u0003\u0001\t\u0007I\u0011BA{\u0011!\u00119\u0001\u0001Q\u0001\n\u0005]\b\"\u0003B\u0005\u0001\t\u0007I\u0011BA{\u0011!\u0011Y\u0001\u0001Q\u0001\n\u0005]\b\"\u0003B\u0007\u0001\t\u0007I\u0011\u0002B\b\u0011!\u00119\u0002\u0001Q\u0001\n\tE\u0001\"\u0003B\r\u0001\t\u0007I\u0011\u0002B\u000e\u0011!\u00119\u0003\u0001Q\u0001\n\tu\u0001\"\u0003B\u0015\u0001\t\u0007IQ\u0002B\u0016\u0011!\u0011\u0019\u0004\u0001Q\u0001\u000e\t5\u0002b\u0003B\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0005oA1B!%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0014\"Y!q\u0013\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u001d\u0011%\u0011I\n\u0001a\u0001\n\u0013\u0011Y\nC\u0005\u0003*\u0002\u0001\r\u0011\"\u0003\u0003,\"A!q\u0016\u0001!B\u0013\u0011i\nC\u0004\u00032\u0002!\tAa-\t\u000f\tU\u0006\u0001\"\u0003\u00034\"I!q\u0017\u0001C\u0002\u0013%!\u0011\u0018\u0005\t\u0005\u0003\u0004\u0001\u0015!\u0003\u0003<\"I!1\u0019\u0001C\u0002\u0013%!q\u0002\u0005\t\u0005\u000b\u0004\u0001\u0015!\u0003\u0003\u0012!I!q\u0019\u0001C\u0002\u0013%!\u0011\u0018\u0005\t\u0005\u0013\u0004\u0001\u0015!\u0003\u0003<\"I!1\u001a\u0001C\u0002\u0013%!q\u0002\u0005\t\u0005\u001b\u0004\u0001\u0015!\u0003\u0003\u0012!I!q\u001a\u0001C\u0002\u0013%!\u0011\u0018\u0005\t\u0005#\u0004\u0001\u0015!\u0003\u0003<\"I!1\u001b\u0001C\u0002\u0013%!q\u0002\u0005\t\u0005+\u0004\u0001\u0015!\u0003\u0003\u0012!9!q\u001b\u0001\u0005\u0002\te\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0005\b\u0005S\u0004A\u0011\u0001Bv\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005WDqAa<\u0001\t\u0003\u0011Y\u000fC\u0004\u0003r\u0002!\tAa;\t\u000f\tM\b\u0001\"\u0003\u0003v\"9!1 \u0001\u0005\u0002\tu\bbBB\u0005\u0001\u0011\u000511\u0002\u0005\b\u0007'\u0001A\u0011BB\u000b\u0011\u001d\u0019Y\u0002\u0001C\u0005\u0007;Aqaa\u000b\u0001\t\u0003\u0011\u0019\f\u0003\u0005\u0004.\u0001!\t\u0001\u001bB*\r\u001d\u0011i\u0004\u0001\u0001i\u0005\u007fAq!!\u0017?\t\u0003\u0011\u0019\u0006C\u0005\u0003Vy\u0012\r\u0011\"\u0003\u0003X!A!\u0011\f !\u0002\u0013\u0011i\u0005\u0003\u0005\u0003\\y\"\t\u0001\u001bB/\u0011\u001d\u0011IG\u0010C\u0005\u0005WBqA!!?\t\u0003\u0012\u0019\tC\u0004\u00040\u0001!\te!\r\t\u000f\ru\u0002\u0001\"\u0011\u0004@\u001d91q\t4\t\u0002\r%cAB3g\u0011\u0003\u0019Y\u0005C\u0004\u0002Z!#\ta!\u0014\t\u000f\r=\u0003\n\"\u0001\u0004R!I11\f%\u0012\u0002\u0013\u00051Q\f\u0005\n\u0007gB%\u0019!C\u0001\u0007kB\u0001ba\u001eIA\u0003%\u0011q\u0016\u0005\n\u0007sB%\u0019!C\u0005\u0007kB\u0001ba\u001fIA\u0003%\u0011q\u0016\u0005\n\u0007{B%\u0019!C\u0005\u0007kB\u0001ba IA\u0003%\u0011q\u0016\u0005\n\u0007\u0003C%\u0019!C\u0005\u0007kB\u0001ba!IA\u0003%\u0011q\u0016\u0005\n\u0007\u000bC%\u0019!C\u0005\u0007kB\u0001ba\"IA\u0003%\u0011q\u0016\u0005\n\u0007\u0013C%\u0019!C\u0005\u0007kB\u0001ba#IA\u0003%\u0011q\u0016\u0005\n\u0007\u001bC%\u0019!C\u0005\u0007kB\u0001ba$IA\u0003%\u0011q\u0016\u0005\n\u0007#C%\u0019!C\u0005\u0007kB\u0001ba%IA\u0003%\u0011q\u0016\u0005\n\u0007+C%\u0019!C\u0005\u0007kB\u0001ba&IA\u0003%\u0011q\u0016\u0005\n\u00073C%\u0019!C\u0005\u0007kB\u0001ba'IA\u0003%\u0011q\u0016\u0005\n\u0007;C%\u0019!C\u0005\u0007kB\u0001ba(IA\u0003%\u0011q\u0016\u0005\n\u0007CC%\u0019!C\u0005\u0007kB\u0001ba)IA\u0003%\u0011q\u0016\u0005\n\u0007KC\u0015\u0013!C\u0001\u0007;\u0012!B\u0011:pW\u0016\u0014Hj\\1e\u0015\t9\u0007.A\u0004nKR\u0014\u0018nY:\u000b\u0003%\fQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001YJD\bCA7q\u001b\u0005q'\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005Et'AB!osJ+g\r\u0005\u0002tm6\tAO\u0003\u0002vQ\u0006)Q\u000f^5mg&\u0011q\u000f\u001e\u0002\b\u0019><w-\u001b8h!\rI\u0018Q\u0002\b\u0004u\u0006%Q\"A>\u000b\u0005ql\u0018a\u00028fi^|'o\u001b\u0006\u0003}~\faaY8n[>t'bA5\u0002\u0002)!\u00111AA\u0003\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006w\u0006A1+\u001a7fGR|'/\u0003\u0003\u0002\u0010\u0005E!AE(o\u001d\u0016<XI^3oi2K7\u000f^3oKJT1!a\u0003|!\u0011\t)\"!\u0007\u000e\u0005\u0005]!BA4~\u0013\u0011\tY\"a\u0006\u0003\u000f5+GO]5dg\u000611m\u001c8gS\u001e\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KA\u0017AB:feZ,'/\u0003\u0003\u0002*\u0005\r\"aC&bM.\f7i\u001c8gS\u001e\faC]3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017\n\u001a7f\u001b\u0016$XM\u001d\t\u0005\u0003_\ty$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011\u0019wN]3\u000b\u0007\u001d\f9D\u0003\u0003\u0002:\u0005m\u0012AB=b[6,'O\u0003\u0002\u0002>\u0005\u00191m\\7\n\t\u0005\u0005\u0013\u0011\u0007\u0002\u0006\u001b\u0016$XM]\u0001\u0014[VdG/\u001b+f]\u0006tG/T3uC\u0012\fG/\u0019\t\u0006[\u0006\u001d\u00131J\u0005\u0004\u0003\u0013r'AB(qi&|g\u000e\u0005\u0003\u0002N\u0005USBAA(\u0015\u0011\t\t&a\u0015\u0002\u00175,H\u000e^5uK:\fg\u000e\u001e\u0006\u0004\u0003Ky\u0018\u0002BA,\u0003\u001f\u00121#T;mi&$VM\\1oi6+G/\u00193bi\u0006\fa\u0001P5oSRtDCCA/\u0003C\n\u0019'!\u001a\u0002hA\u0019\u0011q\f\u0001\u000e\u0003\u0019DaaZ\u0003A\u0002\u0005M\u0001bBA\u000f\u000b\u0001\u0007\u0011q\u0004\u0005\b\u0003W)\u0001\u0019AA\u0017\u0011%\t\u0019%\u0002I\u0001\u0002\u0004\t)%\u0001\tce>\\WM\u001d'pC\u0012\u001cuN\u001c4jOV\u0011\u0011Q\u000e\t\u0005\u0003?\ny'C\u0002\u0002r\u0019\u0014\u0001C\u0011:pW\u0016\u0014Hj\\1e\u0007>tg-[4\u0002)\t\u0014xn[3s\u0019>\fGmQ8oM&<w\fJ3r)\u0011\t9(! \u0011\u00075\fI(C\u0002\u0002|9\u0014A!\u00168ji\"I\u0011qP\u0004\u0002\u0002\u0003\u0007\u0011QN\u0001\u0004q\u0012\n\u0014!\u00052s_.,'\u000fT8bI\u000e{gNZ5hA\u0005aQ.\u001a;sS\u000e\u001cuN\u001c4jOV\u0011\u0011q\u0011\t\u0005\u0003+\tI)\u0003\u0003\u0002\f\u0006]!\u0001D'fiJL7mQ8oM&<\u0017!D7fiJL7mQ8oM&<\u0007%A\nj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'/\u0006\u0002\u0002\u0014B\u0019!0!&\n\u0007\u0005]5P\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u000bj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'\u000fI\u0001\u0019[VdG/\u001b+f]\u0006tG\u000fT5ti\u0016tWM\u001d(b[\u0016\u001cXCAAP!\u0019\t\t+a+\u000206\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0003vi&d'BAAU\u0003\u0011Q\u0017M^1\n\t\u00055\u00161\u0015\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00022\u0006]VBAAZ\u0015\u0011\t),a*\u0002\t1\fgnZ\u0005\u0005\u0003s\u000b\u0019L\u0001\u0004TiJLgnZ\u0001\u001a[VdG/\u001b+f]\u0006tG\u000fT5ti\u0016tWM\u001d(b[\u0016\u001c\b%\u0001\ftK2,7\r^8s'\u0016\u0014h/[2f\u001b\u0016$(/[2t+\t\t\t\r\u0005\u0005\u0002D\u0006E\u0017q[Ao\u001d\u0011\t)-!4\u0011\u0007\u0005\u001dg.\u0004\u0002\u0002J*\u0019\u00111\u001a6\u0002\rq\u0012xn\u001c;?\u0013\r\tyM\\\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0017Q\u001b\u0002\u0004\u001b\u0006\u0004(bAAh]B!\u0011qLAm\u0013\r\tYN\u001a\u0002\u0016'\u0016dWm\u0019;peN+'O^5dK6+GO]5d!\u0019\ty.!:\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f\u0019+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a:\u0002b\n\u00192i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-_*fiB!\u00111^Aw\u001b\u0005i\u0018bAAx{\n1Q*\u001a;sS\u000e\fqc]3mK\u000e$xN]*feZL7-Z'fiJL7m\u001d\u0011\u0002\u000fM$\u0018M\u001d;fIV\u0011\u0011q\u001f\t\u0005\u0003s\fy0\u0004\u0002\u0002|*!\u0011Q`Aq\u0003\u0019\tGo\\7jG&!!\u0011AA~\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006A1\u000f^1si\u0016$\u0007%A\ftG\",G-\u001e7fIN+'O^5dK6+GO]5dg\u0006A2o\u00195fIVdW\rZ*feZL7-Z'fiJL7m\u001d\u0011\u0002)I,7m\u001c:e'\u0016\u0014h/[2f\u001b\u0016$(/[2t\u0003U\u0011XmY8sIN+'O^5dK6+GO]5dg\u0002\nAC\u0019:pW\u0016\u0014Hj\\1e\u001b\u0016$(/[2OC6,WC\u0001B\t!\u0011\tYOa\u0005\n\u0007\tUQP\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\fQC\u0019:pW\u0016\u0014Hj\\1e\u001b\u0016$(/[2OC6,\u0007%A\u000ece>\\WM\u001d'pC\u0012$VM\\1oi6+GO]5d\u001d\u0006lWm]\u000b\u0003\u0005;\u0001ra\u001dB\u0010\u0005G\u0011\t\"C\u0002\u0003\"Q\u0014A\u0001U8pYB!\u00111\u0019B\u0013\u0013\u0011\tI,!6\u00029\t\u0014xn[3s\u0019>\fG\rV3oC:$X*\u001a;sS\u000et\u0015-\\3tA\u0005\u0011\"M]8lKJdu.\u00193Fq\u0016\u001cW\u000f^8s+\t\u0011i\u0003\u0005\u0003\u0002`\n=\u0012\u0002\u0002B\u0019\u0003C\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003M\u0011'o\\6fe2{\u0017\rZ#yK\u000e,Ho\u001c:!\u0003=\u0011'o\\6fe2{\u0017\rZ$bk\u001e,WC\u0001B\u001d!\r\u0011YDP\u0007\u0002\u0001\ty!I]8lKJdu.\u00193HCV<WmE\u0003?\u0005\u0003\u00129\u0005\u0005\u0003\u00022\n\r\u0013\u0002\u0002B#\u0003g\u0013aa\u00142kK\u000e$\bCBA\u000b\u0005\u0013\u0012i%\u0003\u0003\u0003L\u0005]!!B$bk\u001e,\u0007cA7\u0003P%\u0019!\u0011\u000b8\u0003\r\u0011{WO\u00197f)\t\u0011I$\u0001\u0004O_2{\u0017\rZ\u000b\u0003\u0005\u001b\nqAT8M_\u0006$\u0007%A\u0004xK&<\u0007\u000e^:\u0015\t\t}#Q\r\t\b[\n\u0005$Q\nB'\u0013\r\u0011\u0019G\u001c\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\u001d$\t1\u0001\u0003N\u0005\t\u00010A\u0006oC:\fu/\u0019:f\u001b&tG\u0003\u0002B'\u0005[BqAa\u001cD\u0001\u0004\u0011\t(A\u0001u!\u0019\u0011\u0019H! \u0003N9!!Q\u000fB=\u001d\u0011\t9Ma\u001e\n\u0003=L1Aa\u001fo\u0003\u001d\u0001\u0018mY6bO\u0016LA!!,\u0003\u0000)\u0019!1\u00108\u0002\u000bY\fG.^3\u0015\r\t5#Q\u0011BD\u0011\u001d\ti\u0002\u0012a\u0001\u0003\u000fCqA!#E\u0001\u0004\u0011Y)A\u0002o_^\u00042!\u001cBG\u0013\r\u0011yI\u001c\u0002\u0005\u0019>tw-A\nce>\\WM\u001d'pC\u0012<\u0015-^4f?\u0012*\u0017\u000f\u0006\u0003\u0002x\tU\u0005\"CA@=\u0005\u0005\t\u0019\u0001B\u001d\u0003A\u0011'o\\6fe2{\u0017\rZ$bk\u001e,\u0007%\u0001\u0004mW\u000eLEm]\u000b\u0003\u0005;\u0003bAa(\u0003&\n\rRB\u0001BQ\u0015\r\u0011\u0019K\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BT\u0005C\u00131aU3u\u0003)a7nY%eg~#S-\u001d\u000b\u0005\u0003o\u0012i\u000bC\u0005\u0002\u0000\u0005\n\t\u00111\u0001\u0003\u001e\u00069An[2JIN\u0004\u0013aC:uCJ$X*\u001a;sS\u000e$\"!a\u001e\u0002?5\f\u0017PY3Va\u0012\fG/\u001a\"s_.,'\u000fT8bI6+GO]5dg6\u000b\u0007/A\u000eu_R\fGnU3sm&\u001cW\rT8dC2$\u0016.\\3TK:\u001cxN]\u000b\u0003\u0005w\u0003B!!\u0006\u0003>&!!qXA\f\u0005\u0019\u0019VM\\:pe\u0006aBo\u001c;bYN+'O^5dK2{7-\u00197US6,7+\u001a8t_J\u0004\u0013AL<fS\u001eDG/\u001a3Bm\u0016\u0014\u0018mZ3U_R\fGnU3sm&\u001cW\rT8dC2$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\fqf^3jO\"$X\rZ!wKJ\fw-\u001a+pi\u0006d7+\u001a:wS\u000e,Gj\\2bYRKW.Z'fiJL7MT1nK\u0002\nA%\u001a=uKJt\u0017\r\u001c(fi^|'o\u001b+ie\u0016\fG-\u00133mKJ\u000bG/[8TK:\u001cxN]\u0001&Kb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>\u001cVM\\:pe\u0002\nqg^3jO\"$X\rZ!wKJ\fw-Z#yi\u0016\u0014h.\u00197OKR<xN]6UQJ,\u0017\rZ%eY\u0016\u0014\u0016\r^5p\u001b\u0016$(/[2OC6,\u0017\u0001O<fS\u001eDG/\u001a3Bm\u0016\u0014\u0018mZ3FqR,'O\\1m\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_6+GO]5d\u001d\u0006lW\rI\u0001(e\u0016\u0004H.[2bi&|gNT3uo>\u00148\u000e\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\*f]N|'/\u0001\u0015sKBd\u0017nY1uS>tg*\u001a;x_J\\G\u000b\u001b:fC\u0012LE\r\\3SCRLwnU3og>\u0014\b%\u0001\u001exK&<\u0007\u000e^3e\u0003Z,'/Y4f%\u0016\u0004H.[2bi&|gNT3uo>\u00148\u000e\u00165sK\u0006$\u0017\n\u001a7f%\u0006$\u0018n\\'fiJL7MT1nK\u0006Yt/Z5hQR,G-\u0011<fe\u0006<WMU3qY&\u001c\u0017\r^5p]:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u0019U\u0004H-\u0019;f\u0007>tg-[4\u0015\t\u0005]$1\u001c\u0005\b\u0005;\f\u0004\u0019AA\u0010\u0003%qWm^\"p]\u001aLw-\u0001\fce>\\WM\u001d'pC\u0012$VM\\1oi6+GO]5d)\u0011\u0011\u0019O!:\u0011\u000b5\f9%!;\t\u000f\t\u001d(\u00071\u0001\u0003$\u0005)An[2JI\u0006\u0001\"M]8lKJdu.\u00193NKR\u0014\u0018nY\u000b\u0003\u0005G\f!f^3jO\"$X\rZ!wKJ\fw-\u001a+pi\u0006d7+\u001a:wS\u000e,Gj\\2bYRKW.Z'fiJL7-A\u001axK&<\u0007\u000e^3e\u0003Z,'/Y4f\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG\u00061t/Z5hQR,G-\u0011<fe\u0006<WMU3qY&\u001c\u0017\r^5p]:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG\u0006Iq-\u001a;NKR\u0014\u0018n\u0019\u000b\u0005\u0005G\u00149\u0010C\u0004\u0003z^\u0002\rA!\u0005\u0002\u00155,GO]5d\u001d\u0006lW-A\bn_:LGo\u001c:TK2,7\r^8s)\u0011\t9Ha@\t\u000f\r\u0005\u0001\b1\u0001\u0004\u0004\u0005A1/\u001a7fGR|'\u000fE\u0002{\u0007\u000bI1aa\u0002|\u0005!\u0019V\r\\3di>\u0014\u0018A\u0006:fG>\u0014HMU3rk\u0016\u001cH\u000fV5nK:\u000bgn\\:\u0015\r\u0005]4QBB\b\u0011\u001d\u0019\t!\u000fa\u0001\u0007\u0007Aqa!\u0005:\u0001\u0004\u0011Y)A\u0005uS6,g*\u00198pg\u0006I\"/Z2pe\u0012\u001cuN\u001c8fGRLwN\u001c+j[\u0016t\u0015M\\8t)\u0011\t9ha\u0006\t\u000f\re!\b1\u0001\u0003\f\u0006ABo\u001c;bY\u000e{gN\\3di&|g\u000eV5nK:\u000bgn\\:\u0002;I,7m\u001c:e\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193t\u0013\u0012dWMU1uS>$\u0002\"a\u001e\u0004 \r\r2q\u0005\u0005\b\u0007CY\u0004\u0019\u0001B\u0012\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\u0019)c\u000fa\u0001\u0005\u001b\n\u0011\"\u001b3mKJ\u000bG/[8\t\u000f\r%2\b1\u0001\u0003\f\u00061A/[7f\u001bN\fQa\u00197pg\u0016\f!C\\3x\u0005J|7.\u001a:M_\u0006$w)Y;hK\u0006\u0011bn\u001c;jMf|enQ8o]\u0016\u001cG/[8o)\u0011\t9ha\r\t\u000f\rUR\t1\u0001\u00048\u000591\r[1o]\u0016d\u0007c\u0001>\u0004:%\u001911H>\u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\u0002'9|G/\u001b4z\u001f:$\u0006N]3bIV\u001b\u0018mZ3\u0015\u0011\u0005]4\u0011IB\"\u0007\u000bBqa!\tG\u0001\u0004\u0011\u0019\u0003C\u0004\u0004&\u0019\u0003\rA!\u0014\t\u000f\r%b\t1\u0001\u0003\f\u0006Q!I]8lKJdu.\u00193\u0011\u0007\u0005}\u0003j\u0005\u0002IYR\u00111\u0011J\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003;\u001a\u0019f!\u0016\u0004X\re\u0003BB4K\u0001\u0004\t\u0019\u0002C\u0004\u0002\u001e)\u0003\r!a\b\t\u000f\u0005-\"\n1\u0001\u0002.!I\u00111\t&\u0011\u0002\u0003\u0007\u0011QI\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\f\u0016\u0005\u0003\u000b\u001a\tg\u000b\u0002\u0004dA!1QMB8\u001b\t\u00199G\u0003\u0003\u0004j\r-\u0014!C;oG\",7m[3e\u0015\r\u0019iG\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB9\u0007O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U\u0011%o\\6fe2{\u0017\rZ'fiJL7m\u0012:pkB,\"!a,\u0002-\t\u0013xn[3s\u0019>\fG-T3ue&\u001cwI]8va\u0002\nAC\u0011:pW\u0016\u0014Hj\\1e\u001b\u0016$(/[2OC6,\u0017!\u0006\"s_.,'\u000fT8bI6+GO]5d\u001d\u0006lW\rI\u0001\u001c\u0005J|7.\u001a:M_\u0006$W*\u001a;sS\u000e$Um]2sSB$\u0018n\u001c8\u00029\t\u0013xn[3s\u0019>\fG-T3ue&\u001cG)Z:de&\u0004H/[8oA\u0005Q2+\u001a:wS\u000e,Gj\\2bYRKW.Z*f]N|'OT1nK\u0006Y2+\u001a:wS\u000e,Gj\\2bYRKW.Z*f]N|'OT1nK\u0002\n!dU3sm&\u001cW\rT8dC2$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f1dU3sm&\u001cW\rT8dC2$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!I*feZL7-\u001a'pG\u0006dG+[7f\u001b\u0016$(/[2EKN\u001c'/\u001b9uS>t\u0017AI*feZL7-\u001a'pG\u0006dG+[7f\u001b\u0016$(/[2EKN\u001c'/\u001b9uS>t\u0007%\u0001\u0015FqR,'O\\1m\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_N+gn]8s\u001d\u0006lW-A\u0015FqR,'O\\1m\u001d\u0016$xo\u001c:l)\"\u0014X-\u00193JI2,'+\u0019;j_N+gn]8s\u001d\u0006lW\rI\u0001)\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.Z\u0001*\u000bb$XM\u001d8bY:+Go^8sWRC'/Z1e\u0013\u0012dWMU1uS>lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002_\u0015CH/\u001a:oC2tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000e$Um]2sSB$\u0018n\u001c8\u0002a\u0015CH/\u001a:oC2tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000e$Um]2sSB$\u0018n\u001c8!\u0003-\u0012V\r\u001d7jG\u0006$\u0018n\u001c8OKR<xN]6UQJ,\u0017\rZ%eY\u0016\u0014\u0016\r^5p'\u0016t7o\u001c:OC6,\u0017\u0001\f*fa2L7-\u0019;j_:tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|7+\u001a8t_Jt\u0015-\\3!\u0003-\u0012V\r\u001d7jG\u0006$\u0018n\u001c8OKR<xN]6UQJ,\u0017\rZ%eY\u0016\u0014\u0016\r^5p\u001b\u0016$(/[2OC6,\u0017\u0001\f*fa2L7-\u0019;j_:tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000et\u0015-\\3!\u0003I\u0012V\r\u001d7jG\u0006$\u0018n\u001c8OKR<xN]6UQJ,\u0017\rZ%eY\u0016\u0014\u0016\r^5p\u001b\u0016$(/[2EKN\u001c'/\u001b9uS>t\u0017a\r*fa2L7-\u0019;j_:tU\r^<pe.$\u0006N]3bI&#G.\u001a*bi&|W*\u001a;sS\u000e$Um]2sSB$\u0018n\u001c8!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class BrokerLoad
implements Logging,
Selector.OnNewEventListener {
    private final Metrics metrics;
    public final Meter kafka$metrics$BrokerLoad$$requestThreadIdleMeter;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private BrokerLoadConfig brokerLoadConfig;
    private final MetricConfig metricConfig;
    private final ListenerName interBrokerListener;
    private final java.util.List<String> multiTenantListenerNames;
    private final scala.collection.immutable.Map<SelectorServiceMetric, CopyOnWriteArraySet<Metric>> selectorServiceMetrics;
    private final AtomicBoolean started;
    private final AtomicBoolean scheduledServiceMetrics;
    private final AtomicBoolean recordServiceMetrics;
    private final MetricName brokerLoadMetricName;
    private final Pool<String, MetricName> brokerLoadTenantMetricNames;
    private final ScheduledExecutorService brokerLoadExecutor;
    private BrokerLoadGauge brokerLoadGauge;
    private Set<String> lkcIds;
    private final Sensor totalServiceLocalTimeSensor;
    private final MetricName weightedAverageTotalServiceLocalTimeMetricName;
    private final Sensor externalNetworkThreadIdleRatioSensor;
    private final MetricName weightedAverageExternalNetworkThreadIdleRatioMetricName;
    private final Sensor replicationNetworkThreadIdleRatioSensor;
    private final MetricName weightedAverageReplicationNetworkThreadIdleRatioMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<MultiTenantMetadata> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public static String BrokerLoadMetricGroup() {
        return BrokerLoad$.MODULE$.BrokerLoadMetricGroup();
    }

    public static Option<MultiTenantMetadata> apply$default$4() {
        return None$.MODULE$;
    }

    public static BrokerLoad apply(Metrics metrics, KafkaConfig config, Meter requestThreadIdleMeter, Option<MultiTenantMetadata> multiTenantMetadata) {
        return new BrokerLoad(metrics, config, requestThreadIdleMeter, multiTenantMetadata);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerLoadConfig brokerLoadConfig() {
        return this.brokerLoadConfig;
    }

    public void brokerLoadConfig_$eq(BrokerLoadConfig x$1) {
        this.brokerLoadConfig = x$1;
    }

    public MetricConfig metricConfig() {
        return this.metricConfig;
    }

    private ListenerName interBrokerListener() {
        return this.interBrokerListener;
    }

    private java.util.List<String> multiTenantListenerNames() {
        return this.multiTenantListenerNames;
    }

    public scala.collection.immutable.Map<SelectorServiceMetric, CopyOnWriteArraySet<Metric>> selectorServiceMetrics() {
        return this.selectorServiceMetrics;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean scheduledServiceMetrics() {
        return this.scheduledServiceMetrics;
    }

    private AtomicBoolean recordServiceMetrics() {
        return this.recordServiceMetrics;
    }

    private MetricName brokerLoadMetricName() {
        return this.brokerLoadMetricName;
    }

    private Pool<String, MetricName> brokerLoadTenantMetricNames() {
        return this.brokerLoadTenantMetricNames;
    }

    private final ScheduledExecutorService brokerLoadExecutor() {
        return this.brokerLoadExecutor;
    }

    private BrokerLoadGauge brokerLoadGauge() {
        return this.brokerLoadGauge;
    }

    private void brokerLoadGauge_$eq(BrokerLoadGauge x$1) {
        this.brokerLoadGauge = x$1;
    }

    private Set<String> lkcIds() {
        return this.lkcIds;
    }

    private void lkcIds_$eq(Set<String> x$1) {
        this.lkcIds = x$1;
    }

    public void startMetric() {
        if (this.brokerLoadConfig().metricEnable() && this.started().compareAndSet(false, true)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Starting broker load metric");
            }
            this.brokerLoadGauge_$eq(new BrokerLoadGauge());
            if (!this.metrics.metrics().containsKey(this.brokerLoadMetricName())) {
                this.metrics.addMetric(this.brokerLoadMetricName(), (MetricValueProvider)this.brokerLoadGauge());
            }
            if (this.brokerLoadConfig().tenantMetricEnabled()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Starting broker load tenant metric");
                }
                this.brokerLoadExecutor().scheduleAtFixedRate(() -> this.maybeUpdateBrokerLoadMetricsMap(), 0L, this.brokerLoadConfig().updateMetricTagIntervalMs().toMillis(), TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    private void maybeUpdateBrokerLoadMetricsMap() {
        Set logicalClusters = (Set)this.multiTenantMetadata.map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.SetHasAsScala(x$2.kafkaLogicalClusterIds()).asScala()).getOrElse((Function0 & Serializable)() -> (Set)Set$.MODULE$.empty());
        if (!logicalClusters.equals(this.lkcIds())) {
            this.lkcIds_$eq((Set<String>)logicalClusters);
            Set metricsToRemove = (Set)this.brokerLoadTenantMetricNames().keys().diff(this.lkcIds());
            metricsToRemove.foreach((Function1 & Serializable)lkcId -> {
                $this.metrics.removeMetric(this.brokerLoadTenantMetricNames().get((String)lkcId));
                return this.brokerLoadTenantMetricNames().remove((String)lkcId);
            });
            Set metricsToAdd = (Set)this.lkcIds().diff(this.brokerLoadTenantMetricNames().keys());
            metricsToAdd.foreach((Function1 & Serializable)lkcId -> {
                scala.collection.immutable.Map mTag = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), lkcId)}));
                MetricName mName = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava((Map)mTag).asJava());
                if (!$this.metrics.metrics().containsKey(mName)) {
                    $this.metrics.addMetric(mName, (MetricValueProvider)this.brokerLoadGauge());
                }
                return this.brokerLoadTenantMetricNames().put((String)lkcId, mName);
            });
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Updated broker load metric names. Removed tenant: {}. Added tenant: {}", new Object[]{metricsToRemove, metricsToAdd});
            }
            return;
        }
    }

    private Sensor totalServiceLocalTimeSensor() {
        return this.totalServiceLocalTimeSensor;
    }

    private MetricName weightedAverageTotalServiceLocalTimeMetricName() {
        return this.weightedAverageTotalServiceLocalTimeMetricName;
    }

    private Sensor externalNetworkThreadIdleRatioSensor() {
        return this.externalNetworkThreadIdleRatioSensor;
    }

    private MetricName weightedAverageExternalNetworkThreadIdleRatioMetricName() {
        return this.weightedAverageExternalNetworkThreadIdleRatioMetricName;
    }

    private Sensor replicationNetworkThreadIdleRatioSensor() {
        return this.replicationNetworkThreadIdleRatioSensor;
    }

    private MetricName weightedAverageReplicationNetworkThreadIdleRatioMetricName() {
        return this.weightedAverageReplicationNetworkThreadIdleRatioMetricName;
    }

    public void updateConfig(KafkaConfig newConfig) {
        this.brokerLoadConfig_$eq(new BrokerLoadConfig(this.brokerLoadConfig().metricEnable(), this.brokerLoadConfig().sampleWindowSize(), this.brokerLoadConfig().numSamples(), Predef$.MODULE$.Double2double(newConfig.brokerLoadAverageServiceRequestTimeMs()), Predef$.MODULE$.Double2double(newConfig.brokerLoadWorkloadCoefficient()), this.brokerLoadConfig().delayMetricStartMs(), this.brokerLoadConfig().tenantMetricEnabled(), this.brokerLoadConfig().updateMetricTagIntervalMs(), 0.05, 0.25));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Updated broker load config to ").append(this.brokerLoadConfig()).toString());
    }

    public Option<Metric> brokerLoadTenantMetric(String lkcId) {
        return Option$.MODULE$.apply((Object)this.brokerLoadTenantMetricNames().get(lkcId)).flatMap((Function1 & Serializable)metricName -> this.getMetric((MetricName)metricName));
    }

    public Option<Metric> brokerLoadMetric() {
        return this.getMetric(this.brokerLoadMetricName());
    }

    public Option<Metric> weightedAverageTotalServiceLocalTimeMetric() {
        return this.getMetric(this.weightedAverageTotalServiceLocalTimeMetricName());
    }

    public Option<Metric> weightedAverageExternalNetworkThreadIdleRatioMetric() {
        return this.getMetric(this.weightedAverageExternalNetworkThreadIdleRatioMetricName());
    }

    public Option<Metric> weightedAverageReplicationNetworkThreadIdleRatioMetric() {
        return this.getMetric(this.weightedAverageReplicationNetworkThreadIdleRatioMetricName());
    }

    private Option<Metric> getMetric(MetricName metricName) {
        KafkaMetric metric = this.metrics.metric(metricName);
        if (metric != null) {
            return new Some((Object)metric);
        }
        return None$.MODULE$;
    }

    public void monitorSelector(Selector selector) {
        this.selectorServiceMetrics().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoad.$anonfun$monitorSelector$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoad.$anonfun$monitorSelector$2(this, selector, x$3);
            return BoxedUnit.UNIT;
        });
        selector.registerOnNewEventListener((Selector.OnNewEventListener)this);
    }

    public void recordRequestTimeNanos(Selector selector, long timeNanos) {
        RequestLocalTime$.MODULE$.sensor(selector).record((double)timeNanos);
        if (this.recordServiceMetrics().get()) {
            this.totalServiceLocalTimeSensor().record((double)timeNanos);
            return;
        }
    }

    private void recordConnectionTimeNanos(long totalConnectionTimeNanos) {
        if (!this.recordServiceMetrics().get() && totalConnectionTimeNanos > 0L && this.scheduledServiceMetrics().compareAndSet(false, true)) {
            if (this.brokerLoadConfig().delayMetricStartMs().toMillis() == 0L) {
                this.kafka$metrics$BrokerLoad$$s$1();
            } else {
                this.brokerLoadExecutor().schedule(new Runnable(this){
                    private final /* synthetic */ BrokerLoad $outer;

                    public void run() {
                        this.$outer.kafka$metrics$BrokerLoad$$s$1();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.brokerLoadConfig().delayMetricStartMs().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        if (this.recordServiceMetrics().get()) {
            this.totalServiceLocalTimeSensor().record((double)totalConnectionTimeNanos);
            return;
        }
    }

    private void recordNetworkThreadsIdleRatio(String listenerName, double idleRatio, long timeMs) {
        if (this.multiTenantListenerNames().contains(listenerName)) {
            this.externalNetworkThreadIdleRatioSensor().record(idleRatio, timeMs);
            return;
        }
        if (listenerName.equals(this.interBrokerListener().value())) {
            this.replicationNetworkThreadIdleRatioSensor().record(idleRatio, timeMs);
            return;
        }
    }

    public void close() {
        this.metrics.removeSensor(this.totalServiceLocalTimeSensor().name());
        this.metrics.removeSensor(this.externalNetworkThreadIdleRatioSensor().name());
        this.metrics.removeSensor(this.replicationNetworkThreadIdleRatioSensor().name());
        if (this.started().compareAndSet(true, false)) {
            this.brokerLoadExecutor().shutdownNow();
            this.brokerLoadTenantMetricNames().values().foreach((Function1 & Serializable)m -> $this.metrics.removeMetric(m));
            this.metrics.removeMetric(this.brokerLoadMetricName());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Broker Load Metric closed.");
        }
    }

    public BrokerLoadGauge newBrokerLoadGauge() {
        return new BrokerLoadGauge();
    }

    public void notifyOnConnection(KafkaChannel channel) {
        this.recordConnectionTimeNanos(channel.metrics().computeConnectionLocalServiceTimeNanos());
    }

    public void notifyOnThreadUsage(String listenerName, double idleRatio, long timeMs) {
        this.recordNetworkThreadsIdleRatio(listenerName, idleRatio, timeMs);
    }

    public static final /* synthetic */ boolean $anonfun$monitorSelector$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$monitorSelector$2(BrokerLoad $this, Selector selector$1, Tuple2 x$3) {
        if (x$3 != null) {
            SelectorServiceMetric serviceMetric = (SelectorServiceMetric)x$3._1();
            CopyOnWriteArraySet metricsSet = (CopyOnWriteArraySet)x$3._2();
            serviceMetric.create(selector$1, $this.metrics, $this.metricConfig(), (MeasurableStat)new ExponentialWeightedAvg($this.brokerLoadConfig().weightedAvgAlpha())).foreach((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)metricsSet.add(metric)));
            return;
        }
        throw new MatchError(null);
    }

    public final void kafka$metrics$BrokerLoad$$s$1() {
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting broker load service metrics");
        }
        this.recordServiceMetrics().set(true);
    }

    public BrokerLoad(Metrics metrics, KafkaConfig config, Meter requestThreadIdleMeter, Option<MultiTenantMetadata> multiTenantMetadata) {
        this.metrics = metrics;
        this.kafka$metrics$BrokerLoad$$requestThreadIdleMeter = requestThreadIdleMeter;
        this.multiTenantMetadata = multiTenantMetadata;
        this.brokerLoadConfig = BrokerLoadConfig$.MODULE$.apply(config);
        this.metricConfig = new MetricConfig().samples(this.brokerLoadConfig().numSamples()).timeWindow(this.brokerLoadConfig().sampleWindowSize().toMillis(), TimeUnit.MILLISECONDS);
        this.interBrokerListener = config.interBrokerListenerName();
        this.multiTenantListenerNames = ConfluentConfigs.multitenantListenerNames((AbstractConfig)config, (ListenerName)this.interBrokerListener());
        this.selectorServiceMetrics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SelectorRegisterTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)HandshakeLocalTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)AuthenticationLocalTime$.MODULE$, new CopyOnWriteArraySet()), new Tuple2((Object)RequestLocalTime$.MODULE$, new CopyOnWriteArraySet())}));
        this.started = new AtomicBoolean(false);
        this.scheduledServiceMetrics = new AtomicBoolean(false);
        this.recordServiceMetrics = new AtomicBoolean(false);
        this.brokerLoadMetricName = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$BrokerLoadMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        this.brokerLoadTenantMetricNames = new Pool(None$.MODULE$);
        this.brokerLoadExecutor = Executors.newSingleThreadScheduledExecutor();
        this.lkcIds = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.totalServiceLocalTimeSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeSensorName());
        MetricName metricName = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ServiceLocalTimeMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName)) {
            this.totalServiceLocalTimeSensor().add(metricName, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageTotalServiceLocalTimeMetricName = metricName;
        this.externalNetworkThreadIdleRatioSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioSensorName());
        MetricName metricName2 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ExternalNetworkThreadIdleRatioMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName2)) {
            this.externalNetworkThreadIdleRatioSensor().add(metricName2, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageExternalNetworkThreadIdleRatioMetricName = metricName2;
        this.replicationNetworkThreadIdleRatioSensor = metrics.sensor(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioSensorName());
        MetricName metricName3 = new MetricName(BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioMetricName(), BrokerLoad$.MODULE$.BrokerLoadMetricGroup(), BrokerLoad$.MODULE$.kafka$metrics$BrokerLoad$$ReplicationNetworkThreadIdleRatioMetricDescription(), Collections.emptyMap());
        if (!metrics.metrics().containsKey(metricName3)) {
            this.replicationNetworkThreadIdleRatioSensor().add(metricName3, (MeasurableStat)new ExponentialWeightedAvg(this.brokerLoadConfig().weightedAvgAlpha()), this.metricConfig());
        }
        this.weightedAverageReplicationNetworkThreadIdleRatioMetricName = metricName3;
    }

    public class BrokerLoadGauge
    implements Gauge<Object> {
        private final double NoLoad;

        private double NoLoad() {
            return this.NoLoad;
        }

        public Tuple2<Object, Object> weights(double x) {
            double upperBound = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().weightsUpperBound();
            double lowerBound = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().weightsLowerBound();
            if (x <= lowerBound) {
                return new Tuple2.mcDD.sp(1.0, 0.0);
            }
            if (x <= upperBound) {
                double m_1 = (double)-1 / (upperBound - lowerBound);
                double b_1 = (double)-1 * m_1 * upperBound;
                double m_2 = 1.0 / (upperBound - lowerBound);
                double b_2 = (double)-1 * m_2 * lowerBound;
                return new Tuple2.mcDD.sp(m_1 * x + b_1, m_2 * x + b_2);
            }
            return new Tuple2.mcDD.sp(0.0, 1.0);
        }

        private double nanAwareMin(List<Object> t) {
            return BoxesRunTime.unboxToDouble((Object)t.minBy((Function1)(JFunction1.mcDD.sp & Serializable)x -> {
                if (Double.isNaN(x)) {
                    return Double.POSITIVE_INFINITY;
                }
                return x;
            }, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        }

        /*
         * WARNING - void declaration
         */
        public double value(MetricConfig config, long now) {
            void var28_17;
            void var26_16;
            Option<Metric> externalIdleRatioMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageExternalNetworkThreadIdleRatioMetric();
            Option<Metric> replicationIdleRatioMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageReplicationNetworkThreadIdleRatioMetric();
            if (externalIdleRatioMetric == null || replicationIdleRatioMetric == null) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isWarnEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().warn("Cannot compute broker load because of a null idle ratio metric");
                }
                return this.NoLoad();
            }
            double externalIdleRatio = BoxesRunTime.unboxToDouble((Object)((Metric)externalIdleRatioMetric.get()).metricValue());
            double replicationIdleRatio = BoxesRunTime.unboxToDouble((Object)((Metric)replicationIdleRatioMetric.get()).metricValue());
            double requestIdleRatio = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().kafka$metrics$BrokerLoad$$requestThreadIdleMeter.oneMinuteRate();
            if (Double.isNaN(externalIdleRatio) && Double.isNaN(replicationIdleRatio) && Double.isNaN(requestIdleRatio)) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isWarnEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().warn("Cannot compute broker load because of NaN thread idle ratio metrics");
                }
                return this.NoLoad();
            }
            double minThreadIdleRatio = this.nanAwareMin((List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{externalIdleRatio, replicationIdleRatio, requestIdleRatio}))));
            double lowLoad = 1.0 - minThreadIdleRatio;
            Option<Metric> etMetric = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().weightedAverageTotalServiceLocalTimeMetric();
            if (etMetric == null) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isWarnEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().warn("Cannot compute broker load because of a null weighted average service time metric");
                }
                return this.NoLoad();
            }
            double et = BoxesRunTime.unboxToDouble((Object)((Metric)etMetric.get()).metricValue());
            if (Double.isNaN(et)) {
                if (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().isWarnEnabled()) {
                    this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().logger().underlying().warn("Cannot compute broker load because of NaN expected total service time");
                }
                return this.NoLoad();
            }
            double es = this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().averageServiceRequestTime() * 1000000.0;
            double serviceLoad = et > es ? (et - es) / (this.kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer().brokerLoadConfig().workloadCoefficient() * es) : this.NoLoad();
            double highLoad = serviceLoad / (1.0 + serviceLoad);
            Tuple2<Object, Object> tuple2 = this.weights(lowLoad);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            double a = tuple2._1$mcD$sp();
            double b = tuple2._2$mcD$sp();
            return (double)(var26_16 * lowLoad + var28_17 * highLoad);
        }

        public /* synthetic */ BrokerLoad kafka$metrics$BrokerLoad$BrokerLoadGauge$$$outer() {
            return BrokerLoad.this;
        }

        public BrokerLoadGauge() {
            if (BrokerLoad.this == null) {
                throw null;
            }
            this.NoLoad = 0.0;
        }
    }
}

