/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import kafka.network.RequestChannel;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class AuthorizerUtils$
implements Logging {
    public static final AuthorizerUtils$ MODULE$ = new AuthorizerUtils$();
    private static final MetricName AclCountMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.security.authorizer", (String)"AclMetrics", (String)"AclCount", Collections.emptyMap());
    private static final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup(MODULE$.getClass());
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public MetricName AclCountMetricName() {
        return AclCountMetricName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return metricsGroup;
    }

    public Authorizer createAuthorizer(String className) {
        return (Authorizer)Utils.newInstance((String)className, Authorizer.class);
    }

    public boolean isClusterResource(String name) {
        return name.endsWith("kafka-cluster");
    }

    public Option<Authorizer> configureAuthorizer(KafkaConfig config) {
        Option<Authorizer> authorizerOpt = config.createNewAuthorizer();
        authorizerOpt.foreach((Function1 & Serializable)authorizer -> {
            authorizer.configure(config.originals());
            return MODULE$.metricsGroup().newGauge(MODULE$.AclCountMetricName(), (Gauge)new Gauge<Object>(authorizer){
                private final Authorizer authorizer$1;

                public final int value() {
                    return this.authorizer$1.aclCount();
                }
                {
                    this.authorizer$1 = authorizer$1;
                }
            });
        });
        return authorizerOpt;
    }

    public void closeAuthorizer(Authorizer authorizer) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> authorizer.close(), this, Level.WARN);
        this.metricsGroup().removeMetric(this.AclCountMetricName());
    }

    public AuthorizableRequestContext sessionToRequestContext(RequestChannel.Session session) {
        return new AuthorizableRequestContext(session){
            private final RequestChannel.Session session$1;

            public long kafkaRequestId() {
                return super.kafkaRequestId();
            }

            public long sessionId() {
                return super.sessionId();
            }

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return this.session$1.clientAddress();
            }

            public KafkaPrincipal principal() {
                return this.session$1.principal();
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }

            public boolean isProxyModeLocal() {
                return false;
            }
            {
                this.session$1 = session$1;
            }
        };
    }

    public boolean isCentralizedAclRequestOnKraftMdsBroker(KafkaConfig config, RequestChannel.Request request) {
        block8: {
            block7: {
                if (config == null || request == null) {
                    return false;
                }
                if (config.isMultitenantCluster() || !config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) || !config.isMdsEnabled()) break block7;
                ApiKeys apiKeys = request.header().apiKey();
                ApiKeys apiKeys2 = ApiKeys.CREATE_ACLS;
                if (!(apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2))) break block8;
                ApiKeys apiKeys3 = request.header().apiKey();
                ApiKeys apiKeys4 = ApiKeys.DELETE_ACLS;
                if (!(apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4))) break block8;
            }
            return false;
        }
        try {
            boolean isValidRequest = true;
            Object t = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            isValidRequest = t instanceof CreateAclsRequest ? isValidRequest && ((CreateAclsRequest)request.body(ClassTag$.MODULE$.apply(CreateAclsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).clusterId().isPresent() : (t instanceof DeleteAclsRequest ? isValidRequest && ((DeleteAclsRequest)request.body(ClassTag$.MODULE$.apply(DeleteAclsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).clusterId().isPresent() : false);
            if (!isValidRequest && this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = AuthorizerUtils$.$anonfun$isCentralizedAclRequestOnKraftMdsBroker$1(request);
                Object var7_7 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return isValidRequest;
        }
        catch (Throwable throwable) {
            throw new Exception("Unknown exception occurred while computing if request should be handled by MDS broker ");
        }
    }

    public static final /* synthetic */ int kafka$security$authorizer$AuthorizerUtils$$$anonfun$configureAuthorizer$2(Authorizer authorizer$1) {
        return authorizer$1.aclCount();
    }

    public static final /* synthetic */ String $anonfun$isCentralizedAclRequestOnKraftMdsBroker$1(RequestChannel.Request request$1) {
        return new StringBuilder(40).append(request$1.header().apiKey().name).append(" Request should be handled by MDS broker").toString();
    }

    private AuthorizerUtils$() {
    }
}

