/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.BrokerEndPoint;
import kafka.server.BrokerBlockingSender;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public final class BrokerBlockingSender$ {
    public static final BrokerBlockingSender$ MODULE$ = new BrokerBlockingSender$();

    /*
     * WARNING - void declaration
     */
    public BrokerBlockingSender apply(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags) {
        void var12_12;
        void var11_11;
        int socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        Tuple2<NetworkClient, Option<Reconfigurable>> tuple2 = this.createNetworkClientAndReconfigurableChannelBuilder(sourceBroker, brokerConfig, metrics, time, fetcherId, clientId, logContext, extraMetricTags, "replica-fetcher");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        NetworkClient networkClient = (NetworkClient)tuple2._1();
        Option reconfigurableChannelBuilder = (Option)tuple2._2();
        return new BrokerBlockingSender(sourceBroker, brokerConfig, socketTimeout, time, fetcherId, (KafkaClient)var11_11, (Option<Reconfigurable>)var12_12);
    }

    public Map<String, String> apply$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<NetworkClient, Option<Reconfigurable>> createNetworkClientAndReconfigurableChannelBuilder(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext, Map<String, String> extraMetricTags, String metricGrpPrefix) {
        None$ none$;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_clientSaslMechanism;
        boolean bl = brokerConfig.saslInterBrokerHandshakeRequestEnable();
        String string = brokerConfig.saslMechanismInterBrokerProtocol();
        ListenerName clientChannelBuilder_listenerName = brokerConfig.interBrokerListenerName();
        Object var14_12 = null;
        string = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)clientChannelBuilder_listenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)logContext, null, null);
        if (channelBuilder instanceof Reconfigurable) {
            brokerConfig.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, metricGrpPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)extraMetricTags.$plus$plus((IterableOnce)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))})))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMaxMs()), time, false, new ApiVersions(), logContext);
        return new Tuple2((Object)networkClient, (Object)reconfigurableChannelBuilder);
    }

    public Map<String, String> createNetworkClientAndReconfigurableChannelBuilder$default$8() {
        return (Map)Map$.MODULE$.empty();
    }

    public String createNetworkClientAndReconfigurableChannelBuilder$default$9() {
        return "replica-fetcher";
    }

    private BrokerBlockingSender$() {
    }
}

