/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001QA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005U!)q\u0006\u0001C\u0001a!91\u0007\u0001b\u0001\n\u0003!\u0004BB\u001e\u0001A\u0003%Q\u0007C\u0003=\u0001\u0011%Q\bC\u0003R\u0001\u0011%!\u000bC\u0003U\u0001\u0011%Q\u000bC\u0003a\u0001\u0011%\u0011\rC\u0003j\u0001\u0011\u0005#\u000eC\u0003j\u0001\u0011\u0005C\u000eC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0004\u0002\u0010\u0001!I!!\u0005\u0003A\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN\u001d\u0006\u0003!E\taa]3sm\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!F\u000f\u0011\u0005YYR\"A\f\u000b\u0005aI\u0012\u0001\u00027b]\u001eT\u0011AG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001d/\t1qJ\u00196fGR\u0004\"A\b\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'O\u0003\u0002\u0013E)\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0013\t9sD\u0001\fD_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003-Y\u0017MZ6b\u0007>tg-[4\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003=I!!L\b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\rW\u000647.Y\"p]\u001aLw\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\u0016\u0001\u0011\u0015A3\u00011\u0001+\u0003\u0019awnZ4feV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029I\u0005)1\u000f\u001c45U&\u0011!h\u000e\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005\tb/\u00197jI\u0006$X\rV8qS\u000et\u0015-\\3\u0015\u0005y\"\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%\u0001B+oSRDQ!\u0012\u0004A\u0002\u0019\u000bAA\\1nKB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013!\u000e\u0003)S!aS\n\u0002\rq\u0012xn\u001c;?\u0013\ti\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'A\u0003I1\u0018\r\\5eCR,'I]8lKJt\u0015-\\3\u0015\u0005y\u001a\u0006\"B#\b\u0001\u00041\u0015\u0001\n;ie><X\t_2faRLwN\u001c$peVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3\u0015\u0005y2\u0006\"B,\t\u0001\u0004A\u0016\u0001\u0003:fg>,(oY3\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AB2p]\u001aLwM\u0003\u0002^C\u000511m\\7n_:L!a\u0018.\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\u0006)c/\u00197jI\u0006$XM\u0011:pW\u0016\u00148k\u00195f[\u00064\u0016\r\\5eCRLwN\\\"p]\u001aLwm\u001d\u000b\u0003}\tDQaW\u0005A\u0002\r\u0004B\u0001Z4G\r6\tQM\u0003\u0002g3\u0005!Q\u000f^5m\u0013\tAWMA\u0002NCB\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003}-DQa\u0016\u0006A\u0002a#2AP7o\u0011\u001596\u00021\u0001Y\u0011\u0015Y6\u00021\u0001d\u0003e1\u0018\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3\u0015\ry\n8/^A\u0003\u0011\u0015\u0011H\u00021\u0001d\u0003I\u0001(/\u001a<SKN|GN^3e\u0007>tg-[4\t\u000bQd\u0001\u0019A2\u0002#9,wOU3t_24X\rZ\"p]\u001aLw\rC\u0003w\u0019\u0001\u0007q/A\u0004ce>\\WM]:\u0011\u0007\u0011D(0\u0003\u0002zK\nA\u0011\n^3sCR|'\u000fE\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\f\u0011\u0002\u001d7bG\u0016lWM\u001c;\u000b\u0005}\f\u0013\u0001C7fi\u0006$\u0017\r^1\n\u0007\u0005\rAP\u0001\u0007Vg\u0006\u0014G.\u001a\"s_.,'\u000fC\u0004\u0002\b1\u0001\r!!\u0003\u00023%\u001cHk\u001c9jGBc\u0017mY3nK:$8+\u001e9q_J$X\r\u001a\t\u0004\u007f\u0005-\u0011bAA\u0007\u0001\n9!i\\8mK\u0006t\u0017!\u000b<bY&$\u0017\r^3U_BL7\r\u00157bG\u0016lWM\u001c;D_:4\u0017nZ;sCRLwN\\\"iC:<W\rF\u0005?\u0003'\t)#!\u000b\u0002,!9\u0011QC\u0007A\u0002\u0005]\u0011A\u00059sKZ$v\u000e]5d!2\f7-Z7f]R\u0004R\u0001ZA\r\u0003;I1!a\u0007f\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BA\u0010\u0003Ci\u0011A`\u0005\u0004\u0003Gq(A\u0004+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u0005\b\u0003Oi\u0001\u0019AA\f\u0003EqWm\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u0005\u0006m6\u0001\ra\u001e\u0005\b\u0003\u000fi\u0001\u0019AA\u0005\u0001")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;
    private final Logger logger;

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Logger logger() {
        return this.logger;
    }

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (!name.isEmpty()) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    private void validateBrokerSchemaValidationConfigs(Map<String, String> config) {
        HashMap<String, Object> allConfigs = new HashMap<String, Object>(this.kafkaConfig().originals());
        allConfigs.putAll(config);
        try {
            LogConfig.createSchemaValidationInterceptorIfNeeded(allConfigs, (Logger)this.logger()).ifPresent(x$1 -> x$1.close());
            return;
        }
        catch (Exception e) {
            this.logger().error("Error closing schema validation interceptor", (Throwable)e);
            return;
        }
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig.validate((Properties)properties, this.kafkaConfig().extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isRemoteLogStorageSystemEnabled()));
            this.validateBrokerSchemaValidationConfigs(config);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            ClusterLinkConfig$.MODULE$.create(config, (Option<KafkaConfig>)new Some((Object)this.kafkaConfig()), true);
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validateTopicConfigChange(Map<String, String> prevResolvedConfig, Map<String, String> newResolvedConfig, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        LogConfig curLogConfig = LogConfig.fromProps(prevResolvedConfig, (Properties)new Properties());
        LogConfig nextLogConfig = LogConfig.fromProps(newResolvedConfig, (Properties)new Properties());
        LogConfig.validateChange((LogConfig)curLogConfig, (LogConfig)nextLogConfig, (MetadataVersion)MetadataVersion.latest(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierFeature()), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierCleanerFeatureEnable()));
        this.validateBrokerSchemaValidationConfigs(newResolvedConfig);
        this.validateTopicPlacementConfigurationChange(curLogConfig.confluentLogConfig().topicPlacementConstraints, nextLogConfig.confluentLogConfig().topicPlacementConstraints, brokers, isTopicPlacementSupported);
    }

    private void validateTopicPlacementConfigurationChange(Optional<TopicPlacement> prevTopicPlacement, Optional<TopicPlacement> newTopicPlacement, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        if (!Objects.equals(prevTopicPlacement, newTopicPlacement)) {
            newTopicPlacement.ifPresent(topicPlacement -> {
                if (!isTopicPlacementSupported) {
                    throw new InvalidConfigurationException("Topic placement is not supported.");
                }
                TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)topicPlacement, (Iterator)brokers, (Logger)this.logger());
            });
            return;
        }
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

