/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerChannelManager;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\t\u0013\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000fy\u0003!\u0019!C\u0005?\"11\u000f\u0001Q\u0001\n\u0001DQ\u0001\u001e\u0001\u0005BUDq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011BAI\u0005}!UMZ1vYR\fU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0007\u0010#!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002%%\u0011\u0011E\u0005\u0002\u0019\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\bCA\u0012'\u001b\u0005!#BA\u0013\u0015\u0003\u0015)H/\u001b7t\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\ty\"&\u0003\u0002,%\tY1*\u00194lC\u000e{gNZ5h\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJ\u00042!\u0007\u00181\u0013\ty#D\u0001\u0004PaRLwN\u001c\t\u0003?EJ!A\r\n\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001D1e[&tW*\u00198bO\u0016\u0014\bcA\r/kA\u0011qDN\u0005\u0003oI\u0011aBW6BI6Lg.T1oC\u001e,'/\u0001\u0006d_:$(o\u001c7mKJ\u00042!\u0007\u0018;!\tYT(D\u0001=\u0015\tAD#\u0003\u0002?y\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'/\u0001\the>,\boQ8pe\u0012Lg.\u0019;peB\u0011\u0011iS\u0007\u0002\u0005*\u00111\tR\u0001\u0006OJ|W\u000f\u001d\u0006\u0003\u000b\u001a\u000b1bY8pe\u0012Lg.\u0019;pe*\u0011Qc\u0012\u0006\u0003\u0011&\u000ba!\u00199bG\",'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0005\n\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN]\u0001\u000fibt7i\\8sI&t\u0017\r^8s!\ty5+D\u0001Q\u0015\t\t&+A\u0006ue\u0006t7/Y2uS>t'BA#\u0015\u0013\t!\u0006K\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0003\u0019a\u0014N\\5u}Q9q\u000bW-[7rk\u0006CA\u0010\u0001\u0011\u0015As\u00011\u0001*\u0011\u0015as\u00011\u0001.\u0011\u0015\u0019t\u00011\u00015\u0011\u0015At\u00011\u0001:\u0011\u0015yt\u00011\u0001A\u0011\u0015iu\u00011\u0001O\u00039IgN\u001a7jO\"$Hk\u001c9jGN,\u0012\u0001\u0019\t\u0004C\u001aDW\"\u00012\u000b\u0005\r$\u0017\u0001B;uS2T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n\u00191+\u001a;\u0011\u0005%\u0004hB\u00016o!\tY'$D\u0001m\u0015\tig#\u0001\u0004=e>|GOP\u0005\u0003_j\ta\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qNG\u0001\u0010S:4G.[4iiR{\u0007/[2tA\u0005a1M]3bi\u0016$v\u000e]5dgR9a/a\t\u0002,\u0005U\u0002cA<{y6\t\u0001P\u0003\u0002z5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005mD(aA*fcB\u0019Q0!\b\u000f\u0007y\f9BD\u0002\u0000\u0003#qA!!\u0001\u0002\u000e9!\u00111AA\u0006\u001d\u0011\t)!!\u0003\u000f\u0007-\f9!C\u0001K\u0013\tA\u0015*\u0003\u0002\u0016\u000f&\u0019\u0011q\u0002$\u0002\r\r|W.\\8o\u0013\u0011\t\u0019\"!\u0006\u0002\u000f5,7o]1hK*\u0019\u0011q\u0002$\n\t\u0005e\u00111D\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005M\u0011QC\u0005\u0005\u0003?\t\tCA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\u000b\t\u0005e\u00111\u0004\u0005\b\u0003KQ\u0001\u0019AA\u0014\u0003\u0019!x\u000e]5dgB!q/!\u000bi\u0013\t9\u0007\u0010C\u0004\u0002.)\u0001\r!a\f\u0002/\r|g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007cA\u0010\u00022%\u0019\u00111\u0007\n\u0003/\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007bBA\u001c\u0015\u0001\u0007\u0011\u0011H\u0001\u0017[\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u000e{g\u000e^3yiB!\u0011DLA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"\u0002BA!\u0003+\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u000b\nyD\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002!\r\u0014X-\u0019;f)>\u0004\u0018nY:J]j[Gc\u0002<\u0002L\u0005\r\u0014Q\r\u0005\b\u0003\u001bZ\u0001\u0019AA(\u0003=\u0019'/Z1uC\ndW\rV8qS\u000e\u001c\bCB<\u0002R!\f)&C\u0002\u0002Ta\u00141!T1q!\u0011\t9&!\u0018\u000f\u0007y\fI&\u0003\u0003\u0002\\\u0005m\u0011aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\ty&!\u0019\u0003\u001d\r\u0013X-\u0019;bE2,Gk\u001c9jG*!\u00111LA\u000e\u0011\u001d\tic\u0003a\u0001\u0003_Aq!a\u000e\f\u0001\u0004\tI$\u0001\ftK:$7I]3bi\u0016$v\u000e]5d%\u0016\fX/Z:u)\u00151\u00181NA7\u0011\u001d\ti\u0005\u0004a\u0001\u0003\u001fBq!a\u000e\r\u0001\u0004\tI$A\u000bdY\u0016\f'/\u00138gY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0015\t\u0005M\u0014\u0011\u0010\t\u00043\u0005U\u0014bAA<5\t!QK\\5u\u0011\u001d\ti%\u0004a\u0001\u0003\u001f\nab\u0019:fCR\f'\r\\3U_BL7\r\u0006\u0003\u0002V\u0005}\u0004BBAA\u001d\u0001\u0007\u0001.A\u0003u_BL7-\u0001\tjgZ\u000bG.\u001b3U_BL7MT1nKR!\u0011qQAG!\rI\u0012\u0011R\u0005\u0004\u0003\u0017S\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0003{\u0001\u0019\u00015\u0002+\u0019LG\u000e^3s\u0007J,\u0017\r^1cY\u0016$v\u000e]5dgR!\u00111SAM!\u0019I\u0012QSA(m&\u0019\u0011q\u0013\u000e\u0003\rQ+\b\u000f\\33\u0011\u001d\t)\u0003\u0005a\u0001\u0003O\u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<NodeToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = var5_5.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, metadataRequestContext) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, controllerMutationQuota, metadataRequestContext));
        return (Seq)var6_6.$plus$plus((IterableOnce)creatableTopicResponses);
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        scala.collection.immutable.Seq seq;
        block5: {
            AtomicReference topicErrors = new AtomicReference();
            try {
                ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)((Map)scala.collection.Map$.MODULE$.empty()), controllerMutationQuota, (Option<KafkaPrincipal>)metadataRequestContext.map((Function1 & Serializable)x$2 -> x$2.principal), (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                    topicErrors.set(x$1);
                    return BoxedUnit.UNIT;
                });
                Option option = Option$.MODULE$.apply(topicErrors.get());
                if (option instanceof Some) {
                    seq = (scala.collection.immutable.Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable)x0$1 -> {
                        if (x0$1 != null) {
                            String topic = (String)x0$1._1();
                            Errors errors = ((ApiError)x0$1._2()).error();
                            Errors error = (Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors)) ? Errors.LEADER_NOT_AVAILABLE : (Errors.POLICY_VIOLATION.equals(errors) ? Errors.TOPIC_AUTHORIZATION_FAILED : errors);
                            return new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                        }
                        throw new MatchError(null);
                    });
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    seq = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            finally {
                this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
            }
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with authentication exception").toString());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with invalid version exception").toString());
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(" with response ").append(response.responseBody()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        NodeToControllerChannelManager channelManager = (NodeToControllerChannelManager)this.channelManager.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Channel manager must be defined in order to send CreateTopic requests.");
        });
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = channelManager.controllerApiVersions();
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable)() -> createTopicsRequest);
        channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        switch (topic == null ? 0 : topic.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(topic)) break;
                Properties groupMetadataTopicConfigs = this.groupCoordinator.groupMetadataTopicConfigs();
                short replicationFactor = groupMetadataTopicConfigs.getProperty("confluent.placement.constraints", "").isEmpty() ? (short)Predef$.MODULE$.Short2short(this.config.offsetsTopicReplicationFactor()) : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.offsetsTopicPartitions())).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(groupMetadataTopicConfigs));
            }
            case -253293552: {
                if (!"__transaction_state".equals(topic)) break;
                short replicationFactor = this.txnCoordinator.placementConstraints().isEmpty() ? (short)Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor()) : (short)-1;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable)topic -> {
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                return uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(validationError)) {
                return creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            }
            throw new MatchError((Object)validationError);
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<NodeToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

