/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001B\u0012%\u0001%B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"I!\n\u0001BC\u0002\u0013\u0005Ae\u0013\u0005\t/\u0002\u0011\t\u0011)A\u0005\u0019\"I\u0001\f\u0001BC\u0002\u0013\u0005A%\u0017\u0005\t;\u0002\u0011\t\u0011)A\u00055\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!1\u0007A!A!\u0002\u00139\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u00119\u0004!\u0011!Q\u0001\n=DQ!\u001f\u0001\u0005\u0002iD\u0011\"a\u0003\u0001\u0001\u0004%\t\"!\u0004\t\u0013\u0005}\u0001\u00011A\u0005\u0012\u0005\u0005\u0002\u0002CA\u0017\u0001\u0001\u0006K!a\u0004\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA\u001f\u0001\u0011\u0005\u00131\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!!#\u0001\t#\tY\tC\u0004\u0002$\u0002!\t\"!*\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003@\u0001!\tE!\u0011\t\u000f\t=\u0003\u0001\"\u0005\u0003R!9!\u0011\r\u0001\u0005\u0012\t\r\u0004b\u0002B5\u0001\u0011E!1\u000e\u0005\b\u0005c\u0002A\u0011\tB:\u0011\u001d\u0011I\n\u0001C!\u00057\u0013ACU3n_R,G*Z1eKJ,e\u000e\u001a)pS:$(BA\u0013'\u0003\u0019\u0019XM\u001d<fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Q\u0003\u0007\u000e\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0012T\"\u0001\u0013\n\u0005M\"#A\u0004'fC\u0012,'/\u00128e!>Lg\u000e\u001e\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\nQ!\u001e;jYNL!!\u000f\u001c\u0003\u000f1{wmZ5oO\u0006IAn\\4Qe\u00164\u0017\u000e\u001f\t\u0003y\rs!!P!\u0011\u0005ybS\"A \u000b\u0005\u0001C\u0013A\u0002\u001fs_>$h(\u0003\u0002CY\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011E&\u0001\bcY>\u001c7.\u001b8h'\u0016tG-\u001a:\u0011\u0005EB\u0015BA%%\u00051\u0011En\\2lS:<7+\u001a8e\u0003M1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s+\u0005a\u0005CA'V\u001b\u0005q%BA(Q\u0003\u001d\u0019G.[3oiNT!aJ)\u000b\u0005I\u001b\u0016AB1qC\u000eDWMC\u0001U\u0003\ry'oZ\u0005\u0003-:\u00131CR3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\fACZ3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ\u0004\u0013A\u0004:fcV,7\u000f\u001e\"vS2$WM]\u000b\u00025B\u0011\u0011gW\u0005\u00039\u0012\u0012aBU3rk\u0016\u001cHOQ;jY\u0012,'/A\bsKF,Xm\u001d;Ck&dG-\u001a:!\u0003%!\bN]8ui2,'\u000f\u0005\u00022A&\u0011\u0011\r\n\u0002\u0012\r>dGn\\<feRC'o\u001c;uY\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0019e\u0013\t)GEA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003c!L!!\u001b\u0013\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0011\u0011\u0007\\\u0005\u0003[\u0012\u0012ABU3qY&\u001c\u0017-U;pi\u0006\fq#\\3uC\u0012\fG/\u0019,feNLwN\\*vaBd\u0017.\u001a:\u0011\u0007-\u0002(/\u0003\u0002rY\tIa)\u001e8di&|g\u000e\r\t\u0003g^l\u0011\u0001\u001e\u0006\u0003kZ\faaY8n[>t'BA\u0013Q\u0013\tAHOA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0019a\u0014N\\5u}Qy1\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\tI\u0001\u0005\u00022\u0001!)!\b\u0004a\u0001w!)a\t\u0004a\u0001\u000f\")!\n\u0004a\u0001\u0019\")\u0001\f\u0004a\u00015\")a\f\u0004a\u0001?\")!\r\u0004a\u0001G\")a\r\u0004a\u0001O\")!\u000e\u0004a\u0001W\")a\u000e\u0004a\u0001_\u0006Ia-\u001a;dQNK'0Z\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\b\u0013:$XmZ3s\u000351W\r^2i'&TXm\u0018\u0013fcR!\u00111EA\u0015!\rY\u0013QE\u0005\u0004\u0003Oa#\u0001B+oSRD\u0011\"a\u000b\u000f\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'\u0001\u0006gKR\u001c\u0007nU5{K\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u00024A\u00191&!\u000e\n\u0007\u0005]BFA\u0004C_>dW-\u00198\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\t\t\u0019#A\u0003dY>\u001cX-\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0015\u0005\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%c%A\u0004dYV\u001cH/\u001a:\n\t\u00055\u0013q\t\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003\u00151W\r^2i)\u0011\t\u0019&!\u001d\u0011\u0011\u0005U\u00131LA0\u0003Sj!!a\u0016\u000b\u0007\u0005eC&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\t\u0019Q*\u00199\u0011\t\u0005\u0005\u0014QM\u0007\u0003\u0003GR!!\u001e)\n\t\u0005\u001d\u00141\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tY'!\u001c\u000e\u0003\u0001I1!a\u001c3\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002tQ\u0001\r!!\u001e\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005]\u00141\u0011\b\u0005\u0003s\ny(\u0004\u0002\u0002|)!\u0011QPA2\u0003!\u0011X-];fgR\u001c\u0018\u0002BAA\u0003w\nABR3uG\"\u0014V-];fgRLA!!\"\u0002\b\n9!)^5mI\u0016\u0014(\u0002BAA\u0003w\nQ\u0003\u001d:pG\u0016\u001c8OR3uG\",\u0005pY3qi&|g\u000e\u0006\u0003\u0002$\u00055\u0005bBAH+\u0001\u0007\u0011\u0011S\u0001\u0002iB!\u00111SAO\u001d\u0011\t)*!'\u000f\u0007y\n9*C\u0001.\u0013\r\tY\nL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty*!)\u0003\u0013QC'o\\<bE2,'bAANY\u0005!\u0002O]8dKN\u001ch)\u001a;dQJ+7\u000f]8og\u0016$B!a\u0015\u0002(\"9\u0011\u0011\u0016\fA\u0002\u0005-\u0016AD2mS\u0016tGOU3ta>t7/\u001a\t\u0004\u001b\u00065\u0016bAAX\u001d\nq1\t\\5f]R\u0014Vm\u001d9p]N,\u0017a\u00054fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HCBA[\u0003w\u000by\fE\u0002t\u0003oK1!!/u\u00059yeMZ:fi\u0006sG-\u00129pG\"Dq!!0\u0018\u0001\u0004\ty&\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0005w\u00031\u0001\u0002D\u0006\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i!\rY\u0013QY\u0005\u0004\u0003\u000fd#aA%oi\u0006\tb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\r\u0005U\u0016QZAh\u0011\u001d\ti\f\u0007a\u0001\u0003?Bq!!1\u0019\u0001\u0004\t\u0019-\u0001\u0010gKR\u001c\u0007\u000eV5fe6\u000bG/\u001a:jC2L'0\u0019;j_:$\u0016M]4fiR1\u0011Q[An\u0003;\u00042!MAl\u0013\r\tI\u000e\n\u0002\u000f)&,'o\u00144gg\u0016$\u0018J\u001c4p\u0011\u001d\ti,\u0007a\u0001\u0003?Bq!!1\u001a\u0001\u0004\t\u0019-\u0001\rgKR\u001c\u0007.R1sY&,7\u000f\u001e'pG\u0006dwJ\u001a4tKR$b!!.\u0002d\u0006\u0015\bbBA_5\u0001\u0007\u0011q\f\u0005\b\u0003\u0003T\u0002\u0019AAb\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0015\u0011\u0005-\u0018\u0011_Az\u0003k\u0004raKAw\u0003\u0007\f).C\u0002\u0002p2\u0012a\u0001V;qY\u0016\u0014\u0004bBA_7\u0001\u0007\u0011q\f\u0005\b\u0003\u0003\\\u0002\u0019AAb\u0011\u001d\t9p\u0007a\u0001\u0003s\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007-\nY0C\u0002\u0002~2\u0012A\u0001T8oO\u0006Qb-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN\f5OS1wCR!!1\u0001B\u001a!!\u0011)Aa\u0003\u0002`\t5QB\u0001B\u0004\u0015\u0011\u0011I!a\u0006\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\u00129\u0001\u0005\u0003\u0003\u0010\t5b\u0002\u0002B\t\u0005OqAAa\u0005\u0003$9!!Q\u0003B\u0011\u001d\u0011\u00119Ba\b\u000f\t\te!Q\u0004\b\u0004}\tm\u0011\"\u0001+\n\u0005I\u001b\u0016BA\u0014R\u0013\t)\b+\u0003\u0003\u0003&\u0005\r\u0014aB7fgN\fw-Z\u0005\u0005\u0005S\u0011Y#\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'\u0002\u0002B\u0013\u0003GJAAa\f\u00032\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002\u0002B\u0015\u0005WAqA!\u000e\u001d\u0001\u0004\u00119$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002B!\u0002\u0003\f\u0005}#\u0011\b\t\u0005\u0003W\u0012Y$C\u0002\u0003>I\u0012\u0011\"\u00129pG\"$\u0015\r^1\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\u0011\u0019Ea\u0013\u0011\u0011\u0005U\u00131LA0\u0005\u000b\u0002BAa\u0012\u0003.9!!\u0011\nB\u0014\u001b\t\u0011Y\u0003C\u0004\u00036u\u0001\rA!\u0014\u0011\u0011\u0005U\u00131LA0\u0005s\tAd\u0019:fCR,W\t]8dQ\u0016sGm\u00144gg\u0016$8OU3rk\u0016\u001cH\u000f\u0006\u0003\u0003T\t}\u0003\u0003\u0002B+\u00057rA!!\u001f\u0003X%!!\u0011LA>\u0003qyeMZ:fiN4uN\u001d'fC\u0012,'/\u00129pG\"\u0014V-];fgRLA!!\"\u0003^)!!\u0011LA>\u0011\u001d\u0011)D\ba\u0001\u0005\u001b\na\u0004\u001d:pG\u0016\u001c8/\u00129pG\",e\u000eZ(gMN,Go\u001d*fgB|gn]3\u0015\t\t\r#Q\r\u0005\b\u0005Oz\u0002\u0019AAV\u0003!\u0011Xm\u001d9p]N,\u0017!\b9s_\u000e,7o]#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:GC&dWO]3\u0015\r\t\r#Q\u000eB8\u0011\u001d\u0011)\u0004\ta\u0001\u0005\u001bBq!a$!\u0001\u0004\t\t*\u0001\u0006ck&dGMR3uG\"$BA!\u001e\u0003\u0010B1!q\u000fB?\u0005\u0007s1!\rB=\u0013\r\u0011Y\bJ\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011yH!!\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011Y\b\n\t\u0006W\t\u0015%\u0011R\u0005\u0004\u0005\u000fc#AB(qi&|g\u000e\u0005\u0003\u0003x\t-\u0015\u0002\u0002BG\u0005\u0003\u0013ABU3qY&\u001c\u0017MR3uG\"DqA!\u000e\"\u0001\u0004\u0011\t\n\u0005\u0005\u0002V\u0005m\u0013q\fBJ!\r\t$QS\u0005\u0004\u0005/##a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017aD5t%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0015\t\u0005M\"Q\u0014\u0005\b\u0005?\u0013\u0003\u0019AA0\u0003\t!\b\u000f")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(Integer x$1) {
        this.fetchSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.processFetchException(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        return this.processFetchResponse(clientResponse2);
    }

    public void processFetchException(Throwable t) {
        this.fetchSessionHandler().handleError(t);
    }

    public Map<TopicPartition, FetchResponseData.PartitionData> processFetchResponse(ClientResponse clientResponse) {
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse.requestHeader().apiVersion())).asScala();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            void var4_4;
            Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TierOffsetInfo tierOffsetInfo = (TierOffsetInfo)tuple2._2();
            return var4_4;
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Remote Leader Endpoint.");
    }

    private Tuple2<Object, TierOffsetInfo> fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)listOffsetRequest).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV2)) {
                if (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID)) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()));
                }
                long apply_localLogStartOffset = responsePartition.offset();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)new TierOffsetInfo(apply_localLogStartOffset, (Option<TierMaterializationRequirements>)None$.MODULE$));
            }
            long apply_localLogStartOffset = Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0));
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)new TierOffsetInfo(apply_localLogStartOffset, (Option<TierMaterializationRequirements>)None$.MODULE$));
        }
        throw errors.exception();
    }

    public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsetsAsJava(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.fetchEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala())).asJava();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return (Map)scala.collection.Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.createEpochEndOffsetsRequest(partitions);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            return this.processEpochEndOffsetsResponse(response);
        }
        catch (Throwable t) {
            return this.processEpochEndOffsetsFailure(partitions, t);
        }
    }

    public OffsetsForLeaderEpochRequest.Builder createEpochEndOffsetsRequest(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$createEpochEndOffsetsRequest$1(topics, topicPartition, epochData));
        partitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var3_3 = null;
        return this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsResponse(ClientResponse response) {
        OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responseBody.data().topics()).asScala().flatMap((Function1 & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1 & Serializable)offsetForLeaderPartitionResult -> {
            TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> processEpochEndOffsetsFailure(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions, Throwable t) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        Errors error = Errors.forException((Throwable)t);
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
            }
            throw new MatchError(null);
        });
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || $this.throttler.shouldThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager);
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$5 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$5))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.replicationSessionId().map((Function1 & Serializable)x$6 -> RemoteLeaderEndPoint.$anonfun$buildFetch$4(BoxesRunTime.unboxToLong((Object)x$6))))), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)Errors.KAFKA_STORAGE_ERROR));
                }
            }
            return BoxedUnit.UNIT;
        };
        partitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_6 = null;
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Some fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Some>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createEpochEndOffsetsRequest$1(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ Long $anonfun$buildFetch$4(long x$6) {
        return BoxesRunTime.boxToLong((long)x$6);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

