/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoMirroring$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.SourceCluster$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001\u0002 @\u0001\u0019C\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003X\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u000b\u0007I\u0011A2\t\u0011]\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000by\u0002\u0011\t\u0011)A\u0005{\u0006-\u0001\u0002DA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0010\u0005]\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_A\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\t\u0011\u0005\u0015\u0003\u0001)Q\u0005\u0003cA\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005E\u0004\u0001)A\u0005\u0003\u0017B\u0011\"a\u001d\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005U\u0004\u0001)A\u0005\u0003\u0017B\u0011\"a\u001e\u0001\u0001\u0004%I!!\u001f\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005\r\u0005\u0002CAD\u0001\u0001\u0006K!a\u001f\t\u0013\u0005%\u0005A1A\u0005\n\u0005-\u0005bBAG\u0001\u0001\u0006IA\u001b\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#C\u0011\"!'\u0001\u0001\u0004%I!a'\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003'C1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012\"Y\u00111\u0015\u0001A\u0002\u0003\u0007I\u0011BAS\u0011-\tI\u000b\u0001a\u0001\u0002\u0003\u0006K!a%\t\u0013\u0005-\u0006\u00011A\u0005\n\u00055\u0006\"CA^\u0001\u0001\u0007I\u0011BA_\u0011!\t\t\r\u0001Q!\n\u0005=\u0006bBAf\u0001\u0011E\u0013Q\u001a\u0005\b\u0003G\u0004A\u0011BAg\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t5\u0002\u0001\"\u0003\u00030!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#BqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003\u0014\u0002!IA!&\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"9!1\u0016\u0001\u0005\n\t5\u0006\u0002\u0003BX\u0001\u0011\u0005q(!\u0013\t\u0011\tE\u0006\u0001\"\u0001@\u0003\u0013B\u0001Ba-\u0001\t\u0003y\u0014\u0011\u0013\u0005\b\u0005k\u0003A\u0011\u000bB\\\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007<qA!2@\u0011\u0003\u00119M\u0002\u0004?\u007f!\u0005!\u0011\u001a\u0005\b\u00033)D\u0011\u0001Bi\u0011%\u0011\u0019.\u000eb\u0001\n\u0003\u0011)\u000e\u0003\u0005\u0003fV\u0002\u000b\u0011\u0002Bl\u0011%\u00119/\u000eb\u0001\n\u0003\u0011I\u000f\u0003\u0005\u0003xV\u0002\u000b\u0011\u0002Bv\u0011\u001d\u0011I0\u000eC\u0001\u0005wD\u0011b!\u00056\u0005\u0004%\t!!\u001f\t\u0011\rMQ\u0007)A\u0005\u0003w\u0012\u0001d\u00117vgR,'\u000fT5oW\u0006+Ho\\'jeJ|'/\u001b8h\u0015\t\u0001\u0015)\u0001\u0003mS:\\'B\u0001\"D\u0003\u0019\u0019XM\u001d<fe*\tA)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0005C\u0001%M\u001d\tI%*D\u0001@\u0013\tYu(\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003\u001b:\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!aS \u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\u0005\t\u0006CA%S\u0013\t\u0019vH\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/F\u0001X!\tI\u0005,\u0003\u0002Z\u007f\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u0001R.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fI\u0001\tY&t7\u000eR1uCB\u0011Q\fY\u0007\u0002=*\u0011qlQ\u0001\u0003u.L!!\u00190\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0001\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0003\u0011\u00042!\u001a5k\u001b\u00051'\"A4\u0002\u000bM\u001c\u0017\r\\1\n\u0005%4'!\u0003$v]\u000e$\u0018n\u001c81!\tYW/D\u0001m\u0015\tig.A\u0003bI6LgN\u0003\u0002pa\u000691\r\\5f]R\u001c(B\u0001#r\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\n\u0005Yd'AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0012I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef\u0004\u0013aB7fiJL7m\u001d\t\u0003\u0013jL!a_ \u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0005i&lW\rE\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0003vi&d7OC\u0002\u0002\u0006A\faaY8n[>t\u0017bAA\u0005\u007f\n!A+[7f\u0013\taH*A\u0003rk>$\u0018\r\u0005\u0003\u0002\u0012\u0005MQ\"A!\n\u0007\u0005U\u0011IA\fDYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC&\u0019\u0011Q\u0002'\u0002\rqJg.\u001b;?)A\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\tY\u0003\u0005\u0002J\u0001!)qj\u0003a\u0001#\")Qk\u0003a\u0001/\")1l\u0003a\u00019\")!m\u0003a\u0001I\")\u0001p\u0003a\u0001s\")Ap\u0003a\u0001{\"9\u0011QB\u0006A\u0002\u0005=\u0011AB2p]\u001aLw-\u0006\u0002\u00022A\u0019\u0011*a\r\n\u0007\u0005UrHA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\tY$!\u0011\u0011\u0007\u0015\fi$C\u0002\u0002@\u0019\u0014A!\u00168ji\"I\u00111I\u0007\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\r[&\u0014(o\u001c:U_BL7m]\u000b\u0003\u0003\u0017\u0002b!!\u0014\u0002X\u0005mSBAA(\u0015\u0011\t\t&a\u0015\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u000b4\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002Z\u0005=#aA*fiB!\u0011QLA6\u001d\u0011\ty&a\u001a\u0011\u0007\u0005\u0005d-\u0004\u0002\u0002d)\u0019\u0011QM#\u0002\rq\u0012xn\u001c;?\u0013\r\tIGZ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0014q\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%d-A\u0007nSJ\u0014xN\u001d+pa&\u001c7\u000fI\u0001\u0016G>tg\r\\5di&tw\rR3tiR{\u0007/[2t\u0003Y\u0019wN\u001c4mS\u000e$\u0018N\\4EKN$Hk\u001c9jGN\u0004\u0013\u0001\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h+\t\tY\bE\u0002f\u0003{J1!a g\u0005\rIe\u000e^\u0001\u0015i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F%Z9\u0015\t\u0005m\u0012Q\u0011\u0005\n\u0003\u0007\"\u0012\u0011!a\u0001\u0003w\n\u0011\u0003^1tWN|U\u000f^:uC:$\u0017N\\4!\u0003%!Wm\u001d;BI6Lg.F\u0001k\u0003)!Wm\u001d;BI6Lg\u000eI\u0001\fS:LG/[1mSj,G-\u0006\u0002\u0002\u0014B\u0019Q-!&\n\u0007\u0005]eMA\u0004C_>dW-\u00198\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$B!a\u000f\u0002\u001e\"I\u00111I\r\u0002\u0002\u0003\u0007\u00111S\u0001\rS:LG/[1mSj,G\rI\u0001\u0019g\"|W\u000f\u001c3GS2$XM]'jeJ|'\u000fV8qS\u000e\u001c\u0018\u0001H:i_VdGMR5mi\u0016\u0014X*\u001b:s_J$v\u000e]5dg~#S-\u001d\u000b\u0005\u0003w\t9\u000bC\u0005\u0002Dq\t\t\u00111\u0001\u0002\u0014\u0006I2\u000f[8vY\u00124\u0015\u000e\u001c;fe6K'O]8s)>\u0004\u0018nY:!\u0003!!\u0018m]6EKN\u001cWCAAX!\u0015)\u0017\u0011WA[\u0013\r\t\u0019L\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007%\u000b9,C\u0002\u0002:~\u0012q\u0002V1tW\u0012+7o\u0019:jaRLwN\\\u0001\ri\u0006\u001c8\u000eR3tG~#S-\u001d\u000b\u0005\u0003w\ty\fC\u0005\u0002D}\t\t\u00111\u0001\u00020\u0006IA/Y:l\t\u0016\u001c8\r\t\u0015\u0004A\u0005\u0015\u0007cA3\u0002H&\u0019\u0011\u0011\u001a4\u0003\u0011Y|G.\u0019;jY\u0016\f1A];o)\t\ty\r\u0005\u0003\u0002R\u0006}gbAAj\u0015:!\u0011Q[Ao\u001d\u0011\t9.a7\u000f\t\u0005\u0005\u0014\u0011\\\u0005\u0002\t&\u0011!iQ\u0005\u0003\u0001\u0006K1!!9O\u0005)!\u0016m]6SKN,H\u000e^\u0001\u0018S:LG/[1mSj,\u0017I\u001c3BkR|W*\u001b:s_J\f!\"Y;u_6K'O]8s)\u0011\ty-!;\t\u000f\u0005-8\u00051\u0001\u0002n\u0006YA/Y:l\u0007>tG/\u001a=u!\u0011\t\t.a<\n\u0007\u0005EhJA\u0006UCN\\7i\u001c8uKb$\u0018A\u00065b]\u0012dW\rT5tiN{WO]2f)>\u0004\u0018nY:\u0015\r\u0005=\u0017q_A}\u0011\u001d\tY\u000f\na\u0001\u0003[Dq!a?%\u0001\u0004\ti0\u0001\u0004sKN,H\u000e\u001e\t\u0004W\u0006}\u0018b\u0001B\u0001Y\n\u0001B*[:u)>\u0004\u0018nY:SKN,H\u000e^\u0001\u001dQ\u0006tG\r\\3MSN$8k\\;sG\u0016l\u0015N\u001d:peR{\u0007/[2t)!\tyMa\u0002\u0003\n\tE\u0001bBAvK\u0001\u0007\u0011Q\u001e\u0005\b\u0005\u0017)\u0003\u0019\u0001B\u0007\u0003\u0019!x\u000e]5dgB1\u0011Q\fB\b\u00037JA!!\u0017\u0002p!9!1C\u0013A\u0002\tU\u0011!\u00057jgRl\u0015N\u001d:peN4U\u000f^;sKB1!q\u0003B\r\u0005;i!!a\u0001\n\t\tm\u00111\u0001\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0004\u0003 \t%\u00121L\u0007\u0003\u0005CQAAa\t\u0003&\u0005!Q\u000f^5m\u0015\t\u00119#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0016\u0005C\u0011!bQ8mY\u0016\u001cG/[8o\u0003QA\u0017M\u001c3mK\u001aKG\u000e^3sK\u0012$v\u000e]5dgR1\u0011q\u001aB\u0019\u0005gAq!a;'\u0001\u0004\ti\u000fC\u0004\u00036\u0019\u0002\rA!\u0004\u0002\u001d\u0019LG\u000e^3sK\u0012$v\u000e]5dg\u0006!\u0002.\u00198eY\u0016d\u0015n\u001d;EKN$Hk\u001c9jGN$\u0002\"a4\u0003<\tu\"q\b\u0005\b\u0003W<\u0003\u0019AAw\u0011\u001d\tYp\na\u0001\u0003{DqA!\u000e(\u0001\u0004\u0011i!\u0001\u0007gS2$XM\u001d+pa&\u001c7\u000f\u0006\u0003\u0003\u000e\t\u0015\u0003b\u0002B\u0006Q\u0001\u0007!QB\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\u0007\u0003\u001f\u0014YE!\u0014\t\u000f\u0005-\u0018\u00061\u0001\u0002n\"9!1B\u0015A\u0002\t5\u0011\u0001\u0007:f[>4XmU8ve\u000e,W*\u001b:s_J$v\u000e]5dgR1!Q\u0002B*\u0005+BqAa\u0003+\u0001\u0004\u0011i\u0001C\u0004\u0002H)\u0002\rA!\u0004\u0002/!\fg\u000e\u001a7f\u0005\u0006$8\r[\"sK\u0006$X\rV8qS\u000e\u001cH\u0003CAh\u00057\u0012iF!\u001e\t\u000f\u0005-8\u00061\u0001\u0002n\"9!qL\u0016A\u0002\t\u0005\u0014!\u0004;pa&\u001cG*[:uS:<7\u000f\u0005\u0005\u0003 \t\r\u00141\fB4\u0013\u0011\u0011)G!\t\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0003\u0018\te!\u0011\u000e\t\u0005\u0005W\u0012\t(\u0004\u0002\u0003n)!!q\u000eB\u0013\u0003\u0011a\u0017M\\4\n\t\tM$Q\u000e\u0002\u0005->LG\rC\u0004\u0003x-\u0002\rA!\u001f\u0002!I,W.Y5oS:<')\u0019;dQ\u0016\u001c\bC\u0002B>\u0005\u000b\u0013YI\u0004\u0003\u0003~\t\u0005e\u0002BA1\u0005\u007fJ\u0011aZ\u0005\u0004\u0005\u00073\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u000f\u0013IIA\u0002TKFT1Aa!g!\u0019\tiFa\u0004\u0003\u000eB\u00191Na$\n\u0007\tEEN\u0001\u0005OK^$v\u000e]5d\u0003y\tG\rZ'jeJ|'/\u001a3U_BL7-\u00118e\u0019><w+\u0019:oS:<7\u000f\u0006\u0004\u0003\u0018\n}%1\u0015\t\u0007\u0005w\u0012)I!'\u0011\u0007%\u0013Y*C\u0002\u0003\u001e~\u00121\u0003V1tW\u0016\u0013(o\u001c:D_\u0012,\u0017I\u001c3Ng\u001eDqA!)-\u0001\u0004\tY&A\u0003u_BL7\rC\u0004\u0003&2\u0002\rAa\u001a\u0002\r\u0019,H/\u001e:f\u0003=\tG\u000e\u001c'j].,G\rV8qS\u000e\u001cHC\u0001B\u0007\u0003-\u0012XmY8sI\u001a\u000b\u0017\u000e\\3e!J,g-\u001b=fI\u0006+Ho\\'jeJ|'o\u0011:fCR,W*\u001a;sS\u000e\u001cHCAA\u001e\u0003=9W\r^'jeJ|'\u000fV8qS\u000e\u001c\u0018\u0001G4fi\u000e{gN\u001a7jGRLgn\u001a#fgR$v\u000e]5dg\u0006qq-\u001a;J]&$\u0018.\u00197ju\u0016$\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>tG\u0003BA\u001e\u0005sCq!a?3\u0001\u0004\u0011Y\fE\u0002I\u0005{K1Aa0O\u0005M\u0019u.\u001c9mKR,G\rV1tWJ+7/\u001e7u\u0003=!\u0018m]6EKN\u001c'/\u001b9uS>tGCAAX\u0003a\u0019E.^:uKJd\u0015N\\6BkR|W*\u001b:s_JLgn\u001a\t\u0003\u0013V\u001a2!\u000eBf!\r)'QZ\u0005\u0004\u0005\u001f4'AB!osJ+g\r\u0006\u0002\u0003H\u0006A\u0012\r\u001a3ji&|g.\u00197J]R,'O\\1m)>\u0004\u0018nY:\u0016\u0005\t]\u0007C\u0002Bm\u0005?\u0014\t/\u0004\u0002\u0003\\*!!Q\\A*\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002Z\tm\u0007\u0003\u0002B6\u0005GLA!!\u001c\u0003n\u0005I\u0012\r\u001a3ji&|g.\u00197J]R,'O\\1m)>\u0004\u0018nY:!\u0003y\tG\rZ5uS>t\u0017\r\\%oi\u0016\u0014h.\u00197U_BL7\rU1ui\u0016\u0014h.\u0006\u0002\u0003lB!!Q\u001eBz\u001b\t\u0011yO\u0003\u0003\u0003r\n\u0005\u0012!\u0002:fO\u0016D\u0018\u0002\u0002B{\u0005_\u0014q\u0001U1ui\u0016\u0014h.A\u0010bI\u0012LG/[8oC2Le\u000e^3s]\u0006dGk\u001c9jGB\u000bG\u000f^3s]\u0002\n1BZ5mi\u0016\u0014Hk\u001c9jGRA\u00111\u0013B\u007f\u0007\u0017\u0019y\u0001C\u0004\u0003\u0000n\u0002\ra!\u0001\u0002\u001f9\fW.Z:U_2K7\u000f^5oON\u0004\u0002\"!\u0014\u0004\u0004\u0005m3QA\u0005\u0005\u0005K\ny\u0005E\u0002l\u0007\u000fI1a!\u0003m\u00051!v\u000e]5d\u0019&\u001cH/\u001b8h\u0011\u001d\u0019ia\u000fa\u0001\u0003w\n\u0011\u0002\u001d:fM&DH*\u001a8\t\u000f\t\u00056\b1\u0001\u0002\\\u0005A2IU#B)\u0016{Fk\u0014)J\u0007N{&)\u0011+D\u0011~\u001b\u0016JW#\u00023\r\u0013V)\u0011+F?R{\u0005+S\"T?\n\u000bEk\u0011%`'&SV\t\t")
public class ClusterLinkAutoMirroring
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private final ConfluentAdmin destAdmin;
    private boolean initialized;
    private boolean shouldFilterMirrorTopics;
    private volatile Option<TaskDescription> taskDesc;

    public static int CREATE_TOPICS_BATCH_SIZE() {
        return ClusterLinkAutoMirroring$.MODULE$.CREATE_TOPICS_BATCH_SIZE();
    }

    public static boolean filterTopic(scala.collection.mutable.Map<String, TopicListing> namesToListings, int prefixLen, String topic) {
        return ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefixLen, topic);
    }

    public static Pattern additionalInternalTopicPattern() {
        return ClusterLinkAutoMirroring$.MODULE$.additionalInternalTopicPattern();
    }

    public static scala.collection.immutable.Set<String> additionalInternalTopics() {
        return ClusterLinkAutoMirroring$.MODULE$.additionalInternalTopics();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean shouldFilterMirrorTopics() {
        return this.shouldFilterMirrorTopics;
    }

    private void shouldFilterMirrorTopics_$eq(boolean x$1) {
        this.shouldFilterMirrorTopics = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!this.initialized()) {
            return this.initializeAndAutoMirror();
        }
        return this.autoMirror(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())));
    }

    private ClusterLinkScheduler.TaskResult initializeAndAutoMirror() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Initializing auto-mirroring ").append($this.linkData.linkId()).toString());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.config().clusterLinkPrefix().isEmpty() || ((String)this.config().clusterLinkPrefix().get()).isEmpty()) {
            this.shouldFilterMirrorTopics_$eq(false);
            this.initialized_$eq(true);
            return this.autoMirror(taskContext);
        }
        KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
        this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            this.shouldFilterMirrorTopics_$eq(SourceCluster$.MODULE$.canContainMirrorTopics($this.metrics, (KafkaFuture<Collection<String>>)listMirrorsFuture));
            this.initialized_$eq(true);
            return this.autoMirror((ClusterLinkScheduler.TaskContext)tc);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult autoMirror(ClusterLinkScheduler.TaskContext taskContext) {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                String errMsg = new StringBuilder(72).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is true but no topic filters are specified. No topics will be mirrored.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
                Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Attempting to list topics from source cluster");
            ListTopicsResult listTopicsResult = this.clientManager().getAdmin().listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleListSourceTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result) {
        ClusterLinkScheduler.TaskResult taskResult;
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            ObjectRef filteredTopics = ObjectRef.create((Object)((scala.collection.immutable.Set)this.filterTopics((scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)result.names().get()).asScala().toSet()).$minus$minus(this.allLinkedTopics())));
            Map namesToListings = (Map)result.namesToListings().get();
            int prefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length() + ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
            ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1 & Serializable)topicName -> {
                ClusterLinkAutoMirroring.$anonfun$handleListSourceTopics$3(this, namesToListings, prefixLength, filteredTopics, topicName);
                return BoxedUnit.UNIT;
            });
            if (this.shouldFilterMirrorTopics()) {
                KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
                this.scheduleWhenComplete(listMirrorsFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListSourceMirrorTopics((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics$1.elem), (KafkaFuture<Collection<String>>)listMirrorsFuture), taskContext));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            taskResult = this.handleFilteredTopics(taskContext, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics.elem));
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to list topics on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list topics on the source cluster due to unexpected execution exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on the source cluster due to unexpected throwable exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleListSourceMirrorTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics, KafkaFuture<Collection<String>> listMirrorsFuture) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            scala.collection.immutable.Set<String> filteredTopics = this.removeSourceMirrorTopics(topics, (scala.collection.immutable.Set<String>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)listMirrorsFuture.get()).asScala().toSet());
            return this.handleFilteredTopics(taskContext, filteredTopics);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = "Unable to list mirrors on the source cluster due to authentication issues.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = "Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = "Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored.";
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg errorCodeAndMsg = taskErrorCodeAndMsg;
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)errorCodeAndMsg, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult handleFilteredTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> filteredTopics) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Will attempt to mirror following topics on destination cluster: ").append(filteredTopics).toString());
        if (this.conflictingDestTopics().intersect(filteredTopics).nonEmpty()) {
            ListTopicsResult listTopicsResult = this.destAdmin().listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListDestTopics((ClusterLinkScheduler.TaskContext)tc, listTopicsResult, filteredTopics), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        if (this.conflictingDestTopics().nonEmpty()) {
            this.conflictingDestTopics().clear();
        }
        return this.createTopics(taskContext, filteredTopics);
    }

    private ClusterLinkScheduler.TaskResult handleListDestTopics(ClusterLinkScheduler.TaskContext taskContext, ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            java.util.Set destTopics = (java.util.Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(destTopics).asScala().intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Found following conflicting topics on destination: ").append(this.conflictingDestTopics()).toString());
            }
            this.conflictingDestTopics().foreach((Function1 & Serializable)topic -> {
                ClusterLinkAutoMirroring.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            return this.createTopics(taskContext, (scala.collection.immutable.Set<String>)topicsToCreate);
        }
        catch (Throwable ex) {
            String errMsg = "Unable to list topics on destination cluster to check for conflicting topics.";
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromDestinationFailedSensor().record();
            ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$))));
            return this.createTopics(newTaskContext, filteredTopics);
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        void var3_3;
        void var4_4;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Filtering source topics ").append(topics).append(" to match topic filters JSON").toString());
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterTopics(topics, this.config().topicFilters(), this.linkData.tenantPrefix(), this.config().clusterLinkPrefix());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        var4_4.foreach((Function1 & Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(197).append("The filter ").append(unusedFilter).append(" does not match any source topic. This filter may not be ").append("required or the topics it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private ClusterLinkScheduler.TaskResult createTopics(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> topics) {
        int tenantPrefixLength;
        int clusterLinkPrefixLength = ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable)() -> "")).length();
        Seq batchedTopics = ((scala.collection.immutable.Set)topics.map(arg_0 -> ClusterLinkAutoMirroring.$anonfun$createTopics$3(this, clusterLinkPrefixLength, tenantPrefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "")).length(), arg_0))).grouped(ClusterLinkAutoMirroring$.MODULE$.CREATE_TOPICS_BATCH_SIZE()).toSeq();
        if (batchedTopics.nonEmpty()) {
            scala.collection.immutable.Set firstBatch = (scala.collection.immutable.Set)batchedTopics.apply(0);
            Seq remainingBatches = (Seq)batchedTopics.drop(1);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(firstBatch).toString());
            CreateTopicsResult result = this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)firstBatch).asJava());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)remainingBatches), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private scala.collection.immutable.Set<String> removeSourceMirrorTopics(scala.collection.immutable.Set<String> topics, scala.collection.immutable.Set<String> mirrorTopics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Mirror topics at source ").append(mirrorTopics).toString());
        scala.collection.immutable.Set filteredTopics = (scala.collection.immutable.Set)topics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAutoMirroring.$anonfun$removeSourceMirrorTopics$2(mirrorTopics, x$3)));
        scala.collection.immutable.Set filteredOutTopics = (scala.collection.immutable.Set)topics.$minus$minus((IterableOnce)filteredTopics);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Filtering out ").append(filteredOutTopics).append(" because they are mirror topics at the source cluster").toString());
        if (filteredOutTopics.nonEmpty()) {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record((double)filteredOutTopics.size());
        } else {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record(0.0);
        }
        return filteredTopics;
    }

    private ClusterLinkScheduler.TaskResult handleBatchCreateTopics(ClusterLinkScheduler.TaskContext taskContext, Map<String, KafkaFuture<Void>> topicListings, Seq<scala.collection.immutable.Set<NewTopic>> remainingBatches) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicListings).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                return this.addMirroredTopicAndLogWarnings(topic, (KafkaFuture<Void>)future);
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (remainingBatches.isEmpty()) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        scala.collection.immutable.Set nextBatch = (scala.collection.immutable.Set)remainingBatches.apply(0);
        Seq nextRemainingBatches = (Seq)remainingBatches.drop(1);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(nextBatch).toString());
        CreateTopicsResult result = this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)nextBatch).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleBatchCreateTopics((ClusterLinkScheduler.TaskContext)tc, result.values(), (Seq<scala.collection.immutable.Set<NewTopic>>)nextRemainingBatches), newTaskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private Seq<TaskErrorCodeAndMsg> addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        None$ errOpt;
        None$ none$;
        try {
            future.get();
            this.mirrorTopics().$plus$eq((Object)topic);
            this.metrics.autoMirrorCreateSensor().record();
            if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty()))) {
                this.metrics.prefixedAutoMirrorCreateSensor().record();
            }
            none$ = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add((Object)topic);
                String errMsg = new StringBuilder(75).append("Topic ").append(topic).append(" already exists on destination cluster. Will not mirror source").append(" topic.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(errMsg).append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(TopicExistsTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = new StringBuilder(53).append("Unable to create topic ").append(topic).append(" due to authentication issues.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg));
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = new StringBuilder(86).append("Unable to create topic ").append(topic).append(". Please allow CREATE access on destination cluster to proceed.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, errMsg));
            } else {
                String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        }
        catch (Throwable ex) {
            String errMsg = new StringBuilder(47).append("Unable to create topic ").append(topic).append(" on destination cluster.").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(errMsg).append(" ").append(ex).toString());
            this.metrics.autoMirrorCreateFailedSensor().record();
            this.recordFailedPrefixedAutoMirrorCreateMetrics();
            none$ = errOpt = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
        }
        if (errOpt instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)errOpt).value();
            return new .colon.colon((Object)err, (List)Nil$.MODULE$);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private scala.collection.immutable.Set<String> allLinkedTopics() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).keySet().toSet();
    }

    private void recordFailedPrefixedAutoMirrorCreateMetrics() {
        if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))) {
            this.metrics.prefixedAutoMirrorCreateFailedSensor().record();
            return;
        }
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public boolean getInitialized() {
        return this.initialized();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        Option<TaskDescription> newTaskDesc = this.metadataManager().isLinkCoordinator(this.linkData.linkName()) ? (this.config().autoMirroringEnable() ? ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkAutoMirroringTaskType$.MODULE$, "run the auto create mirror topics task") : new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty())))) : None$.MODULE$;
        this.taskDesc_$eq(newTaskDesc);
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$3(ClusterLinkAutoMirroring $this, Map namesToListings$1, int prefixLength$1, ObjectRef filteredTopics$1, String topicName) {
        if (ClusterLinkAutoMirroring$.MODULE$.filterTopic((scala.collection.mutable.Map<String, TopicListing>)CollectionConverters$.MODULE$.MapHasAsScala(namesToListings$1).asScala(), prefixLength$1, topicName)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Internal or Confluent topic ").append(topicName).append(" will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoMirroring $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
        $this.recordFailedPrefixedAutoMirrorCreateMetrics();
    }

    public static final /* synthetic */ NewTopic $anonfun$createTopics$3(ClusterLinkAutoMirroring $this, int clusterLinkPrefixLength$1, int tenantPrefixLength$1, String topic) {
        String mirrorTopicName = clusterLinkPrefixLength$1 > 0 ? new StringBuilder(0).append(topic.substring(0, tenantPrefixLength$1)).append(topic.substring(tenantPrefixLength$1 + clusterLinkPrefixLength$1)).toString() : topic;
        return new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), mirrorTopicName)));
    }

    public static final /* synthetic */ boolean $anonfun$removeSourceMirrorTopics$2(scala.collection.immutable.Set mirrorTopics$1, String x$3) {
        return !mirrorTopics$1.contains((Object)x$3);
    }

    public ClusterLinkAutoMirroring(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoMirroring", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.mirrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.conflictingDestTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.tasksOutstanding = 0;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
        this.initialized = false;
        this.taskDesc = None$.MODULE$;
    }
}

