/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConvertToMirrorTopic;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFailed;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPromoteAndSwapMirrorTopic;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrorTopic;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MirrorTopicDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u000e\u001d\u0001\rB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!A!\u0002\u00139\u0005\"\u0002&\u0001\t\u0003Y\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007=\u0002\u0001\u000b\u0011\u0002*\t\u000f}\u0003!\u0019!C\u0005A\"1A\r\u0001Q\u0001\n\u0005DQ!\u001a\u0001\u0005B\u0019DQA\u001d\u0001\u0005BMDq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!a\u001b\u0001\t\u0013\ty\nC\u0004\u0002$\u0002!I!!*\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017\u0014ad\u00117vgR,'\u000fT5oW\u000e{wN\u001d3j]\u0006$xN\u001d'jgR,g.\u001a:\u000b\u0005uq\u0012\u0001\u00027j].T!a\b\u0011\u0002\rM,'O^3s\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0011bC\u0007\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!A.\u00198h\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\r=\u0013'.Z2u!\ti\u0013G\u0004\u0002/_5\tA$\u0003\u000219\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\u00114GA\fMS:\\7i\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8fe*\u0011\u0001\u0007\b\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0001\nQ!\u001e;jYNL!!\u000f\u001c\u0003\u000f1{wmZ5oO\u0006YA.\u001b8l\u001b\u0006t\u0017mZ3s+\u0005a\u0004C\u0001\u0018>\u0013\tqDD\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018\u0001\u00047j].l\u0015M\\1hKJ\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003\t\u0003\"AL\"\n\u0005\u0011c\"AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002/\u0011&\u0011\u0011\n\b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\rqJg.\u001b;?)\u0011aUJT(\u0011\u00059\u0002\u0001\"\u0002\u001e\u0007\u0001\u0004a\u0004\"\u0002!\u0007\u0001\u0004\u0011\u0005\"\u0002$\u0007\u0001\u00049\u0015AE6sC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u0015\t\u0004'ZCV\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\r=\u0003H/[8o!\tIF,D\u0001[\u0015\tYf$\u0001\u0005nKR\fG-\u0019;b\u0013\ti&L\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017aE6sC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013a\u00045bg.\u0013\u0016M\u001a;TkB\u0004xN\u001d;\u0016\u0003\u0005\u0004\"a\u00152\n\u0005\r$&a\u0002\"p_2,\u0017M\\\u0001\u0011Q\u0006\u001c8JU1giN+\b\u000f]8si\u0002\nAA\\1nKR\tq\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003URk\u0011a\u001b\u0006\u0003Y\n\na\u0001\u0010:p_Rt\u0014B\u00018U\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059$\u0016\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)\u0019!x/!\u0003\u0002\u0014A\u00111+^\u0005\u0003mR\u0013A!\u00168ji\")\u0001\u0010\u0004a\u0001s\u0006iQ.\u001a;bI\u0006$\u0018\rR3mi\u0006\u00042A_A\u0003\u001b\u0005Y(B\u0001?~\u0003\u0015IW.Y4f\u0015\t\tcPC\u0002\u0000\u0003\u0003\ta!\u00199bG\",'BAA\u0002\u0003\ry'oZ\u0005\u0004\u0003\u000fY(!D'fi\u0006$\u0017\r^1EK2$\u0018\rC\u0004\u0002\f1\u0001\r!!\u0004\u0002!9,w/T3uC\u0012\fG/Y%nC\u001e,\u0007c\u0001>\u0002\u0010%\u0019\u0011\u0011C>\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\t\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD>\u0002\r1|\u0017\rZ3s\u0013\u0011\t\t#a\u0007\u0003\u001d1{\u0017\rZ3s\u001b\u0006t\u0017NZ3ti\u0006\u0001rN\\+qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0004i\u0006\u001d\u0002bBA\u0015\u001b\u0001\u0007\u00111F\u0001\u0013[&\u0014(o\u001c:U_BL7m\u00115b]\u001e,7\u000f\u0005\u0003\u0002.\u0005Ub\u0002BA\u0018\u0003ci\u0011AH\u0005\u0004\u0003gq\u0012A\u0004*fa2L7-Y'b]\u0006<WM]\u0005\u0005\u0003o\tID\u0001\nNSJ\u0014xN\u001d+pa&\u001c7\t[1oO\u0016\u001c(bAA\u001a=\u0005\u0001sN\\\"mkN$XM\u001d'j].\u001cun\u001c:eS:\fGo\u001c:FY\u0016\u001cG/[8o)\r!\u0018q\b\u0005\b\u0003\u0003r\u0001\u0019AA\"\u0003\u0015a\u0017N\\6t!\u0015A\u0017QIA%\u0013\r\t9%\u001d\u0002\u0004'\u0016$\b\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=\u0003%\u0001\u0002{W&!\u00111KA'\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017aI8o\u00072,8\u000f^3s\u0019&t7nQ8pe\u0012Lg.\u0019;peJ+7/[4oCRLwN\u001c\u000b\u0004i\u0006e\u0003bBA.\u001f\u0001\u0007\u0011QL\u0001\nY&t7.\u00133TKR\u0004R\u0001[A#\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003Kj\u0018AB2p[6|g.\u0003\u0003\u0002j\u0005\r$\u0001B+vS\u0012\fqd\u00195fG.l\u0015N\u001d:peN#\u0018\r^3B]\u0012,\u00050Z2vi\u0016$\u0016m]6t)\u0015!\u0018qNA9\u0011\u0019i\u0002\u00031\u0001\u0002J!1\u00111\u000f\tA\u0002e\fQ\u0001Z3mi\u0006\fq\u0004]3oI&twm\u0015;paB,G-T5se>\u0014Hk\u001c9jG\u0012+G\u000e^1t)\u0019\tI(!!\u0002\fB)\u0001.!\u0012\u0002|A\u0019!0! \n\u0007\u0005}4P\u0001\u0006U_BL7\rR3mi\u0006Dq!a!\u0012\u0001\u0004\t))A\u0006u_BL7m\u001d#fYR\f\u0007c\u0001>\u0002\b&\u0019\u0011\u0011R>\u0003\u0017Q{\u0007/[2t\t\u0016dG/\u0019\u0005\b\u0003\u001b\u000b\u0002\u0019AA0\u0003\u0019a\u0017N\\6JI\u0006A\u0002/\u001a8eS:<W*\u001b:s_J$v\u000e]5d\t\u0016dG/Y:\u0015\r\u0005e\u00141SAK\u0011\u001d\t\u0019I\u0005a\u0001\u0003\u000bCq!!$\u0013\u0001\u0004\ty&A\u0012qK:$\u0017N\\4Ts:\u001c\u0007N]8oSj,W*\u001b:s_J$v\u000e]5d\t\u0016dG/Y:\u0015\r\u0005e\u00141TAO\u0011\u001d\t\u0019i\u0005a\u0001\u0003\u000bCq!!$\u0014\u0001\u0004\ty\u0006F\u0002u\u0003CCa!\b\u000bA\u0002\u0005%\u0013!K2iK\u000e\\\u0017JZ'jeJ|'o\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012$v\u000eU3oI&twm\u0015;paB,G\rF\u0002b\u0003OCq!a\u001d\u0016\u0001\u0004\tY(\u0001\u0015dQ\u0016\u001c7.\u00134NSJ\u0014xN]*uCR,7\t[1oO\u0016$Gk\u001c)f]\u0012LgnZ'jeJ|'\u000fF\u0002b\u0003[Cq!a\u001d\u0017\u0001\u0004\tY(A\u0017dQ\u0016\u001c7.\u00134NSJ\u0014xN]*uCR,7\t[1oO\u0016$Gk\u001c)f]\u0012LgnZ*z]\u000eD'o\u001c8ju\u0016$2!YAZ\u0011\u001d\t\u0019h\u0006a\u0001\u0003w\n\u0011C];o'R|\u0007/T5se>\u0014H+Y:l)\u0015!\u0018\u0011XA^\u0011\u001d\ti\t\u0007a\u0001\u0003?Ba!!0\u0019\u0001\u00049\u0017!\u0003;pa&\u001cg*Y7f\u0003m\u0011XO\\\"p]Z,'\u000f\u001e+p\u001b&\u0014(o\u001c:U_BL7\rV1tWR)A/a1\u0002H\"1\u0011QY\rA\u0002\u001d\fQ\u0001^8qS\u000eDq!!$\u001a\u0001\u0004\ty&\u0001\u0011sk:\u0004&o\\7pi\u0016\fe\u000eZ*xCBl\u0015N\u001d:peR{\u0007/[2UCN\\G#\u0002;\u0002N\u0006=\u0007BBAc5\u0001\u0007q\rC\u0004\u0002\u000ej\u0001\r!a\u0018")
public class ClusterLinkCoordinatorListener
implements ClusterLinkFactory.LinkCoordinatorListener,
Logging {
    private final ClusterLinkManager linkManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkScheduler scheduler;
    private final Option<KRaftMetadataCache> kraftMetadataCache;
    private final boolean hasKRaftSupport;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<KRaftMetadataCache> kraftMetadataCache() {
        return this.kraftMetadataCache;
    }

    private boolean hasKRaftSupport() {
        return this.hasKRaftSupport;
    }

    public String name() {
        return "ClusterLinkCoordinatorListener";
    }

    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest manifest) {
        this.scheduler.scheduleOnce("scheduleChangesForDeltaByClusterLinkLeaders", () -> this.metadataManager().getClusterLinksWithOwnedLinkCoordinator().foreach((Function1 & Serializable)cld -> {
            this.checkMirrorStateAndExecuteTasks(cld, metadataDelta);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public void onUpdateMetadata(ReplicaManager.MirrorTopicChanges mirrorTopicChanges) {
        Set pendingStoppedMirrorTopics = mirrorTopicChanges.pendingStoppedMirrorTopics().toSet();
        Set pendingMirrorTopics = mirrorTopicChanges.pendingMirrorTopics().toSet();
        Set pendingSynchronizeMirrorTopics = mirrorTopicChanges.pendingSynchronizeMirrorTopics().toSet();
        if (!this.metadataManager().isLinkCoordinatorEnabled()) {
            return;
        }
        this.metadataManager().mirrorTopicStatesFromMetadataCache((Set<String>)pendingStoppedMirrorTopics).foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkCoordinatorListener.$anonfun$onUpdateMetadata$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.metadataManager().mirrorTopicStatesFromMetadataCache((Set<String>)pendingMirrorTopics).foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkCoordinatorListener.$anonfun$onUpdateMetadata$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        this.metadataManager().mirrorTopicStatesFromMetadataCache((Set<String>)pendingSynchronizeMirrorTopics).foreach((Function1 & Serializable)x0$3 -> {
            ClusterLinkCoordinatorListener.$anonfun$onUpdateMetadata$3(this, x0$3);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.linkManager().listClusterLinks().flatMap((Function1 & Serializable)link -> this.linkManager().destClientManager(link.linkId()))).foreach((Function1 & Serializable)x$1 -> {
            x$1.processMirrorStateChanges();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onClusterLinkCoordinatorElection(Set<ClusterLinkData> links) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("link coordinator elected for links: ").append(links.map((Function1 & Serializable)x$2 -> x$2.linkName())).toString());
        links.foreach((Function1 & Serializable)cld -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorElection$3(this, cld);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onClusterLinkCoordinatorResignation(Set<Uuid> linkIdSet) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("link coordinator resigned for links: ").append(linkIdSet).toString());
        linkIdSet.foreach((Function1 & Serializable)linkId -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$2(this, linkId);
            return BoxedUnit.UNIT;
        });
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link, MetadataDelta delta) {
        if (delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()) {
            Uuid linkId = link.linkId();
            TopicsDelta topicsDelta = delta.topicsDelta();
            this.pendingStoppedMirrorTopicDeltas(topicsDelta, linkId).foreach((Function1 & Serializable)td -> {
                this.runStopMirrorTask(linkId, td.name());
                return BoxedUnit.UNIT;
            });
            this.pendingMirrorTopicDeltas(topicsDelta, linkId).foreach((Function1 & Serializable)td -> {
                this.runConvertToMirrorTopicTask(td.name(), linkId);
                return BoxedUnit.UNIT;
            });
            this.pendingSynchronizeMirrorTopicDeltas(topicsDelta, linkId).foreach((Function1 & Serializable)td -> {
                this.runPromoteAndSwapMirrorTopicTask(td.name(), linkId);
                return BoxedUnit.UNIT;
            });
            this.linkManager().destClientManager(link.linkId()).foreach((Function1 & Serializable)x$5 -> {
                x$5.processMirrorStateChanges();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Set<TopicDelta> pendingStoppedMirrorTopicDeltas(TopicsDelta topicsDelta, Uuid linkId) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(topicsDelta.changedTopics()).asScala().values().filter((Function1 & Serializable)td -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingStoppedMirrorTopicDeltas$1(this, linkId, td)))).toSet();
    }

    private Set<TopicDelta> pendingMirrorTopicDeltas(TopicsDelta topicsDelta, Uuid linkId) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(topicsDelta.changedTopics()).asScala().values().filter((Function1 & Serializable)td -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingMirrorTopicDeltas$1(this, linkId, td)))).toSet();
    }

    private Set<TopicDelta> pendingSynchronizeMirrorTopicDeltas(TopicsDelta topicsDelta, Uuid linkId) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(topicsDelta.changedTopics()).asScala().values().filter((Function1 & Serializable)td -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingSynchronizeMirrorTopicDeltas$1(this, linkId, td)))).toSet();
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link) {
        if (this.metadataManager().isLinkCoordinatorEnabled()) {
            Uuid linkId = link.linkId();
            ((MapOps)this.metadataManager().mirrorTopicStatesFromMetadataCache(linkId).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$5(x0$1)))).keys().foreach((Function1 & Serializable)topic -> {
                this.runStopMirrorTask(linkId, topic);
                return BoxedUnit.UNIT;
            });
            ((MapOps)this.metadataManager().mirrorTopicStatesFromMetadataCache(linkId).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$7(x0$2)))).keys().foreach((Function1 & Serializable)topic -> {
                this.runPromoteAndSwapMirrorTopicTask(topic, link.linkId());
                return BoxedUnit.UNIT;
            });
            this.linkManager().destClientManager(linkId).foreach((Function1 & Serializable)x$9 -> {
                x$9.processMirrorStateChanges();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean checkIfMirrorStateChangedToPendingStopped(TopicDelta delta) {
        Option newMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.latestMirrorTopicState()));
        Option prevMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.image().mirrorTopic()));
        return newMirrorState.exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingStopped$1(prevMirrorState, x$10)));
    }

    private boolean checkIfMirrorStateChangedToPendingMirror(TopicDelta delta) {
        Option newMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.latestMirrorTopicState()));
        Option prevMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.image().mirrorTopic()));
        return newMirrorState.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingMirror$1(prevMirrorState, x$12)));
    }

    private boolean checkIfMirrorStateChangedToPendingSynchronize(TopicDelta delta) {
        Option newMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.latestMirrorTopicState()));
        Option prevMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.image().mirrorTopic()));
        return newMirrorState.exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingSynchronize$1(this, prevMirrorState, x$14)));
    }

    private void runStopMirrorTask(Uuid linkId, String topicName) {
        Option<ClusterLinkFactory.ClientManager> option = this.linkManager().clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkDestClientManager) {
                ClusterLinkDestClientManager clusterLinkDestClientManager = (ClusterLinkDestClientManager)clientManager;
                new ClusterLinkStopMirrorTopic(topicName, clusterLinkDestClientManager, clusterLinkDestClientManager.destAdminFactory(), clusterLinkDestClientManager.time(), clusterLinkDestClientManager.requestQuota(), 500).startup();
                return;
            }
            if (clientManager instanceof ClusterLinkFailed.ClientManager) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Cannot start 'stop topic mirror' task, cluster link '").append(linkId).append("' is in a failed state").toString());
                return;
            }
            throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Unable to resolve client manager for link ID '").append(linkId).append("'. Cluster link may have ").append("been deleted or the managers are not initialized.").toString());
            return;
        }
        throw new MatchError(option);
    }

    private void runConvertToMirrorTopicTask(String topic, Uuid linkId) {
        Option<ClusterLinkFactory.ClientManager> option = this.linkManager().clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkDestClientManager) {
                ClusterLinkDestClientManager clusterLinkDestClientManager = (ClusterLinkDestClientManager)clientManager;
                new ClusterLinkConvertToMirrorTopic(topic, clusterLinkDestClientManager, clusterLinkDestClientManager.destAdminFactory(), clusterLinkDestClientManager.time(), clusterLinkDestClientManager.requestQuota(), 5000).startup();
                return;
            }
            if (clientManager instanceof ClusterLinkFailed.ClientManager) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Cannot start ClusterLinkConvertToMirrorTopic task, cluster link '").append(linkId).append("' is in a failed state").toString());
                return;
            }
            throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(89).append("Unable to resolve client manager for link ID '").append(linkId).append("', may be due to cluster link deletion race").toString());
            return;
        }
        throw new MatchError(option);
    }

    private void runPromoteAndSwapMirrorTopicTask(String topic, Uuid linkId) {
        Option<ClusterLinkFactory.ClientManager> option = this.linkManager().clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkDestClientManager) {
                ClusterLinkDestClientManager clusterLinkDestClientManager = (ClusterLinkDestClientManager)clientManager;
                new ClusterLinkPromoteAndSwapMirrorTopic(topic, clusterLinkDestClientManager, clusterLinkDestClientManager.destAdminFactory(), (Function0<ClusterLinkAdminClient>)(Function0 & Serializable)() -> clusterLinkDestClientManager.getClusterLinkAdmin(), clusterLinkDestClientManager.time(), clusterLinkDestClientManager.requestQuota(), 5000).startup();
                return;
            }
            if (clientManager instanceof ClusterLinkFailed.ClientManager) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Cannot start 'promote and swap mirror topic' task, cluster link '").append(linkId).append("' is in a failed state").toString());
                return;
            }
            throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(89).append("Unable to resolve client manager for link ID '").append(linkId).append("', may be due to cluster link deletion race").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$onUpdateMetadata$1(ClusterLinkCoordinatorListener $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            if ($this.metadataManager().isLinkCoordinator(state.linkName())) {
                $this.runStopMirrorTask(state.linkId(), topic);
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$onUpdateMetadata$2(ClusterLinkCoordinatorListener $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            String topic = (String)x0$2._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$2._2();
            if ($this.metadataManager().isLinkCoordinator(state.linkName())) {
                $this.runConvertToMirrorTopicTask(topic, state.linkId());
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$onUpdateMetadata$3(ClusterLinkCoordinatorListener $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            String topic = (String)x0$3._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$3._2();
            if ($this.metadataManager().isLinkCoordinator(state.linkName())) {
                $this.runPromoteAndSwapMirrorTopicTask(topic, state.linkId());
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorElection$3(ClusterLinkCoordinatorListener $this, ClusterLinkData cld) {
        try {
            if (cld.isDeleted()) {
                if ($this.hasKRaftSupport()) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Found link ").append(cld.linkName()).append(" marked for deletion in KRaft mode").toString());
                    throw new IllegalStateException(new StringBuilder(45).append("Found link ").append(cld.linkName()).append(" marked for deletion in KRaft mode").toString());
                }
            } else {
                $this.checkMirrorStateAndExecuteTasks(cld);
                $this.linkManager().connectionManager(cld.linkId()).foreach((Function1 & Serializable)x$3 -> {
                    x$3.onLinkMetadataPartitionLeaderChange();
                    return BoxedUnit.UNIT;
                });
                return;
            }
            $this.linkManager().processClusterLinkChanges(cld.linkId(), new Properties(), $this.linkManager().processClusterLinkChanges$default$3());
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Unable to process link coordinator change for link ").append(cld.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
        }
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$2(ClusterLinkCoordinatorListener $this, Uuid linkId) {
        try {
            $this.linkManager().connectionManager(linkId).foreach((Function1 & Serializable)x$4 -> {
                x$4.onLinkMetadataPartitionLeaderChange();
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Unable to process link coordinator change for link ").append(linkId).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$pendingStoppedMirrorTopicDeltas$2(Uuid linkId$3, MirrorTopic x$6) {
        return x$6.linkId().equals((Object)linkId$3);
    }

    public static final /* synthetic */ boolean $anonfun$pendingStoppedMirrorTopicDeltas$1(ClusterLinkCoordinatorListener $this, Uuid linkId$3, TopicDelta td) {
        return td.mirrorTopicDelta().changed() && OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((MirrorTopicDelta.Changed)td.mirrorTopicDelta()).newValue())).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingStoppedMirrorTopicDeltas$2(linkId$3, x$6))) && $this.checkIfMirrorStateChangedToPendingStopped(td);
    }

    public static final /* synthetic */ boolean $anonfun$pendingMirrorTopicDeltas$2(Uuid linkId$4, MirrorTopic x$7) {
        return x$7.linkId().equals((Object)linkId$4);
    }

    public static final /* synthetic */ boolean $anonfun$pendingMirrorTopicDeltas$1(ClusterLinkCoordinatorListener $this, Uuid linkId$4, TopicDelta td) {
        return td.mirrorTopicDelta().changed() && OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((MirrorTopicDelta.Changed)td.mirrorTopicDelta()).newValue())).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingMirrorTopicDeltas$2(linkId$4, x$7))) && $this.checkIfMirrorStateChangedToPendingMirror(td);
    }

    public static final /* synthetic */ boolean $anonfun$pendingSynchronizeMirrorTopicDeltas$2(Uuid linkId$5, MirrorTopic x$8) {
        return x$8.linkId().equals((Object)linkId$5);
    }

    public static final /* synthetic */ boolean $anonfun$pendingSynchronizeMirrorTopicDeltas$1(ClusterLinkCoordinatorListener $this, Uuid linkId$5, TopicDelta td) {
        return td.mirrorTopicDelta().changed() && OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((MirrorTopicDelta.Changed)td.mirrorTopicDelta()).newValue())).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$pendingSynchronizeMirrorTopicDeltas$2(linkId$5, x$8))) && $this.checkIfMirrorStateChangedToPendingSynchronize(td);
    }

    public static final /* synthetic */ boolean $anonfun$checkMirrorStateAndExecuteTasks$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicLinkState topicLinkState = ((ClusterLinkTopicState)x0$1._2()).state();
            TopicLinkPendingStoppedMirror$ topicLinkPendingStoppedMirror$ = TopicLinkPendingStoppedMirror$.MODULE$;
            return topicLinkState != null && topicLinkState.equals(topicLinkPendingStoppedMirror$);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$checkMirrorStateAndExecuteTasks$7(Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicLinkState topicLinkState = ((ClusterLinkTopicState)x0$2._2()).state();
            TopicLinkPendingSynchronizeMirror$ topicLinkPendingSynchronizeMirror$ = TopicLinkPendingSynchronizeMirror$.MODULE$;
            return topicLinkState != null && topicLinkState.equals(topicLinkPendingSynchronizeMirror$);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingStopped$2(MirrorTopic x$11) {
        MirrorTopic.State state = x$11.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.PENDING_STOPPED;
        return state == null ? state2 != null : !state.equals(state2);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingStopped$1(Option prevMirrorState$1, MirrorTopic x$10) {
        if (x$10 instanceof MirrorTopic.PendingStoppedMirrorTopic) {
            return prevMirrorState$1.forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingStopped$2(x$11)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingMirror$2(MirrorTopic x$13) {
        MirrorTopic.State state = x$13.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingMirror$1(Option prevMirrorState$2, MirrorTopic x$12) {
        if (x$12 instanceof MirrorTopic.PendingMirrorTopic) {
            return prevMirrorState$2.forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingMirror$2(x$13)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingSynchronize$2(MirrorTopic x$15) {
        MirrorTopic.State state = x$15.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.MIRROR;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingSynchronize$4(MirrorTopic x$16) {
        MirrorTopic.State state = x$16.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.MIRROR;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingSynchronize$1(ClusterLinkCoordinatorListener $this, Option prevMirrorState$3, MirrorTopic x$14) {
        if (x$14 instanceof MirrorTopic.PendingSynchronizeMirrorTopic) {
            if (!prevMirrorState$3.forall((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingSynchronize$2(x$15)))) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Previous mirror state was not ").append(MirrorTopic.State.MIRROR.stateName()).append(" but ").append(((MirrorTopic)prevMirrorState$3.get()).mirrorState().stateName()).append(".").toString());
            }
            return prevMirrorState$3.forall((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingSynchronize$4(x$16)));
        }
        return false;
    }

    public ClusterLinkCoordinatorListener(ClusterLinkManager linkManager, ClusterLinkMetadataManager metadataManager, ClusterLinkScheduler scheduler) {
        None$ none$;
        this.linkManager = linkManager;
        this.metadataManager = metadataManager;
        this.scheduler = scheduler;
        MetadataCache metadataCache = metadataManager.metadataCache();
        if (metadataCache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)metadataCache;
            none$ = new Some((Object)kRaftMetadataCache);
        } else {
            none$ = None$.MODULE$;
        }
        this.kraftMetadataCache = none$;
        this.hasKRaftSupport = this.kraftMetadataCache().nonEmpty();
    }
}

