/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.PartitionStatus;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkClearMirrorStartOffsets;
import kafka.server.link.ClusterLinkClearMirrorStartOffsetsTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkListOffsets;
import kafka.server.link.ClusterLinkListOffsetsTaskType$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkPauseMirrorTopicsTaskType$;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkRepairMirrorsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.PeriodicPartitionSchedulerTaskType$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskType;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011Ub\u0001B&M\u0001MC\u0011\"\u001a\u0001\u0003\u0002\u0003\u0006IAZ5\t\u0011)\u0004!\u0011!Q\u0001\n-D\u0011b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001d<\t\u0011]\u0004!\u0011!Q\u0001\naD\u0011b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001`@\t\u0015\u0005\u0005\u0001A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"!\f\u0001\u0005\u000b\u0007I\u0011AA\u0018\u0011)\ty\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0007\u0005\r\u0003\u0003\u0002!\u0011!Q\u0001\n\u0005\r\u0013\u0011\n\u0005\r\u0003\u001b\u0002!\u0011!Q\u0001\n\u0005=\u00131\f\u0005\u000b\u0003;\u0002!Q1A\u0005\u0002\u0005}\u0003BCA7\u0001\t\u0005\t\u0015!\u0003\u0002b!Q\u0011q\u000e\u0001\u0003\u0006\u0004%\t!!\u001d\t\u0015\u0005e\u0004A!A!\u0002\u0013\t\u0019\b\u0003\u0006\u0002|\u0001\u0011)\u0019!C\u0001\u0003{B!\"!$\u0001\u0005\u0003\u0005\u000b\u0011BA@\u0011)\ty\t\u0001B\u0001B\u0003%\u0011\u0011\u0013\u0005\b\u0003/\u0003A\u0011AAM\u0011%\tI\f\u0001a\u0001\n\u0013\tY\fC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002H\"A\u00111\u001b\u0001!B\u0013\ti\fC\u0005\u0002V\u0002\u0001\r\u0011\"\u0003\u0002X\"I\u0011\u0011\u001d\u0001A\u0002\u0013%\u00111\u001d\u0005\t\u0003O\u0004\u0001\u0015)\u0003\u0002Z\"I\u0011\u0011\u001e\u0001A\u0002\u0013%\u00111\u001e\u0005\n\u0003k\u0004\u0001\u0019!C\u0005\u0003oD\u0001\"a?\u0001A\u0003&\u0011Q\u001e\u0005\n\u0003{\u0004\u0001\u0019!C\u0005\u0003\u007fD\u0011B!\u0003\u0001\u0001\u0004%IAa\u0003\t\u0011\t=\u0001\u0001)Q\u0005\u0005\u0003A\u0011B!\u0005\u0001\u0001\u0004%IAa\u0005\t\u0013\tu\u0001\u00011A\u0005\n\t}\u0001\u0002\u0003B\u0012\u0001\u0001\u0006KA!\u0006\t\u0015\t\u0015\u0002A1A\u0005\u00021\u00139\u0003\u0003\u0005\u00030\u0001\u0001\u000b\u0011\u0002B\u0015\u0011)\u0011\t\u0004\u0001b\u0001\n\u0003a%1\u0007\u0005\t\u0005w\u0001\u0001\u0015!\u0003\u00036!I!Q\b\u0001C\u0002\u0013%!q\b\u0005\t\u0005\u000f\u0002\u0001\u0015!\u0003\u0003B!I!\u0011\n\u0001C\u0002\u0013%!1\n\u0005\t\u0005g\u0002\u0001\u0015!\u0003\u0003N!A!Q\u000f\u0001\u0005\u00021\u00139\bC\u0004\u0003\u0000\u0001!\tF!!\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0006\"9!1\u0013\u0001\u0005\u0002\tU\u0005b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005;\u0003A\u0011\u0001BN\u0011\u001d\u0011y\n\u0001C)\u0005\u0003CqA!)\u0001\t#\u0012\t\tC\u0004\u0003$\u0002!\tF!!\t\u0011\t\u0015\u0006\u0001\"\u0001M\u0005OC\u0001Ba-\u0001\t\u0003a%Q\u0017\u0005\b\u0005w\u0003A\u0011\u0001B_\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003DqAa1\u0001\t\u0003\tY\fC\u0004\u0003F\u0002!\tAa2\t\u000f\t-\b\u0001\"\u0001\u0003n\"91Q\u0001\u0001\u0005\n\r\u001d\u0001bBB\u0016\u0001\u0011\u00051Q\u0006\u0005\b\u0007{\u0001A\u0011BB \u0011\u001d\u0019)\b\u0001C\u0005\u0007oBqa!\u0010\u0001\t\u0013\u0019\t\u000bC\u0004\u00042\u0002!Iaa-\t\u000f\r=\u0007\u0001\"\u0001\u0004R\"91\u0011\u001e\u0001\u0005\n\r-\bbBB{\u0001\u0011\u0005#\u0011\u0011\u0005\b\u0007o\u0004A\u0011AB}\u0011\u001d!\t\u0001\u0001C\u0001\t\u0007Aq\u0001b\u0003\u0001\t\u0013!i\u0001C\u0004\u0005\f\u0001!I\u0001\"\u0005\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0005\u001a!9A1\u0004\u0001\u0005B\u0011u\u0001\"\u0004C\u0019\u0001A\u0005\u0019\u0011!A\u0005\n\u0011MbO\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u000b\u00055s\u0015\u0001\u00027j].T!a\u0014)\u0002\rM,'O^3s\u0015\u0005\t\u0016!B6bM.\f7\u0001A\n\u0005\u0001QCv\f\u0005\u0002V-6\tA*\u0003\u0002X\u0019\n\u0001\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s!\tIFL\u0004\u0002V5&\u00111\fT\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002^=\n\tB)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u000b\u0005mc\u0005C\u00011d\u001b\u0005\t'B\u00012Q\u0003\u0015)H/\u001b7t\u0013\t!\u0017MA\u0004M_\u001e<\u0017N\\4\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\t\u0003+\u001eL!\u0001\u001b'\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0005\u0003KZ\u000bAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"\u0001\\7\u000e\u00039K!A\u001c(\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tY&t7\u000eR1uCB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fU\u0001\u0003u.L!!\u001e:\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006L!a\u001c,\u0002\u001d\u0019,Go\u00195fe6\u000bg.Y4feB\u0011Q+_\u0005\u0003u2\u0013\u0011d\u00117vgR,'\u000fT5oW\u001a+Go\u00195fe6\u000bg.Y4fe\u0006I1o\u00195fIVdWM\u001d\t\u0003+vL!A '\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tYh+A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0004+\u0006\u0015\u0011bAA\u0004\u0019\n\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u0015\u0005,H\u000f[8sSj,'\u000f\u0005\u0004\u0002\u000e\u0005M\u0011qC\u0007\u0003\u0003\u001fQ!!!\u0005\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005U\u0011q\u0002\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005e\u0011\u0011F\u0007\u0003\u00037QA!!\u0003\u0002\u001e)\u0019q*a\b\u000b\u0007E\u000b\tC\u0003\u0003\u0002$\u0005\u0015\u0012AB1qC\u000eDWM\u0003\u0002\u0002(\u0005\u0019qN]4\n\t\u0005-\u00121\u0004\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsV\u0011\u0011\u0011\u0007\t\u0007\u0003\u001b\t\u0019\"a\r\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQA!!\u000f\u0002\u001e\u00051\u0001o\u001c7jGfLA!!\u0010\u00028\t\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0002%\u0005dG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010I\u0001\b[\u0016$(/[2t!\r)\u0016QI\u0005\u0004\u0003\u000fb%AE\"mkN$XM\u001d'j].lU\r\u001e:jGNL1!a\u0013W\u0003-a\u0017N\\6NKR\u0014\u0018nY:\u0002!1Lgn[!e[&tg)Y2u_JL\b\u0003CA\u0007\u0003#\n\u0019!!\u0016\n\t\u0005M\u0013q\u0002\u0002\n\rVt7\r^5p]F\u00022!VA,\u0013\r\tI\u0006\u0014\u0002\u0017\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u001cE.[3oi&\u0019\u0011Q\n,\u0002!\u0011,7\u000f^!e[&tg)Y2u_JLXCAA1!\u0019\ti!a\u0019\u0002h%!\u0011QMA\b\u0005%1UO\\2uS>t\u0007\u0007E\u0002V\u0003SJ1!a\u001bM\u0005U\u0019E.^:uKJd\u0015N\\6M_\u000e\fG.\u00113nS:\f\u0011\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=!\u0003m\t7\r\u001c\"j]\u0012Lgn\u001a$jYR,'\u000f\u0016:b]N4wN]7feV\u0011\u00111\u000f\t\u0004+\u0006U\u0014bAA<\u0019\nY\u0012i\u00197CS:$\u0017N\\4GS2$XM\u001d+sC:\u001chm\u001c:nKJ\fA$Y2m\u0005&tG-\u001b8h\r&dG/\u001a:Ue\u0006t7OZ8s[\u0016\u0014\b%\u0001\u0003uS6,WCAA@!\u0011\t\t)!#\u000e\u0005\u0005\r%b\u00012\u0002\u0006*!\u0011qQA\u0010\u0003\u0019\u0019w.\\7p]&!\u00111RAB\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\rE,x\u000e^1t!\ra\u00171S\u0005\u0004\u0003+s%!E\"mkN$XM\u001d'j].\fVo\u001c;bg\u00061A(\u001b8jiz\"b$a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\u0011\u0005U\u0003\u0001\"B3\u0014\u0001\u00041\u0007\"\u00026\u0014\u0001\u0004Y\u0007\"B8\u0014\u0001\u0004\u0001\b\"B<\u0014\u0001\u0004A\b\"B>\u0014\u0001\u0004a\bbBA\u0001'\u0001\u0007\u00111\u0001\u0005\b\u0003\u0013\u0019\u0002\u0019AA\u0006\u0011\u001d\tic\u0005a\u0001\u0003cAq!!\u0011\u0014\u0001\u0004\t\u0019\u0005C\u0004\u0002NM\u0001\r!a\u0014\t\u000f\u0005u3\u00031\u0001\u0002b!9\u0011qN\nA\u0002\u0005M\u0004bBA>'\u0001\u0007\u0011q\u0010\u0005\b\u0003\u001f\u001b\u0002\u0019AAI\u0003M\u0019G.^:uKJd\u0015N\\6Ts:\u001c\u0017i\u00197t+\t\ti\f\u0005\u0004\u0002\u000e\u0005M\u0011q\u0018\t\u0004+\u0006\u0005\u0017bAAb\u0019\n\u00192\t\\;ti\u0016\u0014H*\u001b8l'ft7-Q2mg\u000692\r\\;ti\u0016\u0014H*\u001b8l'ft7-Q2mg~#S-\u001d\u000b\u0005\u0003\u0013\fy\r\u0005\u0003\u0002\u000e\u0005-\u0017\u0002BAg\u0003\u001f\u0011A!\u00168ji\"I\u0011\u0011[\u000b\u0002\u0002\u0003\u0007\u0011QX\u0001\u0004q\u0012\n\u0014\u0001F2mkN$XM\u001d'j].\u001c\u0016P\\2BG2\u001c\b%\u0001\fdYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t+\t\tI\u000e\u0005\u0004\u0002\u000e\u0005M\u00111\u001c\t\u0004+\u0006u\u0017bAAp\u0019\n12\t\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8/\u0001\u000edYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002J\u0006\u0015\b\"CAi1\u0005\u0005\t\u0019AAm\u0003]\u0019G.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001c\b%A\u000edYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0003[\u0004b!!\u0004\u0002\u0014\u0005=\bcA+\u0002r&\u0019\u00111\u001f'\u00039\rcWo\u001d;fe2Kgn[*z]\u000e$v\u000e]5dg\u000e{gNZ5hg\u0006y2\r\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001cuN\u001c4jON|F%Z9\u0015\t\u0005%\u0017\u0011 \u0005\n\u0003#\\\u0012\u0011!a\u0001\u0003[\fAd\u00197vgR,'\u000fT5oWNKhn\u0019+pa&\u001c7i\u001c8gS\u001e\u001c\b%\u0001\rdYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001e,\"A!\u0001\u0011\r\u00055\u00111\u0003B\u0002!\r)&QA\u0005\u0004\u0005\u000fa%\u0001G\"mkN$XM\u001d'j].\fU\u000f^8NSJ\u0014xN]5oO\u0006a2\r\\;ti\u0016\u0014H*\u001b8l\u0003V$x.T5se>\u0014\u0018N\\4`I\u0015\fH\u0003BAe\u0005\u001bA\u0011\"!5\u001f\u0003\u0003\u0005\rA!\u0001\u00023\rdWo\u001d;fe2Kgn[!vi>l\u0015N\u001d:pe&tw\rI\u0001\u0017G2,8\u000f^3s\u0019&t7\u000eT5ti>3gm]3ugV\u0011!Q\u0003\t\u0007\u0003\u001b\t\u0019Ba\u0006\u0011\u0007U\u0013I\"C\u0002\u0003\u001c1\u0013ac\u00117vgR,'\u000fT5oW2K7\u000f^(gMN,Go]\u0001\u001bG2,8\u000f^3s\u0019&t7\u000eT5ti>3gm]3ug~#S-\u001d\u000b\u0005\u0003\u0013\u0014\t\u0003C\u0005\u0002R\u0006\n\t\u00111\u0001\u0003\u0016\u000592\r\\;ti\u0016\u0014H*\u001b8l\u0019&\u001cHo\u00144gg\u0016$8\u000fI\u0001#G2,8\u000f^3s\u0019&t7n\u00117fCJl\u0015N\u001d:peN#\u0018M\u001d;PM\u001a\u001cX\r^:\u0016\u0005\t%\u0002cA+\u0003,%\u0019!Q\u0006'\u0003E\rcWo\u001d;fe2Kgn[\"mK\u0006\u0014X*\u001b:s_J\u001cF/\u0019:u\u001f\u001a47/\u001a;t\u0003\r\u001aG.^:uKJd\u0015N\\6DY\u0016\f'/T5se>\u00148\u000b^1si>3gm]3ug\u0002\n\u0001d\u00197vgR,'\u000fT5oWJ+\u0007/Y5s\u001b&\u0014(o\u001c:t+\t\u0011)\u0004E\u0002V\u0005oI1A!\u000fM\u0005a\u0019E.^:uKJd\u0015N\\6SKB\f\u0017N]'jeJ|'o]\u0001\u001aG2,8\u000f^3s\u0019&t7NU3qC&\u0014X*\u001b:s_J\u001c\b%\u0001\u000fdYV\u001cH/\u001a:MS:\\\u0007+Y;tK6K'O]8s)>\u0004\u0018nY:\u0016\u0005\t\u0005\u0003cA+\u0003D%\u0019!Q\t'\u00039\rcWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg\u0006i2\r\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\b%A\u0011u_BL7m](x]\u0016$\u0017i\u001d$jeN$\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u0006\u0002\u0003NA1!q\nB-\u0005;j!A!\u0015\u000b\t\tM#QK\u0001\b[V$\u0018M\u00197f\u0015\u0011\u00119&a\u0004\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\\\tE#aA*fiB!!q\fB7\u001d\u0011\u0011\tG!\u001b\u0011\t\t\r\u0014qB\u0007\u0003\u0005KR1Aa\u001aS\u0003\u0019a$o\\8u}%!!1NA\b\u0003\u0019\u0001&/\u001a3fM&!!q\u000eB9\u0005\u0019\u0019FO]5oO*!!1NA\b\u0003\t\"x\u000e]5dg>;h.\u001a3Bg\u001aK'o\u001d;QCJ$\u0018\u000e^5p]2+\u0017\rZ3sA\u0005a!/Z9vKN$\u0018+^8uCR\u0011!\u0011\u0010\t\u0004Y\nm\u0014b\u0001B?\u001d\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0001'gR\f'\u000f^;q\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017i\u0019;jm\u0016|%/\u00138bGRLg/\u001a+bg.\u001cHCAAe\u0003IqwN\\+tKJLE\r\u0015:j]\u000eL\u0007/\u00197\u0015\t\t\u001d%Q\u0012\t\u0005\u0003\u001b\u0011I)\u0003\u0003\u0003\f\u0006=!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u001fk\u0003\u0019\u0001BI\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0004\u0002\u000e\u0005M!QL\u0001\u0014e\u0016\u001cx.\u001e:dK&#\u0007K]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0005\u000f\u00139\nC\u0004\u0003\u0010:\u0002\rA!%\u0002A\u0005dG.Q2m\r&dG/\u001a:t+N,'+Z:pkJ\u001cW-\u00133G_Jl\u0017\r\u001e\u000b\u0003\u0005\u000f\u000bq#Y2m\r&dG/\u001a:XSRD'+Z:pkJ\u001cW-\u00133\u00029M$\u0018M\u001d;va\u0006#G-\u001b;j_:\fG.Q2uSZ,G+Y:lg\u000693\u000f[;uI><h.\u00113eSRLwN\\1m\u0003\u000e$\u0018N^3Pe&s\u0017m\u0019;jm\u0016$\u0016m]6t\u0003u\u0019\b.\u001e;e_^t\u0017\t\u001a3ji&|g.\u00197BGRLg/\u001a+bg.\u001c\u0018\u0001J1eIR{\u0007/[2t\u001f^tW\rZ!t\r&\u00148\u000f\u001e)beRLG/[8o\u0019\u0016\fG-\u001a:\u0015\t\u0005%'\u0011\u0016\u0005\b\u0005W#\u0004\u0019\u0001BW\u0003%\tG\r\u001a+pa&\u001c7\u000f\u0005\u0004\u00030\nE&QL\u0007\u0003\u0005+JAAa\u0017\u0003V\u00059#/Z7pm\u0016$v\u000e]5dg>;h.\u001a3Bg\u001aK'o\u001d;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s)\u0011\tIMa.\t\u000f\teV\u00071\u0001\u0003.\u0006a!/Z7pm\u0016$v\u000e]5dg\u0006Iq-\u001a;U_BL7m]\u000b\u0003\u0005[\u000bQbZ3u\u0003V$\bn\u001c:ju\u0016\u0014XCAA\u0006\u000399W\r^*z]\u000e\f5\r\u001c+bg.\fACZ3uG\"$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHC\u0002Be\u0005G\u00149\u000f\u0005\u0004\u0003L\ne'Q\\\u0007\u0003\u0005\u001bTAAa4\u0003R\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\tM'Q[\u0001\u0005kRLGN\u0003\u0002\u0003X\u0006!!.\u0019<b\u0013\u0011\u0011YN!4\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002\u000e\t}\u0017\u0002\u0002Bq\u0003\u001f\u00111!\u00138u\u0011\u001d\u0011)/\u000fa\u0001\u0005;\nQ\u0001^8qS\u000eDqA!;:\u0001\u0004\u0011i.A\u0005uS6,w.\u001e;Ng\u0006qa-\u001a;dQR{\u0007/[2J]\u001a|G\u0003\u0003Bx\u0005o\u0014IPa?\u0011\r\t-'\u0011\u001cBy!\r)&1_\u0005\u0004\u0005kd%\u0001F\"mkN$XM\u001d'j].$v\u000e]5d\u0013:4w\u000eC\u0004\u0003fj\u0002\rA!\u0018\t\u000f\t%(\b1\u0001\u0003^\"9!Q \u001eA\u0002\t}\u0018\u0001F:uCJ$xJ\u001a4tKR\u001c\u0006/Z2WC2,X\r\u0005\u0003\u0002\u000e\r\u0005\u0011\u0002BB\u0002\u0003\u001f\u0011A\u0001T8oO\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004\n\r]\u0001C\u0002BX\u0007\u0017\u0019y!\u0003\u0003\u0004\u000e\tU#aA*fcB!1\u0011CB\n\u001b\t\t))\u0003\u0003\u0004\u0016\u0005\u0015%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u00073Y\u0004\u0019AB\u000e\u0003%!x\u000e]5d\t\u0016\u001c8\r\u0005\u0003\u0004\u001e\r\u001dRBAB\u0010\u0015\u0011\u0019\tca\t\u0002\u000b\u0005$W.\u001b8\u000b\t\r\u0015\u0012qD\u0001\bG2LWM\u001c;t\u0013\u0011\u0019Ica\b\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0017a\u00044fi\u000eDGk\u001c9jG&sgm\\:\u0015\r\r=2QGB\u001e!!\u0011yk!\r\u0003^\t=\u0018\u0002BB\u001a\u0005+\u00121!T1q\u0011\u001d\u00199\u0004\u0010a\u0001\u0007s\tq\u0004^8qS\u000e\u001cx+\u001b;i'R\f'\u000f^(gMN,Go\u00159fGZ\u000bG.^3t!!\u0011yk!\r\u0003^\t}\bb\u0002Buy\u0001\u0007!Q\\\u0001\u001cM\u0016$8\r\u001b+pa&\u001c\u0017J\u001c4p\u0011\u0006tG\r\\3SKN,H\u000e^:\u0015\u0019\u0005%7\u0011IB#\u0007/\u001ayf!\u001d\t\u000f\r\rS\b1\u0001\u0003.\u00061Ao\u001c9jGNDqaa\u0012>\u0001\u0004\u0019I%\u0001\u0007d_:4\u0017n\u001a$viV\u0014X\r\u0005\u0005\u00030\u000eE\"QLB&!\u0019\u0019\tb!\u0014\u0004R%!1qJAC\u0005-Y\u0015MZ6b\rV$XO]3\u0011\t\ru11K\u0005\u0005\u0007+\u001ayB\u0001\u0004D_:4\u0017n\u001a\u0005\b\u00073j\u0004\u0019AB.\u0003E!Wm]2sSB$\u0018n\u001c8GkR,(/\u001a\t\t\u0005_\u001b\tD!\u0018\u0004^A11\u0011CB'\u00077Aqa!\u0019>\u0001\u0004\u0019\u0019'\u0001\nti\u0006\u0014Ho\u00144gg\u0016$8OR;ukJ,\u0007C\u0002Bf\u0007K\u001aI'\u0003\u0003\u0004h\t5'aD\"p[BdW\r^5p]N#\u0018mZ3\u0011\r\u00055\u00111CB6!\u0011\u0019ib!\u001c\n\t\r=4q\u0004\u0002\u0012\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\bbBB:{\u0001\u00071qF\u0001\u0007e\u0016\u001cX\u000f\u001c;\u000295\f\u0017PY3UQJ|w\u000fV8qS\u000eLeNZ8Fq\u000e,\u0007\u000f^5p]V!1\u0011PB@)!\u0019Yh!%\u0004\u0014\u000eu\u0005\u0003BB?\u0007\u007fb\u0001\u0001B\u0004\u0004\u0002z\u0012\raa!\u0003\u0003Q\u000bBa!\"\u0004\fB!\u0011QBBD\u0013\u0011\u0019I)a\u0004\u0003\u000f9{G\u000f[5oOB!\u0011QBBG\u0013\u0011\u0019y)a\u0004\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003fz\u0002\rA!\u0018\t\u000f\rUe\b1\u0001\u0004\u0018\u00061a-\u001e;ve\u0016\u0004bAa3\u0004\u001a\u000em\u0014\u0002BBN\u0005\u001b\u0014aAR;ukJ,\u0007bBBP}\u0001\u0007!QL\u0001\u0007C\u000e$\u0018n\u001c8\u0015\u001d\u0005%71UBS\u0007O\u001bIka+\u00040\"911I A\u0002\t5\u0006bBB$\u007f\u0001\u00071\u0011\n\u0005\b\u00073z\u0004\u0019AB.\u0011\u001d\u0019\tg\u0010a\u0001\u0007GBqa!,@\u0001\u0004\u0019\u0019'A\nmCR,7\u000f^(gMN,Go\u001d$viV\u0014X\rC\u0004\u0004t}\u0002\raa\f\u00027\u0019,Go\u00195U_BL7-\u00138g_^\u0013\u0018\r]#yG\u0016\u0004H/[8o)!\u0019)la2\u0004J\u000e5\u0007\u0003BB\\\u0007\u0003tAa!/\u0004>:!!1MB^\u0013\t\t\t\"\u0003\u0003\u0004@\u0006=\u0011a\u00029bG.\fw-Z\u0005\u0005\u0007\u0007\u001c)MA\u0005UQJ|w/\u00192mK*!1qXA\b\u0011\u001d\u0011)\u000f\u0011a\u0001\u0005;Bqaa3A\u0001\u0004\u0019),A\u0001f\u0011\u001d\u0019y\n\u0011a\u0001\u0005;\nQB]3qY&\u001c\u0017m\u0015;biV\u001cH\u0003BBj\u0007G\u0004\u0002Ba,\u00042\r=1Q\u001b\t\u0007\u0005\u0017\u0014Ina6\u0011\t\re7q\\\u0007\u0003\u00077T1a!8Q\u0003\u001d\u0019G.^:uKJLAa!9\u0004\\\ny\u0001+\u0019:uSRLwN\\*uCR,8\u000fC\u0004\u0004f\u0006\u0003\raa:\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u00030\nE6qB\u0001\u001bi>\u0014Vm];mi6K'O]8s\u0013:4wn\u0015;sSB\u0004X\r\u001a\u000b\u0005\u0007/\u001ci\u000fC\u0004\u0004t\t\u0003\raa<\u0011\t\ru1\u0011_\u0005\u0005\u0007g\u001cyBA\bQCJ$\u0018\u000e^5p]J+7/\u001e7u\u0003e\u0001(o\\2fgNl\u0015N\u001d:peN#\u0018\r^3DQ\u0006tw-Z:\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t)\t\u0019Y\u0010E\u0002V\u0007{L1aa@M\u0005ii\u0015N\u001d:peR{\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014XC\u0001C\u0003!\r)FqA\u0005\u0004\t\u0013a%AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018!F5t'V\u0004\bo\u001c:uK\u0012\fU\u000f\u001e5pe&TXM\u001d\u000b\u0005\u0005\u000f#y\u0001C\u0004\u0002\n\u0019\u0003\r!a\u0006\u0015\r\t\u001dE1\u0003C\f\u0011\u001d!)b\u0012a\u0001\u0005;\n\u0011b\u00197bgNt\u0015-\\3\t\u000f\u0005%q\t1\u0001\u0002\u0018Q\u0011\u00111I\u0001!i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\u001a{'/\u00113eSRLwN\\1m)\u0006\u001c8\u000e\u0006\u0003\u0005 \u0011\u001d\u0002CBA\u0007\u0003'!\t\u0003E\u0002V\tGI1\u0001\"\nM\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0007b\u0002C\u0015\u0013\u0002\u0007A1F\u0001\ti\u0006\u001c8\u000eV=qKB\u0019Q\u000b\"\f\n\u0007\u0011=BJ\u0001\u0005UCN\\G+\u001f9f\u00039\u0019X\u000f]3sI1Lgn\u001b#bi\u0006,\u0012\u0001\u001d")
public class ClusterLinkDestClientManager
extends AbstractClusterLinkClientManager
implements ClusterLinkFactory.DestClientManager {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkFetcherManager fetcherManager;
    private final Option<Authorizer> authorizer;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final Function0<ClusterLinkLocalAdmin> destAdminFactory;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final Time time;
    private final ClusterLinkQuotas quotas;
    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls;
    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets;
    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs;
    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring;
    private Option<ClusterLinkListOffsets> clusterLinkListOffsets;
    private final ClusterLinkClearMirrorStartOffsets clusterLinkClearMirrorStartOffsets;
    private final ClusterLinkRepairMirrors clusterLinkRepairMirrors;
    private final ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics;
    private final scala.collection.mutable.Set<String> topicsOwnedAsFirstPartitionLeader;

    private /* synthetic */ ClusterLinkData super$linkData() {
        return super.linkData();
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public Function0<ClusterLinkLocalAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    public Time time() {
        return this.time;
    }

    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls() {
        return this.clusterLinkSyncAcls;
    }

    private void clusterLinkSyncAcls_$eq(Option<ClusterLinkSyncAcls> x$1) {
        this.clusterLinkSyncAcls = x$1;
    }

    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets() {
        return this.clusterLinkSyncOffsets;
    }

    private void clusterLinkSyncOffsets_$eq(Option<ClusterLinkSyncOffsets> x$1) {
        this.clusterLinkSyncOffsets = x$1;
    }

    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs() {
        return this.clusterLinkSyncTopicConfigs;
    }

    private void clusterLinkSyncTopicConfigs_$eq(Option<ClusterLinkSyncTopicsConfigs> x$1) {
        this.clusterLinkSyncTopicConfigs = x$1;
    }

    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring() {
        return this.clusterLinkAutoMirroring;
    }

    private void clusterLinkAutoMirroring_$eq(Option<ClusterLinkAutoMirroring> x$1) {
        this.clusterLinkAutoMirroring = x$1;
    }

    private Option<ClusterLinkListOffsets> clusterLinkListOffsets() {
        return this.clusterLinkListOffsets;
    }

    private void clusterLinkListOffsets_$eq(Option<ClusterLinkListOffsets> x$1) {
        this.clusterLinkListOffsets = x$1;
    }

    public ClusterLinkClearMirrorStartOffsets clusterLinkClearMirrorStartOffsets() {
        return this.clusterLinkClearMirrorStartOffsets;
    }

    public ClusterLinkRepairMirrors clusterLinkRepairMirrors() {
        return this.clusterLinkRepairMirrors;
    }

    private ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics() {
        return this.clusterLinkPauseMirrorTopics;
    }

    private scala.collection.mutable.Set<String> topicsOwnedAsFirstPartitionLeader() {
        return this.topicsOwnedAsFirstPartitionLeader;
    }

    public ClusterLinkRequestQuota requestQuota() {
        return this.quotas.requestQuotaAdapter(super.linkData());
    }

    @Override
    public void startupAdditionalActiveOrInactiveTasks() {
        this.clusterLinkClearMirrorStartOffsets().startup();
        this.clusterLinkRepairMirrors().startup();
        this.clusterLinkPauseMirrorTopics().startup();
    }

    public boolean nonUserIdPrincipal(Option<String> principal) {
        if (principal instanceof Some) {
            String principal2 = (String)((Some)principal).value();
            return SecurityUtils.parseKafkaPrincipal((String)principal2).getName().startsWith("pool") || SecurityUtils.parseKafkaPrincipal((String)principal2).getName().startsWith("spiffe") || SecurityUtils.parseKafkaPrincipal((String)principal2).getName().startsWith("group");
        }
        if (None$.MODULE$.equals(principal)) {
            return false;
        }
        throw new MatchError(principal);
    }

    public boolean resourceIdPrincipal(Option<String> principal) {
        if (principal instanceof Some) {
            return !SecurityUtils.parseKafkaPrincipal((String)((String)((Some)principal).value())).getName().matches("[0-9]+");
        }
        if (None$.MODULE$.equals(principal)) {
            return false;
        }
        throw new MatchError(principal);
    }

    public boolean allAclFiltersUseResourceIdFormat() {
        Option<AclFiltersJson> option = this.currentConfig().aclFilters();
        if (option instanceof Some) {
            AclFiltersJson filter = (AclFiltersJson)((Some)option).value();
            scala.collection.immutable.Set filtersFormat = ((IterableOnceOps)((StrictOptimizedIterableOps)AclJson$.MODULE$.toAclBindingFilters(filter).filter((Function1 & Serializable)aclBindingFilter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$allAclFiltersUseResourceIdFormat$1(this, aclBindingFilter)))).map((Function1 & Serializable)aclBindingFilter -> BoxesRunTime.boxToBoolean((boolean)this.resourceIdPrincipal((Option<String>)Option$.MODULE$.apply((Object)aclBindingFilter.entryFilter().principal()))))).toSet();
            if (filtersFormat.isEmpty()) {
                return true;
            }
            if (filtersFormat.size() == 1) {
                return BoxesRunTime.unboxToBoolean((Object)filtersFormat.head());
            }
            throw new IllegalArgumentException(new StringBuilder(177).append("If kafka.config.authorizer.resource.id.support.enable flag is enabled, aclFilters in cluster link").append("should contain filters either in old or new format, but got mix of both format. ").append(filter).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public boolean aclFilterWithResourceId() {
        return Predef$.MODULE$.Boolean2boolean(this.brokerConfig.getBoolean("multitenant.authorizer.support.resource.ids")) && this.allAclFiltersUseResourceIdFormat();
    }

    @Override
    public void startupAdditionalActiveTasks() {
        ClusterLinkRequestQuota requestQuota = this.quotas.requestQuotaAdapter(super.linkData());
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)new Some((Object)new ClusterLinkSyncOffsets(this, super.clusterLinkManager().metadataManager(), super.linkData(), this.destAdminFactory(), super.linkMetrics(), this.time(), requestQuota)));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncOffsets().get()).startup();
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)new Some((Object)new ClusterLinkSyncTopicsConfigs(this, super.clusterLinkManager().metadataManager(), (ConfluentAdmin)this.destAdminFactory().apply(), Predef$.MODULE$.Integer2int(this.currentConfig().topicConfigSyncMs()), super.linkMetrics(), super.linkData(), this.time(), requestQuota)));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncTopicConfigs().get()).startup();
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)new Some((Object)new ClusterLinkListOffsets(this, this.fetcherManager, Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.time(), requestQuota, this.linkMetrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkListOffsets().get()).startup();
        if (this.currentConfig().aclSyncEnable()) {
            this.authorizer.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            });
            if (!this.authorizer.exists((Function1 & Serializable)authorizer -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedAuthorizer(authorizer)))) {
                throw new IllegalArgumentException(new StringBuilder(125).append("ACL migration is supported only with the built-in ").append("authorizers AclAuthorizer and ConfluentServerAuthorizer. ").append(this.authorizer.get().getClass()).append(" is not supported.").toString());
            }
            this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)new Some((Object)new ClusterLinkSyncAcls(this, super.linkData(), super.clusterLinkManager().metadataManager(), this.destAdminFactory(), super.linkMetrics(), this.aclBindingFilterTransformer(), this.time(), requestQuota, this.aclFilterWithResourceId())));
            ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncAcls().get()).startup();
        }
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)new Some((Object)new ClusterLinkAutoMirroring(this, super.clusterLinkManager().metadataManager(), super.linkData(), this.destAdminFactory(), super.linkMetrics(), this.time(), requestQuota)));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkAutoMirroring().get()).startup();
    }

    @Override
    public void shutdownAdditionalActiveOrInactiveTasks() {
        this.clusterLinkClearMirrorStartOffsets().shutdown();
        this.clusterLinkRepairMirrors().shutdown();
        this.clusterLinkPauseMirrorTopics().shutdown();
    }

    @Override
    public void shutdownAdditionalActiveTasks() {
        this.clusterLinkSyncTopicConfigs().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)None$.MODULE$);
        this.clusterLinkSyncOffsets().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)None$.MODULE$);
        this.clusterLinkSyncAcls().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)None$.MODULE$);
        this.clusterLinkAutoMirroring().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)None$.MODULE$);
        this.clusterLinkListOffsets().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)None$.MODULE$);
    }

    @Override
    public void addTopicsOwnedAsFirstPartitionLeader(Set<String> addTopics) {
        Object object = this.lock();
        synchronized (object) {
            addTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkDestClientManager.$anonfun$addTopicsOwnedAsFirstPartitionLeader$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void removeTopicsOwnedAsFirstPartitionLeader(Set<String> removeTopics) {
        Object object = this.lock();
        synchronized (object) {
            removeTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkDestClientManager.$anonfun$removeTopicsOwnedAsFirstPartitionLeader$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Set<String> getTopics() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = this.metadataManager().isLinkCoordinatorEnabled() ? (this.metadataManager().isLinkCoordinator(super.linkData().linkName()) ? ((MapOps)this.metadataManager().mirrorTopicStatesFromMetadataCache(super.linkData().linkId()).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$getTopics$1(x$6)))).keySet() : (Set)scala.collection.Set$.MODULE$.empty()) : this.topicsOwnedAsFirstPartitionLeader().toSet();
            return set;
        }
    }

    public Option<Authorizer> getAuthorizer() {
        return this.authorizer;
    }

    public Option<ClusterLinkSyncAcls> getSyncAclTask() {
        return this.clusterLinkSyncAcls();
    }

    @Override
    public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            super.scheduler().scheduleWhenComplete("ClusterLinkFetchTopicPartitions", describeTopicsResult.allTopicNames(), () -> result.complete(BoxesRunTime.boxToInteger((int)((TopicDescription)((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)).get()).partitions().size())));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "fetching partitions"));
        }
        return result;
    }

    @Override
    public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs, long startOffsetSpecValue) {
        return (CompletableFuture)this.fetchTopicInfos((Map<String, Object>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToLong((long)startOffsetSpecValue))}))), timeoutMs).apply((Object)topic);
    }

    private Seq<TopicPartition> topicPartitions(TopicDescription topicDesc) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), topicDesc.partitions().size()).map((Function1 & Serializable)x$7 -> ClusterLinkDestClientManager.$anonfun$topicPartitions$1(topicDesc, BoxesRunTime.unboxToInt((Object)x$7)));
    }

    public Map<String, CompletableFuture<ClusterLinkTopicInfo>> fetchTopicInfos(Map<String, Object> topicsWithStartOffsetSpecValues, int timeoutMs) {
        scala.collection.immutable.Map topicsWithStartOffsetSpec = topicsWithStartOffsetSpecValues.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                long spec = x0$1._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)ClusterLinkUtils$.MODULE$.toOffsetSpec(spec, this.currentConfig().mirrorStartOffsetSpec()));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Set topics = topicsWithStartOffsetSpec.keySet();
        scala.collection.immutable.Map result = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> new Tuple2(topic, new CompletableFuture()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)).includeAuthorizedOperations(true);
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)topics).asJava(), describeTopicsOptions);
            scala.collection.immutable.Map topicsRequiringOffsets = (scala.collection.immutable.Map)topicsWithStartOffsetSpec.filterNot((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$fetchTopicInfos$3(x$8)));
            CompletableFuture<None$> startOffsetsFuture = topicsRequiringOffsets.nonEmpty() ? describeTopicsResult.allTopicNames().toCompletionStage().thenCompose(topicDescs -> {
                HashMap reqMap = new HashMap();
                topicDescs.forEach((topic, topicDesc) -> {
                    if (topicsRequiringOffsets.contains(topic)) {
                        this.topicPartitions((TopicDescription)topicDesc).foreach((Function1 & Serializable)tp -> (OffsetSpec)reqMap.put(tp, topicsWithStartOffsetSpec.apply(topic)));
                        return;
                    }
                });
                ListOffsetsResult listResult = this.getAdmin().listOffsets(reqMap);
                return listResult.all().toCompletionStage().thenApply(x$9 -> new Some((Object)listResult));
            }) : CompletableFuture.completedFuture(None$.MODULE$);
            scala.collection.immutable.Set resources = (scala.collection.immutable.Set)topics.map((Function1 & Serializable)topic -> new ConfigResource(ConfigResource.Type.TOPIC, topic));
            DescribeConfigsOptions describeConfigsOptions = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeConfigsResult describeConfigsResult = this.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)resources).asJava(), describeConfigsOptions);
            CompletableFuture<Void> futures = CompletableFuture.allOf(describeTopicsResult.allTopicNames().toCompletionStage().toCompletableFuture(), describeConfigsResult.all().toCompletionStage().toCompletableFuture(), startOffsetsFuture.toCompletableFuture());
            super.scheduler().scheduleWhenComplete("FetchTopicInfo", futures, () -> {
                scala.collection.immutable.Map configs = CollectionConverters$.MODULE$.MapHasAsScala(describeConfigsResult.values()).asScala().map((Function1 & Serializable)e -> new Tuple2((Object)((ConfigResource)e._1()).name(), e._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                scala.collection.mutable.Map describeResult = CollectionConverters$.MODULE$.MapHasAsScala(describeTopicsResult.topicNameValues()).asScala();
                this.fetchTopicInfoHandleResults((Set<String>)topics, (Map<String, KafkaFuture<Config>>)configs, (Map<String, KafkaFuture<TopicDescription>>)describeResult, startOffsetsFuture, (Map<String, CompletableFuture<ClusterLinkTopicInfo>>)result);
            });
        }
        catch (Throwable e) {
            result.foreach((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$fetchTopicInfos$11(this, e, r)));
        }
        return result;
    }

    private void fetchTopicInfoHandleResults(Set<String> topics, Map<String, KafkaFuture<Config>> configFuture, Map<String, KafkaFuture<TopicDescription>> descriptionFuture, CompletionStage<Option<ListOffsetsResult>> startOffsetsFuture, Map<String, CompletableFuture<ClusterLinkTopicInfo>> result) {
        try {
            CompletionStage<Object> completionStage;
            Option<ListOffsetsResult> startOffsetsResult = this.maybeThrowTopicInfoException(topics.mkString(","), startOffsetsFuture.toCompletableFuture(), "fetching start offsets");
            HashMap latestOffsetReqMap = new HashMap();
            topics.foreach((Function1 & Serializable)topic -> {
                try {
                    TopicDescription topicDesc = (TopicDescription)this.maybeThrowTopicInfoException((String)topic, (Future)descriptionFuture.apply(topic), "fetching description");
                    startOffsetsResult.foreach((Function1 & Serializable)startResult -> {
                        ClusterLinkDestClientManager.$anonfun$fetchTopicInfoHandleResults$2(this, topicDesc, latestOffsetReqMap, startResult);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    return BoxesRunTime.boxToBoolean((boolean)((CompletableFuture)result.apply(topic)).completeExceptionally(e));
                }
            });
            if (latestOffsetReqMap.isEmpty()) {
                completionStage = CompletableFuture.completedFuture(None$.MODULE$);
            } else {
                ListOffsetsResult listResult = this.getAdmin().listOffsets(latestOffsetReqMap);
                completionStage = listResult.all().toCompletionStage().thenApply(x$10 -> new Some((Object)listResult));
            }
            CompletableFuture<None$> latestOffsetsFuture = completionStage;
            super.scheduler().scheduleWhenComplete("FetchTopicInfoLatestOffsets", latestOffsetsFuture.toCompletableFuture(), () -> this.fetchTopicInfoHandleResults(topics, configFuture, descriptionFuture, startOffsetsFuture, latestOffsetsFuture, result));
            return;
        }
        catch (Throwable e) {
            result.values().foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.completeExceptionally(e)));
            return;
        }
    }

    private <T> T maybeThrowTopicInfoException(String topic, Future<T> future, String action) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw this.fetchTopicInfoWrapException(topic, e.getCause(), action);
        }
        catch (Throwable e) {
            throw this.fetchTopicInfoWrapException(topic, e, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fetchTopicInfoHandleResults(Set<String> topics, Map<String, KafkaFuture<Config>> configFuture, Map<String, KafkaFuture<TopicDescription>> descriptionFuture, CompletionStage<Option<ListOffsetsResult>> startOffsetsFuture, CompletionStage<Option<ListOffsetsResult>> latestOffsetsFuture, Map<String, CompletableFuture<ClusterLinkTopicInfo>> result) {
        Object object = new Object();
        try {
            void var10_10;
            void var9_9;
            Tuple2 tuple2 = this.liftedTree1$1(topics, startOffsetsFuture, latestOffsetsFuture, result, object);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option startOffsetsResult = (Option)tuple2._1();
            Option latestOffsetsResult = (Option)tuple2._2();
            configFuture.keySet().foreach(arg_0 -> ClusterLinkDestClientManager.$anonfun$fetchTopicInfoHandleResults$8$adapted(this, descriptionFuture, configFuture, (Option)var9_9, (Option)var10_10, result, arg_0));
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private Throwable fetchTopicInfoWrapException(String topic, Throwable e, String action) {
        ApiError error = ApiError.fromThrowable((Throwable)e);
        return error.error().exception(new StringBuilder(42).append("While ").append(action).append(" for topic '").append(topic).append("' over cluster link '").append(super.linkData().linkName()).append("': ").append(error.messageWithFallback()).toString());
    }

    @Override
    public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(false);
        return CollectionConverters$.MODULE$.MapHasAsScala(this.getAdmin().replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava(), options).partitionResults()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                CompletableFuture completableFuture = new CompletableFuture();
                future.whenComplete((res, ex) -> {
                    Option option = Option$.MODULE$.apply(ex);
                    if (option instanceof Some) {
                        Throwable e = (Throwable)((Some)option).value();
                        completableFuture.completeExceptionally(e);
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        completableFuture.complete(this.toResultMirrorInfoStripped((PartitionResult)res));
                        return;
                    }
                    throw new MatchError((Object)option);
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), completableFuture);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private PartitionStatus toResultMirrorInfoStripped(PartitionResult result) {
        scala.collection.immutable.Seq replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.replicas()).asScala().map((Function1 & Serializable)rs -> new ReplicaStatus(rs.brokerId(), rs.isLeader(), rs.isObserver(), rs.isIsrEligible(), rs.isInIsr(), rs.isCaughtUp(), rs.logStartOffset(), rs.logEndOffset(), rs.lastCaughtUpTimeMs(), rs.lastFetchTimeMs(), Optional.of(this.super$linkData().linkName()), Optional.empty()))).toSeq();
        return new PartitionStatus(result.leaderId(), result.leaderEpoch().getAsInt(), (Seq<ReplicaStatus>)replicas);
    }

    @Override
    public void processMirrorStateChanges() {
        this.clusterLinkClearMirrorStartOffsets().processMirrorStateChanges();
        this.clusterLinkRepairMirrors().processMirrorStateChanges();
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.currentConfig().topicConfigSyncRules();
    }

    public ClusterLinkMetadataManager metadataManager() {
        return super.clusterLinkManager().metadataManager();
    }

    private boolean isSupportedAuthorizer(Authorizer authorizer) {
        if (authorizer instanceof AclAuthorizer) {
            return true;
        }
        if (authorizer instanceof StandardAuthorizer) {
            return true;
        }
        return this.isSupportedAuthorizer("io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer", authorizer);
    }

    private boolean isSupportedAuthorizer(String className, Authorizer authorizer) {
        try {
            return Utils.loadClass((String)className, Authorizer.class).isInstance(authorizer);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public ClusterLinkMetrics metrics() {
        return this.linkMetrics();
    }

    @Override
    public Option<TaskDescription> taskDescriptionForAdditionalTask(TaskType taskType) {
        if (ClusterLinkSyncOffsetsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkSyncOffsets().flatMap((Function1 & Serializable)x$14 -> x$14.taskDescription());
        }
        if (ClusterLinkSyncAclsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkSyncAcls().flatMap((Function1 & Serializable)x$15 -> x$15.taskDescription());
        }
        if (ClusterLinkAutoMirroringTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkAutoMirroring().flatMap((Function1 & Serializable)x$16 -> x$16.taskDescription());
        }
        if (ClusterLinkSyncTopicConfigsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkSyncTopicConfigs().flatMap((Function1 & Serializable)x$17 -> x$17.taskDescription());
        }
        if (ClusterLinkClearMirrorStartOffsetsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkClearMirrorStartOffsets().taskDescription();
        }
        if (ClusterLinkPauseMirrorTopicsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkPauseMirrorTopics().taskDescription();
        }
        if (ClusterLinkListOffsetsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkListOffsets().flatMap((Function1 & Serializable)x$18 -> x$18.taskDescription());
        }
        if (PeriodicPartitionSchedulerTaskType$.MODULE$.equals(taskType)) {
            return this.fetcherManager.partitionSchedulerTaskDescription();
        }
        if (ClusterLinkRepairMirrorsTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkRepairMirrors().taskDescription();
        }
        throw new IllegalArgumentException(new StringBuilder(18).append("Unknown task type ").append(taskType.name()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$allAclFiltersUseResourceIdFormat$1(ClusterLinkDestClientManager $this, AclBindingFilter aclBindingFilter) {
        return !$this.nonUserIdPrincipal((Option<String>)Option$.MODULE$.apply((Object)aclBindingFilter.entryFilter().principal()));
    }

    public static final /* synthetic */ void $anonfun$addTopicsOwnedAsFirstPartitionLeader$1(ClusterLinkDestClientManager $this, String topic) {
        if ($this.topicsOwnedAsFirstPartitionLeader().add((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Added topic '").append(topic).append("' for cluster link data '").append($this.super$linkData()).append("'").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$removeTopicsOwnedAsFirstPartitionLeader$1(ClusterLinkDestClientManager $this, String topic) {
        if ($this.topicsOwnedAsFirstPartitionLeader().remove((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Removed topic '").append(topic).append("' for cluster link data '").append($this.super$linkData()).append("''").toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getTopics$1(Tuple2 x$6) {
        return ((ClusterLinkTopicState)x$6._2()).state().shouldSync();
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TopicDescription topicDesc$1, int x$7) {
        return new TopicPartition(topicDesc$1.name(), x$7);
    }

    public static final /* synthetic */ boolean $anonfun$fetchTopicInfos$3(Tuple2 x$8) {
        return x$8._2() instanceof OffsetSpec.EarliestSpec;
    }

    public static final /* synthetic */ boolean $anonfun$fetchTopicInfos$11(ClusterLinkDestClientManager $this, Throwable e$1, Tuple2 r) {
        return ((CompletableFuture)r._2()).completeExceptionally($this.fetchTopicInfoWrapException((String)r._1(), e$1, "preparing client to fetch information"));
    }

    public static final /* synthetic */ void $anonfun$fetchTopicInfoHandleResults$2(ClusterLinkDestClientManager $this, TopicDescription topicDesc$2, HashMap latestOffsetReqMap$1, ListOffsetsResult startResult) {
        $this.topicPartitions(topicDesc$2).foreach((Function1 & Serializable)tp -> {
            if (((ListOffsetsResult.ListOffsetsResultInfo)$this.maybeThrowTopicInfoException(tp.toString(), (Future)startResult.partitionResult(tp), "fetching start offset")).offset() == -1L) {
                return latestOffsetReqMap$1.put(tp, new OffsetSpec.LatestSpec());
            }
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(Set topics$3, CompletionStage startOffsetsFuture$3, CompletionStage latestOffsetsFuture$2, Map result$4, Object nonLocalReturnKey1$1) {
        try {
            Option start = (Option)this.maybeThrowTopicInfoException(topics$3.mkString(","), startOffsetsFuture$3.toCompletableFuture(), "fetching start offsets");
            Option latest = (Option)this.maybeThrowTopicInfoException(topics$3.mkString(","), latestOffsetsFuture$2.toCompletableFuture(), "fetching latest offsets");
            return new Tuple2((Object)start, (Object)latest);
        }
        catch (Throwable e) {
            result$4.values().foreach((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.completeExceptionally(e)));
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ long $anonfun$fetchTopicInfoHandleResults$10(ClusterLinkDestClientManager $this, TopicPartition tp$1, Option latestOffsetsResult$1, KafkaFuture partitionResult) {
        long startOffset = ((ListOffsetsResult.ListOffsetsResultInfo)$this.maybeThrowTopicInfoException(tp$1.toString(), (Future)partitionResult, "fetching partition offsets to use as mirror start offsets")).offset();
        if (startOffset == -1L) {
            long latestOffset = ((ListOffsetsResult.ListOffsetsResultInfo)$this.maybeThrowTopicInfoException(tp$1.toString(), (Future)((ListOffsetsResult)latestOffsetsResult$1.get()).partitionResult(tp$1), "fetching start offsets")).offset();
            return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)latestOffset)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        return startOffset;
    }

    public static final /* synthetic */ long $anonfun$fetchTopicInfoHandleResults$9(ClusterLinkDestClientManager $this, ListOffsetsResult result$5, Option latestOffsetsResult$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)result$5.partitionResult(tp)).map((Function1 & Serializable)partitionResult -> BoxesRunTime.boxToLong((long)ClusterLinkDestClientManager.$anonfun$fetchTopicInfoHandleResults$10($this, tp, latestOffsetsResult$1, partitionResult))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$fetchTopicInfoHandleResults$8(ClusterLinkDestClientManager $this, Map descriptionFuture$2, Map configFuture$2, Option startOffsetsResult$2, Option latestOffsetsResult$1, Map result$4, String topic) {
        try {
            Seq seq;
            TopicDescription description = (TopicDescription)$this.maybeThrowTopicInfoException(topic, (Future)descriptionFuture$2.apply((Object)topic), "fetching description");
            Config config = (Config)$this.maybeThrowTopicInfoException(topic, (Future)configFuture$2.apply((Object)topic), "fetching configuration");
            if (startOffsetsResult$2 instanceof Some) {
                ListOffsetsResult result = (ListOffsetsResult)((Some)startOffsetsResult$2).value();
                seq = (Seq)$this.topicPartitions(description).map((Function1 & Serializable)tp -> BoxesRunTime.boxToLong((long)ClusterLinkDestClientManager.$anonfun$fetchTopicInfoHandleResults$9($this, result, latestOffsetsResult$1, tp)));
            } else if (None$.MODULE$.equals(startOffsetsResult$2)) {
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)startOffsetsResult$2);
            }
            Seq startOffsets = seq;
            return ((CompletableFuture)result$4.apply((Object)topic)).complete(new ClusterLinkTopicInfo(description, config, (Seq<Object>)startOffsets));
        }
        catch (Throwable e) {
            return ((CompletableFuture)result$4.apply((Object)topic)).completeExceptionally(e);
        }
    }

    public ClusterLinkDestClientManager(ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, ClusterLinkData linkData, ClusterLinkFetcherManager fetcherManager, ClusterLinkScheduler scheduler, ClusterLinkConfig initialConfig, Option<Authorizer> authorizer, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkMetrics metrics, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, Function0<ClusterLinkLocalAdmin> destAdminFactory, AclBindingFilterTransformer aclBindingFilterTransformer, Time time, ClusterLinkQuotas quotas) {
        this.brokerConfig = brokerConfig;
        this.fetcherManager = fetcherManager;
        this.authorizer = authorizer;
        this.alterConfigPolicy = alterConfigPolicy;
        this.destAdminFactory = destAdminFactory;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.time = time;
        this.quotas = quotas;
        super(clusterLinkManager, linkData, metrics, scheduler, linkAdminFactory, initialConfig, time, quotas);
        this.logIdent_$eq(new StringBuilder(36).append("[ClusterLinkClientManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.clusterLinkSyncAcls = None$.MODULE$;
        this.clusterLinkSyncOffsets = None$.MODULE$;
        this.clusterLinkSyncTopicConfigs = None$.MODULE$;
        this.clusterLinkAutoMirroring = None$.MODULE$;
        this.clusterLinkListOffsets = None$.MODULE$;
        this.clusterLinkClearMirrorStartOffsets = new ClusterLinkClearMirrorStartOffsets(super.linkData(), super.scheduler(), super.clusterLinkManager().metadataManager(), destAdminFactory, time, this.requestQuota(), super.linkMetrics(), 1000, 1000);
        this.clusterLinkRepairMirrors = new ClusterLinkRepairMirrors(super.linkData(), super.scheduler(), super.clusterLinkManager().metadataManager(), destAdminFactory, time, this.requestQuota(), super.linkMetrics(), 1000, 1000);
        this.clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics(super.linkData().linkId(), super.linkData().linkName(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> !this.isActive(), super.scheduler(), super.clusterLinkManager().metadataManager(), destAdminFactory, time, this.requestQuota(), super.linkMetrics(), 20, 5000, 1000);
        this.topicsOwnedAsFirstPartitionLeader = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$fetchTopicInfoHandleResults$8$adapted(ClusterLinkDestClientManager $this, Map descriptionFuture$2, Map configFuture$2, Option startOffsetsResult$2, Option latestOffsetsResult$1, Map result$4, String topic) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$fetchTopicInfoHandleResults$8($this, descriptionFuture$2, configFuture$2, startOffsetsResult$2, latestOffsetsResult$1, result$4, topic));
    }
}

