/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStatus;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSensorFactory;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.FetcherRemoveReason;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskSensorsManager;
import kafka.server.link.TaskType;
import kafka.server.link.UnavailableLinkReason;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\rEw!\u0002%J\u0011\u0003\u0001f!\u0002*J\u0011\u0003\u0019\u0006\"\u0002.\u0002\t\u0003Yf\u0001\u0002/\u0002\u0001uCQAW\u0002\u0005\u0002)DQ!\\\u0002\u0005\u00029DQA]\u0002\u0005\u00029Daa]\u0002\u0005\u0002%#\b\u0002CA\u000e\u0007\u0011\u0005\u0011*!\b\t\u0011\u0005\u00053\u0001\"\u0001J\u0003\u0007Bq!!\u001b\u0004\t\u0003Ie\u000eC\u0004\u0002l\r!\t!!\u001c\t\u000f\u0005=4\u0001\"\u0001\u0002r\u00191\u0011QV\u0001\u0001\u0003_C!\"!.\u000e\u0005\u000b\u0007I\u0011AA\\\u0011)\ty,\u0004B\u0001B\u0003%\u0011\u0011\u0018\u0005\u000756!\t!!1\t\u000f\u0005\u001dW\u0002\"\u0003\u0002J\")Q.\u0004C\u0001]\")!/\u0004C\u0001]\"91/\u0004C\u0001\u0013\u0006m\u0007\u0002CAq\u001b\u0011\u0005\u0011*a9\t\u0011\u0005\u001dX\u0002\"\u0001J\u0003SDq!a\u001b\u000e\t\u0003\ti\u0007C\u0004\u0002n6!\t!a<\t\u000f\t=Q\u0002\"\u0001\u0003\u0012!9!\u0011F\u0007\u0005\u0002\t-\u0002b\u0002B\u001f\u001b\u0011\u0005#q\b\u0005\b\u0005'jA\u0011\tB+\r\u0019\u0011I(\u0001\u0001\u0003|!Q!\u0011R\u000f\u0003\u0006\u0004%\tAa#\t\u0015\teUD!A!\u0002\u0013\u0011i\t\u0003\u0006\u0003\u001cv\u0011)\u0019!C\u0001\u0005;C!Ba(\u001e\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011\u0019QV\u0004\"\u0001\u0003\"\"9\u0011qY\u000f\u0005\n\u0005%\u0007\"B7\u001e\t\u0003r\u0007bB:\u001e\t\u0003J%\u0011\u0016\u0005\u0006ev!\tE\u001c\u0005\b\u0003WjB\u0011IA7\u0011\u001d\u0011y+\bC!\u0005cCqA!/\u001e\t\u0003\u0012Y\fC\u0004\u0003bv!\tEa9\t\u000f\t}X\u0004\"\u0011\u0004\u0002!91qE\u000f\u0005B\r%bABB\u0018\u0003\u0001\u0019\t\u0004\u0003\u0006\u0004:5\u0012)\u0019!C\u0001\u0005;C!ba\u000f.\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\u0019i$\fBC\u0002\u0013\u00051q\b\u0005\u000b\u0007\u0017j#\u0011!Q\u0001\n\r\u0005\u0003BCB'[\t\u0005\t\u0015!\u0003\u0004P!Q\u0011\u0011M\u0017\u0003\u0002\u0003\u0006Ia!\u0015\t\rikC\u0011AB,\u0011%\u0019\u0019'\fb\u0001\n\u0003\u0019)\u0007\u0003\u0005\u0004h5\u0002\u000b\u0011BB(\u0011%\u0019I'\fb\u0001\n\u0013\u0019Y\u0007\u0003\u0005\u0004r5\u0002\u000b\u0011BB7\u0011%\u0019\u0019(\fb\u0001\n\u0013\u0019)\b\u0003\u0005\u0004\u00026\u0002\u000b\u0011BB<\u0011%\u0019\u0019)\fb\u0001\n\u0003\u0019)\t\u0003\u0005\u0004\u000e6\u0002\u000b\u0011BBD\u0011%\u0019y)\fb\u0001\n\u0003\u0019\t\n\u0003\u0005\u0004\u001a6\u0002\u000b\u0011BBJ\u0011%\u0019Y*\fb\u0001\n\u0003\u0019i\n\u0003\u0005\u0004&6\u0002\u000b\u0011BBP\u0011-\u00199+\fa\u0001\u0002\u0004%\ta!+\t\u0017\rEV\u00061AA\u0002\u0013\u000511\u0017\u0005\f\u0007sk\u0003\u0019!A!B\u0013\u0019Y\u000bC\u0003n[\u0011\u0005c\u000eC\u0003s[\u0011\u0005c\u000eC\u0004\u0004<6\"\te!0\t\u000f\r\u0005W\u0006\"\u0011\u0004D\u0006\t2\t\\;ti\u0016\u0014H*\u001b8l\r\u0006LG.\u001a3\u000b\u0005)[\u0015\u0001\u00027j].T!\u0001T'\u0002\rM,'O^3s\u0015\u0005q\u0015!B6bM.\f7\u0001\u0001\t\u0003#\u0006i\u0011!\u0013\u0002\u0012\u00072,8\u000f^3s\u0019&t7NR1jY\u0016$7CA\u0001U!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0015\u0002\u000f\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s'\u0011\u0019AK\u00183\u0011\u0005}\u0013gBA)a\u0013\t\t\u0017*\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018B\u0001/d\u0015\t\t\u0017\n\u0005\u0002fQ6\taM\u0003\u0002h\u001b\u0006)Q\u000f^5mg&\u0011\u0011N\u001a\u0002\b\u0019><w-\u001b8h)\u0005Y\u0007C\u00017\u0004\u001b\u0005\t\u0011aB:uCJ$X\u000f\u001d\u000b\u0002_B\u0011Q\u000b]\u0005\u0003cZ\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0006sK\u000e|gNZ5hkJ,GcA8vu\")ao\u0002a\u0001o\u0006Ia.Z<D_:4\u0017n\u001a\t\u0003#bL!!_%\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\rC\u0003|\u000f\u0001\u0007A0A\u0006va\u0012\fG/\u001a3LKf\u001c\b#B?\u0002\u0002\u0005\u0015Q\"\u0001@\u000b\u0005}4\u0016AC2pY2,7\r^5p]&\u0019\u00111\u0001@\u0003\u0007M+G\u000f\u0005\u0003\u0002\b\u0005Ua\u0002BA\u0005\u0003#\u00012!a\u0003W\u001b\t\tiAC\u0002\u0002\u0010=\u000ba\u0001\u0010:p_Rt\u0014bAA\n-\u00061\u0001K]3eK\u001aLA!a\u0006\u0002\u001a\t11\u000b\u001e:j]\u001eT1!a\u0005W\u0003u\tG\r\u001a'j].,GMR3uG\",'OR8s!\u0006\u0014H/\u001b;j_:\u001cHcA8\u0002 !9\u0011\u0011\u0005\u0005A\u0002\u0005\r\u0012A\u00039beRLG/[8ogB1\u0011QEA\u0018\u0003kqA!a\n\u0002,9!\u00111BA\u0015\u0013\u00059\u0016bAA\u0017-\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0019\u0003g\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003[1\u0006\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mR*A\u0004dYV\u001cH/\u001a:\n\t\u0005}\u0012\u0011\b\u0002\n!\u0006\u0014H/\u001b;j_:\f\u0001E]3n_Z,G*\u001b8lK\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogR)q.!\u0012\u0002`!9\u0011\u0011E\u0005A\u0002\u0005\u001d\u0003#B?\u0002\u0002\u0005%\u0003\u0003BA&\u00037j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0007G>lWn\u001c8\u000b\u00079\u000b\u0019F\u0003\u0003\u0002V\u0005]\u0013AB1qC\u000eDWM\u0003\u0002\u0002Z\u0005\u0019qN]4\n\t\u0005u\u0013Q\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\t'\u0003a\u0001\u0003G\naA]3bg>t\u0007cA)\u0002f%\u0019\u0011qM%\u0003'\u0019+Go\u00195feJ+Wn\u001c<f%\u0016\f7o\u001c8\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0002\u001b\r,(O]3oi\u000e{gNZ5h+\u00059\u0018\u0001\u00069beRLG/[8o\u001b&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0005\u0002t\u0005\u001d\u00151RAO!\u0011\t)(!!\u000f\t\u0005]\u0014QP\u0007\u0003\u0003sRA!a\u001f\u0002N\u00059!/\u001a9mS\u000e\f\u0017\u0002BA@\u0003s\nQBU3qY&\u001c\u0017m\u0015;biV\u001c\u0018\u0002BAB\u0003\u000b\u0013!\"T5se>\u0014\u0018J\u001c4p\u0015\u0011\ty(!\u001f\t\u000f\u0005%E\u00021\u0001\u0002J\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAG\u0019\u0001\u0007\u0011qR\u0001\u0016a\u0016\u00148/[:uK:$X*\u001b:s_J\u001cF/\u0019;f!\u0011\t\t*a&\u000f\t\u0005U\u00141S\u0005\u0005\u0003+\u000b))\u0001\u0006NSJ\u0014xN]%oM>LA!!'\u0002\u001c\n)1\u000b^1uK*!\u0011QSAC\u0011\u001d\ty\n\u0004a\u0001\u0003C\u000bQ#\u001e8bm\u0006LG.\u00192mK2Kgn\u001b*fCN|g\u000eE\u0003V\u0003G\u000b9+C\u0002\u0002&Z\u0013aa\u00149uS>t\u0007cA)\u0002*&\u0019\u00111V%\u0003+Us\u0017M^1jY\u0006\u0014G.\u001a'j].\u0014V-Y:p]\ni1\t\\5f]Rl\u0015M\\1hKJ\u001cR!\u0004+\u00022\u0012\u00042aXAZ\u0013\r\tikY\u0001\ng\u000eDW\rZ;mKJ,\"!!/\u0011\u0007E\u000bY,C\u0002\u0002>&\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sAQ!\u00111YAc!\taW\u0002C\u0004\u00026B\u0001\r!!/\u0002\u0013\u0015D8-\u001a9uS>tGCAAf!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\fA\u0001\\1oO*\u0011\u0011Q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0006='!F%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\u001c\u000b\u0006_\u0006u\u0017q\u001c\u0005\u0006mR\u0001\ra\u001e\u0005\u0006wR\u0001\r\u0001`\u0001\nC\u0012$Gk\u001c9jGN$2a\\As\u0011\u0019\t\t/\u0006a\u0001y\u0006a!/Z7pm\u0016$v\u000e]5dgR\u0019q.a;\t\r\u0005\u001dh\u00031\u0001}\u0003Q1W\r^2i)>\u0004\u0018n\u0019)beRLG/[8ogR1\u0011\u0011\u001fB\u0004\u0005\u0017\u0001b!a=\u0002~\n\u0005QBAA{\u0015\u0011\t90!?\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002|\u0006M\u0017\u0001B;uS2LA!a@\u0002v\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0007U\u0013\u0019!C\u0002\u0003\u0006Y\u00131!\u00138u\u0011\u001d\u0011I\u0001\u0007a\u0001\u0003\u000b\tQ\u0001^8qS\u000eDqA!\u0004\u0019\u0001\u0004\u0011\t!A\u0005uS6,w.\u001e;Ng\u0006qa-\u001a;dQR{\u0007/[2J]\u001a|G\u0003\u0003B\n\u00057\u0011iBa\b\u0011\r\u0005M\u0018Q B\u000b!\r\t&qC\u0005\u0004\u00053I%\u0001F\"mkN$XM\u001d'j].$v\u000e]5d\u0013:4w\u000eC\u0004\u0003\ne\u0001\r!!\u0002\t\u000f\t5\u0011\u00041\u0001\u0003\u0002!9!\u0011E\rA\u0002\t\r\u0012aD:uCJ$xJ\u001a4tKR\u001c\u0006/Z2\u0011\u0007U\u0013)#C\u0002\u0003(Y\u0013A\u0001T8oO\u0006i!/\u001a9mS\u000e\f7\u000b^1ukN$BA!\f\u0003<A9QPa\f\u0002J\tM\u0012b\u0001B\u0019}\n\u0019Q*\u00199\u0011\r\u0005M\u0018Q B\u001b!\u0011\t9Da\u000e\n\t\te\u0012\u0011\b\u0002\u0010!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;vg\"9\u0011\u0011\u0005\u000eA\u0002\u0005\u001d\u0013a\u0004;bg.$Um]2sSB$\u0018n\u001c8\u0015\t\t\u0005#\u0011\n\t\u0006+\u0006\r&1\t\t\u0004#\n\u0015\u0013b\u0001B$\u0013\nyA+Y:l\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003Lm\u0001\rA!\u0014\u0002\u0011Q\f7o\u001b+za\u0016\u00042!\u0015B(\u0013\r\u0011\t&\u0013\u0002\t)\u0006\u001c8\u000eV=qK\u0006!\"/Z4jgR,'\u000fT1{sJ+7o\\;sG\u0016$2a\u001cB,\u0011\u001d\u0011I\u0006\ba\u0001\u00057\nA\u0002\\1{sJ+7o\\;sG\u0016\u0004DA!\u0018\u0003hA)\u0011Ka\u0018\u0003d%\u0019!\u0011M%\u0003\u00191\u000b'0\u001f*fg>,(oY3\u0011\t\t\u0015$q\r\u0007\u0001\t1\u0011IGa\u0016\u0002\u0002\u0003\u0005)\u0011\u0001B6\u0005\ryF\u0005N\t\u0005\u0005[\u0012\u0019\bE\u0002V\u0005_J1A!\u001dW\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u0016B;\u0013\r\u00119H\u0016\u0002\u0004\u0003:L(!E\"p]:,7\r^5p]6\u000bg.Y4feN1Q\u0004\u0016B?\u0005\u0007\u00032a\u0018B@\u0013\r\u0011\ti\u0019\u0002\u0019\u0013:\u0014w.\u001e8e\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014\bcA0\u0003\u0006&\u0019!qQ2\u00033=+HOY8v]\u0012\u001cuN\u001c8fGRLwN\\'b]\u0006<WM]\u0001\tY&t7\u000eR1uCV\u0011!Q\u0012\t\u0005\u0005\u001f\u0013)*\u0004\u0002\u0003\u0012*\u0019!1S'\u0002\u0005i\\\u0017\u0002\u0002BL\u0005#\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0001\nY&t7\u000eR1uC\u0002\n1\u0003\\8dC2dunZ5dC2\u001cE.^:uKJ,\"!!\u0002\u0002)1|7-\u00197M_\u001eL7-\u00197DYV\u001cH/\u001a:!)\u0019\u0011\u0019K!*\u0003(B\u0011A.\b\u0005\b\u0005\u0013\u0013\u0003\u0019\u0001BG\u0011\u001d\u0011YJ\ta\u0001\u0003\u000b!Ra\u001cBV\u0005[CQA^\u0013A\u0002]DQa_\u0013A\u0002q\fA\u0002\\5oW\u000ecWo\u001d;feN,\"Aa-\u0011\u000bu\u0014),!\u0002\n\u0007\t]fPA\u0002TKF\f\u0011#\u001a8bE2,7\t\\;ti\u0016\u0014H*\u001b8l)\u0015y'Q\u0018Bd\u0011\u001d\u0011y,\u000ba\u0001\u0005\u0003\fQB\\3uo>\u00148n\u00117jK:$\bcA)\u0003D&\u0019!QY%\u00031\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG\u000fC\u0004\u0003J&\u0002\rAa3\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004R!VAR\u0005\u001b\u0004BAa4\u0003^6\u0011!\u0011\u001b\u0006\u0005\u0005'\u0014).A\u0005j]R,'O\\1mg*!!q\u001bBm\u0003\u0015\tG-\\5o\u0015\u0011\u0011Y.!\u0015\u0002\u000f\rd\u0017.\u001a8ug&!!q\u001cBi\u0005Q\tE-\\5o\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006A\u0002O]8dKN\u001c(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000b=\u0014)O!>\t\u000f\t\u001d(\u00061\u0001\u0003j\u000691\r[1o]\u0016d\u0007\u0003\u0002Bv\u0005cl!A!<\u000b\t\t=\u0018QJ\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0011\u0019P!<\u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\t\u000f\t](\u00061\u0001\u0003z\u0006Y!/\u001a<feN,gj\u001c3f!\u0011\u0011YOa?\n\t\tu(Q\u001e\u0002\f%\u00164XM]:f\u001d>$W-\u0001\u000ej]&$\u0018.\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000f\u0006\u0004\u0004\u0004\r51Q\u0004\t\u0006{\nU6Q\u0001\t\u0007\u0003g\fipa\u0002\u0011\t\u000557\u0011B\u0005\u0005\u0007\u0017\tyM\u0001\u0003W_&$\u0007bBB\bW\u0001\u00071\u0011C\u0001\u001aS:LG/[1uK\u000e{gN\\3di&|gNU3rk\u0016\u001cH\u000f\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\u0011\u00199\"!\u0014\u0002\u0011I,\u0017/^3tiNLAaa\u0007\u0004\u0016\t\t\u0013J\\5uS\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogJ+\u0017/^3ti\"91qD\u0016A\u0002\r\u0005\u0012A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007'\u0019\u0019#\u0003\u0003\u0004&\rU!A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010^\u0001\u0014_:\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0006_\u000e-2Q\u0006\u0005\b\u0005Od\u0003\u0019\u0001Bu\u0011\u001d\u00119\u0010\fa\u0001\u0005s\u0014\u0001DR1jY\u0016$7\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t'\u0011iCka\r\u0011\u0007}\u001b)$C\u0002\u00048\r\u00141\u0002T5oW6+GO]5dg\u0006AA.\u001b8l\u001d\u0006lW-A\u0005mS:\\g*Y7fA\u00059Q.\u001a;sS\u000e\u001cXCAB!!\u0011\u0019\u0019ea\u0012\u000e\u0005\r\u0015#\u0002BB\u001f\u0003\u001bJAa!\u0013\u0004F\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0019Q,g.\u00198u!J,g-\u001b=\u0011\u000bU\u000b\u0019+!\u0002\u0011\u0007E\u001b\u0019&C\u0002\u0004V%\u0013\u0001CR1jY\u0016$G*\u001b8l%\u0016\f7o\u001c8\u0015\u0015\re31LB/\u0007?\u001a\t\u0007\u0005\u0002m[!91\u0011\b\u001bA\u0002\u0005\u0015\u0001bBB\u001fi\u0001\u00071\u0011\t\u0005\b\u0007\u001b\"\u0004\u0019AB(\u0011\u001d\t\t\u0007\u000ea\u0001\u0007#\na\u0001^3oC:$XCAB(\u0003\u001d!XM\\1oi\u0002\n!#\u001e8qe\u00164\u0017\u000e_3e\u0019&t7NT1nKV\u00111Q\u000e\t\u0005\u0003\u001b\u001cy'\u0003\u0003\u0002\u0018\u0005=\u0017aE;oaJ,g-\u001b=fI2Kgn\u001b(b[\u0016\u0004\u0013\u0001\u0002;bON,\"aa\u001e\u0011\u0011\re4qPB7\u0003\u000bi!aa\u001f\u000b\u0007\rud0A\u0005j[6,H/\u00192mK&!!\u0011GB>\u0003\u0015!\u0018mZ:!\u0003e1\u0017-\u001b7fI2Kgn[\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\r\u001d\u0005\u0003BA&\u0007\u0013KAaa#\u0002N\tQQ*\u001a;sS\u000et\u0015-\\3\u00025\u0019\f\u0017\u000e\\3e\u0019&t7nQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u000f\u0019\f7\r^8ssV\u001111\u0013\t\u0004#\u000eU\u0015bABL\u0013\nA2\t\\;ti\u0016\u0014H*\u001b8l'\u0016t7o\u001c:GC\u000e$xN]=\u0002\u0011\u0019\f7\r^8ss\u0002\n!\u0003^1tWN+gn]8sg6\u000bg.Y4feV\u00111q\u0014\t\u0004#\u000e\u0005\u0016bABR\u0013\n\u0011B+Y:l'\u0016t7o\u001c:t\u001b\u0006t\u0017mZ3s\u0003M!\u0018m]6TK:\u001cxN]:NC:\fw-\u001a:!\u0003ya\u0017N\\6GC&dWO]3SKR\u0014\u00180\u0011;uK6\u0004Ho]*f]N|'/\u0006\u0002\u0004,B!11IBW\u0013\u0011\u0019yk!\u0012\u0003\rM+gn]8s\u0003\tb\u0017N\\6GC&dWO]3SKR\u0014\u00180\u0011;uK6\u0004Ho]*f]N|'o\u0018\u0013fcR\u0019qn!.\t\u0013\r]&)!AA\u0002\r-\u0016a\u0001=%c\u0005yB.\u001b8l\r\u0006LG.\u001e:f%\u0016$(/_!ui\u0016l\u0007\u000f^:TK:\u001cxN\u001d\u0011\u00027\rdWo\u001d;fe2Kgn\u001b+bg.\f5\r^5wKN+gn]8s)\u0011\u0019Yka0\t\u000f\t-c\t1\u0001\u0003N\u0005a2\r\\;ti\u0016\u0014H*\u001b8l)\u0006\u001c8.\u00138FeJ|'oU3og>\u0014HCBBV\u0007\u000b\u001c9\rC\u0004\u0003L\u001d\u0003\rA!\u0014\t\u000f\r%w\t1\u0001\u0004L\u0006IQM\u001d:pe\u000e{G-\u001a\t\u0004#\u000e5\u0017bABh\u0013\niA+Y:l\u000bJ\u0014xN]\"pI\u0016\u0004")
public final class ClusterLinkFailed {

    public static class ClientManager
    implements ClusterLinkFactory.ClientManager,
    Logging {
        private final ClusterLinkScheduler scheduler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ClientManager.onAvailabilityChange$(this, isAvailable);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public ClusterLinkScheduler scheduler() {
            return this.scheduler;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting up failed client manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down failed client manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        public void addTopics(Set<String> addTopics) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Adding topics ").append(addTopics).append(" for failed client manager").toString());
        }

        public void removeTopics(Set<String> removeTopics) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Removing topics ").append(removeTopics).append(" for failed client manager").toString());
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs, long startOffsetSpec) {
            throw new InvalidClusterLinkException("Cluster link is in failed state.");
        }

        public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public Option<TaskDescription> taskDescription(TaskType taskType) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void registerLazyResource(LazyResource<?> lazyResource) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        public ClientManager(ClusterLinkScheduler scheduler) {
            this.scheduler = scheduler;
        }
    }

    public static class ConnectionManager
    implements ClusterLinkFactory.InboundConnectionManager,
    ClusterLinkFactory.OutboundConnectionManager {
        private final ClusterLinkData linkData;
        private final String localLogicalCluster;

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ConnectionManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public boolean active() {
            return ClusterLinkFactory.ConnectionManager.active$(this);
        }

        @Override
        public void onControllerChange(boolean isActive) {
            ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
        }

        @Override
        public void onLinkMetadataPartitionLeaderChange() {
            ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
        }

        @Override
        public int persistentConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
        }

        @Override
        public int reverseConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.ConnectionManager.lazyResources$(this);
        }

        @Override
        public boolean isLinkCoordinator() {
            return ClusterLinkFactory.ConnectionManager.isLinkCoordinator$(this);
        }

        @Override
        public Option<Object> linkCoordinatorId() {
            return ClusterLinkFactory.ConnectionManager.linkCoordinatorId$(this);
        }

        @Override
        public ClusterLinkData linkData() {
            return this.linkData;
        }

        @Override
        public String localLogicalCluster() {
            return this.localLogicalCluster;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public Seq<String> linkClusters() {
            return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus(this.linkData().clusterId());
        }

        @Override
        public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void processReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection is no longer required");
        }

        @Override
        public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
            throw new NetworkException("Cluster link has failed, connection cannot be created");
        }

        public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection not required any more");
        }

        public ConnectionManager(ClusterLinkData linkData, String localLogicalCluster) {
            this.linkData = linkData;
            this.localLogicalCluster = localLogicalCluster;
        }
    }

    public static class FailedClusterLinkMetrics
    implements ClusterLinkFactory.LinkMetrics {
        private final String linkName;
        private final Metrics metrics;
        private final Option<String> tenant;
        private final String unprefixedLinkName;
        private final scala.collection.immutable.Map<String, String> tags;
        private final MetricName failedLinkCountMetricName;
        private final ClusterLinkSensorFactory factory;
        private final TaskSensorsManager taskSensorsManager;
        private Sensor linkFailureRetryAttemptsSensor;

        public String linkName() {
            return this.linkName;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Option<String> tenant() {
            return this.tenant;
        }

        private String unprefixedLinkName() {
            return this.unprefixedLinkName;
        }

        private scala.collection.immutable.Map<String, String> tags() {
            return this.tags;
        }

        public MetricName failedLinkCountMetricName() {
            return this.failedLinkCountMetricName;
        }

        public ClusterLinkSensorFactory factory() {
            return this.factory;
        }

        public TaskSensorsManager taskSensorsManager() {
            return this.taskSensorsManager;
        }

        public Sensor linkFailureRetryAttemptsSensor() {
            return this.linkFailureRetryAttemptsSensor;
        }

        public void linkFailureRetryAttemptsSensor_$eq(Sensor x$1) {
            this.linkFailureRetryAttemptsSensor = x$1;
        }

        @Override
        public void startup() {
            this.metrics().addMetric(this.failedLinkCountMetricName(), (x$2, x$3) -> 1.0);
            this.linkFailureRetryAttemptsSensor_$eq(this.factory().createSensorForTotalAndRateMetrics((Option<String>)new Some((Object)this.linkName()), (Option<Sensor>)None$.MODULE$, "link-failure-retry-attempts", "link failure retry attempts", this.factory().createSensorForTotalAndRateMetrics$default$5()));
            this.taskSensorsManager().createFailedLinkTasksSensors(this.factory());
        }

        @Override
        public void shutdown() {
            this.metrics().removeMetric(this.failedLinkCountMetricName());
            this.taskSensorsManager().removeSensors();
        }

        @Override
        public Sensor clusterLinkTaskActiveSensor(TaskType taskType) {
            return this.taskSensorsManager().activeSensor(taskType);
        }

        @Override
        public Sensor clusterLinkTaskInErrorSensor(TaskType taskType, TaskErrorCode errorCode) {
            return this.taskSensorsManager().inErrorSensor(taskType, errorCode);
        }

        public FailedClusterLinkMetrics(String linkName, Metrics metrics, Option<String> tenantPrefix2, FailedLinkReason reason) {
            this.linkName = linkName;
            this.metrics = metrics;
            this.tenant = tenantPrefix2.map((Function1 & Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix));
            this.unprefixedLinkName = (String)this.tenant().map((Function1 & Serializable)t -> this.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> this.linkName());
            this.tags = ((IterableOnceOps)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason.name())), (List)new .colon.colon((Object)this.tenant().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.failedLinkCountMetricName = new MetricName("broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), "Number of failed cluster links at the broker.", CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
            this.factory = new ClusterLinkSensorFactory(metrics, this.tags());
            this.taskSensorsManager = new TaskSensorsManager(linkName, this.tags(), metrics);
        }
    }

    public static class FetcherManager
    implements ClusterLinkFactory.FetcherManager,
    Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public boolean isEmpty() {
            return ClusterLinkFactory.FetcherManager.isEmpty$(this);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.FetcherManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public void maybeNotifyReadyForFetch(Partition partition) {
            ClusterLinkFactory.FetcherManager.maybeNotifyReadyForFetch$(this, partition);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.FetcherManager.lazyResources$(this);
        }

        @Override
        public int fetcherCount() {
            return ClusterLinkFactory.FetcherManager.fetcherCount$(this);
        }

        @Override
        public int throttledPartitionCount() {
            return ClusterLinkFactory.FetcherManager.throttledPartitionCount$(this);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting up failed fetcher manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down failed fetcher manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void addLinkedFetcherForPartitions(Iterable<Partition> partitions) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Adding linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void removeLinkedFetcherForPartitions(Set<TopicPartition> partitions, FetcherRemoveReason reason) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Removing linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void shutdownIdleFetcherThreads() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down idle fetcher threads for failed fetcher manager");
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public ReplicaStatus.MirrorInfo partitionMirrorState(TopicPartition topicPartition, ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason) {
            return new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.LINK_FAILED, -1L, -1L);
        }
    }
}

