/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierOffsetInfo;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkAsyncSender;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tuq!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002*\u0002\t\u0003\u0019\u0006bBA}\u0003\u0011\u0005\u00111 \u0004\u0005U\u0005\u0002Q\u000b\u0003\u0005[\r\t\u0005\t\u0015!\u0003\\\u0011!1gA!A!\u0002\u00139\u0007\u0002\u00036\u0007\u0005\u0003\u0005\u000b\u0011B6\t\u001394!Q1A\u0005B\rz\u0007\u0002C>\u0007\u0005\u0003\u0005\u000b\u0011\u00029\t\u0013q4!Q1A\u0005B\rj\b\"CA\u0002\r\t\u0005\t\u0015!\u0003\u007f\u0011)\t)A\u0002B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001b1!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\r\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0004\u0004\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015bA!A!\u0002\u0013\t9\u0003\u0003\u0005C\r\t\u0005\t\u0015!\u0003D\u0011\u0019\u0011d\u0001\"\u0001\u0002.!9\u0011Q\t\u0004\u0005\u0002\u0005\u001d\u0003bBA)\r\u0011\u0005\u0011\u0011\f\u0005\b\u000372A\u0011AA/\u0011\u001d\t\tG\u0002C\u0001\u0003SBq!a\u001b\u0007\t\u0003\ti\u0007C\u0005\u0002t\u0019\u0011\r\u0011\"\u0011\u0002v!9\u0011q\u000f\u0004!\u0002\u00131\u0004bBA=\r\u0011\u0005\u00131\u0010\u0005\b\u0003/3A\u0011IAM\u0011\u001d\tyJ\u0002C!\u0003CCq!a)\u0007\t\u0003\t)+A\rDYV\u001cH/\u001a:MS:\\G*Z1eKJ,e\u000e\u001a)pS:$(B\u0001\u0012$\u0003\u0011a\u0017N\\6\u000b\u0005\u0011*\u0013AB:feZ,'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!K\u0001\u000e\u0003\u0005\u0012\u0011d\u00117vgR,'\u000fT5oW2+\u0017\rZ3s\u000b:$\u0007k\\5oiN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013aG5t%\u0016\fG-\u001f$pe\u001a+Go\u00195G_J\u0004\u0016M\u001d;ji&|g\u000eF\u00037s\u00053\u0005\u000b\u0005\u0002.o%\u0011\u0001H\f\u0002\b\u0005>|G.Z1o\u0011\u0015Q4\u00011\u0001<\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?K\u000591\r\\;ti\u0016\u0014\u0018B\u0001!>\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003C\u0007\u0001\u00071)\u0001\ndYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\bCA\u0015E\u0013\t)\u0015E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\b\"B$\u0004\u0001\u0004A\u0015A\u00067j].4U\r^2iKJ4En\\<D_:$(o\u001c7\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001\u00027b]\u001eT\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n9\u0011J\u001c;fO\u0016\u0014\b\"B)\u0004\u0001\u00041\u0014aD;qI\u0006$X\rT1h'\u0016t7o\u001c:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015'Q\u000b\t.!9\u0002l\u00065\u0018q^Ay\u0003g\f)0a>\u0011\u0005%21C\u0001\u0004W!\t9\u0006,D\u0001$\u0013\tI6E\u0001\u000bSK6|G/\u001a'fC\u0012,'/\u00128e!>Lg\u000e^\u0001\nY><\u0007K]3gSb\u0004\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010/\u001b\u0005y&B\u00011(\u0003\u0019a$o\\8u}%\u0011!ML\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c]\u0005q!\r\\8dW&twmU3oI\u0016\u0014\bCA,i\u0013\tI7E\u0001\u0007CY>\u001c7.\u001b8h'\u0016tG-A\tdYV\u001cH/\u001a:MS:\\7\t\\5f]R\u0004\"!\u000b7\n\u00055\f#\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\u0006\u0019b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7feV\t\u0001\u000f\u0005\u0002rs6\t!O\u0003\u0002ti\u000691\r\\5f]R\u001c(B\u0001\u0014v\u0015\t1x/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0006\u0019qN]4\n\u0005i\u0014(a\u0005$fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001\u00064fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014\b%\u0001\bsKF,Xm\u001d;Ck&dG-\u001a:\u0016\u0003y\u0004\"!K@\n\u0007\u0005\u0005\u0011EA\u0010DYV\u001cH/\u001a:MS:\\G*Z1eKJ\u0014V-];fgR\u0014U/\u001b7eKJ\fqB]3rk\u0016\u001cHOQ;jY\u0012,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ\u00042aVA\u0005\u0013\r\tYa\t\u0002\u0012\r>dGn\\<feRC'o\u001c;uY\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007cA,\u0002\u0012%\u0019\u00111C\u0012\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007cA\u0015\u0002\u001a%\u0019\u00111D\u0011\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007]\u000b\t#C\u0002\u0002$\r\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\rE\u0002X\u0003SI1!a\u000b$\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b)]!\u0016qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003\n\u0019\u0005C\u0003[)\u0001\u00071\fC\u0003g)\u0001\u0007q\rC\u0003k)\u0001\u00071\u000eC\u0003o)\u0001\u0007\u0001\u000fC\u0003})\u0001\u0007a\u0010C\u0004\u0002\u0006Q\u0001\r!a\u0002\t\u000f\u00055A\u00031\u0001\u0002\u0010!9\u0011Q\u0003\u000bA\u0002\u0005]\u0001bBA\u000f)\u0001\u0007\u0011q\u0004\u0005\b\u0003K!\u0002\u0019AA\u0014\u0011\u0015\u0011E\u00031\u0001D\u0003])\b\u000fZ1uK\u001a+Go\u00195SKN\u0004xN\\:f'&TX\r\u0006\u0003\u0002J\u0005=\u0003cA\u0017\u0002L%\u0019\u0011Q\n\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#*\u0002\u0019AA*\u0003E1W\r^2i%\u0016\u001c\bo\u001c8tKNK'0\u001a\t\u0004[\u0005U\u0013bAA,]\t\u0019\u0011J\u001c;\u0015\u0003!\u000bQ#\u001e9eCR,G*Y:u\r\u0016$8\r\u001b+j[\u0016l5\u000f\u0006\u0003\u0002J\u0005}\u0003bBA1/\u0001\u0007\u00111M\u0001\u0010Y\u0006\u001cHOR3uG\"$\u0016.\\3NgB\u0019Q&!\u001a\n\u0007\u0005\u001ddF\u0001\u0003M_:<GCAA2\u00031\u0019X\r\u001e$fi\u000eD7+\u001b>f)\u0011\tI%a\u001c\t\u000f\u0005E\u0014\u00041\u0001\u0002T\u0005qa-\u001a;dQNK'0\u001a\"zi\u0016\u001c\u0018\u0001H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\rZ\u000b\u0002m\u0005i\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$\u0007%\u0001\u0010gKR\u001c\u0007\u000eV5fe6\u000bG/\u001a:jC2L'0\u0019;j_:$\u0016M]4fiR1\u0011QPAB\u0003'\u00032aVA@\u0013\r\t\ti\t\u0002\u000f)&,'o\u00144gg\u0016$\u0018J\u001c4p\u0011\u001d\t)\t\ba\u0001\u0003\u000f\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\n\u0006=UBAAF\u0015\r\ti\t^\u0001\u0007G>lWn\u001c8\n\t\u0005E\u00151\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)\n\ba\u0001\u0003'\n1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006y\u0011n\u001d*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000eF\u00027\u00037Cq!!(\u001e\u0001\u0004\t9)\u0001\u0002ua\u0006)1\r\\8tKR\u0011\u0011\u0011J\u0001\u0013M\u0016$8\r\u001b+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0002(\u00065\u0007\u0003BAU\u0003\u000ftA!a+\u0002B:!\u0011QVA_\u001d\u0011\ty+a/\u000f\t\u0005E\u0016\u0011\u0018\b\u0005\u0003g\u000b9LD\u0002_\u0003kK\u0011\u0001_\u0005\u0003m^L!AJ;\n\u0007\u00055E/\u0003\u0003\u0002@\u0006-\u0015aB7fgN\fw-Z\u0005\u0005\u0003\u0007\f)-\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003\u007f\u000bY)\u0003\u0003\u0002J\u0006-'!F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f)>\u0004\u0018n\u0019\u0006\u0005\u0003\u0007\f)\r\u0003\u0004\u0002P~\u0001\raW\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003'$\u0001\u0019AAk\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*!\u00111\\AF\u0003\u0015)H/\u001b7t\u0013\u0011\ty.!7\u0003\u00151{wmQ8oi\u0016DH\u000fC\u0004\u0002d\u0012\u0001\r!!:\u0002\tQLW.\u001a\t\u0005\u0003/\f9/\u0003\u0003\u0002j\u0006e'\u0001\u0002+j[\u0016DQA\u001a\u0003A\u0002\u001dDQA\u001b\u0003A\u0002-Dq!!\u0004\u0005\u0001\u0004\ty\u0001C\u0004\u0002\u0016\u0011\u0001\r!a\u0006\t\u000f\u0005uA\u00011\u0001\u0002 !9\u0011Q\u0005\u0003A\u0002\u0005\u001d\u0002\"\u0002\"\u0005\u0001\u0004\u0019\u0015!G2sK\u0006$X-Q:z]\u000edU-\u00193fe\u0016sG\r]8j]R$B#!@\u0003\u0004\t\u0015!q\u0001B\t\u0005'\u0011)Ba\u0006\u0003\u001a\tm\u0001cA\u0015\u0002\u0000&\u0019!\u0011A\u0011\u0003=\rcWo\u001d;fe2Kgn[!ts:\u001cG*Z1eKJ,e\u000e\u001a)pS:$\bbBAj\u000b\u0001\u0007\u0011Q\u001b\u0005\b\u0003G,\u0001\u0019AAs\u0011\u001d\u0011I!\u0002a\u0001\u0005\u0017\t1\"Y:z]\u000e\u001cVM\u001c3feB\u0019\u0011F!\u0004\n\u0007\t=\u0011E\u0001\fDYV\u001cH/\u001a:MS:\\\u0017i]=oGN+g\u000eZ3s\u0011\u0015QW\u00011\u0001l\u0011\u001d\ti!\u0002a\u0001\u0003\u001fAq!!\u0006\u0006\u0001\u0004\t9\u0002C\u0004\u0002\u001e\u0015\u0001\r!a\b\t\u000f\u0005\u0015R\u00011\u0001\u0002(!)!)\u0002a\u0001\u0007\u0002")
public class ClusterLinkLeaderEndPoint
extends RemoteLeaderEndPoint {
    private final BlockingSend blockingSender;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final FetchSessionHandler fetchSessionHandler;
    private final ClusterLinkLeaderRequestBuilder requestBuilder;
    private final ClusterLinkConfig clusterLinkConfig;
    private final ReplicaManager replicaManager;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final boolean isTruncationOnFetchSupported;

    public static ClusterLinkAsyncLeaderEndPoint createAsyncLeaderEndpoint(LogContext logContext, Time time, ClusterLinkAsyncSender asyncSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        return ClusterLinkLeaderEndPoint$.MODULE$.createAsyncLeaderEndpoint(logContext, time, asyncSender, clusterLinkClient, brokerConfig, clusterLinkConfig, replicaManager, quota, clusterLinkMetrics);
    }

    public static ClusterLinkLeaderEndPoint apply(LogContext logContext, Time time, BlockingSend blockingSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        return ClusterLinkLeaderEndPoint$.MODULE$.apply(logContext, time, blockingSender, clusterLinkClient, brokerConfig, clusterLinkConfig, replicaManager, quota, clusterLinkMetrics);
    }

    public static boolean isReadyForFetchForPartition(Partition partition, ClusterLinkMetrics clusterLinkMetrics, Integer linkFetcherFlowControl, boolean updateLagSensor) {
        return ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, clusterLinkMetrics, linkFetcherFlowControl, updateLagSensor);
    }

    @Override
    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public ClusterLinkLeaderRequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public void updateFetchResponseSize(int fetchResponseSize) {
        this.requestBuilder().fetchResponseSize_$eq(Predef$.MODULE$.int2Integer(fetchResponseSize));
    }

    public Integer fetchResponseSize() {
        return this.requestBuilder().fetchResponseSize();
    }

    public void updateLastFetchTimeMs(long lastFetchTimeMs) {
        this.requestBuilder().lastFetchTimeMs_$eq(lastFetchTimeMs);
    }

    public long lastFetchTimeMs() {
        return this.requestBuilder().lastFetchTimeMs();
    }

    public void setFetchSize(int fetchSizeBytes) {
        this.fetchSize_$eq(Predef$.MODULE$.int2Integer(fetchSizeBytes));
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Cluster link leader endpoint does not support tiered partitions");
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return this.replicaManager.onlinePartition(tp).exists((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.clusterLinkConfig.linkFetcherFlowControl(), true)));
    }

    @Override
    public void close() {
        super.close();
        this.clusterLinkClient.removeMetrics();
    }

    public MetadataResponseData.MetadataResponseTopic fetchTopicMetadata(String topic) {
        MetadataRequest.Builder metadataRequest = this.requestBuilder().buildMetadataRequest(topic);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Sending metadata request for topic ").append(topic).append(": ").append(metadataRequest).toString());
        ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)metadataRequest);
        MetadataResponse responseBody = (MetadataResponse)response.responseBody();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Received metadata response ").append(response).toString());
        return responseBody.data().topics().find(topic);
    }

    public ClusterLinkLeaderEndPoint(String logPrefix, BlockingSend blockingSender, ClusterLinkNetworkClient clusterLinkClient, FetchSessionHandler fetchSessionHandler, ClusterLinkLeaderRequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        this.blockingSender = blockingSender;
        this.clusterLinkClient = clusterLinkClient;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.clusterLinkConfig = clusterLinkConfig;
        this.replicaManager = replicaManager;
        this.clusterLinkMetrics = clusterLinkMetrics;
        Serializable x$9 = new Serializable(brokerConfig){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        };
        super(logPrefix, blockingSender, fetchSessionHandler, requestBuilder, throttler, brokerConfig, replicaManager, quota, (Function0<MetadataVersion>)x$9);
        this.isTruncationOnFetchSupported = false;
    }
}

