/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.Partition;
import kafka.server.link.ClusterLinkFetcher;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.EpochUpdateState;
import kafka.server.link.FetchState;
import kafka.server.link.FetcherAssignmentState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$NoSourceRecords$;
import kafka.server.link.UnavailableLinkReason;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tea!\u0002\u0012$\u0001\rJ\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\t\u0011e\u0002!\u0011!Q\u0001\nMB\u0001B\u000f\u0001\u0003\u0002\u0004%\ta\u000f\u0005\t\u0001\u0002\u0011\t\u0019!C\u0001\u0003\"Aq\t\u0001B\u0001B\u0003&A\b\u0003\u0005M\u0001\t\u0005\r\u0011\"\u0001N\u0011!\t\u0006A!a\u0001\n\u0003\u0011\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0015\u0002(\t\u000bY\u0003A\u0011A,\t\u000fq\u0003\u0001\u0019!C\u0001;\"9q\u000f\u0001a\u0001\n\u0003A\bB\u0002>\u0001A\u0003&a\fC\u0004|\u0001\t\u0007I\u0011\u0001?\t\u000f\u0005M\u0001\u0001)A\u0005{\"I\u0011Q\u0003\u0001A\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003K\u0001\u0001\u0019!C\u0001\u0003OA\u0001\"a\u000b\u0001A\u0003&\u0011\u0011\u0004\u0005\n\u0003_\u0001\u0001\u0019!C\u0001\u0003/A\u0011\"!\r\u0001\u0001\u0004%\t!a\r\t\u0011\u0005]\u0002\u0001)Q\u0005\u00033A\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u007fA\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0014\t\u0013\u0005e\u0003\u00011A\u0005\u0002\u0005m\u0003\u0002CA0\u0001\u0001\u0006K!!\u0015\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!.\u0001\t\u0003\t9\fC\u0004\u0002>\u0002!I!a0\t\u000f\u0005m\b\u0001\"\u0001\u0002~\n\t\u0002+\u0019:uSRLwN\\!oIN#\u0018\r^3\u000b\u0005\u0011*\u0013\u0001\u00027j].T!AJ\u0014\u0002\rM,'O^3s\u0015\u0005A\u0013!B6bM.\f7C\u0001\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fM\u0006I\u0001/\u0019:uSRLwN\\\u0002\u0001+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c(\u0003\u001d\u0019G.^:uKJL!\u0001O\u001b\u0003\u0013A\u000b'\u000f^5uS>t\u0017A\u00039beRLG/[8oA\u0005!B.Y:u\u000bB|7\r[+qI\u0006$Xm\u0015;bi\u0016,\u0012\u0001\u0010\t\u0003{yj\u0011aI\u0005\u0003\u007f\r\u0012\u0001#\u00129pG\",\u0006\u000fZ1uKN#\u0018\r^3\u000211\f7\u000f^#q_\u000eDW\u000b\u001d3bi\u0016\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002C\u000bB\u00111fQ\u0005\u0003\t2\u0012A!\u00168ji\"9a\tBA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005)B.Y:u\u000bB|7\r[+qI\u0006$Xm\u0015;bi\u0016\u0004\u0003FA\u0003J!\tY#*\u0003\u0002LY\tAao\u001c7bi&dW-\u0001\fgKR\u001c\u0007.\u001a:BgNLwM\\7f]R\u001cF/\u0019;f+\u0005q\u0005CA\u001fP\u0013\t\u00016E\u0001\fGKR\u001c\u0007.\u001a:BgNLwM\\7f]R\u001cF/\u0019;f\u0003i1W\r^2iKJ\f5o]5h]6,g\u000e^*uCR,w\fJ3r)\t\u00115\u000bC\u0004G\u000f\u0005\u0005\t\u0019\u0001(\u0002/\u0019,Go\u00195fe\u0006\u001b8/[4o[\u0016tGo\u0015;bi\u0016\u0004\u0003F\u0001\u0005J\u0003\u0019a\u0014N\\5u}Q!\u0001,\u0017.\\!\ti\u0004\u0001C\u00031\u0013\u0001\u00071\u0007C\u0003;\u0013\u0001\u0007A\bC\u0003M\u0013\u0001\u0007a*\u0001\u000bt_V\u00148-\u001a'fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0002=B\u0011q\f\u001e\b\u0003AFt!!\u00198\u000f\u0005\tdgBA2j\u001d\t!w-D\u0001f\u0015\t1\u0017'\u0001\u0004=e>|GOP\u0005\u0002Q\u0006\u0019qN]4\n\u0005)\\\u0017AB1qC\u000eDWMC\u0001i\u0013\tASN\u0003\u0002kW&\u0011q\u000e]\u0001\bG2LWM\u001c;t\u0015\tAS.\u0003\u0002sg\u0006AQ*\u001a;bI\u0006$\u0018M\u0003\u0002pa&\u0011QO\u001e\u0002\u000f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2i\u0015\t\u00118/\u0001\rt_V\u00148-\u001a'fC\u0012,'/\u00118e\u000bB|7\r[0%KF$\"AQ=\t\u000f\u0019[\u0011\u0011!a\u0001=\u0006)2o\\;sG\u0016dU-\u00193fe\u0006sG-\u00129pG\"\u0004\u0013A\u00044bS2,(/Z*uCJ$Xj]\u000b\u0002{B\u0019a0a\u0004\u000e\u0003}TA!!\u0001\u0002\u0004\u00051\u0011\r^8nS\u000eTA!!\u0002\u0002\b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005%\u00111B\u0001\u0005kRLGN\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\r\t\tb \u0002\u000b\u0003R|W.[2M_:<\u0017a\u00044bS2,(/Z*uCJ$Xj\u001d\u0011\u0002\u001f1\f7\u000f\u001e$bS2,(/\u001a+za\u0016,\"!!\u0007\u0011\u000b-\nY\"a\b\n\u0007\u0005uAF\u0001\u0004PaRLwN\u001c\t\u0004{\u0005\u0005\u0012bAA\u0012G\t\tR*\u001b:s_J4\u0015-\u001b7ve\u0016$\u0016\u0010]3\u0002'1\f7\u000f\u001e$bS2,(/\u001a+za\u0016|F%Z9\u0015\u0007\t\u000bI\u0003\u0003\u0005G!\u0005\u0005\t\u0019AA\r\u0003Aa\u0017m\u001d;GC&dWO]3UsB,\u0007\u0005\u000b\u0002\u0012\u0013\u0006q\u0011\r]5GC&dWO]3UsB,\u0017AE1qS\u001a\u000b\u0017\u000e\\;sKRK\b/Z0%KF$2AQA\u001b\u0011!15#!AA\u0002\u0005e\u0011aD1qS\u001a\u000b\u0017\u000e\\;sKRK\b/\u001a\u0011)\u0005QI\u0015aC0gKR\u001c\u0007n\u0015;bi\u0016,\"!a\u0010\u0011\u000by\f\t%!\u0012\n\u0007\u0005\rsPA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\ri\u0014qI\u0005\u0004\u0003\u0013\u001a#A\u0003$fi\u000eD7\u000b^1uK\u0006aqLZ3uG\"\u001cF/\u0019;fA\u00059a-\u001a;dQ\u0016\u0014XCAA)!\u0015Y\u00131DA*!\ri\u0014QK\u0005\u0004\u0003/\u001a#AE\"mkN$XM\u001d'j].4U\r^2iKJ\f1BZ3uG\",'o\u0018\u0013fcR\u0019!)!\u0018\t\u0011\u0019C\u0012\u0011!a\u0001\u0003#\n\u0001BZ3uG\",'\u000f\t\u0015\u00033%\u000b\u0001#\u001e9eCR,W\t]8dQN#\u0018\r^3\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004W\u0005%\u0014bAA6Y\t9!i\\8mK\u0006t\u0007BBA85\u0001\u0007a,\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0002\u0015\u0019,Go\u00195Ti\u0006$X-\u0006\u0002\u0002vA)1&a\u0007\u0002F\u0005\u0001R\u000f\u001d3bi\u00164U\r^2i'R\fG/\u001a\u000b\u0006\u0005\u0006m\u0014Q\u0011\u0005\b\u0003{b\u0002\u0019AA@\u000391W\r^2iKJl\u0015M\\1hKJ\u00042!PAA\u0013\r\t\u0019i\t\u0002\u001a\u00072,8\u000f^3s\u0019&t7NR3uG\",'/T1oC\u001e,'\u000fC\u0004\u0002\br\u0001\r!!#\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007cB\u0016\u0002\f\u0006U\u0014QO\u0005\u0004\u0003\u001bc#!\u0003$v]\u000e$\u0018n\u001c82\u00035yg\u000eT5oW\u001a\u000b\u0017\u000e\\;sKRA\u00111SAP\u0003G\u000b9\u000bE\u0004,\u0003+\u000bI*a\u001a\n\u0007\u0005]EF\u0001\u0004UkBdWM\r\t\u0004W\u0005m\u0015bAAOY\t!Aj\u001c8h\u0011\u001d\t\t+\ba\u0001\u0003?\t1BZ1jYV\u0014X\rV=qK\"9\u0011QU\u000fA\u0002\u0005e\u0015a\u00018po\"9\u0011\u0011V\u000fA\u0002\u0005-\u0016A\u0004:fiJLH+[7f_V$Xj\u001d\t\u0004W\u00055\u0016bAAXY\t\u0019\u0011J\u001c;\u0002#I,7/\u001a;Fa>\u001c\u0007.\u00169eCR,7\u000fF\u0001C\u0003A\u0019G.Z1s\u0019&t7NR1jYV\u0014X\r\u0006\u0003\u0002h\u0005e\u0006bBA^?\u0001\u0007\u0011qM\u0001\u000eQ\u0006\u001ch*Z<SK\u000e|'\u000fZ:\u0002SU\u0004H-\u0019;f%\u0016\u0004H.[2b'R\fG/\u001a$pe:{gNR3uG\"Lgn\u001a)beRLG/[8o))\t\t-!9\u0002f\u0006\u001d\u00181\u001e\t\u0005\u0003\u0007\fYN\u0004\u0003\u0002F\u0006Ug\u0002BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\be\u0016\u0004H.[2b\u0015\r\ty\r]\u0001\u0007G>lWn\u001c8\n\t\u0005M\u0017\u0011Z\u0001\u000e%\u0016\u0004H.[2b'R\fG/^:\n\t\u0005]\u0017\u0011\\\u0001\u000b\u001b&\u0014(o\u001c:J]\u001a|'\u0002BAj\u0003\u0013LA!!8\u0002`\n)1\u000b^1uK*!\u0011q[Am\u0011\u001d\t\u0019\u000f\ta\u0001\u0003\u0003\fQa\u001d;bi\u0016Dq!!\u001d!\u0001\u0004\t)\bC\u0004\u0002j\u0002\u0002\r!a+\u000211\f7\u000f\u001e$fi\u000eDG+[7f\u001bN$\u0006N]3tQ>dG\rC\u0004\u0002n\u0002\u0002\r!a<\u0002\tQLW.\u001a\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011Q_Ag\u0003\u0015)H/\u001b7t\u0013\u0011\tI0a=\u0003\tQKW.Z\u0001\f[&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0006\u0002\u0000\n\u0015!\u0011\u0002B\u000b\u0005/\u0001B!!2\u0003\u0002%!!1AAm\u0005)i\u0015N\u001d:pe&sgm\u001c\u0005\b\u0005\u000f\t\u0003\u0019AAa\u0003U\u0001XM]:jgR,g\u000e^'jeJ|'o\u0015;bi\u0016DqAa\u0003\"\u0001\u0004\u0011i!A\u000bv]\u00064\u0018-\u001b7bE2,G*\u001b8l%\u0016\f7o\u001c8\u0011\u000b-\nYBa\u0004\u0011\u0007u\u0012\t\"C\u0002\u0003\u0014\r\u0012Q#\u00168bm\u0006LG.\u00192mK2Kgn\u001b*fCN|g\u000eC\u0004\u0002j\u0006\u0002\r!a+\t\u000f\u00055\u0018\u00051\u0001\u0002p\u0002")
public class PartitionAndState {
    private final Partition partition;
    private volatile EpochUpdateState lastEpochUpdateState;
    private volatile FetcherAssignmentState fetcherAssignmentState;
    private Metadata.LeaderAndEpoch sourceLeaderAndEpoch;
    private final AtomicLong failureStartMs;
    private volatile Option<MirrorFailureType> lastFailureType;
    private volatile Option<MirrorFailureType> apiFailureType;
    private final AtomicReference<FetchState> _fetchState;
    private volatile Option<ClusterLinkFetcher> fetcher;

    public Partition partition() {
        return this.partition;
    }

    public EpochUpdateState lastEpochUpdateState() {
        return this.lastEpochUpdateState;
    }

    public void lastEpochUpdateState_$eq(EpochUpdateState x$1) {
        this.lastEpochUpdateState = x$1;
    }

    public FetcherAssignmentState fetcherAssignmentState() {
        return this.fetcherAssignmentState;
    }

    public void fetcherAssignmentState_$eq(FetcherAssignmentState x$1) {
        this.fetcherAssignmentState = x$1;
    }

    public Metadata.LeaderAndEpoch sourceLeaderAndEpoch() {
        return this.sourceLeaderAndEpoch;
    }

    public void sourceLeaderAndEpoch_$eq(Metadata.LeaderAndEpoch x$1) {
        this.sourceLeaderAndEpoch = x$1;
    }

    public AtomicLong failureStartMs() {
        return this.failureStartMs;
    }

    public Option<MirrorFailureType> lastFailureType() {
        return this.lastFailureType;
    }

    public void lastFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.lastFailureType = x$1;
    }

    public Option<MirrorFailureType> apiFailureType() {
        return this.apiFailureType;
    }

    public void apiFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.apiFailureType = x$1;
    }

    private AtomicReference<FetchState> _fetchState() {
        return this._fetchState;
    }

    public Option<ClusterLinkFetcher> fetcher() {
        return this.fetcher;
    }

    public void fetcher_$eq(Option<ClusterLinkFetcher> x$1) {
        this.fetcher = x$1;
    }

    public boolean updateEpochState(Metadata.LeaderAndEpoch leaderAndEpoch) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        leaderAndEpoch.epoch.ifPresent(currentEpoch -> {
            Option<Object> option;
            EpochUpdateState epochUpdateState = this.lastEpochUpdateState();
            if (epochUpdateState != null) {
                Option<Object> option2 = epochUpdateState.sourceEpoch();
                int lastEmptyUpdates = epochUpdateState.numEmptyEpochUpdates();
                if (option2 instanceof Some) {
                    int lastEpoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    if (Predef$.MODULE$.Integer2int(currentEpoch) > lastEpoch) {
                        this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), lastEmptyUpdates + 1));
                        updated$1.elem = true;
                        return;
                    }
                    return;
                }
            }
            if (epochUpdateState != null && None$.MODULE$.equals(option = epochUpdateState.sourceEpoch())) {
                this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), 1));
                updated$1.elem = true;
                return;
            }
            throw new MatchError((Object)epochUpdateState);
        });
        return updated.elem;
    }

    public Option<FetchState> fetchState() {
        return Option$.MODULE$.apply((Object)this._fetchState().get());
    }

    public void updateFetchState(ClusterLinkFetcherManager fetcherManager, Function1<Option<FetchState>, Option<FetchState>> transform) {
        boolean done = false;
        for (int attemptsRemaining = 100; !done && attemptsRemaining > 0; --attemptsRemaining) {
            Option oldState = Option$.MODULE$.apply((Object)this._fetchState().get());
            done = ((Option)transform.apply((Object)oldState)).forall((Function1 & Serializable)newState -> BoxesRunTime.boxToBoolean((boolean)PartitionAndState.$anonfun$updateFetchState$1(this, oldState, newState)));
        }
        if (!done) {
            Option oldState = Option$.MODULE$.apply((Object)this._fetchState().get());
            ((Option)transform.apply((Object)oldState)).foreach((Function1 & Serializable)newState -> {
                PartitionAndState.$anonfun$updateFetchState$2(this, fetcherManager, oldState, newState);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Tuple2<Object, Object> onLinkFailure(MirrorFailureType failureType, long now, int retryTimeoutMs) {
        boolean apiFailureTypeChanged;
        long remainingRetryMs;
        Option<MirrorFailureType> lastFailureType = this.lastFailureType();
        this.lastFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        if (failureType.persistFailure() && !lastFailureType.exists((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)x$35.persistFailure()))) {
            this.failureStartMs().set(now);
        } else {
            this.failureStartMs().compareAndSet(0L, now);
        }
        long l = remainingRetryMs = failureType.retriable() ? this.failureStartMs().get() + (long)retryTimeoutMs - now : 0L;
        boolean bl = remainingRetryMs <= 0L || !failureType.retriable() ? !this.apiFailureType().contains((Object)failureType) : (apiFailureTypeChanged = false);
        if (apiFailureTypeChanged) {
            this.apiFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        }
        return new Tuple2.mcJZ.sp(remainingRetryMs, apiFailureTypeChanged);
    }

    public void resetEpochUpdates() {
        this.lastEpochUpdateState_$eq(new EpochUpdateState(this.lastEpochUpdateState().sourceEpoch(), 0));
    }

    public boolean clearLinkFailure(boolean hasNewRecords) {
        if (hasNewRecords && this.lastEpochUpdateState().numEmptyEpochUpdates() > 0) {
            this.resetEpochUpdates();
        }
        this.apiFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        this.lastFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        return this.failureStartMs().getAndSet(0L) != 0L;
    }

    private ReplicaStatus.MirrorInfo.State updateReplicaStateForNonFetchingPartition(ReplicaStatus.MirrorInfo.State state, Option<FetchState> fetchState, int lastFetchTimeMsThreshold, Time time) {
        boolean beyondThreshold = fetchState.forall((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)PartitionAndState.$anonfun$updateReplicaStateForNonFetchingPartition$1(time, lastFetchTimeMsThreshold, x$36)));
        ReplicaStatus.MirrorInfo.State state2 = state;
        ReplicaStatus.MirrorInfo.State state3 = ReplicaStatus.MirrorInfo.State.ACTIVE;
        if (!(state2 != null ? !state2.equals(state3) : state3 != null) && beyondThreshold) {
            return ReplicaStatus.MirrorInfo.State.SOURCE_UNAVAILABLE;
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReplicaStatus.MirrorInfo mirrorState(ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason, int lastFetchTimeMsThreshold, Time time) {
        ReplicaStatus.MirrorInfo.State state;
        Object object;
        Option<MirrorFailureType> option = this.apiFailureType();
        if (option instanceof Some) {
            object = this.apiFailureType();
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            object = this.lastEpochUpdateState().numEmptyEpochUpdates() > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeLowerThreshold() ? new Some((Object)MirrorFailureType$NoSourceRecords$.MODULE$) : None$.MODULE$;
        }
        None$ currentFailure = object;
        Option<FetchState> currentFetchState = this.fetchState();
        if (ReplicaStatus.MirrorInfo.State.ACTIVE.equals(persistentMirrorState)) {
            ReplicaStatus.MirrorInfo.State state2;
            Option option2 = currentFailure.map((Function1 & Serializable)x$37 -> x$37.replicaStatusState());
            if (option2 instanceof Some && ReplicaStatus.MirrorInfo.State.ACTIVE.equals(state2 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value()) ? true : None$.MODULE$.equals(option2)) {
                if (unavailableLinkReason instanceof Some) {
                    UnavailableLinkReason e = (UnavailableLinkReason)((Some)unavailableLinkReason).value();
                    state = (ReplicaStatus.MirrorInfo.State)MirrorFailureType$.MODULE$.failureType(e).map((Function1 & Serializable)x$38 -> x$38.replicaStatusState()).getOrElse((Function0 & Serializable)() -> ReplicaStatus.MirrorInfo.State.ACTIVE);
                } else {
                    state = ReplicaStatus.MirrorInfo.State.ACTIVE;
                }
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                state = (ReplicaStatus.MirrorInfo.State)((Some)option2).value();
            }
        } else {
            state = persistentMirrorState;
        }
        ReplicaStatus.MirrorInfo.State mirrorState = state;
        return new ReplicaStatus.MirrorInfo(this.updateReplicaStateForNonFetchingPartition(mirrorState, currentFetchState, lastFetchTimeMsThreshold, time), BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable)x$39 -> BoxesRunTime.boxToLong((long)x$39.lastFetchTimeMs())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)), BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable)x$40 -> BoxesRunTime.boxToLong((long)x$40.lastFetchHighWatermark())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    public static final /* synthetic */ boolean $anonfun$updateFetchState$1(PartitionAndState $this, Option oldState$2, FetchState newState) {
        return $this._fetchState().compareAndSet((FetchState)oldState$2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), newState);
    }

    public static final /* synthetic */ void $anonfun$updateFetchState$2(PartitionAndState $this, ClusterLinkFetcherManager fetcherManager$1, Option oldState$3, FetchState newState) {
        $this._fetchState().set(newState);
        fetcherManager$1.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Could not set fetch state safely after 100 attempts, overwriting from ").append(oldState$3).append(" to ").append(newState).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateReplicaStateForNonFetchingPartition$1(Time time$1, int lastFetchTimeMsThreshold$2, FetchState x$36) {
        return x$36.lastFetchTimeMs() < time$1.milliseconds() - (long)lastFetchTimeMsThreshold$2;
    }

    public PartitionAndState(Partition partition, EpochUpdateState lastEpochUpdateState, FetcherAssignmentState fetcherAssignmentState) {
        this.partition = partition;
        this.lastEpochUpdateState = lastEpochUpdateState;
        this.fetcherAssignmentState = fetcherAssignmentState;
        this.sourceLeaderAndEpoch = Metadata.LeaderAndEpoch.noLeaderOrEpoch();
        this.failureStartMs = new AtomicLong();
        this.lastFailureType = None$.MODULE$;
        this.apiFailureType = None$.MODULE$;
        this._fetchState = new AtomicReference();
        this.fetcher = None$.MODULE$;
    }
}

