/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.Objects;
import java.util.UUID;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;

public final class TopicIdPartition {
    private final UUID topicId;
    private final TopicPartition topicPartition;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @JsonCreator
    public TopicIdPartition(@JsonProperty(value="topic") String topic, @JsonProperty(value="topicId") UUID topicId, @JsonProperty(value="partition") int partition) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.topicId = topicId;
    }

    @JsonProperty(value="partition", required=true)
    public int partition() {
        return this.topicPartition.partition();
    }

    @JsonProperty(value="topic", required=true)
    public String topic() {
        return this.topicPartition.topic();
    }

    @JsonProperty(value="topicId", required=true)
    public UUID topicId() {
        return this.topicId;
    }

    public Uuid kafkaTopicId() {
        return CoreUtils.toKafkaUUID(this.topicId);
    }

    public String topicIdAsBase64() {
        return CoreUtils.uuidToBase64(this.topicId);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.topicId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicIdPartition other = (TopicIdPartition)obj;
        return Objects.equals(this.topicPartition(), other.topicPartition()) && Objects.equals(this.topicId(), other.topicId());
    }

    public String toString() {
        return this.topicIdAsBase64() + ":" + this.topic() + "-" + this.partition();
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

