/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import org.apache.kafka.common.Uuid;

public class KRaftSnapshotObjectUtils {
    public static void putObject(TierObjectStore objectStore, TierObjectStore.KRaftSnapshotMetadata objectMetadata, File file) throws IOException {
        objectStore.putObject(objectMetadata, file, TierObjectStore.FileType.KRAFT_SNAPSHOT);
    }

    public static TierObjectStoreResponse getObject(TierObjectStore objectStore, TierObjectStore.KRaftSnapshotMetadata objectMetadata) throws IOException {
        return objectStore.getObject(objectMetadata, TierObjectStore.FileType.KRAFT_SNAPSHOT);
    }

    public static TierObjectStoreResponse getObject(TierObjectStore objectStore, TierObjectStore.KRaftSnapshotMetadata objectMetadata, VersionInformation versionInformation) throws IOException {
        return objectStore.getObject(objectMetadata, TierObjectStore.FileType.KRAFT_SNAPSHOT, null, null, versionInformation);
    }

    public static Map<KRaftSnapshotObject, List<VersionInformation>> listObjects(TierObjectStore objectStore, boolean versionInfo, String keyPrefix) {
        Map<String, List<VersionInformation>> objects = objectStore.listObject(KRaftSnapshotObject.filePathPrefix(keyPrefix), versionInfo);
        return objects.entrySet().stream().collect(Collectors.toMap(entry -> KRaftSnapshotObject.decodePath(keyPrefix, (String)entry.getKey()), Map.Entry::getValue));
    }

    public static Map<KRaftSnapshotObject, List<VersionInformation>> listObjectsByNode(TierObjectStore objectStore, boolean versionInfo, String keyPrefix, Uuid topicId, int partition, String clusterId, int nodeId) {
        String prefix = KRaftSnapshotObject.filePathPrefixByNode(keyPrefix, topicId, partition, clusterId, nodeId);
        Map<String, List<VersionInformation>> objects = objectStore.listObject(prefix, versionInfo);
        return objects.entrySet().stream().collect(Collectors.toMap(entry -> KRaftSnapshotObject.decodePath(keyPrefix, (String)entry.getKey()), Map.Entry::getValue));
    }

    public static boolean objectExists(TierObjectStore objectStore, TierObjectStore.KRaftSnapshotMetadata objectMetadata) throws IOException {
        return objectStore.objectExists((TierObjectStore.ObjectStoreMetadata)objectMetadata, (TierObjectStore.FileType)TierObjectStore.FileType.KRAFT_SNAPSHOT).exist;
    }

    public static void deleteObject(TierObjectStore objectStore, TierObjectStore.KRaftSnapshotMetadata objectMetadata, String keyPrefix) {
        objectStore.deleteVersions(Collections.singletonList(new TierObjectStore.KeyAndVersion(objectMetadata.toPath(keyPrefix, TierObjectStore.FileType.KRAFT_SNAPSHOT))));
    }
}

