/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kafka.log.MergedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.domain.TierRecordType;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierCatchupConsumer;
import kafka.tier.topic.TierDiscoverConsumer;
import kafka.tier.topic.TierTopicListeners;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Set;

public class TierTopicConsumer
implements Runnable,
BrokerReconfigurable {
    private static final Logger log = LoggerFactory.getLogger(TierTopicConsumer.class);
    private static final int RESTORE_STATE_FETCH_EXCEPTION_BACKOFF_MS = 1000;
    private static final int MAX_RETRY_COUNT = 3;
    volatile TierTopicManagerConfig config;
    private final Optional<Metrics> metrics;
    private final Time time;
    private final TierTopicListeners resultListeners;
    private final Map<TopicIdPartition, ClientCtx> immigratingPartitions = new HashMap<TopicIdPartition, ClientCtx>();
    private final Map<TopicIdPartition, ClientCtx> primaryConsumerPartitions = new HashMap<TopicIdPartition, ClientCtx>();
    private final Map<TopicIdPartition, ClientCtx> catchUpConsumerPartitions = new HashMap<TopicIdPartition, ClientCtx>();
    private final Map<TopicIdPartition, ClientCtx> discoverConsumerPartitions = new HashMap<TopicIdPartition, ClientCtx>();
    private final java.util.Set<TopicIdPartition> primaryConsumerErrorPartitions = new HashSet<TopicIdPartition>();
    private final java.util.Set<TopicIdPartition> catchUpConsumerErrorPartitions = new HashSet<TopicIdPartition>();
    private final Thread consumerThread = new KafkaThread("TierTopicConsumer", (Runnable)this, false);
    private final Supplier<Consumer<byte[], byte[]>> primaryConsumerSupplier;
    private final TierTopicManagerCommitter committer;
    private final AtomicLong lastHeartbeatMs;
    private final MetricName heartbeatMetricName = new MetricName("HeartbeatMs", "TierTopicConsumer", "Time since last heartbeat in milliseconds.", new HashMap());
    private final MetricName immigrationMetricName = new MetricName("ImmigratingPartitions", "TierTopicConsumer", "Number of tiered partitions that are pending for materialization", new HashMap());
    private final MetricName catchupConsumerPartitionsMetricName = new MetricName("CatchupConsumerPartitions", "TierTopicConsumer", "Number of tiered partitions being consumed by the catch up consumer (either CATCHUP or ERROR status)", new HashMap());
    private final MetricName discoverConsumerPartitionsMetricName = new MetricName("DiscoverConsumerPartitions", "TierTopicConsumer", "Number of tiered partitions being consumed by the discover consumer (either DISCOVER, CATCHUP or ERROR status)", new HashMap());
    private final MetricName primaryConsumerPartitionsMetricName = new MetricName("PrimaryConsumerPartitions", "TierTopicConsumer", "Number of tiered partitions being consumed by the primary consumer (either ONLINE or ERROR status)", new HashMap());
    private final MetricName primaryConsumerErrorPartitionsMetricName = new MetricName("ErrorPartitions", "TierTopicConsumer", "Number of tiered partitions being consumed by primary consumer, and with ERROR materialization state", new HashMap());
    private final MetricName primaryConsumerFrozenPartitionsMetricName = new MetricName("FrozenPartitions", "TierTopicConsumer", "Number of tiered partitions being consumed by primary consumer, and with FROZEN_LOG_START_OFFSET materialization state", new HashMap());
    private final MetricName numListenersMetricName = new MetricName("NumListeners", "TierTopicConsumer", "Number of metadata listeners awaiting materialization.", new HashMap());
    final MetricName maxListeningMsMetricName = new MetricName("MaxListeningMs", "TierTopicConsumer", "The time that the oldest metadata listener has been waiting in milliseconds.", new HashMap());
    final MetricName maxTierLagMetricName = new MetricName("MaxTierLag", "TierTopicConsumer", "Current max tier materialization lag across all partitions.", new HashMap());
    private final TierCatchupConsumer catchupConsumer;
    final TierDiscoverConsumer discoverConsumer;
    private final TierStateFetcher tierStateFetcher;
    final java.util.Set<TopicPartition> requireRediscoverTTPs = new HashSet<TopicPartition>();
    private final Map<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
    private boolean initialized = false;
    private volatile Consumer<byte[], byte[]> primaryConsumer;
    private volatile boolean ready = true;
    private volatile boolean shutdown = false;
    private InitializedTierTopic tierTopic;
    public static final Set<String> RECONFIGURABLE_CONFIGS = JavaConverters.asScalaSet(new HashSet<String>(Arrays.asList(KafkaConfig.TierPartitionStateMetadataSnapshotsRetentionDaysProp())));

    public TierTopicConsumer(TierTopicManagerConfig config, LogDirFailureChannel logDirFailureChannel, TierStateFetcher tierStateFetcher, Metrics metrics, Time time) {
        this(config, new TierTopicConsumerSupplier(config, "primary"), new TierTopicConsumerSupplier(config, "catchup"), new TierTopicConsumerSupplier(config, "discover"), new TierTopicManagerCommitter(config, logDirFailureChannel), tierStateFetcher, Optional.of(metrics), time);
    }

    public TierTopicConsumer(TierTopicManagerConfig config, Supplier<Consumer<byte[], byte[]>> primaryConsumerSupplier, Supplier<Consumer<byte[], byte[]>> catchupConsumerSupplier, Supplier<Consumer<byte[], byte[]>> discoverConsumerSupplier, TierTopicManagerCommitter committer, TierStateFetcher tierStateFetcher, Optional<Metrics> metrics, Time time) {
        this.config = config;
        this.committer = committer;
        this.primaryConsumerSupplier = primaryConsumerSupplier;
        this.catchupConsumer = new TierCatchupConsumer(catchupConsumerSupplier);
        this.discoverConsumer = new TierDiscoverConsumer(discoverConsumerSupplier);
        this.tierStateFetcher = tierStateFetcher;
        this.metrics = metrics;
        this.time = time;
        this.resultListeners = new TierTopicListeners(time);
        this.lastHeartbeatMs = new AtomicLong(time.milliseconds());
        this.setupMetrics();
    }

    protected synchronized boolean isPartitionRegistered(TopicIdPartition partition) {
        return this.immigratingPartitions.containsKey(partition) || this.primaryConsumerPartitions.containsKey(partition) || this.catchUpConsumerPartitions.containsKey(partition) || this.discoverConsumerPartitions.containsKey(partition);
    }

    private synchronized boolean isClientCtxRegistered(TopicIdPartition partition, ClientCtx clientCtx) {
        Optional<ClientCtx> registeredClientCtx = this.getRegisteredClientCtx(partition);
        return registeredClientCtx.map(ClientCtx::id).equals(Optional.of(clientCtx.id()));
    }

    private synchronized Optional<ClientCtx> getRegisteredClientCtx(TopicIdPartition partition) {
        ClientCtx clientCtx = this.immigratingPartitions.get(partition);
        if (clientCtx != null) {
            return Optional.of(clientCtx);
        }
        clientCtx = this.primaryConsumerPartitions.get(partition);
        if (clientCtx != null) {
            return Optional.of(clientCtx);
        }
        clientCtx = this.catchUpConsumerPartitions.get(partition);
        if (clientCtx != null) {
            return Optional.of(clientCtx);
        }
        clientCtx = this.discoverConsumerPartitions.get(partition);
        return Optional.ofNullable(clientCtx);
    }

    public synchronized void register(TopicIdPartition partition, ClientCtx clientCtx) {
        if (!this.isPartitionRegistered(partition)) {
            log.info("Processing registration for {} with status {}", (Object)partition, (Object)clientCtx.status());
            this.immigratingPartitions.put(partition, clientCtx);
            if (clientCtx.status().hasError() && !this.config.enableSnapshotBasedMaterialization.booleanValue()) {
                log.info("Partition: {} registered with {} status", (Object)partition, (Object)clientCtx.status());
                this.catchUpConsumerErrorPartitions.add(partition);
            }
        } else if (!this.isClientCtxRegistered(partition, clientCtx)) {
            throw new IllegalStateException("Duplicate registration for " + partition + " with a new ClientCtx. isImmigrating: " + this.immigratingPartitions.containsKey(partition) + " isPrimary: " + this.primaryConsumerPartitions.containsKey(partition) + " isCatchUp: " + this.catchUpConsumerPartitions.containsKey(partition) + " isDiscover: " + this.discoverConsumerPartitions.containsKey(partition));
        }
    }

    public synchronized void register(Map<TopicIdPartition, ClientCtx> partitionsToRegister) {
        for (Map.Entry<TopicIdPartition, ClientCtx> partitionToRegister : partitionsToRegister.entrySet()) {
            this.register(partitionToRegister.getKey(), partitionToRegister.getValue());
        }
    }

    public synchronized void deregister(TopicIdPartition partition) {
        log.info("Processing de-registration for {}", (Object)partition);
        this.immigratingPartitions.remove(partition);
        this.primaryConsumerPartitions.remove(partition);
        this.catchUpConsumerPartitions.remove(partition);
        if (this.discoverConsumerPartitions.remove(partition) != null) {
            this.resultListeners.getAndRemoveAll(partition).forEach(c -> c.completeExceptionally((Throwable)((Object)new TierMetadataRetriableException("Tier partition state for " + partition + " does not exist"))));
        }
        this.primaryConsumerErrorPartitions.remove(partition);
        this.catchUpConsumerErrorPartitions.remove(partition);
    }

    public synchronized void deregister(TopicIdPartition partition, String expectedClientCtxId) {
        Optional<ClientCtx> clientCtx = this.getRegisteredClientCtx(partition);
        if (clientCtx.map(ctx -> !ctx.id().equals(expectedClientCtxId)).orElse(false).booleanValue()) {
            log.warn("Registered ClientCtx is not de-registered because its id doesn't match the expected one.  Registered ClientCtx id: {}, expected ClientCtx id: {}", (Object)clientCtx.get().id(), (Object)expectedClientCtxId);
            return;
        }
        this.deregister(partition);
    }

    public void trackMaterialization(AbstractTierMetadata metadata, CompletableFuture<TierPartitionState.AppendResult> future) {
        this.resultListeners.addTracked(metadata, future);
    }

    public void cancelTracked(AbstractTierMetadata metadata) {
        this.resultListeners.getAndRemoveTracked(metadata);
    }

    public void initialize(InitializedTierTopic tierTopic) {
        if (this.initialized) {
            return;
        }
        this.tierTopic = tierTopic;
        java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions(tierTopic.topicName(), tierTopic.numPartitions().getAsInt());
        this.beginningOffsets.clear();
        this.requireRediscoverTTPs.clear();
        if (this.primaryConsumer == null) {
            this.primaryConsumer = this.primaryConsumerSupplier.get();
        }
        this.primaryConsumer.assign(tierTopicPartitions);
        if (!this.config.enableSnapshotBasedMaterialization.booleanValue()) {
            tierTopicPartitions.forEach(tp -> this.beginningOffsets.put((TopicPartition)tp, 0L));
        } else if (this.config.materializationTimeRangeMs < 0L) {
            this.primaryConsumer.beginningOffsets(tierTopicPartitions).forEach((tp, offset) -> this.beginningOffsets.put((TopicPartition)tp, (Long)offset));
        } else {
            Long timestampToSeek = this.time.milliseconds() - this.config.materializationTimeRangeMs;
            Map timestampsToSearch = tierTopicPartitions.stream().distinct().collect(Collectors.toMap(Function.identity(), tp -> timestampToSeek));
            this.primaryConsumer.offsetsForTimes(timestampsToSearch).forEach((tp, offsetAndTimestamp) -> this.beginningOffsets.put((TopicPartition)tp, offsetAndTimestamp == null ? 0L : offsetAndTimestamp.offset()));
        }
        for (TopicPartition topicPartition : tierTopicPartitions) {
            OffsetAndEpoch offsetAndEpoch = this.committer.positionFor(topicPartition.partition());
            if (offsetAndEpoch != null) {
                if (offsetAndEpoch.offset() >= this.beginningOffsets.get(topicPartition)) {
                    log.info("seeking primary consumer to committed offset {} for partition {}", (Object)offsetAndEpoch, (Object)topicPartition);
                    OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(offsetAndEpoch.offset(), offsetAndEpoch.epoch(), "");
                    this.primaryConsumer.seek(topicPartition, offsetAndMetadata);
                    continue;
                }
                log.info("committed offset is behind, seeking primary consumer to beginning offset {} for partition {}", (Object)this.beginningOffsets.get(topicPartition), (Object)topicPartition);
                this.primaryConsumer.seek(topicPartition, this.beginningOffsets.get(topicPartition).longValue());
                this.requireRediscoverTTPs.add(topicPartition);
                continue;
            }
            log.info("primary consumer missing committed offset for partition {}. Seeking to beginning", (Object)topicPartition);
            this.requireRediscoverTTPs.add(topicPartition);
            this.primaryConsumer.seekToBeginning(Collections.singletonList(topicPartition));
        }
        this.initialized = true;
    }

    public void start() {
        if (!this.initialized) {
            throw new IllegalStateException("TierTopicConsumer was started without first calling initialize.");
        }
        this.ready = true;
        this.consumerThread.start();
    }

    public Map<Integer, OffsetAndEpoch> snapshotPositions() {
        return this.committer.takePositionsSnapshot();
    }

    public void writePositions(Map<Integer, OffsetAndEpoch> positions) {
        this.committer.writePositionsSnapshot(positions);
    }

    public boolean isReady() {
        return this.ready;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.primaryConsumer != null) {
            this.primaryConsumer.wakeup();
        }
        this.catchupConsumer.wakeup();
        this.discoverConsumer.wakeup();
        try {
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            log.error("Shutdown interrupted", (Throwable)e);
        }
        this.resultListeners.shutdown();
        this.removeMetrics();
    }

    public void cleanup() {
        if (this.primaryConsumer != null) {
            this.primaryConsumer.close();
        }
        this.catchupConsumer.close();
        this.discoverConsumer.close();
    }

    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                this.doWork();
            }
        }
        catch (Exception e) {
            if (this.shutdown) {
                log.debug("Exception caught during shutdown", (Throwable)e);
            } else {
                log.error("Fatal exception in TierTopicConsumer", (Throwable)e);
            }
        }
        finally {
            this.ready = false;
        }
    }

    public void doWork() {
        this.lastHeartbeatMs.set(this.time.milliseconds());
        if (!this.catchupConsumer.active() && this.discoverConsumer.tryComplete()) {
            this.completeDiscover();
        } else if (this.catchupConsumer.tryComplete((tp, currentPosition) -> this.primaryConsumer.position(tp) <= currentPosition)) {
            this.completeCatchup();
        }
        this.processPendingImmigrations();
        Duration primaryPollDuration = this.catchupConsumer.active() || this.discoverConsumer.active() ? Duration.ZERO : this.config.pollDuration;
        this.processRecords((ConsumerRecords<byte[], byte[]>)this.primaryConsumer.poll(primaryPollDuration), TierPartitionStatus.ONLINE, true);
        this.processRecords(this.catchupConsumer.poll(this.config.pollDuration), TierPartitionStatus.CATCHUP, false);
        this.processRecords(this.discoverConsumer.poll(this.config.pollDuration), TierPartitionStatus.DISCOVER, false);
    }

    InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    private void processPendingImmigrations() {
        if (this.config.enableSnapshotBasedMaterialization.booleanValue()) {
            this.processPendingImmigrationsToDiscover();
        } else {
            this.processPendingImmigrationsToCatchup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingImmigrationsToCatchup() {
        HashMap<TopicIdPartition, ClientCtx> newCatchupPartitions = new HashMap<TopicIdPartition, ClientCtx>();
        HashMap<TopicIdPartition, ClientCtx> newOnlinePartitions = new HashMap<TopicIdPartition, ClientCtx>();
        if (!this.catchupConsumer.active()) {
            TierTopicConsumer tierTopicConsumer = this;
            synchronized (tierTopicConsumer) {
                for (Map.Entry<TopicIdPartition, ClientCtx> entry : this.immigratingPartitions.entrySet()) {
                    TopicIdPartition partition = entry.getKey();
                    ClientCtx clientCtx = entry.getValue();
                    TierPartitionStatus status = clientCtx.status();
                    if (status == TierPartitionStatus.INIT || status == TierPartitionStatus.DISCOVER || status == TierPartitionStatus.CATCHUP || status.hasError()) {
                        newCatchupPartitions.put(partition, clientCtx);
                        continue;
                    }
                    if (status == TierPartitionStatus.ONLINE) {
                        newOnlinePartitions.put(partition, clientCtx);
                        continue;
                    }
                    log.debug("Ignoring immigration of partition {} in state {}", (Object)partition, (Object)status);
                }
                this.catchUpConsumerPartitions.putAll(newCatchupPartitions);
                this.primaryConsumerPartitions.putAll(newOnlinePartitions);
                this.immigratingPartitions.clear();
            }
        }
        if (!newCatchupPartitions.isEmpty()) {
            this.beginCatchup(newCatchupPartitions);
        }
    }

    private boolean needRediscover(ClientCtx clientCtx, TopicPartition tierPartition) {
        return this.requireRediscoverTTPs.contains(tierPartition) && clientCtx.localMaterializedOffset() < this.beginningOffsets.get(tierPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingImmigrationsToDiscover() {
        HashMap<TopicIdPartition, ClientCtx> newDiscoverPartitions = new HashMap<TopicIdPartition, ClientCtx>();
        HashMap<TopicIdPartition, ClientCtx> newOnlinePartitions = new HashMap<TopicIdPartition, ClientCtx>();
        if (!this.discoverConsumer.active()) {
            TierTopicConsumer tierTopicConsumer = this;
            synchronized (tierTopicConsumer) {
                if (!this.discoverConsumerPartitions.isEmpty()) {
                    newDiscoverPartitions.putAll(this.discoverConsumerPartitions);
                }
                for (Map.Entry<TopicIdPartition, ClientCtx> entry : this.immigratingPartitions.entrySet()) {
                    TopicIdPartition partition = entry.getKey();
                    ClientCtx clientCtx = entry.getValue();
                    TierPartitionStatus status = clientCtx.status();
                    TopicPartition tierPartition = this.tierTopic.toTierTopicPartition(partition);
                    if (this.needRediscover(clientCtx, tierPartition) || status == TierPartitionStatus.INIT || status == TierPartitionStatus.DISCOVER || status == TierPartitionStatus.CATCHUP || status.hasError()) {
                        newDiscoverPartitions.put(partition, clientCtx);
                        continue;
                    }
                    if (status == TierPartitionStatus.ONLINE) {
                        newOnlinePartitions.put(partition, clientCtx);
                        continue;
                    }
                    log.debug("Ignoring immigration of partition {} in state {}", (Object)partition, (Object)status);
                }
                this.discoverConsumerPartitions.putAll(newDiscoverPartitions);
                this.primaryConsumerPartitions.putAll(newOnlinePartitions);
                this.immigratingPartitions.clear();
            }
        }
        if (!newDiscoverPartitions.isEmpty()) {
            this.beginDiscover(newDiscoverPartitions);
        }
    }

    private void beginCatchup(Map<TopicIdPartition, ClientCtx> partitionsToCatchup) {
        this.beginCatchup(partitionsToCatchup, null);
    }

    private void beginCatchup(Map<TopicIdPartition, ClientCtx> partitionsToCatchup, Map<TopicPartition, Long> tierTopicPartitionsAndStartOffsets) {
        for (ClientCtx ctx : partitionsToCatchup.values()) {
            if (ctx.status().hasError()) continue;
            ctx.beginCatchup();
        }
        if (tierTopicPartitionsAndStartOffsets == null) {
            java.util.Set<TopicPartition> tierTopicPartitions = this.tierTopic.toTierTopicPartitions(partitionsToCatchup.keySet());
            this.catchupConsumer.doStart(tierTopicPartitions);
        } else {
            this.catchupConsumer.doStart(tierTopicPartitionsAndStartOffsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCatchup() {
        TierTopicConsumer tierTopicConsumer = this;
        synchronized (tierTopicConsumer) {
            for (Map.Entry<TopicIdPartition, ClientCtx> entry : this.catchUpConsumerPartitions.entrySet()) {
                TopicIdPartition partition = entry.getKey();
                ClientCtx ctx = entry.getValue();
                if (ctx.status().hasError()) {
                    this.catchUpConsumerErrorPartitions.remove(partition);
                    this.primaryConsumerErrorPartitions.add(partition);
                    continue;
                }
                ctx.completeCatchup();
            }
            if (this.primaryConsumerErrorPartitions.size() > 0) {
                log.error("Partitions remaining in ERROR/FROZEN_LOG_START_OFFSET status after catchup: {}", this.primaryConsumerErrorPartitions);
            }
            this.primaryConsumerPartitions.putAll(this.catchUpConsumerPartitions);
            this.catchUpConsumerPartitions.clear();
        }
    }

    private void beginDiscover(Map<TopicIdPartition, ClientCtx> partitionsToBeginDiscover) {
        for (ClientCtx ctx : partitionsToBeginDiscover.values()) {
            if (ctx.status().hasError()) continue;
            ctx.beginDiscover();
        }
        this.startDiscoverConsumer(this.tierTopic.toTierTopicPartitions(partitionsToBeginDiscover.keySet()));
    }

    private void startDiscoverConsumer(java.util.Set<TopicPartition> tierTopicPartitions) {
        try {
            if (this.config.materializationTimeRangeMs < 0L) {
                this.discoverConsumer.doStart(tierTopicPartitions);
            } else {
                this.discoverConsumer.doStart(tierTopicPartitions, this.time.milliseconds() - this.config.materializationTimeRangeMs);
            }
        }
        catch (TimeoutException toe) {
            this.discoverConsumer.close();
            log.warn("Encountered TimeoutException when trying to start discover consumer for {}, materializationTimeRangeMs: {}. Going to retry.", new Object[]{tierTopicPartitions, this.config.materializationTimeRangeMs, toe});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDiscover() {
        TierTopicConsumer tierTopicConsumer = this;
        synchronized (tierTopicConsumer) {
            for (Map.Entry<TopicIdPartition, ClientCtx> entry : this.discoverConsumerPartitions.entrySet()) {
                TopicIdPartition partition = entry.getKey();
                ClientCtx ctx = entry.getValue();
                ctx.completeDiscover();
                if (!ctx.status().hasError()) continue;
                this.catchUpConsumerErrorPartitions.add(partition);
            }
            this.catchUpConsumerPartitions.putAll(this.discoverConsumerPartitions);
            this.discoverConsumerPartitions.clear();
            if (!this.catchUpConsumerPartitions.isEmpty()) {
                HashMap<TopicPartition, Long> tierTopicPartitionsAndStartOffsets = new HashMap<TopicPartition, Long>();
                for (Map.Entry<TopicIdPartition, ClientCtx> entry : this.catchUpConsumerPartitions.entrySet()) {
                    TopicPartition tierTopicPartition = this.tierTopic.toTierTopicPartition(entry.getKey());
                    Long materializedOffset = entry.getValue().localMaterializedOffset();
                    Long curOffset = tierTopicPartitionsAndStartOffsets.getOrDefault(tierTopicPartition, Long.MAX_VALUE);
                    tierTopicPartitionsAndStartOffsets.put(tierTopicPartition, Math.min(materializedOffset, curOffset));
                }
                this.beginCatchup(this.catchUpConsumerPartitions, tierTopicPartitionsAndStartOffsets);
            }
        }
    }

    private void processRecords(ConsumerRecords<byte[], byte[]> records, TierPartitionStatus requiredState, boolean commitPositions) {
        if (records == null) {
            return;
        }
        for (ConsumerRecord record : records) {
            try {
                Optional<AbstractTierMetadata> entryOpt = AbstractTierMetadata.deserialize((byte[])record.key(), (byte[])record.value(), record.timestamp());
                if (entryOpt.isPresent()) {
                    AbstractTierMetadata entry = entryOpt.get();
                    log.trace("Read {} at offset {} of partition {} requiredState {}", new Object[]{entry, record.offset(), record.partition(), requiredState});
                    this.processEntry(entry, new OffsetAndEpoch(record.offset(), record.leaderEpoch()), requiredState);
                    if (!commitPositions) continue;
                    this.committer.updatePosition(record.partition(), new OffsetAndEpoch(record.offset() + 1L, record.leaderEpoch()));
                    continue;
                }
                throw new TierMetadataFatalException(String.format("Fatal Exception message for %s and unknown type: %d cannot be deserialized (requiredState:%s).", new Object[]{AbstractTierMetadata.deserializeKey((byte[])record.key()), AbstractTierMetadata.getTypeId((byte[])record.value()), requiredState}));
            }
            catch (Exception e) {
                throw new TierMetadataFatalException(String.format("Unable to process message at offset %d of partition %d, requiredState %s", new Object[]{record.offset(), record.partition(), requiredState}), e);
            }
        }
    }

    private static boolean checkClientCtxStatus(ClientCtx ctx, TierPartitionStatus status) {
        return ctx != null && EnumSet.of(status, TierPartitionStatus.DISCOVER_ERROR, TierPartitionStatus.ERROR, TierPartitionStatus.FROZEN_LOG_START_OFFSET, TierPartitionStatus.PENDING_DELETION).contains((Object)ctx.status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEntry(AbstractTierMetadata entry, OffsetAndEpoch offsetAndEpoch, TierPartitionStatus requiredState) {
        java.util.Set<TopicIdPartition> errorPartitionsToBeUpdated;
        boolean matchesRequiredState;
        ClientCtx clientCtx;
        TopicIdPartition topicIdPartition = entry.topicIdPartition();
        TierTopicConsumer tierTopicConsumer = this;
        synchronized (tierTopicConsumer) {
            if (this.primaryConsumerPartitions.containsKey(topicIdPartition)) {
                clientCtx = this.primaryConsumerPartitions.get(topicIdPartition);
                matchesRequiredState = requiredState == TierPartitionStatus.ONLINE && TierTopicConsumer.checkClientCtxStatus(clientCtx, requiredState);
                errorPartitionsToBeUpdated = this.primaryConsumerErrorPartitions;
            } else if (this.catchUpConsumerPartitions.containsKey(topicIdPartition)) {
                clientCtx = this.catchUpConsumerPartitions.get(topicIdPartition);
                matchesRequiredState = requiredState == TierPartitionStatus.CATCHUP && TierTopicConsumer.checkClientCtxStatus(clientCtx, requiredState);
                errorPartitionsToBeUpdated = this.catchUpConsumerErrorPartitions;
            } else {
                clientCtx = this.discoverConsumerPartitions.get(topicIdPartition);
                matchesRequiredState = requiredState == TierPartitionStatus.DISCOVER && TierTopicConsumer.checkClientCtxStatus(clientCtx, requiredState);
                errorPartitionsToBeUpdated = new HashSet<TopicIdPartition>();
            }
        }
        if (clientCtx != null) {
            TierPartitionStatus currentState = clientCtx.status();
            if (currentState == TierPartitionStatus.DISK_OFFLINE) {
                this.resultListeners.getAndRemoveTracked(entry).ifPresent(c -> c.completeExceptionally(new TierMetadataFatalException("Partition " + topicIdPartition + " is offline")));
            } else if (matchesRequiredState) {
                if (entry.type() == TierRecordType.PartitionForceRestore || entry.type() == TierRecordType.PartitionUnfreezeLogStartOffset) {
                    this.processRestoreEvents(clientCtx, topicIdPartition, entry, requiredState, offsetAndEpoch, errorPartitionsToBeUpdated);
                } else if (entry.type() == TierRecordType.MetadataSnapshotUploadComplete && currentState.isOpenForSnapshotMaterialization(requiredState)) {
                    this.processSnapshotMaterializationEvent(clientCtx, (TierMetadataSnapshotUploadComplete)entry, offsetAndEpoch);
                } else {
                    TierPartitionState.AppendResult result = this.processEntry(clientCtx, topicIdPartition, entry, offsetAndEpoch, errorPartitionsToBeUpdated);
                    this.resultListeners.getAndRemoveTracked(entry).ifPresent(c -> c.complete(result));
                }
            } else {
                log.debug("Ignoring metadata {}. currentState: {} requiredState: {}", new Object[]{entry, currentState, requiredState});
            }
        } else if (entry.type() == TierRecordType.PartitionDeletePreInitiate || entry.type() == TierRecordType.PartitionDeleteInitiate || entry.type() == TierRecordType.PartitionDeleteComplete) {
            this.resultListeners.getAndRemoveTracked(entry).ifPresent(c -> c.complete(TierPartitionState.AppendResult.ACCEPTED));
        } else {
            this.resultListeners.getAndRemoveTracked(entry).ifPresent(c -> c.completeExceptionally((Throwable)((Object)new TierMetadataRetriableException("Tier partition state for " + topicIdPartition + " does not exist"))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TierPartitionState.AppendResult processEntry(ClientCtx clientCtx, TopicIdPartition topicIdPartition, AbstractTierMetadata entry, OffsetAndEpoch offsetAndEpoch, java.util.Set<TopicIdPartition> errorPartitionsToBeUpdated) {
        try {
            TierPartitionState.AppendResult appendResult = clientCtx.process(entry, offsetAndEpoch);
            return appendResult;
        }
        finally {
            if (clientCtx.status().hasError()) {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    errorPartitionsToBeUpdated.add(topicIdPartition);
                }
            }
        }
    }

    private void processSnapshotMaterializationEvent(ClientCtx clientCtx, TierMetadataSnapshotUploadComplete snapshotUploadComplete, OffsetAndEpoch offsetAndEpoch) {
        if (snapshotUploadComplete.version() >= 3) {
            ByteBuffer snapshotBuffer = this.fetchTierPartitionStateSnapshot(snapshotUploadComplete, offsetAndEpoch);
            TierPartitionState.RestoreResult result = clientCtx.processSnapshotMaterializationEvent(snapshotUploadComplete, snapshotBuffer, offsetAndEpoch);
            if (result == TierPartitionState.RestoreResult.SUCCEEDED) {
                log.info("Successfully materialized snapshot with metadata {}.", (Object)snapshotUploadComplete);
                clientCtx.completeDiscover();
            }
        } else {
            log.debug("Ignored snapshot materialization event with version < 3: " + snapshotUploadComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRestoreEvents(ClientCtx clientCtx, TopicIdPartition topicIdPartition, AbstractTierMetadata entry, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch, java.util.Set<TopicIdPartition> errorPartitionsToBeUpdated) {
        switch (entry.type()) {
            case PartitionForceRestore: {
                TierPartitionForceRestore forceRestoreEvent = (TierPartitionForceRestore)entry;
                ByteBuffer targetState = this.fetchRestoreState(forceRestoreEvent, offsetAndEpoch, topicIdPartition);
                if (this.shutdown) break;
                if (targetState == null) {
                    throw new IllegalStateException("Target restore state  was not successfully fetched for " + topicIdPartition + "for entry " + forceRestoreEvent + " with offset " + offsetAndEpoch);
                }
                this.restoreState(clientCtx, topicIdPartition, forceRestoreEvent, targetState, targetStatus, offsetAndEpoch, errorPartitionsToBeUpdated);
                break;
            }
            case PartitionUnfreezeLogStartOffset: {
                TierPartitionUnfreezeLogStartOffset unfreezeEvent = (TierPartitionUnfreezeLogStartOffset)entry;
                TierPartitionState.RestoreResult result = clientCtx.processRestoreEvents(unfreezeEvent, targetStatus, offsetAndEpoch, Optional.empty());
                if (result != TierPartitionState.RestoreResult.SUCCEEDED) break;
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    errorPartitionsToBeUpdated.remove(unfreezeEvent.topicIdPartition());
                }
                this.resultListeners.getAndRemoveAll(unfreezeEvent.topicIdPartition()).forEach(c -> c.complete(TierPartitionState.AppendResult.RESTORE_FENCED));
                break;
            }
            default: {
                log.warn("Unexpected tier metadata event " + entry.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(ClientCtx clientCtx, TopicIdPartition topicIdPartition, TierPartitionForceRestore entry, ByteBuffer targetState, TierPartitionStatus targetStatus, OffsetAndEpoch offsetAndEpoch, java.util.Set<TopicIdPartition> errorPartitionsToBeUpdated) {
        TierPartitionState.RestoreResult result;
        TierPartitionStatus prevStatus = clientCtx.status();
        if (prevStatus == TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
            targetStatus = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        }
        if ((result = clientCtx.processRestoreEvents(entry, targetStatus, offsetAndEpoch, Optional.of(targetState))) == TierPartitionState.RestoreResult.SUCCEEDED) {
            if (clientCtx.status() != targetStatus) {
                throw new IllegalStateException("TierPartitionState for " + topicIdPartition + " updated status is " + (Object)((Object)clientCtx.status()) + " is not " + (Object)((Object)targetStatus) + " after recovery of " + entry + " with offset " + offsetAndEpoch);
            }
            TierTopicConsumer tierTopicConsumer = this;
            synchronized (tierTopicConsumer) {
                if (prevStatus != TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                    errorPartitionsToBeUpdated.remove(topicIdPartition);
                }
            }
            if (prevStatus != TierPartitionStatus.FROZEN_LOG_START_OFFSET) {
                this.resultListeners.getAndRemoveAll(topicIdPartition).forEach(c -> c.complete(TierPartitionState.AppendResult.RESTORE_FENCED));
            }
        } else if (result == TierPartitionState.RestoreResult.FAILED) {
            log.debug("TierPartitionState {} state restore result: {} for {}", new Object[]{topicIdPartition, result, entry});
            if (clientCtx.status().hasError()) {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    errorPartitionsToBeUpdated.add(topicIdPartition);
                }
            }
        } else {
            throw new IllegalArgumentException("Unhandled restore result " + (Object)((Object)result) + " for " + topicIdPartition + ". Entry " + entry + " target status " + (Object)((Object)targetStatus) + " with offset " + offsetAndEpoch);
        }
    }

    private ByteBuffer fetchTierPartitionStateSnapshot(TierMetadataSnapshotUploadComplete entry, OffsetAndEpoch offsetAndEpoch) {
        ByteBuffer targetState = null;
        boolean retry = !this.shutdown;
        int retryCount = 0;
        FileTierPartitionStateSnapshotObject snapshotObject = new FileTierPartitionStateSnapshotObject(entry.messageId(), entry.snapshotTimestampMs(), entry.snapshotOffsetAndEpoch(), entry.tierEpoch(), MergedLog.filenamePrefixFromOffset(0L) + MergedLog.TierStateSuffix(), entry.checksumAlgorithm());
        while (retry && retryCount < 3) {
            try {
                targetState = this.tierStateFetcher.fetchTierPartitionStateSnapshot(new TierObjectStore.TierPartitionStateSnapshotMetadata(entry.topicIdPartition(), snapshotObject));
                retry = false;
            }
            catch (TierObjectStoreFatalException e) {
                retry = false;
                log.error("Encountered fatal error when fetching snapshot for metadata {} offset {}.", new Object[]{entry, offsetAndEpoch, e});
            }
            catch (Exception e) {
                retry = !this.shutdown;
                log.warn("Encountered retriable error when materializing snapshot for metadata {} offset {}. Backing off for {} ms. Retry count: {}", new Object[]{entry, offsetAndEpoch, 1000, ++retryCount, e});
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1000L));
            }
        }
        return targetState;
    }

    private ByteBuffer fetchRestoreState(TierPartitionForceRestore entry, OffsetAndEpoch offsetAndEpoch, TopicIdPartition topicIdPartition) {
        boolean retry = !this.shutdown;
        ByteBuffer targetState = null;
        int retryCount = 0;
        while (retry) {
            try {
                targetState = this.tierStateFetcher.fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(entry));
                retry = false;
            }
            catch (TierObjectStoreFatalException e) {
                retry = false;
                log.error("Encountered fatal error when fetching snapshot for metadata {} offset {}.", new Object[]{entry, offsetAndEpoch, e});
            }
            catch (Exception e) {
                retry = !this.shutdown;
                log.warn("Encountered retriable error recovering state for {}, metadata {} offset {}. Backing off for {} ms. Retry count: {}", new Object[]{topicIdPartition, entry, offsetAndEpoch, 1000, ++retryCount, e});
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1000L));
            }
        }
        return targetState;
    }

    private void setupMetrics() {
        this.metrics.ifPresent(m -> {
            m.addMetric(this.heartbeatMetricName, (config, nowMs) -> nowMs - this.lastHeartbeatMs.get());
            m.addMetric(this.immigrationMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.immigratingPartitions.size();
                }
            });
            m.addMetric(this.catchupConsumerPartitionsMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.catchUpConsumerPartitions.size();
                }
            });
            m.addMetric(this.discoverConsumerPartitionsMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.discoverConsumerPartitions.size();
                }
            });
            m.addMetric(this.primaryConsumerPartitionsMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.primaryConsumerPartitions.size();
                }
            });
            m.addMetric(this.primaryConsumerErrorPartitionsMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.primaryConsumerErrorPartitions.stream().filter(tpId -> this.primaryConsumerPartitions.containsKey(tpId) && this.primaryConsumerPartitions.get(tpId).status() == TierPartitionStatus.ERROR).count();
                }
            });
            m.addMetric(this.primaryConsumerFrozenPartitionsMetricName, (config, now) -> {
                TierTopicConsumer tierTopicConsumer = this;
                synchronized (tierTopicConsumer) {
                    return this.primaryConsumerErrorPartitions.stream().filter(tpId -> this.primaryConsumerPartitions.containsKey(tpId) && this.primaryConsumerPartitions.get(tpId).status() == TierPartitionStatus.FROZEN_LOG_START_OFFSET).count();
                }
            });
            m.addMetric(this.numListenersMetricName, (config, now) -> this.numListeners());
            m.addMetric(this.maxListeningMsMetricName, (config, now) -> TimeUnit.NANOSECONDS.toMillis(this.maxListenerTimeNanos()));
            m.addMetric(this.maxTierLagMetricName, (config, now) -> this.maxMaterializationLag());
        });
    }

    private void removeMetrics() {
        this.metrics.ifPresent(m -> {
            m.removeMetric(this.heartbeatMetricName);
            m.removeMetric(this.immigrationMetricName);
            m.removeMetric(this.catchupConsumerPartitionsMetricName);
            m.removeMetric(this.discoverConsumerPartitionsMetricName);
            m.removeMetric(this.primaryConsumerPartitionsMetricName);
            m.removeMetric(this.primaryConsumerErrorPartitionsMetricName);
            m.removeMetric(this.primaryConsumerFrozenPartitionsMetricName);
            m.removeMetric(this.numListenersMetricName);
            m.removeMetric(this.maxListeningMsMetricName);
            m.removeMetric(this.maxTierLagMetricName);
        });
    }

    synchronized Map<TopicIdPartition, ClientCtx> immigratingPartitions() {
        return new HashMap<TopicIdPartition, ClientCtx>(this.immigratingPartitions);
    }

    synchronized Map<TopicIdPartition, ClientCtx> primaryConsumerPartitions() {
        return new HashMap<TopicIdPartition, ClientCtx>(this.primaryConsumerPartitions);
    }

    synchronized Map<TopicIdPartition, ClientCtx> catchUpConsumerPartitions() {
        return new HashMap<TopicIdPartition, ClientCtx>(this.catchUpConsumerPartitions);
    }

    synchronized Map<TopicIdPartition, ClientCtx> discoverConsumerPartitions() {
        return new HashMap<TopicIdPartition, ClientCtx>(this.discoverConsumerPartitions);
    }

    synchronized java.util.Set<TopicIdPartition> primaryConsumerErrorPartitions() {
        return new HashSet<TopicIdPartition>(this.primaryConsumerErrorPartitions);
    }

    synchronized java.util.Set<TopicIdPartition> catchUpConsumerErrorPartitions() {
        return new HashSet<TopicIdPartition>(this.catchUpConsumerErrorPartitions);
    }

    synchronized long numListeners() {
        return this.resultListeners.numListeners();
    }

    synchronized long maxListenerTimeNanos() {
        return this.resultListeners.maxListenerTimeNanos().orElse(0L);
    }

    synchronized long maxMaterializationLag() {
        long maxLag = 0L;
        for (ClientCtx entry : this.primaryConsumerPartitions.values()) {
            maxLag = Math.max(maxLag, entry.materializationLag());
        }
        for (ClientCtx entry : this.catchUpConsumerPartitions.values()) {
            maxLag = Math.max(maxLag, entry.materializationLag());
        }
        for (ClientCtx entry : this.discoverConsumerPartitions.values()) {
            maxLag = Math.max(maxLag, entry.materializationLag());
        }
        return maxLag;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (newConfig.confluentConfig().tierPartitionStateMetadataSnapshotsRetentionDays() < Defaults.TierPartitionStateMetadataSnapshotsMinRetentionDays()) {
            throw new ConfigException(String.format("%s must have a value of at least %s days", KafkaConfig.TierPartitionStateMetadataSnapshotsRetentionDaysProp(), Defaults.TierPartitionStateMetadataSnapshotsMinRetentionDays()));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        if (oldConfig.confluentConfig().tierPartitionStateMetadataSnapshotsRetentionDays() != newConfig.confluentConfig().tierPartitionStateMetadataSnapshotsRetentionDays()) {
            this.config = TierTopicManagerConfig.reconfigureTierTopicManagerConfig(this.config, newConfig);
        }
    }

    public static interface ClientCtx {
        public String id();

        public TierPartitionState.AppendResult process(AbstractTierMetadata var1, OffsetAndEpoch var2);

        public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata var1, TierPartitionStatus var2, OffsetAndEpoch var3, Optional<ByteBuffer> var4);

        public TierPartitionState.RestoreResult processSnapshotMaterializationEvent(TierMetadataSnapshotUploadComplete var1, ByteBuffer var2, OffsetAndEpoch var3);

        public TierPartitionStatus status();

        default public long materializationLag() {
            return 0L;
        }

        public long localMaterializedOffset();

        public void beginCatchup();

        public void completeCatchup();

        public void beginDiscover();

        public void completeDiscover();
    }
}

