/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryState;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;

final class ImportCommand {
    static final String COMMAND = "import";
    private static final String CHECKPOINT_OPTION = "--checkpoint";

    ImportCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparser importCmd = subparsers.addParser(COMMAND).help("replace recovery state with a new state");
        MutuallyExclusiveGroup originOptions = importCmd.addMutuallyExclusiveGroup("import origin options").required(true);
        originOptions.addArgument(new String[]{CHECKPOINT_OPTION}).dest(CHECKPOINT_OPTION).metavar(new String[]{"<path-to-checkpoint>"}).help("path to the checkpoint file to import").type((ArgumentType)Arguments.fileType().verifyCanRead());
    }

    static int execute(Namespace namespace) {
        Path logDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
        try (MetadataRecoveryPartition recoveryPartition = MetadataRecoveryPartition.open(logDir, new Metrics(), Time.SYSTEM);){
            recoveryPartition.truncateTo(0L);
            Properties props = MetadataRecoveryUtils.loadRecoveryConfig(namespace);
            MetadataEncryptorFactory encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)props);
            MetadataRecoveryState metadataRecoveryState = new MetadataRecoveryState(recoveryPartition, encryptorFactory);
            try (FileRawSnapshotReader fileReader = ImportCommand.openFileSnapshotReader(namespace);
                 RecordsSnapshotReader<ApiMessageAndVersion> readerReplay = MetadataRecoveryUtils.openSnapshotReader(fileReader);
                 RecordsSnapshotReader<ApiMessageAndVersion> readerAppend = MetadataRecoveryUtils.openSnapshotReader(fileReader);){
                metadataRecoveryState.importCheckpoint(readerReplay, readerAppend);
            }
        }
        return 0;
    }

    private static FileRawSnapshotReader openFileSnapshotReader(Namespace namespace) {
        if (namespace.getString(CHECKPOINT_OPTION) != null) {
            Path path = Paths.get(namespace.getString(CHECKPOINT_OPTION), new String[0]);
            return MetadataRecoveryUtils.openFileRawSnapshotReader(path);
        }
        throw new IllegalArgumentException("one 'origin' option must be specified");
    }
}

