/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.ApplyCommand;
import io.confluent.kafka.tools.recovery.CheckpointCommand;
import io.confluent.kafka.tools.recovery.CommandException;
import io.confluent.kafka.tools.recovery.ExportCommand;
import io.confluent.kafka.tools.recovery.ImportCommand;
import io.confluent.kafka.tools.recovery.NewCommand;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;

final class MetadataRecoveryTool {
    private static final String COMMAND_POSITIONAL = "command";
    public static final String NAME = "kafka-metadata-recovery";

    MetadataRecoveryTool() {
    }

    public static void main(String[] args) {
        Exit.exit((int)MetadataRecoveryTool.execute(args));
    }

    static int execute(String ... args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)NAME).defaultHelp(true).description("this tool generates a KRaft checkpoint file from metadata records");
        Subparsers subparsers = parser.addSubparsers().dest(COMMAND_POSITIONAL).help("sub-command help");
        CheckpointCommand.addCommand(subparsers);
        NewCommand.addCommand(subparsers);
        ImportCommand.addCommand(subparsers);
        ExportCommand.addCommand(subparsers);
        ApplyCommand.addCommand(subparsers);
        try {
            Namespace namespace = parser.parseArgs(args);
            switch (namespace.getString(COMMAND_POSITIONAL)) {
                case "checkpoint": {
                    return CheckpointCommand.execute(namespace);
                }
                case "new": {
                    return NewCommand.execute(namespace);
                }
                case "import": {
                    return ImportCommand.execute(namespace);
                }
                case "export": {
                    return ExportCommand.execute(namespace);
                }
                case "apply": {
                    return ApplyCommand.execute(namespace);
                }
            }
            throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return 1;
        }
        catch (CommandException e) {
            System.err.println(e.getMessage());
            return e.statusCode();
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }
}

