/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;

public class KsqlAuthorizationProviderHandler
implements Handler<RoutingContext> {
    private final WorkerExecutor workerExecutor;
    private final KsqlAuthorizationProvider ksqlAuthorizationProvider;

    public KsqlAuthorizationProviderHandler(Server server, KsqlAuthorizationProvider ksqlAuthorizationProvider) {
        this.workerExecutor = server.getWorkerExecutor();
        this.ksqlAuthorizationProvider = ksqlAuthorizationProvider;
    }

    public void handle(RoutingContext routingContext) {
        this.workerExecutor.executeBlocking(promise -> this.authorize((Promise<Void>)promise, routingContext), false, ar -> KsqlAuthorizationProviderHandler.handleAuthorizeResult((AsyncResult<Void>)ar, routingContext));
    }

    private static void handleAuthorizeResult(AsyncResult<Void> ar, RoutingContext routingContext) {
        if (ar.succeeded()) {
            routingContext.next();
        } else {
            routingContext.fail(HttpResponseStatus.FORBIDDEN.code(), ar.cause());
        }
    }

    private void authorize(Promise<Void> promise, RoutingContext routingContext) {
        User user = routingContext.user();
        if (user == null) {
            promise.fail((Throwable)new IllegalStateException("Null user in " + KsqlAuthorizationProviderHandler.class));
            return;
        }
        if (!(user instanceof ApiUser)) {
            throw new IllegalStateException("Not an ApiUser: " + user);
        }
        ApiUser apiUser = (ApiUser)user;
        try {
            this.ksqlAuthorizationProvider.checkEndpointAccess((Principal)apiUser.getPrincipal(), routingContext.request().method().toString(), routingContext.normalisedPath());
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
            return;
        }
        promise.complete();
    }
}

