/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.QueryHandle;
import io.confluent.ksql.api.spi.QueryPublisher;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.reactive.BasePublisher;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.WorkerExecutor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingQueryPublisher
extends BasePublisher<KeyValueMetadata<List<?>, GenericRow>>
implements QueryPublisher {
    private static final Logger log = LoggerFactory.getLogger(BlockingQueryPublisher.class);
    public static final int SEND_MAX_BATCH_SIZE = 200;
    private final WorkerExecutor workerExecutor;
    private BlockingRowQueue queue;
    private boolean isPullQuery;
    private boolean isScalablePushQuery;
    private QueryHandle queryHandle;
    private ImmutableList<String> columnNames;
    private ImmutableList<String> columnTypes;
    private LogicalSchema logicalSchema;
    private QueryId queryId;
    private boolean complete;
    private boolean hitLimit;
    private volatile boolean closed;
    private volatile boolean started;

    public BlockingQueryPublisher(Context ctx, WorkerExecutor workerExecutor) {
        super(ctx);
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
    }

    public void setQueryHandle(QueryHandle queryHandle, boolean isPullQuery, boolean isScalablePushQuery) {
        this.columnNames = ImmutableList.copyOf(queryHandle.getColumnNames());
        this.columnTypes = ImmutableList.copyOf(queryHandle.getColumnTypes());
        this.logicalSchema = queryHandle.getLogicalSchema();
        this.queue = queryHandle.getQueue();
        this.isPullQuery = isPullQuery;
        this.isScalablePushQuery = isScalablePushQuery;
        this.queryId = queryHandle.getQueryId();
        this.queue.setQueuedCallback(this::maybeSend);
        this.queue.setLimitHandler(() -> {
            if (isPullQuery) {
                queryHandle.getConsistencyOffsetVector().ifPresent(arg_0 -> ((PullQueryWriteStream)((PullQueryWriteStream)this.queue)).putConsistencyVector(arg_0));
                this.maybeSend();
            }
            this.complete = true;
            this.hitLimit = true;
            if (this.queue.isEmpty()) {
                this.ctx.runOnContext(v -> this.sendComplete());
            }
        });
        this.queue.setCompletionHandler(() -> {
            if (isPullQuery) {
                queryHandle.getConsistencyOffsetVector().ifPresent(arg_0 -> ((PullQueryWriteStream)((PullQueryWriteStream)this.queue)).putConsistencyVector(arg_0));
                this.maybeSend();
            }
            this.complete = true;
            if (this.queue.isEmpty()) {
                this.ctx.runOnContext(v -> this.sendComplete());
            }
        });
        this.queryHandle = queryHandle;
        queryHandle.onException(t -> this.ctx.runOnContext(v -> this.sendError((Throwable)t)));
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnNames is ImmutableList")
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnTypes is ImmutableList")
    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public LogicalSchema geLogicalSchema() {
        return this.logicalSchema;
    }

    @Override
    public Future<Void> close() {
        if (this.closed) {
            return Future.succeededFuture();
        }
        this.closed = true;
        this.executeOnWorker(this.queryHandle::stop);
        return super.close();
    }

    @Override
    public boolean isPullQuery() {
        return this.isPullQuery;
    }

    @Override
    public boolean isScalablePushQuery() {
        return this.isScalablePushQuery;
    }

    @Override
    public QueryId queryId() {
        return this.queryId;
    }

    @Override
    public boolean hitLimit() {
        return this.hitLimit;
    }

    @Override
    public Optional<PushQueryMetadata.ResultType> getResultType() {
        return this.queryHandle.getResultType();
    }

    protected void maybeSend() {
        this.ctx.runOnContext(v -> this.doSend());
    }

    protected void afterSubscribe() {
        if (!this.started) {
            this.started = true;
            this.executeOnWorker(this.queryHandle::start);
        }
    }

    public void startFromWorkerThread() {
        VertxUtils.checkIsWorker();
        this.started = true;
        this.queryHandle.start();
    }

    private void executeOnWorker(Runnable runnable) {
        this.workerExecutor.executeBlocking(p -> runnable.run(), false, ar -> {
            if (ar.failed()) {
                log.error("Failed to close query", ar.cause());
            }
        });
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Vert.x ensures this is executed on event loop only")
    private void doSend() {
        this.checkContext();
        int num = 0;
        while (this.getDemand() > 0L && !this.queue.isEmpty()) {
            if (num < 200) {
                this.doOnNext(this.queue.poll());
                if (this.complete && this.queue.isEmpty()) {
                    this.ctx.runOnContext(v -> this.sendComplete());
                }
                ++num;
                continue;
            }
            this.ctx.runOnContext(v -> this.doSend());
            break;
        }
    }
}

