/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.impl.InsertsSubscriber;
import io.confluent.ksql.api.server.InsertResult;
import io.confluent.ksql.api.server.InsertsStreamSubscriber;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.Identifiers;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.ReservedInternalTopics;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.reactivestreams.Subscriber;

public class InsertsStreamEndpoint {
    private final KsqlEngine ksqlEngine;
    private final KsqlConfig ksqlConfig;
    private final ReservedInternalTopics reservedInternalTopics;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public InsertsStreamEndpoint(KsqlEngine ksqlEngine, KsqlConfig ksqlConfig, ReservedInternalTopics reservedInternalTopics) {
        this.ksqlEngine = ksqlEngine;
        this.ksqlConfig = ksqlConfig;
        this.reservedInternalTopics = reservedInternalTopics;
    }

    public InsertsStreamSubscriber createInsertsSubscriber(String caseInsensitiveTarget, JsonObject properties, Subscriber<InsertResult> acksSubscriber, Context context, WorkerExecutor workerExecutor, ServiceContext serviceContext) {
        String target;
        VertxUtils.checkIsWorker();
        if (!this.ksqlConfig.getBoolean("ksql.insert.into.values.enabled").booleanValue()) {
            throw new KsqlApiException("The server has disabled INSERT INTO ... VALUES functionality. To enable it, restart your ksqlDB server with 'ksql.insert.into.values.enabled'=true", Errors.ERROR_CODE_BAD_REQUEST);
        }
        try {
            target = Identifiers.getIdentifierText((String)caseInsensitiveTarget);
        }
        catch (IllegalArgumentException e) {
            throw new KsqlApiException("Invalid target name: " + e.getMessage(), Errors.ERROR_CODE_BAD_STATEMENT);
        }
        DataSource dataSource = this.getDataSource(this.ksqlEngine.getMetaStore(), SourceName.of((String)target));
        return InsertsSubscriber.createInsertsSubscriber(serviceContext, properties, dataSource, this.ksqlConfig, context, acksSubscriber, workerExecutor);
    }

    private DataSource getDataSource(MetaStore metaStore, SourceName sourceName) {
        DataSource dataSource = metaStore.getSource(sourceName);
        if (dataSource == null) {
            throw new KsqlApiException("Cannot insert values into an unknown stream/table: " + sourceName + metaStore.checkAlternatives(sourceName, Optional.empty()), Errors.ERROR_CODE_BAD_STATEMENT);
        }
        if (dataSource.getKsqlTopic().getKeyFormat().isWindowed()) {
            throw new KsqlApiException("Cannot insert values into windowed stream/table", Errors.ERROR_CODE_BAD_STATEMENT);
        }
        if (this.reservedInternalTopics.isReadOnly(dataSource.getKafkaTopicName())) {
            throw new KsqlApiException("Cannot insert values into read-only topic: " + dataSource.getKafkaTopicName(), Errors.ERROR_CODE_BAD_STATEMENT);
        }
        return dataSource;
    }
}

