/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlStatementErrorMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureHandler
implements Handler<RoutingContext> {
    private static final Logger log = LoggerFactory.getLogger(FailureHandler.class);

    public void handle(RoutingContext routingContext) {
        int statusCode = routingContext.statusCode();
        Throwable failure = routingContext.failure();
        log.error(String.format("Failed to handle request %d %s", routingContext.statusCode(), routingContext.request().path()));
        if (failure != null) {
            if (failure instanceof KsqlApiException) {
                KsqlApiException ksqlApiException = (KsqlApiException)((Object)failure);
                FailureHandler.handleError(routingContext.response(), statusCode, ksqlApiException.getErrorCode(), ksqlApiException.getMessage(), ksqlApiException.getStatement());
            } else {
                int errorCode = statusCode == HttpResponseStatus.UNAUTHORIZED.code() ? Errors.ERROR_CODE_UNAUTHORIZED : (statusCode == HttpResponseStatus.FORBIDDEN.code() ? Errors.ERROR_CODE_FORBIDDEN : Errors.ERROR_CODE_SERVER_ERROR);
                FailureHandler.handleError(routingContext.response(), statusCode, errorCode, failure.getMessage(), Optional.empty());
            }
        } else {
            routingContext.response().setStatusCode(statusCode).end();
        }
    }

    private static void handleError(HttpServerResponse response, int statusCode, int errorCode, String errMsg, Optional<String> statement) {
        if (statement.isPresent()) {
            KsqlStatementErrorMessage errorResponse = new KsqlStatementErrorMessage(errorCode, errMsg, statement.get(), new KsqlEntityList());
            Buffer buffer = ServerUtils.serializeObject(errorResponse);
            response.setStatusCode(statusCode).end(buffer);
        } else {
            KsqlErrorMessage errorResponse = new KsqlErrorMessage(errorCode, errMsg);
            Buffer buffer = ServerUtils.serializeObject(errorResponse);
            response.setStatusCode(statusCode).end(buffer);
        }
    }
}

