/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.QueryStreamResponseWriter;
import io.confluent.ksql.api.spi.QueryPublisher;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.resources.streaming.TombstoneFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.protobuf.ProtobufNoSRSerdeFactory;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.RowMetadata;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class JsonStreamedRowResponseWriter
implements QueryStreamResponseWriter {
    private static final int FLUSH_SIZE_BYTES = 5120;
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();
    static final long MAX_FLUSH_MS = 200L;
    private final HttpServerResponse response;
    private final Optional<TombstoneFactory> tombstoneFactory;
    private final Optional<String> completionMessage;
    private final Optional<String> limitMessage;
    private final Clock clock;
    private final boolean bufferOutput;
    private final Context context;
    private final RowFormat rowFormat;
    private final WriterState writerState;
    private StreamedRow lastRow;
    private long timerId = -1L;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public JsonStreamedRowResponseWriter(HttpServerResponse response, QueryPublisher queryPublisher, Optional<String> completionMessage, Optional<String> limitMessage, Clock clock, boolean bufferOutput, Context context, RowFormat rowFormat) {
        this.response = response;
        this.tombstoneFactory = queryPublisher.getResultType().map(resultType -> TombstoneFactory.create(queryPublisher.geLogicalSchema(), resultType));
        this.completionMessage = completionMessage;
        this.limitMessage = limitMessage;
        this.writerState = new WriterState(clock);
        this.clock = clock;
        this.bufferOutput = bufferOutput;
        this.context = context;
        Preconditions.checkState((bufferOutput || limitMessage.isPresent() || completionMessage.isPresent() ? 1 : 0) != 0, (Object)"If buffering isn't used, a limit/completion message must be set");
        this.rowFormat = rowFormat;
    }

    @Override
    public QueryStreamResponseWriter writeMetadata(QueryResponseMetadata metaData) {
        StreamedRow streamedRow = this.rowFormat.metadataRow(metaData);
        Buffer buff = Buffer.buffer().appendByte((byte)91);
        if (this.bufferOutput) {
            this.writeBuffer(buff, true);
            this.maybeCacheRowAndWriteLast(streamedRow);
        } else {
            buff.appendBuffer(JsonStreamedRowResponseWriter.serializeObject(streamedRow));
            this.writeBuffer(buff, false);
        }
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeRow(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
        StreamedRow streamedRow;
        KeyValue keyValue = keyValueMetadata.getKeyValue();
        if (keyValue.value() == null) {
            Preconditions.checkState((boolean)this.tombstoneFactory.isPresent(), (Object)"Should only have null values for query types that support them");
            streamedRow = StreamedRow.tombstone((GenericRow)this.tombstoneFactory.get().createRow(keyValue));
        } else {
            streamedRow = this.rowFormat.dataRow(keyValueMetadata);
        }
        this.maybeCacheRowAndWriteLast(streamedRow);
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeContinuationToken(PushContinuationToken pushContinuationToken) {
        StreamedRow streamedRow = StreamedRow.continuationToken((PushContinuationToken)pushContinuationToken);
        this.maybeCacheRowAndWriteLast(streamedRow);
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeError(KsqlErrorMessage error) {
        StreamedRow streamedRow = StreamedRow.error((KsqlErrorMessage)error);
        this.maybeCacheRowAndWriteLast(streamedRow);
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeConsistencyToken(ConsistencyToken consistencyToken) {
        StreamedRow streamedRow = StreamedRow.consistencyToken((ConsistencyToken)consistencyToken);
        this.maybeCacheRowAndWriteLast(streamedRow);
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeCompletionMessage() {
        if (this.completionMessage.isPresent()) {
            this.writeLastRow(false);
            StreamedRow streamedRow = StreamedRow.finalMessage((String)this.completionMessage.get());
            this.writeBuffer(JsonStreamedRowResponseWriter.serializeObject(streamedRow), true);
        }
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeLimitMessage() {
        if (this.limitMessage.isPresent()) {
            this.writeLastRow(false);
            StreamedRow streamedRow = StreamedRow.finalMessage((String)this.limitMessage.get());
            this.writeBuffer(JsonStreamedRowResponseWriter.serializeObject(streamedRow), true);
        }
        return this;
    }

    @Override
    public void end() {
        this.cancelTimer();
        this.writeLastRow(true);
        this.writeBuffer(Buffer.buffer((String)"]"), true);
        if (this.writerState.length() > 0) {
            this.response.write(this.writerState.getStringToFlush());
        }
        this.response.end();
    }

    @VisibleForTesting
    static String logicalToProtoSchema(LogicalSchema schema) {
        ConnectSchema connectSchema = ConnectSchemas.columnsToConnectSchema((List)schema.columns());
        ProtobufSchema protobufSchema = new ProtobufData(new ProtobufDataConfig((Map)ImmutableMap.of())).fromConnectSchema((Schema)connectSchema);
        return protobufSchema.canonicalString();
    }

    private void maybeCacheRowAndWriteLast(StreamedRow streamedRow) {
        StreamedRow outputRow;
        if (this.bufferOutput) {
            outputRow = this.lastRow;
            this.lastRow = streamedRow;
        } else {
            outputRow = streamedRow;
        }
        if (outputRow != null) {
            this.writeBuffer(JsonStreamedRowResponseWriter.serializeObject(outputRow), false);
            this.maybeFlushBuffer();
        }
    }

    private void writeLastRow(boolean isLast) {
        StreamedRow lastRow = this.lastRow;
        this.lastRow = null;
        if (lastRow != null) {
            this.writeBuffer(JsonStreamedRowResponseWriter.serializeObject(lastRow), isLast);
        }
    }

    private void writeBuffer(Buffer buffer, boolean isLastOrFirst) {
        if (this.bufferOutput) {
            this.writerState.append(buffer.toString(StandardCharsets.UTF_8));
            if (!isLastOrFirst) {
                this.writerState.append(",\n");
            }
        } else {
            Buffer buff = Buffer.buffer();
            buff.appendBuffer(buffer);
            if (!isLastOrFirst) {
                buff.appendString(",\n");
            }
            this.response.write((Object)buff);
        }
    }

    private void maybeFlushBuffer() {
        if (this.writerState.length() > 0) {
            if (this.writerState.length() >= 5120 || this.clock.millis() - this.writerState.getLastFlushMs() >= 200L) {
                this.cancelTimer();
                this.response.write(this.writerState.getStringToFlush());
            } else {
                this.maybeScheduleFlush();
            }
        }
    }

    private void maybeScheduleFlush() {
        if (this.timerId >= 0L) {
            return;
        }
        long sinceLastFlushMs = this.clock.millis() - this.writerState.getLastFlushMs();
        long waitTimeMs = Math.min(Math.max(0L, 200L - sinceLastFlushMs), 200L);
        this.timerId = this.context.owner().setTimer(waitTimeMs, timerId -> {
            this.timerId = -1L;
            this.maybeFlushBuffer();
        });
    }

    private void cancelTimer() {
        if (this.timerId >= 0L) {
            this.context.owner().cancelTimer(this.timerId);
            this.timerId = -1L;
        }
    }

    public static <T> Buffer serializeObject(T t) {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes(t);
            return Buffer.buffer((byte[])bytes);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize buffer", e);
        }
    }

    private static Optional<KsqlHostInfoEntity> toKsqlHostInfoEntity(Optional<KsqlHostInfo> ksqlNode) {
        return ksqlNode.map(node -> new KsqlHostInfoEntity(node.host(), node.port()));
    }

    private static class WriterState {
        private final Clock clock;
        private StringBuilder sb = new StringBuilder();
        private long lastFlushMs = 0L;

        WriterState(Clock clock) {
            this.clock = clock;
            this.lastFlushMs = clock.millis();
        }

        public WriterState append(String str) {
            this.sb.append(str);
            return this;
        }

        public int length() {
            return this.sb.length();
        }

        public long getLastFlushMs() {
            return this.lastFlushMs;
        }

        public String getStringToFlush() {
            String str = this.sb.toString();
            this.sb = new StringBuilder();
            this.lastFlushMs = this.clock.millis();
            return str;
        }
    }

    public static enum RowFormat {
        PROTOBUF{
            private transient ConnectSchema connectSchema;
            private transient KsqlConnectSerializer<Struct> serializer;

            @Override
            public StreamedRow metadataRow(QueryResponseMetadata metaData) {
                LogicalSchema schema = metaData.schema;
                String queryId = metaData.queryId;
                this.connectSchema = ConnectSchemas.columnsToConnectSchema((List)schema.columns());
                this.serializer = new ProtobufNoSRSerdeFactory(ImmutableMap.of()).createSerializer((Schema)this.connectSchema, Struct.class, false);
                return StreamedRow.headerProtobuf((QueryId)new QueryId(queryId), (LogicalSchema)schema, (String)JsonStreamedRowResponseWriter.logicalToProtoSchema(schema));
            }

            @Override
            public StreamedRow dataRow(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
                KeyValue keyValue = keyValueMetadata.getKeyValue();
                Struct ksqlRecord = new Struct((Schema)this.connectSchema);
                int i = 0;
                for (Field field : this.connectSchema.fields()) {
                    ksqlRecord.put(field, ((GenericRow)keyValue.value()).get(i));
                    ++i;
                }
                byte[] protoMessage = this.serializer.serialize("", (Object)ksqlRecord);
                return StreamedRow.pullRowProtobuf((byte[])protoMessage);
            }
        }
        ,
        JSON{

            @Override
            public StreamedRow metadataRow(QueryResponseMetadata metaData) {
                return StreamedRow.header((QueryId)new QueryId(metaData.queryId), (LogicalSchema)metaData.schema);
            }

            @Override
            public StreamedRow dataRow(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
                KeyValue keyValue = keyValueMetadata.getKeyValue();
                if (keyValueMetadata.getRowMetadata().isPresent() && ((RowMetadata)keyValueMetadata.getRowMetadata().get()).getSourceNode().isPresent()) {
                    return StreamedRow.pullRow((GenericRow)((GenericRow)keyValue.value()), (Optional)JsonStreamedRowResponseWriter.toKsqlHostInfoEntity(((RowMetadata)keyValueMetadata.getRowMetadata().get()).getSourceNode()));
                }
                return StreamedRow.pushRow((GenericRow)((GenericRow)keyValue.value()));
            }
        };


        public abstract StreamedRow metadataRow(QueryResponseMetadata var1);

        public abstract StreamedRow dataRow(KeyValueMetadata<List<?>, GenericRow> var1);
    }
}

