/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.spi.QueryPublisher;
import io.confluent.ksql.rest.entity.PushQueryId;
import java.util.Objects;
import java.util.function.Consumer;

public class PushQueryHolder {
    private final Server server;
    private final PushQueryId id;
    private final QueryPublisher queryPublisher;
    private final Consumer<PushQueryHolder> closeHandler;

    PushQueryHolder(Server server, QueryPublisher queryPublisher, Consumer<PushQueryHolder> closeHandler) {
        this.server = Objects.requireNonNull(server);
        this.queryPublisher = Objects.requireNonNull(queryPublisher);
        this.closeHandler = Objects.requireNonNull(closeHandler);
        this.id = new PushQueryId(queryPublisher.queryId().toString());
    }

    public void close() {
        this.close(true);
    }

    public void close(Boolean isOriginalContext) {
        this.server.removeQuery(this.id);
        this.queryPublisher.close();
        if (isOriginalContext.booleanValue()) {
            this.closeHandler.accept(this);
        }
    }

    public PushQueryId getId() {
        return this.id;
    }
}

