/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.auth.DefaultApiSecurityContext;
import io.confluent.ksql.api.impl.BlockingPrintPublisher;
import io.confluent.ksql.api.server.ConnectionQueryManager;
import io.confluent.ksql.api.server.DelimitedQueryStreamResponseWriter;
import io.confluent.ksql.api.server.JsonQueryStreamResponseWriter;
import io.confluent.ksql.api.server.JsonStreamedRowResponseWriter;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.PrintSubscriber;
import io.confluent.ksql.api.server.PushQueryHolder;
import io.confluent.ksql.api.server.QueryStreamResponseWriter;
import io.confluent.ksql.api.server.QuerySubscriber;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.api.server.ServerVerticle;
import io.confluent.ksql.api.spi.Endpoints;
import io.confluent.ksql.api.spi.QueryPublisher;
import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.rest.entity.QueryStreamArgs;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Time;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStreamHandler
implements Handler<RoutingContext> {
    private static final Logger log = LoggerFactory.getLogger(QueryStreamHandler.class);
    static final String DELIMITED_CONTENT_TYPE = "application/vnd.ksqlapi.delimited.v1";
    static final String JSON_CONTENT_TYPE = "application/json";
    static final String CONTENT_TYPE = "content-type";
    private final Endpoints endpoints;
    private final ConnectionQueryManager connectionQueryManager;
    private final Context context;
    private final Server server;
    private final boolean queryCompatibilityMode;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public QueryStreamHandler(Endpoints endpoints, ConnectionQueryManager connectionQueryManager, Context context, Server server, boolean queryCompatibilityMode) {
        this.endpoints = Objects.requireNonNull(endpoints);
        this.connectionQueryManager = Objects.requireNonNull(connectionQueryManager);
        this.context = Objects.requireNonNull(context);
        this.server = Objects.requireNonNull(server);
        this.queryCompatibilityMode = queryCompatibilityMode;
    }

    public void handle(RoutingContext routingContext) {
        if (routingContext.request().version() == HttpVersion.HTTP_1_1) {
            routingContext.response().putHeader("Transfer-Encoding", "chunked");
        } else if (routingContext.request().version() != HttpVersion.HTTP_2) {
            routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException("This endpoint is only available when using HTTP1.1 or HTTP2", Errors.ERROR_CODE_BAD_REQUEST)));
        }
        CommonRequest request = this.getRequest(routingContext);
        if (request == null) {
            return;
        }
        Optional<Boolean> internalRequest = ServerVerticle.isInternalRequest(routingContext);
        MetricsCallbackHolder metricsCallbackHolder = new MetricsCallbackHolder();
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        ((CompletableFuture)this.endpoints.createQueryPublisher(request.sql, request.configOverrides, request.sessionProperties, request.requestProperties, this.context, this.server.getWorkerExecutor(), DefaultApiSecurityContext.create(routingContext, this.server), metricsCallbackHolder, internalRequest).thenAccept(publisher -> {
            if (publisher instanceof BlockingPrintPublisher) {
                this.handlePrintPublisher(routingContext, (BlockingPrintPublisher)((Object)publisher));
            } else {
                this.handleQueryPublisher(routingContext, (QueryPublisher)publisher, metricsCallbackHolder, startTimeNanos);
            }
        })).exceptionally(t -> ServerUtils.handleEndpointException(t, routingContext, "Failed to execute query"));
    }

    private QueryStreamResponseWriter getQueryStreamResponseWriter(RoutingContext routingContext, QueryPublisher queryPublisher, Optional<String> completionMessage, Optional<String> limitMessage, boolean bufferOutput) {
        String contentType = routingContext.getAcceptableContentType();
        if (DELIMITED_CONTENT_TYPE.equals(contentType) || contentType == null && !this.queryCompatibilityMode) {
            routingContext.response().putHeader(CONTENT_TYPE, DELIMITED_CONTENT_TYPE);
            return new DelimitedQueryStreamResponseWriter(routingContext.response());
        }
        if (KsqlMediaType.KSQL_V1_PROTOBUF.mediaType().equals(contentType)) {
            routingContext.response().putHeader(CONTENT_TYPE, KsqlMediaType.KSQL_V1_PROTOBUF.mediaType());
            return new JsonStreamedRowResponseWriter(routingContext.response(), queryPublisher, completionMessage, limitMessage, Clock.systemUTC(), bufferOutput, this.context, JsonStreamedRowResponseWriter.RowFormat.PROTOBUF);
        }
        if (KsqlMediaType.KSQL_V1_JSON.mediaType().equals(contentType) || contentType == null || JSON_CONTENT_TYPE.equals(contentType) && this.queryCompatibilityMode) {
            routingContext.response().putHeader(CONTENT_TYPE, KsqlMediaType.KSQL_V1_JSON.mediaType());
            return new JsonStreamedRowResponseWriter(routingContext.response(), queryPublisher, completionMessage, limitMessage, Clock.systemUTC(), bufferOutput, this.context, JsonStreamedRowResponseWriter.RowFormat.JSON);
        }
        routingContext.response().putHeader(CONTENT_TYPE, JSON_CONTENT_TYPE);
        return new JsonQueryStreamResponseWriter(routingContext.response());
    }

    private CommonRequest getRequest(RoutingContext routingContext) {
        Map requestProperties;
        Map sessionProperties;
        Map configOverrides;
        String sql;
        if (this.queryCompatibilityMode) {
            Optional<KsqlRequest> ksqlRequest = ServerUtils.deserialiseObject(routingContext.getBody(), routingContext, KsqlRequest.class);
            if (!ksqlRequest.isPresent()) {
                return null;
            }
            ApiServerUtils.setMaskedSqlIfNeeded(ksqlRequest.get());
            sql = ksqlRequest.get().getUnmaskedKsql();
            configOverrides = ksqlRequest.get().getConfigOverrides();
            sessionProperties = ksqlRequest.get().getSessionVariables();
            requestProperties = ksqlRequest.get().getRequestProperties();
        } else {
            Optional<QueryStreamArgs> queryStreamArgs = ServerUtils.deserialiseObject(routingContext.getBody(), routingContext, QueryStreamArgs.class);
            if (!queryStreamArgs.isPresent()) {
                return null;
            }
            sql = queryStreamArgs.get().sql;
            configOverrides = queryStreamArgs.get().properties;
            sessionProperties = queryStreamArgs.get().sessionVariables;
            requestProperties = queryStreamArgs.get().requestProperties;
        }
        return new CommonRequest(sql, configOverrides, sessionProperties, requestProperties);
    }

    private void handleQueryPublisher(RoutingContext routingContext, QueryPublisher queryPublisher, MetricsCallbackHolder metricsCallbackHolder, long startTimeNanos) {
        QueryResponseMetadata metadata;
        Optional<String> completionMessage = Optional.empty();
        Optional<String> limitMessage = Optional.of("Limit Reached");
        boolean bufferOutput = false;
        AtomicBoolean endedResponse = new AtomicBoolean(false);
        if (queryPublisher.isPullQuery()) {
            metadata = new QueryResponseMetadata(queryPublisher.queryId().toString(), queryPublisher.getColumnNames(), queryPublisher.getColumnTypes(), queryPublisher.geLogicalSchema());
            limitMessage = Optional.empty();
            bufferOutput = true;
            routingContext.response().endHandler(v -> {
                if (endedResponse.getAndSet(true)) {
                    log.warn("Connection already closed so just returning");
                    return;
                }
                queryPublisher.close();
                metricsCallbackHolder.reportMetrics(routingContext.response().getStatusCode(), routingContext.request().bytesRead(), routingContext.response().bytesWritten(), startTimeNanos);
            });
        } else if (queryPublisher.isScalablePushQuery()) {
            metadata = new QueryResponseMetadata(queryPublisher.queryId().toString(), queryPublisher.getColumnNames(), queryPublisher.getColumnTypes(), this.preparePushProjectionSchema(queryPublisher.geLogicalSchema()));
            routingContext.response().endHandler(v -> {
                if (endedResponse.getAndSet(true)) {
                    log.warn("Connection already closed so just returning");
                    return;
                }
                queryPublisher.close();
                metricsCallbackHolder.reportMetrics(routingContext.response().getStatusCode(), routingContext.request().bytesRead(), routingContext.response().bytesWritten(), startTimeNanos);
            });
        } else {
            PushQueryHolder query = this.connectionQueryManager.createApiQuery(queryPublisher, routingContext.request());
            metadata = new QueryResponseMetadata(queryPublisher.queryId().toString(), queryPublisher.getColumnNames(), queryPublisher.getColumnTypes(), this.preparePushProjectionSchema(queryPublisher.geLogicalSchema()));
            completionMessage = Optional.of("Query Completed");
            routingContext.response().endHandler(v -> {
                if (endedResponse.getAndSet(true)) {
                    log.warn("Connection already closed so just returning");
                    return;
                }
                query.close();
                metricsCallbackHolder.reportMetrics(routingContext.response().getStatusCode(), routingContext.request().bytesRead(), routingContext.response().bytesWritten(), startTimeNanos);
            });
        }
        QueryStreamResponseWriter queryStreamResponseWriter = this.getQueryStreamResponseWriter(routingContext, queryPublisher, completionMessage, limitMessage, bufferOutput);
        queryStreamResponseWriter.writeMetadata(metadata);
        QuerySubscriber querySubscriber = new QuerySubscriber(this.context, routingContext.response(), queryStreamResponseWriter, queryPublisher::hitLimit);
        queryPublisher.subscribe((Subscriber)querySubscriber);
    }

    private void handlePrintPublisher(RoutingContext routingContext, BlockingPrintPublisher printPublisher) {
        String contentType = routingContext.getAcceptableContentType();
        if (!DELIMITED_CONTENT_TYPE.equals(contentType) && (contentType != null || this.queryCompatibilityMode)) {
            routingContext.response().setStatusCode(406).end();
        }
        AtomicBoolean endedResponse = new AtomicBoolean(false);
        routingContext.response().endHandler(v -> this.endhandler(printPublisher, endedResponse));
        PrintSubscriber printSubscriber = new PrintSubscriber(this.context, routingContext.response());
        printPublisher.subscribe((Subscriber)printSubscriber);
    }

    private void endhandler(BlockingPrintPublisher printPublisher, AtomicBoolean endedResponse) {
        if (endedResponse.getAndSet(true)) {
            log.warn("Connection already closed so just returning");
            return;
        }
        printPublisher.close();
    }

    private LogicalSchema preparePushProjectionSchema(LogicalSchema schema) {
        LogicalSchema.Builder projectionSchema = LogicalSchema.builder();
        schema.value().forEach(arg_0 -> ((LogicalSchema.Builder)projectionSchema).valueColumn(arg_0));
        return projectionSchema.build();
    }

    private static class CommonRequest {
        final String sql;
        final Map<String, Object> configOverrides;
        final Map<String, Object> sessionProperties;
        final Map<String, Object> requestProperties;

        CommonRequest(String sql, Map<String, Object> configOverrides, Map<String, Object> sessionProperties, Map<String, Object> requestProperties) {
            this.sql = sql;
            this.configOverrides = configOverrides;
            this.sessionProperties = sessionProperties;
            this.requestProperties = requestProperties;
        }
    }
}

