/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.function.UserFunctionLoader;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogServerUtils;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.SetProperty;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.UnsetProperty;
import io.confluent.ksql.properties.PropertyOverrider;
import io.confluent.ksql.rest.server.Executable;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.AppInfo;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.WelcomeMsgUtils;
import io.confluent.ksql.version.metrics.VersionCheckerAgent;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneExecutor
implements Executable {
    private static final Logger log = LoggerFactory.getLogger(StandaloneExecutor.class);
    private final ServiceContext serviceContext;
    private final ProcessingLogConfig processingLogConfig;
    private final KsqlConfig ksqlConfig;
    private final KsqlEngine ksqlEngine;
    private final String queriesFile;
    private final UserFunctionLoader udfLoader;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final boolean failOnNoQueries;
    private final VersionCheckerAgent versionChecker;
    private final BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory;
    private final Consumer<KsqlConfig> rocksDBConfigSetterHandler;

    StandaloneExecutor(ServiceContext serviceContext, ProcessingLogConfig processingLogConfig, KsqlConfig ksqlConfig, KsqlEngine ksqlEngine, String queriesFile, UserFunctionLoader udfLoader, boolean failOnNoQueries, VersionCheckerAgent versionChecker, BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory, MetricCollectors metricCollectors, Consumer<KsqlConfig> rocksDBConfigSetterHandler) {
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.processingLogConfig = Objects.requireNonNull(processingLogConfig, "processingLogConfig");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.queriesFile = Objects.requireNonNull(queriesFile, "queriesFile");
        this.udfLoader = Objects.requireNonNull(udfLoader, "udfLoader");
        this.failOnNoQueries = failOnNoQueries;
        this.versionChecker = Objects.requireNonNull(versionChecker, "versionChecker");
        this.injectorFactory = Objects.requireNonNull(injectorFactory, "injectorFactory");
        metricCollectors.addConfigurableReporter(ksqlConfig);
        this.rocksDBConfigSetterHandler = Objects.requireNonNull(rocksDBConfigSetterHandler, "rocksDBConfigSetter");
    }

    @Override
    public void startAsync() {
        try {
            this.udfLoader.load();
            ProcessingLogServerUtils.maybeCreateProcessingLogTopic(this.serviceContext.getTopicClient(), this.processingLogConfig, this.ksqlConfig);
            if (this.processingLogConfig.getBoolean(ProcessingLogConfig.STREAM_AUTO_CREATE).booleanValue()) {
                log.warn("processing log auto-create is enabled, but this is not supported for headless mode.");
            }
            this.rocksDBConfigSetterHandler.accept(this.ksqlConfig);
            this.processesQueryFile(StandaloneExecutor.readQueriesFile(this.queriesFile));
            this.showWelcomeMessage();
            Properties properties = new Properties();
            this.ksqlConfig.originals().forEach((key, value) -> {
                if (Objects.nonNull(value)) {
                    properties.put(key, value.toString());
                }
            });
            this.versionChecker.start(KsqlModuleType.SERVER, properties);
        }
        catch (Exception e) {
            log.error("Failed to start KSQL Server with query file: " + this.queriesFile, (Throwable)e);
            throw e;
        }
    }

    @Override
    public void notifyTerminated() {
        this.shutdownLatch.countDown();
    }

    @Override
    public void shutdown() {
        try {
            this.ksqlEngine.close();
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown the KSQL Engine", (Throwable)e);
        }
        try {
            this.serviceContext.close();
        }
        catch (Exception e) {
            log.warn("Failed to cleanly shutdown services", (Throwable)e);
        }
    }

    @Override
    public void awaitTerminated() throws InterruptedException {
        this.shutdownLatch.await();
    }

    private void showWelcomeMessage() {
        Console console = System.console();
        if (console == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        WelcomeMsgUtils.displayWelcomeMessage((int)80, (PrintWriter)writer);
        writer.printf("Server %s started with query file %s. Interactive mode is disabled.%n", AppInfo.getVersion(), this.queriesFile);
        writer.flush();
    }

    private void processesQueryFile(String queries) {
        List preparedStatements = this.ksqlEngine.parse(queries);
        this.validateStatements(preparedStatements);
        Injector injector = this.injectorFactory.apply((KsqlExecutionContext)this.ksqlEngine, this.serviceContext);
        StandaloneExecutor.executeStatements(preparedStatements, new StatementExecutor(this.serviceContext, (KsqlExecutionContext)this.ksqlEngine, injector, this.ksqlConfig));
        this.ksqlEngine.getPersistentQueries().forEach(QueryMetadata::start);
    }

    private void validateStatements(List<KsqlParser.ParsedStatement> statements) {
        KsqlExecutionContext sandboxEngine = this.ksqlEngine.createSandbox(this.serviceContext);
        Injector injector = this.injectorFactory.apply(sandboxEngine, sandboxEngine.getServiceContext());
        StatementExecutor sandboxExecutor = new StatementExecutor(sandboxEngine.getServiceContext(), sandboxEngine, injector, this.ksqlConfig);
        boolean hasQueries = StandaloneExecutor.executeStatements(statements, sandboxExecutor);
        if (this.failOnNoQueries && !hasQueries) {
            throw new KsqlException("The SQL file does not contain any persistent queries. i.e. it contains no 'INSERT INTO', 'CREATE TABLE x AS SELECT' or 'CREATE STREAM x AS SELECT' style statements.");
        }
    }

    private static boolean executeStatements(List<KsqlParser.ParsedStatement> statements, StatementExecutor executor) {
        boolean hasQueries = false;
        for (KsqlParser.ParsedStatement parsed : statements) {
            hasQueries |= executor.execute(parsed);
        }
        return hasQueries;
    }

    private static String readQueriesFile(String queryFilePath) {
        try {
            return new String(Files.readAllBytes(Paths.get(queryFilePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new KsqlException(String.format("Could not read the query file: %s. Details: %s", queryFilePath, e.getMessage()), (Throwable)e);
        }
    }

    private static final class StatementExecutor {
        private static final Map<Class<? extends Statement>, Handler<Statement>> HANDLERS = ImmutableMap.builder().put(SetProperty.class, StatementExecutor.createHandler(StatementExecutor::handleSetProperty, SetProperty.class, "SET")).put(UnsetProperty.class, StatementExecutor.createHandler(StatementExecutor::handleUnsetProperty, UnsetProperty.class, "UNSET")).put(CreateStream.class, StatementExecutor.createHandler(StatementExecutor::handleExecutableDdl, CreateStream.class, "CREATE STREAM")).put(CreateTable.class, StatementExecutor.createHandler(StatementExecutor::handleExecutableDdl, CreateTable.class, "CREATE TABLE")).put(RegisterType.class, StatementExecutor.createHandler(StatementExecutor::handleExecutableDdl, RegisterType.class, "REGISTER TYPE")).put(CreateStreamAsSelect.class, StatementExecutor.createHandler(StatementExecutor::handlePersistentQuery, CreateStreamAsSelect.class, "CREAETE STREAM AS SELECT")).put(CreateTableAsSelect.class, StatementExecutor.createHandler(StatementExecutor::handlePersistentQuery, CreateTableAsSelect.class, "CREATE TABLE AS SELECT")).put(InsertInto.class, StatementExecutor.createHandler(StatementExecutor::handlePersistentQuery, InsertInto.class, "INSERT INTO")).build();
        private static final String SUPPORTED_STATEMENTS = StatementExecutor.generateSupportedMessage();
        private final ServiceContext serviceContext;
        private final KsqlExecutionContext executionContext;
        private final Map<String, Object> configOverrides = new HashMap<String, Object>();
        private final KsqlConfig ksqlConfig;
        private final Injector injector;

        private StatementExecutor(ServiceContext serviceContext, KsqlExecutionContext executionContext, Injector injector, KsqlConfig ksqlConfig) {
            this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
            this.executionContext = Objects.requireNonNull(executionContext, "executionContext");
            this.injector = Objects.requireNonNull(injector, "injector");
            this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        }

        boolean execute(KsqlParser.ParsedStatement statement) {
            ConfiguredStatement<?> configured = this.prepare(statement);
            StatementExecutor.throwOnMissingSchema(configured);
            Handler<Statement> handler = HANDLERS.get(configured.getStatement().getClass());
            if (handler == null) {
                throw new KsqlStatementException("Unsupported statement. Only the following statements are supporting in standalone mode:" + System.lineSeparator() + SUPPORTED_STATEMENTS, statement.getMaskedStatementText());
            }
            handler.handle(this, configured);
            return configured.getStatement() instanceof QueryContainer;
        }

        private ConfiguredStatement<?> prepare(KsqlParser.ParsedStatement statement) {
            KsqlParser.PreparedStatement prepared = this.executionContext.prepare(statement);
            ConfiguredStatement configured = ConfiguredStatement.of((KsqlParser.PreparedStatement)prepared, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlConfig, this.configOverrides));
            return this.injector.inject(configured);
        }

        private static void throwOnMissingSchema(ConfiguredStatement<?> statement) {
            if (!(statement.getStatement() instanceof CreateSource)) {
                return;
            }
            CreateSource createStatement = (CreateSource)statement.getStatement();
            if (!Iterables.isEmpty((Iterable)createStatement.getElements())) {
                return;
            }
            throw new KsqlStatementException("statement does not define the schema and the supplied format does not support schema inference", statement.getMaskedStatementText());
        }

        private void handleSetProperty(ConfiguredStatement<SetProperty> statement) {
            PropertyOverrider.set(statement, this.configOverrides);
        }

        private void handleUnsetProperty(ConfiguredStatement<UnsetProperty> statement) {
            PropertyOverrider.unset(statement, this.configOverrides);
        }

        private void handleExecutableDdl(ConfiguredStatement<?> statement) {
            this.executionContext.execute(this.serviceContext, statement);
        }

        private void handlePersistentQuery(ConfiguredStatement<?> statement) {
            this.executionContext.execute(this.serviceContext, statement).getQuery().filter(q -> q instanceof PersistentQueryMetadata).orElseThrow(() -> new KsqlStatementException("Could not build the query", statement.getMaskedStatementText()));
        }

        private static String generateSupportedMessage() {
            return HANDLERS.values().stream().map(Handler::getName).sorted().collect(Collectors.joining(System.lineSeparator()));
        }

        private static <T extends Statement> Handler<Statement> createHandler(final BiConsumer<StatementExecutor, ConfiguredStatement<T>> handler, Class<T> type, final String name) {
            return new Handler<Statement>(){

                @Override
                public void handle(StatementExecutor executor, ConfiguredStatement<Statement> statement) {
                    handler.accept(executor, statement);
                }

                @Override
                public String getName() {
                    return name;
                }
            };
        }

        private static interface Handler<T extends Statement> {
            public void handle(StatementExecutor var1, ConfiguredStatement<T> var2);

            public String getName();
        }
    }
}

