/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Statement;
import java.util.List;

public class StatementParser {
    private final KsqlExecutionContext ksqlEngine;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public StatementParser(KsqlExecutionContext ksqlEngine) {
        this.ksqlEngine = ksqlEngine;
    }

    public <T extends Statement> KsqlParser.PreparedStatement<T> parseSingleStatement(String statementString) {
        List statements = this.ksqlEngine.parse(statementString);
        if (statements.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected exactly one KSQL statement; found %d instead", statements.size()));
        }
        return this.ksqlEngine.prepare((KsqlParser.ParsedStatement)statements.get(0));
    }
}

