/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.CommandTopic;
import io.confluent.ksql.rest.server.CommandTopicBackup;
import io.confluent.ksql.rest.server.CommandTopicBackupImpl;
import io.confluent.ksql.rest.server.CommandTopicBackupNoOp;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.computation.CommandStatusFuture;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.rest.server.computation.QueuedCommand;
import io.confluent.ksql.rest.server.computation.QueuedCommandStatus;
import io.confluent.ksql.rest.server.computation.SequenceNumberFutureStore;
import io.confluent.ksql.rest.util.CommandTopicBackupUtil;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.QueryMask;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandStore
implements CommandQueue,
Closeable {
    public static final Duration POLLING_TIMEOUT_FOR_COMMAND_TOPIC = Duration.ofMillis(5000L);
    private static final Logger LOG = LoggerFactory.getLogger(CommandStore.class);
    private static final int COMMAND_TOPIC_PARTITION = 0;
    private final CommandTopic commandTopic;
    private final Map<CommandId, CommandStatusFuture> commandStatusMap;
    private final SequenceNumberFutureStore sequenceNumberFutureStore;
    private final String commandTopicName;
    private final Duration commandQueueCatchupTimeout;
    private final Map<String, Object> kafkaConsumerProperties;
    private final Map<String, Object> kafkaProducerProperties;
    private final Serializer<CommandId> commandIdSerializer;
    private final Serializer<Command> commandSerializer;
    private final Deserializer<CommandId> commandIdDeserializer;
    private final CommandTopicBackup commandTopicBackup;

    CommandStore(String commandTopicName, CommandTopic commandTopic, SequenceNumberFutureStore sequenceNumberFutureStore, Map<String, Object> kafkaConsumerProperties, Map<String, Object> kafkaProducerProperties, Duration commandQueueCatchupTimeout, Serializer<CommandId> commandIdSerializer, Serializer<Command> commandSerializer, Deserializer<CommandId> commandIdDeserializer, CommandTopicBackup commandTopicBackup) {
        this.commandTopic = Objects.requireNonNull(commandTopic, "commandTopic");
        this.commandStatusMap = Maps.newConcurrentMap();
        this.sequenceNumberFutureStore = Objects.requireNonNull(sequenceNumberFutureStore, "sequenceNumberFutureStore");
        this.commandQueueCatchupTimeout = Objects.requireNonNull(commandQueueCatchupTimeout, "commandQueueCatchupTimeout");
        this.kafkaConsumerProperties = Objects.requireNonNull(kafkaConsumerProperties, "kafkaConsumerProperties");
        this.kafkaProducerProperties = Objects.requireNonNull(kafkaProducerProperties, "kafkaProducerProperties");
        this.commandTopicName = Objects.requireNonNull(commandTopicName, "commandTopicName");
        this.commandIdSerializer = Objects.requireNonNull(commandIdSerializer, "commandIdSerializer");
        this.commandSerializer = Objects.requireNonNull(commandSerializer, "commandSerializer");
        this.commandIdDeserializer = Objects.requireNonNull(commandIdDeserializer, "commandIdDeserializer");
        this.commandTopicBackup = Objects.requireNonNull(commandTopicBackup, "commandTopicBackup");
    }

    @Override
    public void wakeup() {
        this.commandTopic.wakeup();
    }

    public String getCommandTopicName() {
        return this.commandTopic.getCommandTopicName();
    }

    public void start() {
        this.commandTopic.start();
    }

    @Override
    public void close() {
        this.commandTopic.close();
    }

    @Override
    public QueuedCommandStatus enqueueCommand(CommandId commandId, Command command, Producer<CommandId, Command> transactionalProducer) {
        CommandStatusFuture statusFuture = this.commandStatusMap.compute(commandId, (k, v) -> {
            if (v == null) {
                return new CommandStatusFuture(commandId);
            }
            throw new IllegalStateException(String.format("Another command with the same id (%s) is being executed.", commandId));
        });
        try {
            ProducerRecord producerRecord = new ProducerRecord(this.commandTopicName, Integer.valueOf(0), (Object)commandId, (Object)command);
            RecordMetadata recordMetadata = (RecordMetadata)transactionalProducer.send(producerRecord).get();
            return new QueuedCommandStatus(recordMetadata.offset(), statusFuture);
        }
        catch (Exception e) {
            this.commandStatusMap.remove(commandId);
            throw new KsqlStatementException("Could not write the statement into the command topic.", String.format("Could not write the statement '%s' into the command topic.", QueryMask.getMaskedStatement((String)command.getStatement())), QueryMask.getMaskedStatement((String)command.getStatement()), KsqlStatementException.Problem.OTHER, (Throwable)e);
        }
    }

    @Override
    public List<QueuedCommand> getNewCommands(Duration timeout) {
        this.completeSatisfiedSequenceNumberFutures();
        ArrayList commands = Lists.newArrayList();
        Iterable<ConsumerRecord<byte[], byte[]>> records = this.commandTopic.getNewCommands(timeout);
        for (ConsumerRecord<byte[], byte[]> record : records) {
            if (record.value() == null) continue;
            Optional<CommandStatusFuture> commandStatusFuture = Optional.empty();
            try {
                CommandId commandId = (CommandId)this.commandIdDeserializer.deserialize(this.commandTopicName, (byte[])record.key());
                commandStatusFuture = Optional.ofNullable(this.commandStatusMap.remove(commandId));
            }
            catch (Exception e) {
                LOG.warn("Error while attempting to fetch from commandStatusMap for key {}", record.key(), (Object)e);
            }
            commands.add(new QueuedCommand((byte[])record.key(), (byte[])record.value(), commandStatusFuture, (Long)record.offset()));
        }
        return commands;
    }

    @Override
    public List<QueuedCommand> getRestoreCommands() {
        return this.commandTopic.getRestoreCommands(POLLING_TIMEOUT_FOR_COMMAND_TOPIC);
    }

    @Override
    public void ensureConsumedPast(long seqNum, Duration timeout) throws InterruptedException, TimeoutException {
        CompletableFuture<Void> future = this.sequenceNumberFutureStore.getFutureForSequenceNumber(seqNum);
        try {
            future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("Error waiting for command sequence number of " + seqNum, e.getCause());
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Timeout reached while waiting for command sequence number of %d. Caused by: %s (Timeout: %d ms)", seqNum, e.getMessage(), timeout.toMillis()));
        }
    }

    @Override
    public Producer<CommandId, Command> createTransactionalProducer() {
        return new KafkaProducer(this.kafkaProducerProperties, this.commandIdSerializer, this.commandSerializer);
    }

    @Override
    public void abortCommand(CommandId commandId) {
        this.commandStatusMap.compute(commandId, (k, v) -> {
            if (v != null) {
                LOG.info("Aborting existing command {}", (Object)commandId);
            }
            return null;
        });
    }

    @Override
    public void waitForCommandConsumer() {
        try {
            long endOffset = this.getCommandTopicOffset();
            this.ensureConsumedPast(endOffset - 1L, this.commandQueueCatchupTimeout);
        }
        catch (InterruptedException e) {
            String errorMsg = "Interrupted while waiting for command topic consumer to process command topic";
            throw new KsqlServerException("Interrupted while waiting for command topic consumer to process command topic");
        }
        catch (TimeoutException e) {
            String errorMsg = "Timeout while waiting for command topic consumer to process command topic";
            throw new KsqlServerException("Timeout while waiting for command topic consumer to process command topic");
        }
    }

    private long getCommandTopicOffset() {
        TopicPartition commandTopicPartition = new TopicPartition(this.commandTopicName, 0);
        try (KafkaConsumer commandConsumer = new KafkaConsumer(this.kafkaConsumerProperties, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            commandConsumer.assign(Collections.singleton(commandTopicPartition));
            long l = (Long)commandConsumer.endOffsets(Collections.singletonList(commandTopicPartition)).get(commandTopicPartition);
            return l;
        }
    }

    @Override
    public boolean corruptionDetected() {
        return this.commandTopicBackup.commandTopicCorruption();
    }

    @Override
    public boolean isEmpty() {
        return this.commandTopic.getEndOffset() == 0L;
    }

    private void completeSatisfiedSequenceNumberFutures() {
        this.sequenceNumberFutureStore.completeFuturesUpToAndIncludingSequenceNumber(this.commandTopic.getCommandTopicConsumerPosition() - 1L);
    }

    public static final class Factory {
        private Factory() {
        }

        public static CommandStore create(KsqlConfig ksqlConfig, String commandTopicName, Duration commandQueueCatchupTimeout, Map<String, Object> kafkaConsumerProperties, Map<String, Object> kafkaProducerProperties, KafkaTopicClient internalTopicClient) {
            kafkaConsumerProperties.put("isolation.level", IsolationLevel.READ_COMMITTED.toString().toLowerCase(Locale.ROOT));
            kafkaConsumerProperties.put("auto.offset.reset", "none");
            kafkaProducerProperties.put("transactional.id", ksqlConfig.getString("ksql.service.id"));
            kafkaProducerProperties.put("acks", "all");
            CommandTopicBackup commandTopicBackup = new CommandTopicBackupNoOp();
            if (!CommandTopicBackupUtil.backupLocation(ksqlConfig).isEmpty()) {
                commandTopicBackup = new CommandTopicBackupImpl(CommandTopicBackupUtil.backupLocation(ksqlConfig), commandTopicName, internalTopicClient);
            }
            return new CommandStore(commandTopicName, new CommandTopic(commandTopicName, kafkaConsumerProperties, commandTopicBackup), new SequenceNumberFutureStore(), kafkaConsumerProperties, kafkaProducerProperties, commandQueueCatchupTimeout, InternalTopicSerdes.serializer(), InternalTopicSerdes.serializer(), InternalTopicSerdes.deserializer(CommandId.class), commandTopicBackup);
        }
    }
}

