/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=StringKey.class, name="string")})
abstract class ConfigTopicKey {
    ConfigTopicKey() {
    }

    public static class StringKey
    extends ConfigTopicKey {
        private final String value;

        StringKey(@JsonProperty(value="value") String value) {
            this.value = Objects.requireNonNull(value, "value");
            if (this.value.isEmpty()) {
                throw new IllegalArgumentException("StringKey value must not be empty");
            }
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringKey stringKey = (StringKey)o;
            return Objects.equals(this.value, stringKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

