/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.CommandStatusFuture;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Deserializer;

public class QueuedCommand {
    private final byte[] commandId;
    private final byte[] command;
    private final Optional<CommandStatusFuture> status;
    private final Long offset;

    @VisibleForTesting
    public QueuedCommand(CommandId commandId, Command command, Optional<CommandStatusFuture> status, Long offset) {
        this(InternalTopicSerdes.serializer().serialize("", (Object)commandId), InternalTopicSerdes.serializer().serialize("", (Object)command), status, offset);
    }

    public QueuedCommand(byte[] commandId, byte[] command, Optional<CommandStatusFuture> status, Long offset) {
        this.commandId = Objects.requireNonNull(commandId, "commandId");
        this.command = Objects.requireNonNull(command, "command");
        this.status = Objects.requireNonNull(status, "status");
        this.offset = Objects.requireNonNull(offset, "offset");
    }

    public byte[] getCommandId() {
        return Arrays.copyOf(this.commandId, this.commandId.length);
    }

    public byte[] getCommand() {
        return Arrays.copyOf(this.command, this.command.length);
    }

    public CommandId getAndDeserializeCommandId() {
        return (CommandId)InternalTopicSerdes.deserializer(CommandId.class).deserialize("", this.commandId);
    }

    public Command getAndDeserializeCommand(Deserializer<Command> deserializer) {
        return (Command)deserializer.deserialize("", this.command);
    }

    public Optional<CommandStatusFuture> getStatus() {
        return this.status;
    }

    public Long getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueuedCommand that = (QueuedCommand)o;
        return Arrays.equals(this.commandId, that.commandId) && Arrays.equals(this.command, that.command) && Objects.equals(this.status, that.status) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.commandId, this.command, this.status, this.offset);
    }
}

