/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.engine.QueryPlan;
import io.confluent.ksql.execution.ddl.commands.CreateSourceCommand;
import io.confluent.ksql.execution.ddl.commands.DdlCommand;
import io.confluent.ksql.execution.ddl.commands.DropSourceCommand;
import io.confluent.ksql.logging.query.QueryLogger;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.rest.server.computation.QueuedCommand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestoreCommandsCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreCommandsCompactor.class);

    private RestoreCommandsCompactor() {
    }

    static List<QueuedCommand> compact(List<QueuedCommand> restoreCommands) {
        HashMap<QueryId, CompactedNode> latestNodeWithId = new HashMap<QueryId, CompactedNode>();
        HashMap<SourceName, QueryId> latestCreateAsWithId = new HashMap<SourceName, QueryId>();
        CompactedNode current = null;
        HashSet<SourceName> createAsIfNotExistsBugDetection = new HashSet<SourceName>();
        for (QueuedCommand cmd2 : restoreCommands) {
            current = CompactedNode.maybeAppend(current, cmd2, latestNodeWithId, latestCreateAsWithId, createAsIfNotExistsBugDetection);
        }
        LinkedList<QueuedCommand> compacted = new LinkedList<QueuedCommand>();
        while (current != null) {
            RestoreCommandsCompactor.compact(current).ifPresent(cmd -> compacted.add(0, (QueuedCommand)cmd));
            current = current.prev;
        }
        return compacted;
    }

    private static Optional<QueuedCommand> compact(CompactedNode node) {
        Command command = node.command;
        if (!node.shouldSkip) {
            return Optional.of(node.queued);
        }
        if (!command.getPlan().isPresent() || !command.getPlan().get().getDdlCommand().isPresent()) {
            return Optional.empty();
        }
        Command newCommand = new Command(command.getStatement(), Optional.of(command.getOverwriteProperties()), Optional.of(command.getOriginalProperties()), command.getPlan().map(KsqlPlan::withoutQuery), command.getVersion());
        return Optional.of(new QueuedCommand(InternalTopicSerdes.serializer().serialize("", (Object)node.queued.getAndDeserializeCommandId()), InternalTopicSerdes.serializer().serialize("", (Object)newCommand), node.queued.getStatus(), node.queued.getOffset()));
    }

    private static final class CompactedNode {
        final CompactedNode prev;
        final QueuedCommand queued;
        final Command command;
        boolean shouldSkip = false;

        public static CompactedNode maybeAppend(CompactedNode prev, QueuedCommand queued, Map<QueryId, CompactedNode> latestNodeWithId, Map<SourceName, QueryId> latestCreateAsWithId, Set<SourceName> createAsIfNotExistsBugDetection) {
            Command command = queued.getAndDeserializeCommand(InternalTopicSerdes.deserializer(Command.class));
            Optional<KsqlPlan> plan = command.getPlan();
            Optional ddlCommand = plan.flatMap(p -> p.getDdlCommand());
            if (queued.getAndDeserializeCommandId().getType() == CommandId.Type.TERMINATE) {
                QueryId queryId = new QueryId(queued.getAndDeserializeCommandId().getEntity());
                if (queryId.toString().equals("ALL")) {
                    latestNodeWithId.values().forEach(node -> {
                        node.shouldSkip = true;
                    });
                } else {
                    CompactedNode.markShouldSkip(queryId, latestNodeWithId);
                }
                return prev;
            }
            if (!plan.isPresent() || !plan.get().getQueryPlan().isPresent()) {
                ddlCommand.ifPresent(ddl -> CompactedNode.getDropSourceName(ddl).ifPresent(sourceName -> {
                    QueryId queryId = (QueryId)latestCreateAsWithId.get(sourceName);
                    if (queryId != null) {
                        CompactedNode.markShouldSkip(queryId, latestNodeWithId);
                        createAsIfNotExistsBugDetection.remove(sourceName);
                    }
                }));
                return new CompactedNode(prev, queued, command);
            }
            CompactedNode node2 = new CompactedNode(prev, queued, command);
            QueryId queryId = ((QueryPlan)plan.get().getQueryPlan().get()).getQueryId();
            CompactedNode.markShouldSkip(queryId, latestNodeWithId);
            latestNodeWithId.put(queryId, node2);
            ddlCommand.ifPresent(ddl -> CompactedNode.getCreateSourceName(ddl).ifPresent(sourceName -> {
                CreateSourceCommand createCommand = (CreateSourceCommand)ddl;
                if (!createCommand.isOrReplace().booleanValue() && CompactedNode.isCreateIfNotExists(command) && createAsIfNotExistsBugDetection.contains(sourceName)) {
                    QueryLogger.warn((Object)"A known bug is found while restoring the command topic. The restoring process will continue, but the query of the affected stream or table won't be executed until https://github.com/confluentinc/ksql/issues/8173 is fixed.", (String)command.getStatement());
                }
                createAsIfNotExistsBugDetection.add((SourceName)sourceName);
                latestCreateAsWithId.put((SourceName)sourceName, queryId);
            }));
            return node2;
        }

        private static boolean isCreateIfNotExists(Command command) {
            String statement = command.getStatement().toUpperCase();
            return statement.startsWith("CREATE STREAM IF NOT EXISTS") || statement.startsWith("CREATE TABLE IF NOT EXISTS");
        }

        private static Optional<SourceName> getCreateSourceName(DdlCommand ddlCommand) {
            if (ddlCommand instanceof CreateSourceCommand) {
                return Optional.of(((CreateSourceCommand)ddlCommand).getSourceName());
            }
            return Optional.empty();
        }

        private static Optional<SourceName> getDropSourceName(DdlCommand ddlCommand) {
            if (ddlCommand instanceof DropSourceCommand) {
                return Optional.of(((DropSourceCommand)ddlCommand).getSourceName());
            }
            return Optional.empty();
        }

        private static void markShouldSkip(QueryId queryId, Map<QueryId, CompactedNode> latestNodeWithId) {
            CompactedNode prevWithID = latestNodeWithId.get(queryId);
            if (prevWithID != null) {
                prevWithID.shouldSkip = true;
            }
        }

        private CompactedNode(@Nullable CompactedNode prev, QueuedCommand queued, Command command) {
            this.prev = prev;
            this.queued = queued;
            this.command = command;
        }
    }
}

