/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.ListConnectors;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import io.confluent.ksql.rest.entity.ConnectorList;
import io.confluent.ksql.rest.entity.ConnectorStateInfo;
import io.confluent.ksql.rest.entity.ConnectorType;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.SimpleConnectorInfo;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ListConnectorsExecutor {
    private ListConnectorsExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListConnectors> configuredStatement, SessionProperties sessionProperties, KsqlExecutionContext ksqlExecutionContext, ServiceContext serviceContext) {
        ConnectClient connectClient = serviceContext.getConnectClient();
        ConnectClient.ConnectResponse connectors = serviceContext.getConnectClient().connectors();
        if (connectors.error().isPresent()) {
            String errorMsg = "Failed to list connectors: " + (String)connectors.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(connectors.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)connectors.httpCode()), errorMsg)).build());
        }
        ArrayList<SimpleConnectorInfo> infos = new ArrayList<SimpleConnectorInfo>();
        ArrayList<KsqlWarning> warnings = new ArrayList<KsqlWarning>();
        ListConnectors.Scope scope = ((ListConnectors)configuredStatement.getStatement()).getScope();
        for (String name : (List)connectors.datum().get()) {
            ConnectClient.ConnectResponse response = connectClient.describe(name);
            if (response.datum().filter(i -> ListConnectorsExecutor.inScope(i.type(), scope)).isPresent()) {
                ConnectClient.ConnectResponse status = connectClient.status(name);
                infos.add(ListConnectorsExecutor.fromConnectorInfoResponse(name, (ConnectClient.ConnectResponse<ConnectorInfo>)response, (ConnectClient.ConnectResponse<ConnectorStateInfo>)status));
                continue;
            }
            if (!response.error().isPresent()) continue;
            if (scope == ListConnectors.Scope.ALL) {
                infos.add(new SimpleConnectorInfo(name, ConnectorType.UNKNOWN, null, null));
            }
            warnings.add(new KsqlWarning(String.format("Could not describe connector %s: %s", name, response.error().get())));
        }
        return StatementExecutorResponse.handled(Optional.of(new ConnectorList(configuredStatement.getMaskedStatementText(), warnings, infos)));
    }

    private static boolean inScope(ConnectorType type, ListConnectors.Scope scope) {
        switch (scope) {
            case SOURCE: {
                return type == ConnectorType.SOURCE;
            }
            case SINK: {
                return type == ConnectorType.SINK;
            }
            case ALL: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected scope: " + scope);
    }

    private static SimpleConnectorInfo fromConnectorInfoResponse(String name, ConnectClient.ConnectResponse<ConnectorInfo> response, ConnectClient.ConnectResponse<ConnectorStateInfo> status) {
        if (response.error().isPresent() || status.error().isPresent()) {
            return new SimpleConnectorInfo(name, null, null, ((ConnectorStateInfo)status.datum().get()).connector().state());
        }
        ConnectorInfo info = (ConnectorInfo)response.datum().get();
        return new SimpleConnectorInfo(name, info.type(), (String)info.config().get("connector.class"), ListConnectorsExecutor.summarizeState((ConnectorStateInfo)status.datum().get()));
    }

    private static String summarizeState(ConnectorStateInfo connectorState) {
        if (!connectorState.connector().state().equals("RUNNING")) {
            return connectorState.connector().state();
        }
        long numRunningTasks = connectorState.tasks().stream().map(ConnectorStateInfo.AbstractState::state).filter("RUNNING"::equals).count();
        String status = connectorState.tasks().size() > 0 && numRunningTasks == 0L ? "WARNING" : "RUNNING";
        return String.format("%s (%s/%s tasks RUNNING)", status, numRunningTasks, connectorState.tasks().size());
    }
}

