/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.ListQueries;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.Queries;
import io.confluent.ksql.rest.entity.QueryDescription;
import io.confluent.ksql.rest.entity.QueryDescriptionFactory;
import io.confluent.ksql.rest.entity.QueryDescriptionList;
import io.confluent.ksql.rest.entity.QueryStatusCount;
import io.confluent.ksql.rest.entity.RunningQuery;
import io.confluent.ksql.rest.server.execution.RemoteHostExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.state.HostInfo;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class ListQueriesExecutor {
    private ListQueriesExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListQueries> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        RemoteHostExecutor remoteHostExecutor = RemoteHostExecutor.create(statement, sessionProperties, executionContext, serviceContext.getKsqlClient());
        return ((ListQueries)statement.getStatement()).getShowExtended() ? ListQueriesExecutor.executeExtended(statement, sessionProperties, executionContext, remoteHostExecutor) : ListQueriesExecutor.executeSimple(statement, executionContext, remoteHostExecutor);
    }

    private static StatementExecutorResponse executeSimple(ConfiguredStatement<ListQueries> statement, KsqlExecutionContext executionContext, RemoteHostExecutor remoteHostExecutor) {
        Map<QueryId, RunningQuery> runningQueries = ListQueriesExecutor.mergeSimple(ListQueriesExecutor.getLocalSimple(executionContext), remoteHostExecutor.fetchAllRemoteResults());
        return StatementExecutorResponse.handled(Optional.of(new Queries(statement.getMaskedStatementText(), runningQueries.values())));
    }

    private static Map<QueryId, RunningQuery> getLocalSimple(KsqlExecutionContext executionContext) {
        return executionContext.getAllLiveQueries().stream().collect(Collectors.toMap(QueryMetadata::getQueryId, q -> {
            if (q instanceof PersistentQueryMetadata) {
                PersistentQueryMetadata persistentQuery = (PersistentQueryMetadata)q;
                return new RunningQuery(q.getStatementString(), (Set)(persistentQuery.getSinkName().isPresent() ? ImmutableSet.of((Object)((SourceName)persistentQuery.getSinkName().get()).text()) : ImmutableSet.of()), (Set)(persistentQuery.getResultTopic().isPresent() ? ImmutableSet.of((Object)((KsqlTopic)persistentQuery.getResultTopic().get()).getKafkaTopicName()) : ImmutableSet.of()), q.getQueryId(), new QueryStatusCount(Collections.singletonMap(q.getQueryStatus(), 1)), q.getQueryType());
            }
            return new RunningQuery(q.getStatementString(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), q.getQueryId(), new QueryStatusCount(Collections.singletonMap(q.getQueryStatus(), 1)), q.getQueryType());
        }));
    }

    private static Map<QueryId, RunningQuery> mergeSimple(Map<QueryId, RunningQuery> allResults, Pair<Map<HostInfo, KsqlEntity>, Set<HostInfo>> remoteResults) {
        List remoteRunningQueries = ((Map)remoteResults.getLeft()).values().stream().map(Queries.class::cast).map(Queries::getQueries).flatMap(Collection::stream).collect(Collectors.toList());
        for (RunningQuery q : remoteRunningQueries) {
            QueryId queryId = q.getId();
            if (allResults.containsKey(queryId)) {
                for (Map.Entry entry : q.getStatusCount().getStatuses().entrySet()) {
                    allResults.get(queryId).getStatusCount().updateStatusCount((KsqlConstants.KsqlQueryStatus)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                continue;
            }
            allResults.put(queryId, q);
        }
        Set unresponsiveRemoteHosts = (Set)remoteResults.getRight();
        if (!unresponsiveRemoteHosts.isEmpty()) {
            for (RunningQuery runningQuery : allResults.values()) {
                runningQuery.getStatusCount().updateStatusCount(KsqlConstants.KsqlQueryStatus.UNRESPONSIVE, unresponsiveRemoteHosts.size());
            }
        }
        return allResults;
    }

    private static StatementExecutorResponse executeExtended(ConfiguredStatement<ListQueries> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, RemoteHostExecutor remoteHostExecutor) {
        Map<QueryId, QueryDescription> queryDescriptions = ListQueriesExecutor.mergeExtended(ListQueriesExecutor.getLocalExtended(sessionProperties, executionContext), remoteHostExecutor.fetchAllRemoteResults());
        return StatementExecutorResponse.handled(Optional.of(new QueryDescriptionList(statement.getMaskedStatementText(), queryDescriptions.values())));
    }

    private static Map<QueryId, QueryDescription> getLocalExtended(SessionProperties sessionProperties, KsqlExecutionContext executionContext) {
        return executionContext.getAllLiveQueries().stream().collect(Collectors.toMap(QueryMetadata::getQueryId, query -> QueryDescriptionFactory.forQueryMetadata(query, Collections.singletonMap(new KsqlHostInfoEntity(sessionProperties.getKsqlHostInfo()), query.getQueryStatus()))));
    }

    private static Map<QueryId, QueryDescription> mergeExtended(Map<QueryId, QueryDescription> allResults, Pair<Map<HostInfo, KsqlEntity>, Set<HostInfo>> remoteResults) {
        List remoteQueryDescriptions = ((Map)remoteResults.getLeft()).values().stream().map(QueryDescriptionList.class::cast).map(QueryDescriptionList::getQueryDescriptions).flatMap(Collection::stream).collect(Collectors.toList());
        for (QueryDescription q : remoteQueryDescriptions) {
            QueryId queryId = q.getId();
            if (allResults.containsKey(queryId)) {
                for (Map.Entry entry : q.getKsqlHostQueryStatus().entrySet()) {
                    allResults.get(queryId).updateKsqlHostQueryStatus((KsqlHostInfoEntity)entry.getKey(), (KsqlConstants.KsqlQueryStatus)entry.getValue());
                }
                allResults.get(queryId).updateTaskMetadata((Set)q.getTasksMetadata());
                continue;
            }
            allResults.put(queryId, q);
        }
        Set unresponsiveRemoteHosts = (Set)remoteResults.getRight();
        for (HostInfo hostInfo : unresponsiveRemoteHosts) {
            for (QueryDescription queryDescription : allResults.values()) {
                queryDescription.updateKsqlHostQueryStatus(new KsqlHostInfoEntity(hostInfo.host(), hostInfo.port()), KsqlConstants.KsqlQueryStatus.UNRESPONSIVE);
            }
        }
        return allResults;
    }
}

