/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.server.computation.DistributingExecutor;
import io.confluent.ksql.rest.server.execution.CommandQueueSync;
import io.confluent.ksql.rest.server.execution.StatementExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.util.FeatureFlagChecker;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RequestHandler {
    private final Map<Class<? extends Statement>, StatementExecutor<?>> customExecutors;
    private final KsqlExecutionContext ksqlEngine;
    private final DistributingExecutor distributor;
    private final CommandQueueSync commandQueueSync;

    public RequestHandler(Map<Class<? extends Statement>, StatementExecutor<?>> customExecutors, DistributingExecutor distributor, KsqlExecutionContext ksqlEngine, CommandQueueSync commandQueueSync) {
        this.customExecutors = Objects.requireNonNull(customExecutors, "customExecutors");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.distributor = Objects.requireNonNull(distributor, "distributor");
        this.commandQueueSync = Objects.requireNonNull(commandQueueSync, "commandQueueSync");
    }

    private boolean isVariableSubstitutionEnabled(SessionProperties sessionProperties) {
        Object substitutionEnabled = sessionProperties.getMutableScopedProperties().get("ksql.variable.substitution.enable");
        if (substitutionEnabled != null && substitutionEnabled instanceof Boolean) {
            return (Boolean)substitutionEnabled;
        }
        return this.ksqlEngine.getKsqlConfig().getBoolean("ksql.variable.substitution.enable");
    }

    public KsqlEntityList execute(KsqlSecurityContext securityContext, List<KsqlParser.ParsedStatement> statements, SessionProperties sessionProperties) {
        KsqlEntityList entities = new KsqlEntityList();
        for (KsqlParser.ParsedStatement parsed : statements) {
            KsqlParser.PreparedStatement prepared = this.ksqlEngine.prepare(parsed, this.isVariableSubstitutionEnabled(sessionProperties) ? sessionProperties.getSessionVariables() : Collections.emptyMap());
            this.executeStatement(securityContext, prepared, sessionProperties, entities).ifPresent(arg_0 -> entities.add(arg_0));
        }
        return entities;
    }

    private <T extends Statement> Optional<KsqlEntity> executeStatement(KsqlSecurityContext securityContext, KsqlParser.PreparedStatement<T> prepared, SessionProperties sessionProperties, KsqlEntityList entities) {
        Class<?> statementClass = prepared.getStatement().getClass();
        this.commandQueueSync.waitFor(new KsqlEntityList((Collection)entities), statementClass);
        ConfiguredStatement configured = ConfiguredStatement.of(prepared, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlEngine.getKsqlConfig(), (Map)sessionProperties.getMutableScopedProperties()));
        FeatureFlagChecker.throwOnDisabledFeatures(configured);
        StatementExecutor executor = this.customExecutors.getOrDefault(statementClass, (stmt, props, ctx, svcCtx) -> this.distributor.execute((ConfiguredStatement<? extends Statement>)stmt, ctx, securityContext));
        StatementExecutorResponse response = executor.execute(configured, sessionProperties, this.ksqlEngine, securityContext.getServiceContext());
        if (response.isHandled()) {
            return response.getEntity();
        }
        return this.distributor.execute((ConfiguredStatement<? extends Statement>)configured, this.ksqlEngine, securityContext).getEntity();
    }
}

