/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.TerminateQueryEntity;
import io.confluent.ksql.rest.server.execution.RemoteHostExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Map;
import java.util.Optional;

public final class TerminateQueryExecutor {
    private TerminateQueryExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<TerminateQuery> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        TerminateQuery terminateQuery = (TerminateQuery)statement.getStatement();
        if (!terminateQuery.getQueryId().isPresent()) {
            return StatementExecutorResponse.notHandled();
        }
        QueryId queryId = (QueryId)terminateQuery.getQueryId().get();
        RemoteHostExecutor remoteHostExecutor = RemoteHostExecutor.create(statement, sessionProperties, executionContext, serviceContext.getKsqlClient());
        if (executionContext.getPersistentQuery(queryId).isPresent() || statement.getUnMaskedStatementText().equals("TERMINATE CLUSTER;")) {
            return StatementExecutorResponse.notHandled();
        }
        if (executionContext.getQuery(queryId).isPresent()) {
            ((QueryMetadata)executionContext.getQuery(queryId).get()).close();
        } else {
            boolean wasTerminatedRemotely = ((Map)remoteHostExecutor.fetchAllRemoteResults().getLeft()).values().stream().map(TerminateQueryEntity.class::cast).map(TerminateQueryEntity::getWasTerminated).anyMatch(b -> b.equals(true));
            if (!wasTerminatedRemotely) {
                throw new KsqlException(String.format("Failed to terminate query with query ID: '%s'", queryId));
            }
        }
        return StatementExecutorResponse.handled(Optional.of(new TerminateQueryEntity(statement.getMaskedStatementText(), queryId.toString(), true)));
    }
}

