/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.HeartbeatMessage;
import io.confluent.ksql.rest.entity.HeartbeatResponse;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.server.HeartbeatAgent;
import io.confluent.ksql.util.KsqlHostInfo;

public class HeartbeatResource {
    private final HeartbeatAgent heartbeatAgent;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public HeartbeatResource(HeartbeatAgent heartbeatAgent) {
        this.heartbeatAgent = heartbeatAgent;
    }

    public EndpointResponse registerHeartbeat(HeartbeatMessage request) {
        this.handleHeartbeat(request);
        return EndpointResponse.ok((Object)new HeartbeatResponse(true));
    }

    private void handleHeartbeat(HeartbeatMessage request) {
        KsqlHostInfoEntity ksqlHostInfoEntity = request.getHostInfo();
        KsqlHostInfo ksqlHostInfo = new KsqlHostInfo(ksqlHostInfoEntity.getHost(), ksqlHostInfoEntity.getPort());
        long timestamp = request.getTimestamp();
        this.heartbeatAgent.receiveHeartbeat(ksqlHostInfo, timestamp);
    }
}

