/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.CommandStatuses;
import io.confluent.ksql.rest.server.computation.InteractiveStatementExecutor;
import java.util.Optional;

public class StatusResource {
    private final InteractiveStatementExecutor statementExecutor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public StatusResource(InteractiveStatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    public EndpointResponse getAllStatuses() {
        return EndpointResponse.ok((Object)CommandStatuses.fromFullStatuses(this.statementExecutor.getStatuses()));
    }

    public EndpointResponse getStatus(String type, String entity, String action) {
        CommandId commandId = new CommandId(type, entity, action);
        Optional<CommandStatus> commandStatus = this.statementExecutor.getStatus(commandId);
        return commandStatus.map(EndpointResponse::ok).orElseGet(() -> Errors.notFound((String)"Command not found"));
    }
}

