/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class PollingSubscription<T>
implements Flow.Subscription {
    private static final int BACKOFF_DELAY_MS = 100;
    private final Flow.Subscriber<T> subscriber;
    private final ListeningScheduledExecutorService exec;
    private final LogicalSchema schema;
    private boolean needsSchema = true;
    private volatile boolean done = false;
    private Throwable exception = null;
    private boolean draining = false;
    private volatile ListenableFuture<?> future;

    public PollingSubscription(ListeningScheduledExecutorService exec, Flow.Subscriber<T> subscriber, LogicalSchema schema) {
        this.exec = Objects.requireNonNull(exec, "exec");
        this.subscriber = Objects.requireNonNull(subscriber, "subscriber");
        this.schema = schema;
    }

    @Override
    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.exec.submit(this::close);
    }

    @Override
    public void request(long n) {
        Preconditions.checkArgument((n == 1L ? 1 : 0) != 0, (Object)"number of requested items must be 1");
        if (this.needsSchema) {
            if (this.schema != null) {
                this.subscriber.onSchema(this.schema);
            }
            this.needsSchema = false;
        }
        if (!this.draining) {
            this.future = this.exec.submit(() -> {
                T item;
                if (this.done) {
                    this.draining = true;
                }
                if ((item = this.poll()) == null) {
                    if (!this.draining) {
                        this.future = this.exec.schedule(() -> this.request(1L), 100L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    this.subscriber.onNext(item);
                }
                if (this.draining) {
                    this.close();
                    if (this.exception != null) {
                        this.subscriber.onError(this.exception);
                    } else {
                        this.subscriber.onComplete();
                    }
                }
            });
        }
    }

    protected void setError(Throwable e) {
        this.exception = e;
        this.done = true;
    }

    protected void setDone() {
        this.done = true;
    }

    abstract T poll();

    abstract void close();
}

