/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.ksql.serde.json.KsqlJsonDeserializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.Windowed;

public final class RecordFormatter {
    private static final DateTimeFormatter DATA_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS z").withZone(ZoneOffset.UTC);
    private static final long DEFAULT_WINDOW_SIZE = 1L;
    private final Deserializers keyDeserializers;
    private final Deserializers valueDeserializers;

    public RecordFormatter(SchemaRegistryClient schemaRegistryClient, String topicName) {
        this(new Deserializers(topicName, schemaRegistryClient, true), new Deserializers(topicName, schemaRegistryClient, false));
    }

    @VisibleForTesting
    RecordFormatter(Deserializers keyDeserializers, Deserializers valueDeserializers) {
        this.keyDeserializers = Objects.requireNonNull(keyDeserializers, "keyDeserializers");
        this.valueDeserializers = Objects.requireNonNull(valueDeserializers, "valueDeserializers");
    }

    public List<String> format(Iterable<ConsumerRecord<Bytes, Bytes>> records) {
        String activeKeyFormat = this.keyDeserializers.getPossibleFormats().get(0);
        String activeValueFormat = this.valueDeserializers.getPossibleFormats().get(0);
        List<String> formatted = this.formatRecords(records);
        boolean sameKeyFormatChanged = this.keyDeserializers.getPossibleFormats().stream().anyMatch(activeKeyFormat::equals);
        boolean sameValueFormatChanged = this.valueDeserializers.getPossibleFormats().stream().anyMatch(activeValueFormat::equals);
        if (sameKeyFormatChanged && sameValueFormatChanged) {
            return formatted;
        }
        return this.formatRecords(records);
    }

    public List<String> getPossibleKeyFormats() {
        return this.keyDeserializers.getPossibleFormats();
    }

    public List<String> getPossibleValueFormats() {
        return this.valueDeserializers.getPossibleFormats();
    }

    private List<String> formatRecords(Iterable<ConsumerRecord<Bytes, Bytes>> records) {
        return StreamSupport.stream(records.spliterator(), false).map(this::formatRecord).collect(Collectors.toList());
    }

    private String formatRecord(ConsumerRecord<Bytes, Bytes> record) {
        return "rowtime: " + RecordFormatter.formatRowTime(record.timestamp()) + ", key: " + this.keyDeserializers.format((Bytes)record.key()) + ", value: " + this.valueDeserializers.format((Bytes)record.value()) + ", partition: " + record.partition();
    }

    private static String formatRowTime(long timestamp) {
        return timestamp == -1L ? "N/A" : DATA_FORMATTER.format(Instant.ofEpochMilli(timestamp));
    }

    private static Deserializer<?> newProtobufDeserializer(SchemaRegistryClient srClient) {
        TextFormat.Printer printer = TextFormat.printer();
        KafkaProtobufDeserializer inner = new KafkaProtobufDeserializer(srClient);
        return (topic, data) -> {
            Message msg = inner.deserialize(topic, data);
            if (msg == null) {
                return null;
            }
            return printer.shortDebugString((MessageOrBuilder)msg);
        };
    }

    private static Deserializer<?> newJsonDeserializer() {
        String replacement = StandardCharsets.UTF_8.newDecoder().replacement();
        return (topic, data) -> {
            if (data.length == 0) {
                throw new DeserializationException("Empty data");
            }
            String text = new String(data, StandardCharsets.UTF_8);
            if (text.contains(replacement)) {
                throw new DeserializationException("String contains replacement char");
            }
            try {
                KsqlJsonDeserializer.jsonReader().readTree(text);
                return text;
            }
            catch (IOException e) {
                throw new DeserializationException("Failed to deserialize as JSON", e);
            }
        };
    }

    private static Deserializer<?> newStringDeserializer() {
        StringDeserializer deserializer = new StringDeserializer();
        String replacement = StandardCharsets.UTF_8.newDecoder().replacement();
        return (topic, data) -> {
            if (data.length == 0) {
                throw new DeserializationException("Empty data");
            }
            String text = deserializer.deserialize("", data);
            if (text.contains(replacement)) {
                throw new DeserializationException("String contains replacement char");
            }
            return text;
        };
    }

    private static final class DeserializationException
    extends RuntimeException {
        DeserializationException(String msg) {
            super(msg);
        }

        DeserializationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static final class NamedDeserializer {
        final String name;
        final boolean doNotWrap;
        final Deserializer<?> deserializer;

        private NamedDeserializer(String name, boolean doNotWrap, Deserializer<?> deserializer) {
            this.name = Objects.requireNonNull(name, "name");
            this.doNotWrap = doNotWrap;
            this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
        }

        public String toString() {
            return this.name;
        }
    }

    static enum Format {
        AVRO(0, KafkaAvroDeserializer::new),
        PROTOBUF(0, x$0 -> RecordFormatter.access$300(x$0)),
        JSON(() -> RecordFormatter.access$200()),
        JSON_SR(0, KafkaJsonSchemaDeserializer::new),
        KAFKA_INT(IntegerDeserializer::new),
        KAFKA_BIGINT(LongDeserializer::new),
        KAFKA_DOUBLE(DoubleDeserializer::new),
        KAFKA_STRING(() -> RecordFormatter.access$100()),
        UNRECOGNISED_BYTES(BytesDeserializer::new);

        private final Function<SchemaRegistryClient, Deserializer<?>> deserializerFactory;

        private Format(Supplier<Deserializer<?>> deserializerFactory) {
            this(1, srClient -> (Deserializer)deserializerFactory.get());
        }

        private Format(int usedOnlyToDifferentiateWhichConstructorIsCalled, Function<SchemaRegistryClient, Deserializer<?>> deserializerFactory) {
            this.deserializerFactory = Objects.requireNonNull(deserializerFactory, "deserializerFactory");
        }

        NamedDeserializer getDeserializer(SchemaRegistryClient srClient) {
            Deserializer<?> deserializer = this.deserializerFactory.apply(srClient);
            return new NamedDeserializer(this.name(), this == UNRECOGNISED_BYTES, deserializer);
        }
    }

    static enum WindowSchema {
        SESSION(WindowSchema::newSessionWindowedDeserializer),
        HOPPING(WindowSchema::newTimeWindowedDeserializer),
        TUMBLING(WindowSchema::newTimeWindowedDeserializer);

        private final Function<NamedDeserializer, Deserializer<?>> mapper;

        private WindowSchema(Function<NamedDeserializer, Deserializer<?>> mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
        }

        public NamedDeserializer wrap(NamedDeserializer inner) {
            String name = this.name() + "(" + inner.name + ")";
            Deserializer<?> deserializer = this.mapper.apply(inner);
            return new NamedDeserializer(name, inner.doNotWrap, deserializer);
        }

        private static Deserializer<?> newSessionWindowedDeserializer(NamedDeserializer inner) {
            SessionWindowedDeserializer sessionDeser = new SessionWindowedDeserializer(inner.deserializer);
            return (topic, data) -> {
                Windowed windowed = sessionDeser.deserialize(topic, data);
                return "[" + windowed.key() + "@" + windowed.window().start() + "/" + windowed.window().end() + "]";
            };
        }

        private static Deserializer<?> newTimeWindowedDeserializer(NamedDeserializer inner) {
            TimeWindowedDeserializer windowedDeser = new TimeWindowedDeserializer(inner.deserializer, Long.valueOf(1L));
            return (topic, data) -> {
                Windowed windowed = windowedDeser.deserialize(topic, data);
                return "[" + windowed.key() + "@" + windowed.window().start() + "/-]";
            };
        }
    }

    @VisibleForTesting
    static final class Deserializers {
        private final String topicName;
        private final List<NamedDeserializer> deserializers;
        private boolean seenData = false;

        Deserializers(String topicName, SchemaRegistryClient schemaRegistryClient, boolean incWindowed) {
            this.topicName = Objects.requireNonNull(topicName, "topicName");
            List deserializers = Arrays.stream(Format.values()).map(format -> format.getDeserializer(schemaRegistryClient)).collect(Collectors.toList());
            this.deserializers = !incWindowed ? deserializers : deserializers.stream().flatMap(deserializer -> deserializer.doNotWrap ? Stream.of(deserializer) : Streams.concat((Stream[])new Stream[]{Arrays.stream(WindowSchema.values()).map(ws -> ws.wrap((NamedDeserializer)deserializer)), Stream.of(deserializer)})).collect(Collectors.toList());
        }

        List<String> getPossibleFormats() {
            if (!this.seenData) {
                return ImmutableList.of((Object)"\u00af\\_(\u30c4)_/\u00af - no data processed");
            }
            return this.deserializers.stream().map(NamedDeserializer::toString).filter(name -> !name.equals(Format.UNRECOGNISED_BYTES.toString())).collect(Collectors.toList());
        }

        String format(Bytes bytes) {
            if (bytes == null || bytes.get() == null) {
                return "<null>";
            }
            this.seenData = true;
            String firstResult = null;
            Iterator<NamedDeserializer> it = this.deserializers.iterator();
            while (it.hasNext()) {
                Optional<String> possibleResult = this.tryDeserializer(bytes, it.next());
                if (possibleResult.isPresent() && firstResult == null) {
                    firstResult = possibleResult.get();
                }
                if (possibleResult.isPresent()) continue;
                it.remove();
            }
            return firstResult == null ? "<Failed to deserialize>" : firstResult;
        }

        private Optional<String> tryDeserializer(Bytes bytes, NamedDeserializer deserializer) {
            try {
                Object result = deserializer.deserializer.deserialize(this.topicName, bytes.get());
                return Optional.of(result == null ? "<null>" : result.toString());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }
}

