/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.api.server.StreamingOutput;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.rest.server.resources.streaming.PrintTopicUtil;
import io.confluent.ksql.rest.server.resources.streaming.RecordFormatter;
import io.confluent.ksql.services.ServiceContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicStreamWriter
implements StreamingOutput {
    private static final Logger log = LoggerFactory.getLogger(TopicStreamWriter.class);
    private static final int WRITE_TIMEOUT_MS = 600000;
    private final long interval;
    private final Duration disconnectCheckInterval;
    private final KafkaConsumer<Bytes, Bytes> topicConsumer;
    private final SchemaRegistryClient schemaRegistryClient;
    private final String topicName;
    private final Predicate<Long> limitReached;
    private long messagesWritten;
    private long messagesPolled;
    private volatile boolean connectionClosed;
    private boolean closed;

    public static TopicStreamWriter create(ServiceContext serviceContext, Map<String, Object> consumerProperties, PrintTopic printTopic, Duration disconnectCheckInterval, CompletableFuture<Void> connectionClosedFuture) {
        return new TopicStreamWriter(serviceContext.getSchemaRegistryClient(), PrintTopicUtil.createTopicConsumer(serviceContext, consumerProperties, printTopic), printTopic.getTopic(), printTopic.getIntervalValue(), disconnectCheckInterval, printTopic.getLimit(), connectionClosedFuture);
    }

    TopicStreamWriter(SchemaRegistryClient schemaRegistryClient, KafkaConsumer<Bytes, Bytes> topicConsumer, String topicName, long interval, Duration disconnectCheckInterval, OptionalInt limit, CompletableFuture<Void> connectionClosedFuture) {
        this.topicConsumer = Objects.requireNonNull(topicConsumer, "topicConsumer");
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "schemaRegistryClient");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.interval = interval;
        this.limitReached = Objects.requireNonNull(limit, "limit").isPresent() ? written -> written >= (long)limit.getAsInt() : written -> false;
        this.disconnectCheckInterval = Objects.requireNonNull(disconnectCheckInterval, "disconnectCheckInterval");
        this.messagesWritten = 0L;
        this.messagesPolled = 0L;
        connectionClosedFuture.thenAccept(v -> {
            this.connectionClosed = true;
        });
        if (interval < 1L) {
            throw new IllegalArgumentException("INTERVAL must be greater than one, but was: " + interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream out) {
        try {
            PrintStream print = new PrintStream(out, true, "UTF8");
            RecordFormatter formatter = new RecordFormatter(this.schemaRegistryClient, this.topicName);
            FormatsTracker formatsTracker = new FormatsTracker(print);
            while (!(this.connectionClosed || print.checkError() || this.limitReached.test(this.messagesWritten))) {
                ConsumerRecords records = this.topicConsumer.poll(this.disconnectCheckInterval);
                if (records.isEmpty()) {
                    print.println();
                    continue;
                }
                List<String> values = formatter.format(records.records(this.topicName));
                if (values.isEmpty()) continue;
                ArrayList<String> toOutput = new ArrayList<String>();
                for (String value : values) {
                    if (this.messagesPolled++ % this.interval == 0L) {
                        ++this.messagesWritten;
                        toOutput.add(value);
                    }
                    if (!this.limitReached.test(this.messagesWritten)) continue;
                    break;
                }
                formatsTracker.update(formatter);
                toOutput.forEach(print::println);
            }
        }
        catch (Exception exception) {
            log.error("Exception encountered while writing to output stream", (Throwable)exception);
            TopicStreamWriter.outputException(out, exception);
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.topicConsumer.close();
            this.closed = true;
        }
    }

    @Override
    public int getWriteTimeoutMs() {
        return 600000;
    }

    private static void outputException(OutputStream out, Exception exception) {
        try {
            out.write(exception.getMessage().getBytes(StandardCharsets.UTF_8));
            out.write("\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            log.debug("Client disconnected while attempting to write an error message");
        }
    }

    private static final class FormatsTracker {
        private final PrintStream out;
        private final List<String> keyFormats = new ArrayList<String>();
        private final List<String> valueFormats = new ArrayList<String>();

        FormatsTracker(PrintStream out) {
            this.out = Objects.requireNonNull(out, "out");
            this.keyFormats.add("add an entry to force output for formats on the first loop");
            this.valueFormats.add("add an entry to force output for formats on the first loop");
        }

        public void update(RecordFormatter formatter) {
            FormatsTracker.update(this.out, this.keyFormats, formatter.getPossibleKeyFormats(), "Key format: ");
            FormatsTracker.update(this.out, this.valueFormats, formatter.getPossibleValueFormats(), "Value format: ");
        }

        private static void update(PrintStream out, List<String> previous, List<String> current, String prefix) {
            if (previous.equals(current)) {
                return;
            }
            previous.clear();
            previous.addAll(current);
            out.print(prefix);
            if (current.isEmpty()) {
                out.println(" does not match any supported format. It may be a STRING with encoding other than UTF8, or some other format.");
            } else {
                out.println(String.join((CharSequence)" or ", current));
            }
        }
    }
}

