/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.state;

import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class ServerState {
    private final AtomicReference<StateWithErrorMessage> state = new AtomicReference<StateWithErrorMessage>(new StateWithErrorMessage(State.INITIALIZING, new KsqlErrorMessage(Errors.ERROR_CODE_SERVER_NOT_READY, "KSQL is not yet ready to serve requests.")));

    public void setInitializingReason(KsqlErrorMessage error) {
        this.state.set(new StateWithErrorMessage(State.INITIALIZING, error));
    }

    public void setReady() {
        this.state.set(new StateWithErrorMessage(State.READY));
    }

    public void setTerminating() {
        this.state.set(new StateWithErrorMessage(State.TERMINATING));
    }

    public void setTerminated() {
        this.state.set(new StateWithErrorMessage(State.TERMINATED));
    }

    public Optional<EndpointResponse> checkReady() {
        StateWithErrorMessage state = this.state.get();
        switch (state.state) {
            case INITIALIZING: {
                return Optional.of(Errors.serverNotReady((KsqlErrorMessage)state.errorMessage));
            }
            case TERMINATING: {
                return Optional.of(Errors.serverShuttingDown());
            }
            case TERMINATED: {
                return Optional.of(Errors.serverShutDown());
            }
        }
        return Optional.empty();
    }

    public State getState() {
        return this.state.get().state;
    }

    private static final class StateWithErrorMessage {
        final State state;
        final KsqlErrorMessage errorMessage;

        private StateWithErrorMessage(State state, KsqlErrorMessage error) {
            this.state = state;
            this.errorMessage = error;
        }

        private StateWithErrorMessage(State state) {
            this.state = state;
            this.errorMessage = null;
        }
    }

    public static enum State {
        INITIALIZING,
        READY,
        TERMINATING,
        TERMINATED;

    }
}

