/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;

public class ConcurrencyLimiter {
    private final Semaphore semaphore;
    private final int limit;
    private final String operationType;
    private final Sensor rejectSensor;

    public ConcurrencyLimiter(int limit, String operationType, Metrics metrics, Map<String, String> metricsTags) {
        this.semaphore = new Semaphore(limit);
        this.limit = limit;
        this.operationType = operationType;
        metrics.addMetric(new MetricName(operationType + "-concurrency-limit-remaining", "_confluent-ksql-limits", "The current value of the concurrency limiter", metricsTags), (metricConfig, l) -> this.semaphore.availablePermits());
        this.rejectSensor = metrics.sensor("concurrency-limit-rejects");
        this.rejectSensor.add(new MetricName(operationType + "-concurrency-limit-reject-count", "_confluent-ksql-limits", "The number of requests rejected by this limiter", metricsTags), (MeasurableStat)new CumulativeCount());
    }

    public Decrementer increment() {
        if (!this.semaphore.tryAcquire()) {
            this.rejectSensor.record();
            throw new KsqlException(String.format("Host is at concurrency limit for %s queries. Currently set to %d maximum concurrent operations.", this.operationType, this.limit));
        }
        return new Decrementer();
    }

    private void decrement() {
        this.semaphore.release();
    }

    @VisibleForTesting
    int getCount() {
        return this.limit - this.semaphore.availablePermits();
    }

    public class Decrementer {
        private final AtomicBoolean called = new AtomicBoolean(false);

        public void decrementAtMostOnce() {
            if (!this.called.getAndSet(true)) {
                ConcurrencyLimiter.this.decrement();
            }
        }
    }
}

