/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.raft.RaftMessage;
import org.apache.kafka.raft.RaftMessageQueue;

public class BlockingMessageQueue
implements RaftMessageQueue {
    private static final RaftMessage WAKEUP_MESSAGE = new RaftMessage(){

        @Override
        public int correlationId() {
            return 0;
        }

        @Override
        public ApiMessage data() {
            return null;
        }
    };
    private final BlockingQueue<RaftMessage> queue = new LinkedBlockingQueue<RaftMessage>();
    private final AtomicInteger size = new AtomicInteger(0);

    @Override
    public RaftMessage poll(long timeoutMs) {
        try {
            RaftMessage message = this.queue.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (message == null || message == WAKEUP_MESSAGE) {
                return null;
            }
            this.size.decrementAndGet();
            return message;
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    @Override
    public void add(RaftMessage message) {
        this.queue.add(message);
        this.size.incrementAndGet();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public void wakeup() {
        this.queue.add(WAKEUP_MESSAGE);
    }
}

