/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.auth.CloudKafkaRestContext;
import io.confluent.kafkarest.controllers.ConsumerGroupOffsetsManager;
import io.confluent.kafkarest.controllers.ConsumerGroupOffsetsManagerImpl;
import io.confluent.kafkarest.controllers.KafkaConsumerProvider;
import io.confluent.kafkarest.controllers.SimpleConsumeManager;
import io.confluent.kafkarest.controllers.SimpleConsumeManagerImpl;
import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudUIInternalModule
extends AbstractBinder {
    protected void configure() {
        this.bind(SimpleConsumeManagerImpl.class).to(SimpleConsumeManager.class);
        this.bind(KafkaConsumerProviderImpl.class).to(KafkaConsumerProvider.class).in(RequestScoped.class);
        this.bindFactory(SimpleConsumeExecutorFactory.class, Singleton.class).qualifiedBy((Annotation)new SimpleConsumeExecutorImpl()).to(ExecutorService.class).in(Singleton.class);
        this.bind(ConsumerGroupOffsetsManagerImpl.class).to(ConsumerGroupOffsetsManager.class);
    }

    private static final class SimpleConsumeExecutorFactory
    implements Factory<ExecutorService> {
        private static final String SIMPLE_CONSUME_EXECUTOR_MAX_THREADS_CONFIG = "simple_consume.executor.max_threads";
        private static final int SIMPLE_CONSUME_EXECUTOR_MAX_THREADS_DEFAULT = 10;
        private static final Logger log = LoggerFactory.getLogger(SimpleConsumeExecutorFactory.class);
        private final ExecutorService simpleConsumeExecutor;

        @Inject
        public SimpleConsumeExecutorFactory(KafkaRestConfig config) {
            int executorMaxThreads = Math.max(Runtime.getRuntime().availableProcessors(), 10);
            if (config != null) {
                int configuredExecutorMaxThreads;
                Object value = config.getOriginalProperties().get(SIMPLE_CONSUME_EXECUTOR_MAX_THREADS_CONFIG);
                if (value instanceof Integer && (configuredExecutorMaxThreads = ((Integer)value).intValue()) > 0) {
                    executorMaxThreads = configuredExecutorMaxThreads;
                }
            } else {
                log.info("Null config provided for Simple Consume executor");
            }
            log.debug("Initializing Simple Consume executor with maxPoolSize of {}", (Object)executorMaxThreads);
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("simple-consume-thread-%d").build();
            this.simpleConsumeExecutor = new ThreadPoolExecutor(1, executorMaxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, (r, e) -> {
                throw new RateLimitExceededException();
            });
        }

        public ExecutorService provide() {
            return this.simpleConsumeExecutor;
        }

        public void dispose(ExecutorService instance) {
            this.simpleConsumeExecutor.shutdown();
            try {
                if (!this.simpleConsumeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.debug("Could not shutdown gracefully in 60 seconds, interrupt tasks and shutdown");
                    this.simpleConsumeExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                log.debug("Dispose thread interrupted while waiting, interrupt tasks and shutdown");
                this.simpleConsumeExecutor.shutdownNow();
            }
        }
    }

    private static final class SimpleConsumeExecutorImpl
    extends AnnotationLiteral<SimpleConsumeExecutor>
    implements SimpleConsumeExecutor {
        private SimpleConsumeExecutorImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface SimpleConsumeExecutor {
    }

    private static final class KafkaConsumerProviderImpl
    implements KafkaConsumerProvider {
        private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerProviderImpl.class);
        private final Properties baseConsumerConfig;

        @Inject
        KafkaConsumerProviderImpl(KafkaRestContext context) {
            if (context instanceof CloudKafkaRestContext) {
                CloudKafkaRestContext cloudContext = (CloudKafkaRestContext)context;
                this.baseConsumerConfig = cloudContext.getConsumerProperties();
            } else {
                this.baseConsumerConfig = context.getConfig().getConsumerProperties();
            }
            this.baseConsumerConfig.put("enable.auto.commit", (Object)false);
            this.baseConsumerConfig.put("key.deserializer", ByteArrayDeserializer.class);
            this.baseConsumerConfig.put("value.deserializer", ByteArrayDeserializer.class);
        }

        @Override
        public <K, V> KafkaConsumer<K, V> getConsumer(Properties consumerConfigOverride) {
            Properties consumerConfig = new Properties();
            consumerConfig.putAll((Map<?, ?>)this.baseConsumerConfig);
            for (Map.Entry<Object, Object> newConfig : consumerConfigOverride.entrySet()) {
                Object oldConfig = consumerConfig.put(newConfig.getKey(), newConfig.getValue());
                if (!logger.isTraceEnabled() || oldConfig == null) continue;
                logger.trace("Replaced consumer config for key {}: old value: {} -> new value: {}", new Object[]{newConfig.getKey(), oldConfig, newConfig.getValue()});
            }
            return new KafkaConsumer(consumerConfig);
        }

        @Override
        public <K, V> void releaseConsumer(KafkaConsumer<K, V> consumer) {
            consumer.close();
        }
    }
}

