/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.ConsumerGroupOffsetsManager;
import io.confluent.kafkarest.entities.v3.ListConsumerGroupOffsetsResultsData;
import io.confluent.kafkarest.entities.v3.TopicPartitionOffsetAndMetaData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupOffsetsManagerImpl
implements ConsumerGroupOffsetsManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerGroupOffsetsManagerImpl.class);
    private final Admin adminClient;

    @Inject
    public ConsumerGroupOffsetsManagerImpl(Admin adminClient) {
        this.adminClient = Objects.requireNonNull(adminClient);
    }

    @Override
    public CompletableFuture<ListConsumerGroupOffsetsResultsData> getConsumerGroupOffsets(String consumerGroupId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult = this.adminClient.listConsumerGroupOffsets(consumerGroupId);
                ListConsumerGroupOffsetsResultsData resultData = this.convertToListConsumerGroupOffsetsResultData(listConsumerGroupOffsetsResult, consumerGroupId);
                return resultData;
            }
            catch (KafkaException ex) {
                logger.debug(String.format("Got an exception after attempting to get a consumer group id %s offsets: %s", consumerGroupId, ex.getMessage()));
                throw ex;
            }
        });
    }

    private ListConsumerGroupOffsetsResultsData convertToListConsumerGroupOffsetsResultData(ListConsumerGroupOffsetsResult result, String consumerGroupId) {
        ArrayList<TopicPartitionOffsetAndMetaData> offsets = new ArrayList<TopicPartitionOffsetAndMetaData>();
        try {
            Map topicPartitionOffsetMap = (Map)result.partitionsToOffsetAndMetadata().get();
            for (Map.Entry entry : topicPartitionOffsetMap.entrySet()) {
                offsets.add(TopicPartitionOffsetAndMetaData.fromOffsetAndMetadata((TopicPartition)entry.getKey(), (OffsetAndMetadata)entry.getValue()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        return ListConsumerGroupOffsetsResultsData.builder().setOffsets(offsets).setConsumerGroupId(consumerGroupId).build();
    }
}

