/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.MirrorData;
import io.confluent.kafkarest.entities.v3.MirrorLagData;
import io.confluent.kafkarest.entities.v3.Resource;

final class AutoValue_MirrorData
extends MirrorData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String linkName;
    private final String mirrorTopicName;
    private final String sourceTopicName;
    private final int numPartitions;
    private final ImmutableList<MirrorLagData> mirrorLags;
    private final String mirrorStatus;
    private final String mirrorTopicError;
    private final long stateTimeMs;

    private AutoValue_MirrorData(String kind, Resource.Metadata metadata, String linkName, String mirrorTopicName, String sourceTopicName, int numPartitions, ImmutableList<MirrorLagData> mirrorLags, String mirrorStatus, String mirrorTopicError, long stateTimeMs) {
        this.kind = kind;
        this.metadata = metadata;
        this.linkName = linkName;
        this.mirrorTopicName = mirrorTopicName;
        this.sourceTopicName = sourceTopicName;
        this.numPartitions = numPartitions;
        this.mirrorLags = mirrorLags;
        this.mirrorStatus = mirrorStatus;
        this.mirrorTopicError = mirrorTopicError;
        this.stateTimeMs = stateTimeMs;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="link_name")
    public String getLinkName() {
        return this.linkName;
    }

    @Override
    @JsonProperty(value="mirror_topic_name")
    public String getMirrorTopicName() {
        return this.mirrorTopicName;
    }

    @Override
    @JsonProperty(value="source_topic_name")
    public String getSourceTopicName() {
        return this.sourceTopicName;
    }

    @Override
    @JsonProperty(value="num_partitions")
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    @JsonProperty(value="mirror_lags")
    public ImmutableList<MirrorLagData> getMirrorLags() {
        return this.mirrorLags;
    }

    @Override
    @JsonProperty(value="mirror_status")
    public String getMirrorStatus() {
        return this.mirrorStatus;
    }

    @Override
    @JsonProperty(value="mirror_topic_error")
    public String getMirrorTopicError() {
        return this.mirrorTopicError;
    }

    @Override
    @JsonProperty(value="state_time_ms")
    public long getStateTimeMs() {
        return this.stateTimeMs;
    }

    public String toString() {
        return "MirrorData{kind=" + this.kind + ", metadata=" + this.metadata + ", linkName=" + this.linkName + ", mirrorTopicName=" + this.mirrorTopicName + ", sourceTopicName=" + this.sourceTopicName + ", numPartitions=" + this.numPartitions + ", mirrorLags=" + this.mirrorLags + ", mirrorStatus=" + this.mirrorStatus + ", mirrorTopicError=" + this.mirrorTopicError + ", stateTimeMs=" + this.stateTimeMs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MirrorData) {
            MirrorData that = (MirrorData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.linkName.equals(that.getLinkName()) && this.mirrorTopicName.equals(that.getMirrorTopicName()) && this.sourceTopicName.equals(that.getSourceTopicName()) && this.numPartitions == that.getNumPartitions() && this.mirrorLags.equals(that.getMirrorLags()) && this.mirrorStatus.equals(that.getMirrorStatus()) && this.mirrorTopicError.equals(that.getMirrorTopicError()) && this.stateTimeMs == that.getStateTimeMs();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkName.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorTopicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.sourceTopicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.numPartitions;
        h$ *= 1000003;
        h$ ^= this.mirrorLags.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorTopicError.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.stateTimeMs >>> 32 ^ this.stateTimeMs);
    }

    static final class Builder
    extends MirrorData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String linkName;
        private String mirrorTopicName;
        private String sourceTopicName;
        private Integer numPartitions;
        private ImmutableList<MirrorLagData> mirrorLags;
        private String mirrorStatus;
        private String mirrorTopicError;
        private Long stateTimeMs;

        Builder() {
        }

        public MirrorData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public MirrorData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public MirrorData.Builder setLinkName(String linkName) {
            if (linkName == null) {
                throw new NullPointerException("Null linkName");
            }
            this.linkName = linkName;
            return this;
        }

        @Override
        public MirrorData.Builder setMirrorTopicName(String mirrorTopicName) {
            if (mirrorTopicName == null) {
                throw new NullPointerException("Null mirrorTopicName");
            }
            this.mirrorTopicName = mirrorTopicName;
            return this;
        }

        @Override
        public MirrorData.Builder setSourceTopicName(String sourceTopicName) {
            if (sourceTopicName == null) {
                throw new NullPointerException("Null sourceTopicName");
            }
            this.sourceTopicName = sourceTopicName;
            return this;
        }

        @Override
        public MirrorData.Builder setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        @Override
        public MirrorData.Builder setMirrorLags(ImmutableList<MirrorLagData> mirrorLags) {
            if (mirrorLags == null) {
                throw new NullPointerException("Null mirrorLags");
            }
            this.mirrorLags = mirrorLags;
            return this;
        }

        @Override
        public MirrorData.Builder setMirrorStatus(String mirrorStatus) {
            if (mirrorStatus == null) {
                throw new NullPointerException("Null mirrorStatus");
            }
            this.mirrorStatus = mirrorStatus;
            return this;
        }

        @Override
        public MirrorData.Builder setMirrorTopicError(String mirrorTopicError) {
            if (mirrorTopicError == null) {
                throw new NullPointerException("Null mirrorTopicError");
            }
            this.mirrorTopicError = mirrorTopicError;
            return this;
        }

        @Override
        public MirrorData.Builder setStateTimeMs(long stateTimeMs) {
            this.stateTimeMs = stateTimeMs;
            return this;
        }

        @Override
        public MirrorData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.linkName == null) {
                missing = missing + " linkName";
            }
            if (this.mirrorTopicName == null) {
                missing = missing + " mirrorTopicName";
            }
            if (this.sourceTopicName == null) {
                missing = missing + " sourceTopicName";
            }
            if (this.numPartitions == null) {
                missing = missing + " numPartitions";
            }
            if (this.mirrorLags == null) {
                missing = missing + " mirrorLags";
            }
            if (this.mirrorStatus == null) {
                missing = missing + " mirrorStatus";
            }
            if (this.mirrorTopicError == null) {
                missing = missing + " mirrorTopicError";
            }
            if (this.stateTimeMs == null) {
                missing = missing + " stateTimeMs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MirrorData(this.kind, this.metadata, this.linkName, this.mirrorTopicName, this.sourceTopicName, this.numPartitions, this.mirrorLags, this.mirrorStatus, this.mirrorTopicError, this.stateTimeMs);
        }
    }
}

