/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.TopicPartitionOffsetAndMetaData;
import javax.annotation.Nullable;

final class AutoValue_TopicPartitionOffsetAndMetaData
extends TopicPartitionOffsetAndMetaData {
    private final long offset;
    private final String metadata;
    private final Integer partitionId;
    private final String topicName;

    private AutoValue_TopicPartitionOffsetAndMetaData(long offset, @Nullable String metadata, Integer partitionId, String topicName) {
        this.offset = offset;
        this.metadata = metadata;
        this.partitionId = partitionId;
        this.topicName = topicName;
    }

    @Override
    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    @JsonProperty(value="metadata")
    public String getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="partition_id")
    public Integer getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    public String toString() {
        return "TopicPartitionOffsetAndMetaData{offset=" + this.offset + ", metadata=" + this.metadata + ", partitionId=" + this.partitionId + ", topicName=" + this.topicName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicPartitionOffsetAndMetaData) {
            TopicPartitionOffsetAndMetaData that = (TopicPartitionOffsetAndMetaData)o;
            return this.offset == that.getOffset() && (this.metadata == null ? that.getMetadata() == null : this.metadata.equals(that.getMetadata())) && this.partitionId.equals(that.getPartitionId()) && this.topicName.equals(that.getTopicName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.offset >>> 32 ^ this.offset);
        h$ *= 1000003;
        h$ ^= this.metadata == null ? 0 : this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.topicName.hashCode();
    }

    static final class Builder
    extends TopicPartitionOffsetAndMetaData.Builder {
        private Long offset;
        private String metadata;
        private Integer partitionId;
        private String topicName;

        Builder() {
        }

        @Override
        public TopicPartitionOffsetAndMetaData.Builder setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public TopicPartitionOffsetAndMetaData.Builder setMetadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public TopicPartitionOffsetAndMetaData.Builder setPartitionId(Integer partitionId) {
            if (partitionId == null) {
                throw new NullPointerException("Null partitionId");
            }
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public TopicPartitionOffsetAndMetaData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public TopicPartitionOffsetAndMetaData build() {
            String missing = "";
            if (this.offset == null) {
                missing = missing + " offset";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TopicPartitionOffsetAndMetaData(this.offset, this.metadata, this.partitionId, this.topicName);
        }
    }
}

