/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.RemoveBrokerTask;
import io.confluent.kafkarest.entities.v3.AutoValue_RemoveBrokerTaskData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

@AutoValue
public abstract class RemoveBrokerTaskData
extends Resource {
    RemoveBrokerTaskData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="shutdown_scheduled")
    public abstract boolean getShutdownScheduled();

    @JsonProperty(value="broker_replica_exclusion_status")
    public abstract BrokerReplicaExclusionStatus getBrokerReplicaExclusionStatus();

    @JsonProperty(value="partition_reassignment_status")
    public abstract PartitionReassignmentsStatus getPartitionReassignmentStatus();

    @JsonProperty(value="broker_shutdown_status")
    public abstract BrokerShutdownStatus getBrokerShutdownStatus();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_RemoveBrokerTaskData.Builder().setKind("KafkaRemoveBrokerTask");
    }

    public static Builder fromRemoveBrokerTask(RemoveBrokerTask removeBrokerTask) {
        return RemoveBrokerTaskData.builder().setClusterId(removeBrokerTask.getClusterId()).setBrokerId(removeBrokerTask.getBrokerId()).setShutdownScheduled(removeBrokerTask.getShutdownScheduled()).setBrokerReplicaExclusionStatus(removeBrokerTask.getBrokerReplicaExclusionStatus()).setPartitionReassignmentStatus(removeBrokerTask.getPartitionReassignmentStatus()).setBrokerShutdownStatus(removeBrokerTask.getBrokerShutdownStatus()).setErrorCode(removeBrokerTask.getErrorCode().orElse(null)).setErrorMessage(removeBrokerTask.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static RemoveBrokerTaskData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="shutdown_scheduled") boolean shutdownScheduled, @JsonProperty(value="broker_replica_exclusion_status") BrokerReplicaExclusionStatus brokerReplicaExclusionStatus, @JsonProperty(value="partition_reassignment_status") PartitionReassignmentsStatus partitionReassignmentStatus, @JsonProperty(value="broker_shutdown_status") BrokerShutdownStatus brokerShutdownStatus, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="broker") Resource.Relationship broker) {
        return ((Builder)((Builder)RemoveBrokerTaskData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setShutdownScheduled(shutdownScheduled).setBrokerReplicaExclusionStatus(brokerReplicaExclusionStatus).setPartitionReassignmentStatus(partitionReassignmentStatus).setBrokerShutdownStatus(brokerShutdownStatus).setErrorCode(errorCode).setErrorMessage(errorMessage).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setShutdownScheduled(boolean var1);

        public abstract Builder setBrokerReplicaExclusionStatus(BrokerReplicaExclusionStatus var1);

        public abstract Builder setPartitionReassignmentStatus(PartitionReassignmentsStatus var1);

        public abstract Builder setBrokerShutdownStatus(BrokerShutdownStatus var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract RemoveBrokerTaskData build();
    }
}

